/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.service.BuildCacheLoadResult;
import org.gradle.caching.internal.controller.service.LocalBuildCacheServiceHandle;
import org.gradle.caching.local.internal.LocalBuildCacheService;

public class BaseLocalBuildCacheServiceHandle
implements LocalBuildCacheServiceHandle {
    private final LocalBuildCacheService service;
    private final boolean pushEnabled;

    public BaseLocalBuildCacheServiceHandle(LocalBuildCacheService localBuildCacheService, boolean bl2) {
        this.service = localBuildCacheService;
        this.pushEnabled = bl2;
    }

    @Override
    public Optional<BuildCacheLoadResult> maybeLoad(BuildCacheKey buildCacheKey, Function<File, BuildCacheLoadResult> function) {
        AtomicReference atomicReference = new AtomicReference(Optional.empty());
        this.service.loadLocally(buildCacheKey, file -> atomicReference.set(Optional.ofNullable((BuildCacheLoadResult)function.apply((File)file))));
        return atomicReference.get();
    }

    @Override
    public boolean canStore() {
        return this.pushEnabled;
    }

    @Override
    public boolean maybeStore(BuildCacheKey buildCacheKey, File file) {
        if (this.canStore()) {
            this.storeInner(buildCacheKey, file);
            return true;
        }
        return false;
    }

    protected void storeInner(BuildCacheKey buildCacheKey, File file) {
        this.service.storeLocally(buildCacheKey, file);
    }

    @Override
    public void close() throws IOException {
        this.service.close();
    }
}

