/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import org.gradle.internal.RelativePathSupplier;

public class RelativePathTracker
implements RelativePathSupplier {
    private final Deque<String> segments = new ArrayDeque<String>();
    private String rootName;

    public void enter(String string) {
        if (this.rootName == null) {
            this.rootName = string;
        } else {
            this.segments.addLast(string);
        }
    }

    public String leave() {
        String string = this.segments.pollLast();
        if (string == null) {
            string = this.rootName;
            this.rootName = null;
        }
        return string;
    }

    @Override
    public boolean isRoot() {
        return this.segments.isEmpty();
    }

    @Override
    public Collection<String> getSegments() {
        return this.segments;
    }

    @Override
    public String toRelativePath() {
        switch (this.segments.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return this.segments.getLast();
            }
        }
        int n2 = this.segments.size() - 1;
        for (String object2 : this.segments) {
            n2 += object2.length();
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        Iterator<String> iterator = this.segments.iterator();
        while (true) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) break;
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }
}

