/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testselection.common.model.api.base;

import com.gradle.enterprise.testselection.common.model.api.base.ClassNameHash;
import com.gradle.enterprise.testselection.common.model.api.base.ClassNameHashDeserializer;
import com.gradle.enterprise.testselection.common.model.api.base.DebugData;
import com.gradle.enterprise.testselection.common.model.api.base.InputDebugData;
import com.gradle.enterprise.testselection.common.model.api.base.SelectionDebugData;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonCreator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="DebugData", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableDebugData
implements DebugData {
    private final String requestId;
    private final String inferenceDataHash;
    private final Duration selectionDuration;
    private final List<String> modelFeatureNames;
    private final Map<ClassNameHash, SelectionDebugData> selectionDebugData;
    private final InputDebugData inputs;

    private ImmutableDebugData() {
        this.requestId = null;
        this.inferenceDataHash = null;
        this.selectionDuration = null;
        this.modelFeatureNames = null;
        this.selectionDebugData = null;
        this.inputs = null;
    }

    private ImmutableDebugData(String string, String string2, Duration duration, Iterable<String> iterable, Map<? extends ClassNameHash, ? extends SelectionDebugData> map, InputDebugData inputDebugData) {
        this.requestId = Objects.requireNonNull(string, "requestId");
        this.inferenceDataHash = Objects.requireNonNull(string2, "inferenceDataHash");
        this.selectionDuration = Objects.requireNonNull(duration, "selectionDuration");
        this.modelFeatureNames = ImmutableDebugData.createUnmodifiableList(false, ImmutableDebugData.createSafeList(iterable, true, false));
        this.selectionDebugData = ImmutableDebugData.createUnmodifiableMap(true, false, map);
        this.inputs = Objects.requireNonNull(inputDebugData, "inputs");
    }

    private ImmutableDebugData(Builder builder) {
        this.requestId = builder.requestId;
        this.inferenceDataHash = builder.inferenceDataHash;
        this.selectionDuration = builder.selectionDuration;
        this.modelFeatureNames = ImmutableDebugData.createUnmodifiableList(true, builder.modelFeatureNames);
        this.selectionDebugData = ImmutableDebugData.createUnmodifiableMap(false, false, builder.selectionDebugData);
        this.inputs = builder.inputs;
    }

    @Override
    @JsonProperty(value="requestId")
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    @JsonProperty(value="inferenceDataHash")
    public String getInferenceDataHash() {
        return this.inferenceDataHash;
    }

    @Override
    @JsonProperty(value="selectionDuration")
    public Duration getSelectionDuration() {
        return this.selectionDuration;
    }

    @Override
    @JsonProperty(value="modelFeatureNames")
    public List<String> getModelFeatureNames() {
        return this.modelFeatureNames;
    }

    @Override
    @JsonProperty(value="selectionDebugData")
    @JsonDeserialize(keyUsing=ClassNameHashDeserializer.class)
    public Map<ClassNameHash, SelectionDebugData> getSelectionDebugData() {
        return this.selectionDebugData;
    }

    @Override
    @JsonProperty(value="inputs")
    public InputDebugData getInputs() {
        return this.inputs;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ImmutableDebugData && this.equalTo(0, (ImmutableDebugData)object);
    }

    private boolean equalTo(int n2, ImmutableDebugData immutableDebugData) {
        return this.requestId.equals(immutableDebugData.requestId) && this.inferenceDataHash.equals(immutableDebugData.inferenceDataHash) && this.selectionDuration.equals(immutableDebugData.selectionDuration) && this.modelFeatureNames.equals(immutableDebugData.modelFeatureNames) && this.selectionDebugData.equals(immutableDebugData.selectionDebugData) && this.inputs.equals(immutableDebugData.inputs);
    }

    public int hashCode() {
        int n2 = 5381;
        n2 += (n2 << 5) + this.requestId.hashCode();
        n2 += (n2 << 5) + this.inferenceDataHash.hashCode();
        n2 += (n2 << 5) + this.selectionDuration.hashCode();
        n2 += (n2 << 5) + this.modelFeatureNames.hashCode();
        n2 += (n2 << 5) + this.selectionDebugData.hashCode();
        n2 += (n2 << 5) + this.inputs.hashCode();
        return n2;
    }

    public String toString() {
        return "DebugData{requestId=" + this.requestId + ", inferenceDataHash=" + this.inferenceDataHash + ", selectionDuration=" + this.selectionDuration + ", modelFeatureNames=" + this.modelFeatureNames + ", selectionDebugData=" + this.selectionDebugData + ", inputs=" + this.inputs + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDebugData fromJson(Json json) {
        Builder builder = ImmutableDebugData.builder();
        if (json.requestId != null) {
            builder.requestId(json.requestId);
        }
        if (json.inferenceDataHash != null) {
            builder.inferenceDataHash(json.inferenceDataHash);
        }
        if (json.selectionDuration != null) {
            builder.selectionDuration(json.selectionDuration);
        }
        if (json.modelFeatureNames != null) {
            builder.addAllModelFeatureNames(json.modelFeatureNames);
        }
        if (json.selectionDebugData != null) {
            builder.putAllSelectionDebugData(json.selectionDebugData);
        }
        if (json.inputs != null) {
            builder.inputs(json.inputs);
        }
        return (ImmutableDebugData)builder.build();
    }

    public static DebugData of(String string, String string2, Duration duration, List<String> list, Map<ClassNameHash, SelectionDebugData> map, InputDebugData inputDebugData) {
        return ImmutableDebugData.of(string, string2, duration, list, map, inputDebugData);
    }

    public static DebugData of(String string, String string2, Duration duration, Iterable<String> iterable, Map<? extends ClassNameHash, ? extends SelectionDebugData> map, InputDebugData inputDebugData) {
        return new ImmutableDebugData(string, string2, duration, iterable, map, inputDebugData);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean bl2, boolean bl3) {
        ArrayList<T> arrayList;
        if (iterable instanceof Collection) {
            int n2 = ((Collection)iterable).size();
            if (n2 == 0) {
                return Collections.emptyList();
            }
            arrayList = new ArrayList(n2);
        } else {
            arrayList = new ArrayList<T>();
        }
        for (T t2 : iterable) {
            if (bl3 && t2 == null) continue;
            if (bl2) {
                Objects.requireNonNull(t2, "element");
            }
            arrayList.add(t2);
        }
        return arrayList;
    }

    private static <T> List<T> createUnmodifiableList(boolean bl2, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (bl2) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean bl2, boolean bl3, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> entry = map.entrySet().iterator().next();
                K k2 = entry.getKey();
                V v2 = entry.getValue();
                if (bl2) {
                    Objects.requireNonNull(k2, "key");
                    Objects.requireNonNull(v2, v2 == null ? "value for key: " + k2 : null);
                }
                if (bl3 && (k2 == null || v2 == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k2, v2);
            }
        }
        LinkedHashMap<K, V> linkedHashMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (bl3 || bl2) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K k3 = entry.getKey();
                V v3 = entry.getValue();
                if (bl3) {
                    if (k3 == null || v3 == null) {
                        continue;
                    }
                } else if (bl2) {
                    Objects.requireNonNull(k3, "key");
                    Objects.requireNonNull(v3, v3 == null ? "value for key: " + k3 : null);
                }
                linkedHashMap.put(k3, v3);
            }
        } else {
            linkedHashMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    @Generated(from="DebugData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_REQUEST_ID = 1L;
        private static final long INIT_BIT_INFERENCE_DATA_HASH = 2L;
        private static final long INIT_BIT_SELECTION_DURATION = 4L;
        private static final long INIT_BIT_INPUTS = 8L;
        private long initBits = 15L;
        private String requestId;
        private String inferenceDataHash;
        private Duration selectionDuration;
        private List<String> modelFeatureNames = new ArrayList<String>();
        private Map<ClassNameHash, SelectionDebugData> selectionDebugData = new LinkedHashMap<ClassNameHash, SelectionDebugData>();
        private InputDebugData inputs;

        private Builder() {
        }

        public final Builder from(DebugData debugData) {
            Objects.requireNonNull(debugData, "instance");
            this.requestId(debugData.getRequestId());
            this.inferenceDataHash(debugData.getInferenceDataHash());
            this.selectionDuration(debugData.getSelectionDuration());
            this.addAllModelFeatureNames(debugData.getModelFeatureNames());
            this.putAllSelectionDebugData(debugData.getSelectionDebugData());
            this.inputs(debugData.getInputs());
            return this;
        }

        @JsonProperty(value="requestId")
        public final Builder requestId(String string) {
            this.requestId = Objects.requireNonNull(string, "requestId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="inferenceDataHash")
        public final Builder inferenceDataHash(String string) {
            this.inferenceDataHash = Objects.requireNonNull(string, "inferenceDataHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="selectionDuration")
        public final Builder selectionDuration(Duration duration) {
            this.selectionDuration = Objects.requireNonNull(duration, "selectionDuration");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addModelFeatureNames(String string) {
            this.modelFeatureNames.add(Objects.requireNonNull(string, "modelFeatureNames element"));
            return this;
        }

        public final Builder addModelFeatureNames(String ... stringArray) {
            for (String string : stringArray) {
                this.modelFeatureNames.add(Objects.requireNonNull(string, "modelFeatureNames element"));
            }
            return this;
        }

        @JsonProperty(value="modelFeatureNames")
        public final Builder modelFeatureNames(Iterable<String> iterable) {
            this.modelFeatureNames.clear();
            return this.addAllModelFeatureNames(iterable);
        }

        public final Builder addAllModelFeatureNames(Iterable<String> iterable) {
            for (String string : iterable) {
                this.modelFeatureNames.add(Objects.requireNonNull(string, "modelFeatureNames element"));
            }
            return this;
        }

        public final Builder putSelectionDebugData(ClassNameHash classNameHash, SelectionDebugData selectionDebugData) {
            this.selectionDebugData.put(Objects.requireNonNull(classNameHash, "selectionDebugData key"), Objects.requireNonNull(selectionDebugData, selectionDebugData == null ? "selectionDebugData value for key: " + classNameHash : null));
            return this;
        }

        public final Builder putSelectionDebugData(Map.Entry<? extends ClassNameHash, ? extends SelectionDebugData> entry) {
            SelectionDebugData selectionDebugData;
            ClassNameHash classNameHash = entry.getKey();
            this.selectionDebugData.put(Objects.requireNonNull(classNameHash, "selectionDebugData key"), Objects.requireNonNull(selectionDebugData, (selectionDebugData = entry.getValue()) == null ? "selectionDebugData value for key: " + classNameHash : null));
            return this;
        }

        @JsonProperty(value="selectionDebugData")
        @JsonDeserialize(keyUsing=ClassNameHashDeserializer.class)
        public final Builder selectionDebugData(Map<? extends ClassNameHash, ? extends SelectionDebugData> map) {
            this.selectionDebugData.clear();
            return this.putAllSelectionDebugData(map);
        }

        public final Builder putAllSelectionDebugData(Map<? extends ClassNameHash, ? extends SelectionDebugData> map) {
            for (Map.Entry<? extends ClassNameHash, ? extends SelectionDebugData> entry : map.entrySet()) {
                SelectionDebugData selectionDebugData;
                ClassNameHash classNameHash = entry.getKey();
                this.selectionDebugData.put(Objects.requireNonNull(classNameHash, "selectionDebugData key"), Objects.requireNonNull(selectionDebugData, (selectionDebugData = entry.getValue()) == null ? "selectionDebugData value for key: " + classNameHash : null));
            }
            return this;
        }

        @JsonProperty(value="inputs")
        public final Builder inputs(InputDebugData inputDebugData) {
            this.inputs = Objects.requireNonNull(inputDebugData, "inputs");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public DebugData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDebugData(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                arrayList.add("requestId");
            }
            if ((this.initBits & 2L) != 0L) {
                arrayList.add("inferenceDataHash");
            }
            if ((this.initBits & 4L) != 0L) {
                arrayList.add("selectionDuration");
            }
            if ((this.initBits & 8L) != 0L) {
                arrayList.add("inputs");
            }
            return "Cannot build DebugData, some of required attributes are not set " + arrayList;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DebugData", generator="Immutables")
    static final class Json
    implements DebugData {
        String requestId;
        String inferenceDataHash;
        Duration selectionDuration;
        List<String> modelFeatureNames = Collections.emptyList();
        Map<ClassNameHash, SelectionDebugData> selectionDebugData = Collections.emptyMap();
        InputDebugData inputs;

        Json() {
        }

        @JsonProperty(value="requestId")
        public void setRequestId(String string) {
            this.requestId = string;
        }

        @JsonProperty(value="inferenceDataHash")
        public void setInferenceDataHash(String string) {
            this.inferenceDataHash = string;
        }

        @JsonProperty(value="selectionDuration")
        public void setSelectionDuration(Duration duration) {
            this.selectionDuration = duration;
        }

        @JsonProperty(value="modelFeatureNames")
        public void setModelFeatureNames(List<String> list) {
            this.modelFeatureNames = list;
        }

        @JsonProperty(value="selectionDebugData")
        @JsonDeserialize(keyUsing=ClassNameHashDeserializer.class)
        public void setSelectionDebugData(Map<ClassNameHash, SelectionDebugData> map) {
            this.selectionDebugData = map;
        }

        @JsonProperty(value="inputs")
        public void setInputs(InputDebugData inputDebugData) {
            this.inputs = inputDebugData;
        }

        @Override
        public String getRequestId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getInferenceDataHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Duration getSelectionDuration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getModelFeatureNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<ClassNameHash, SelectionDebugData> getSelectionDebugData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InputDebugData getInputs() {
            throw new UnsupportedOperationException();
        }
    }
}

