/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.api;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.CommonConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.EmptyElementHandler;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.InvalidCharHandler;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.OutputConfigFlags;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.BufferRecycler;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.ArgUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.DataUtil;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.io.EscapingWriterFactory;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import javax.xml.stream.XMLReporter;

public final class WriterConfig
extends CommonConfig
implements OutputConfigFlags {
    protected static final String DEFAULT_AUTOMATIC_NS_PREFIX = "wstxns";
    static final int PROP_AUTOMATIC_NS = 1;
    static final int PROP_AUTOMATIC_EMPTY_ELEMENTS = 2;
    static final int PROP_AUTO_CLOSE_OUTPUT = 3;
    static final int PROP_ENABLE_NS = 4;
    static final int PROP_AUTOMATIC_NS_PREFIX = 5;
    static final int PROP_TEXT_ESCAPER = 6;
    static final int PROP_ATTR_VALUE_ESCAPER = 7;
    static final int PROP_PROBLEM_REPORTER = 8;
    static final int PROP_USE_DOUBLE_QUOTES_IN_XML_DECL = 10;
    static final int PROP_OUTPUT_CDATA_AS_TEXT = 11;
    static final int PROP_COPY_DEFAULT_ATTRS = 12;
    static final int PROP_ESCAPE_CR = 13;
    static final int PROP_ADD_SPACE_AFTER_EMPTY_ELEM = 14;
    static final int PROP_AUTOMATIC_END_ELEMENTS = 15;
    static final int PROP_VALIDATE_STRUCTURE = 16;
    static final int PROP_VALIDATE_CONTENT = 17;
    static final int PROP_VALIDATE_ATTR = 18;
    static final int PROP_VALIDATE_NAMES = 19;
    static final int PROP_FIX_CONTENT = 20;
    static final int PROP_OUTPUT_INVALID_CHAR_HANDLER = 21;
    static final int PROP_OUTPUT_EMPTY_ELEMENT_HANDLER = 22;
    static final int PROP_UNDERLYING_STREAM = 30;
    static final int PROP_UNDERLYING_WRITER = 31;
    static final boolean DEFAULT_USE_DOUBLE_QUOTES_IN_XML_DECL = false;
    static final boolean DEFAULT_OUTPUT_CDATA_AS_TEXT = false;
    static final boolean DEFAULT_COPY_DEFAULT_ATTRS = false;
    static final boolean DEFAULT_ESCAPE_CR = true;
    static final boolean DEFAULT_ADD_SPACE_AFTER_EMPTY_ELEM = false;
    static final boolean DEFAULT_VALIDATE_STRUCTURE = true;
    static final boolean DEFAULT_VALIDATE_CONTENT = true;
    static final boolean DEFAULT_VALIDATE_ATTR = false;
    static final boolean DEFAULT_VALIDATE_NAMES = false;
    static final boolean DEFAULT_FIX_CONTENT = false;
    static final int DEFAULT_FLAGS_J2ME = 933;
    static final int DEFAULT_FLAGS_FULL = 933;
    static final HashMap<String, Integer> sProperties = new HashMap(8);
    final boolean mIsJ2MESubset;
    protected int mConfigFlags;
    Object[] mSpecialProperties = null;
    private static final int SPEC_PROC_COUNT = 6;
    private static final int SP_IX_AUTO_NS_PREFIX = 0;
    private static final int SP_IX_TEXT_ESCAPER_FACTORY = 1;
    private static final int SP_IX_ATTR_VALUE_ESCAPER_FACTORY = 2;
    private static final int SP_IX_PROBLEM_REPORTER = 3;
    private static final int SP_IX_INVALID_CHAR_HANDLER = 4;
    private static final int SP_IX_EMPTY_ELEMENT_HANDLER = 5;
    static final ThreadLocal<SoftReference<BufferRecycler>> mRecyclerRef;
    BufferRecycler mCurrRecycler = null;

    private WriterConfig(WriterConfig writerConfig, boolean bl2, int n2, Object[] objectArray) {
        super(writerConfig);
        this.mIsJ2MESubset = bl2;
        this.mConfigFlags = n2;
        this.mSpecialProperties = objectArray;
        SoftReference<BufferRecycler> softReference = mRecyclerRef.get();
        if (softReference != null) {
            this.mCurrRecycler = softReference.get();
        }
    }

    public static WriterConfig createJ2MEDefaults() {
        return new WriterConfig(null, true, 933, null);
    }

    public static WriterConfig createFullDefaults() {
        return new WriterConfig(null, false, 933, null);
    }

    public WriterConfig createNonShared() {
        Object[] objectArray;
        if (this.mSpecialProperties != null) {
            int n2 = this.mSpecialProperties.length;
            objectArray = new Object[n2];
            System.arraycopy(this.mSpecialProperties, 0, objectArray, 0, n2);
        } else {
            objectArray = null;
        }
        return new WriterConfig(this, this.mIsJ2MESubset, this.mConfigFlags, objectArray);
    }

    @Override
    protected int findPropertyId(String string) {
        Integer n2 = sProperties.get(string);
        return n2 == null ? -1 : n2;
    }

    @Override
    public Object getProperty(int n2) {
        switch (n2) {
            case 1: {
                return this.automaticNamespacesEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.willSupportNamespaces() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return this.getProblemReporter();
            }
            case 2: {
                return this.automaticEmptyElementsEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.willAutoCloseOutput() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return this.getAutomaticNsPrefix();
            }
            case 6: {
                return this.getTextEscaperFactory();
            }
            case 7: {
                return this.getAttrValueEscaperFactory();
            }
            case 10: {
                return this.willUseDoubleQuotesInXmlDecl() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return this.willOutputCDataAsText() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return this.willCopyDefaultAttrs() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return this.willEscapeCr() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 14: {
                return this.willAddSpaceAfterEmptyElem() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 15: {
                return this.automaticEndElementsEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 16: {
                return this.willValidateStructure() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 17: {
                return this.willValidateContent() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 18: {
                return this.willValidateAttributes() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 19: {
                return this.willValidateNames() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 20: {
                return this.willFixContent() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 21: {
                return this.getInvalidCharHandler();
            }
            case 22: {
                return this.getEmptyElementHandler();
            }
            case 30: 
            case 31: {
                throw new IllegalStateException("Can not access per-stream-writer properties via factory");
            }
        }
        throw new IllegalStateException("Internal error: no handler for property with internal id " + n2 + ".");
    }

    @Override
    public boolean setProperty(String string, int n2, Object object) {
        switch (n2) {
            case 1: {
                this.enableAutomaticNamespaces(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 4: {
                this.doSupportNamespaces(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 8: {
                this.setProblemReporter((XMLReporter)object);
                break;
            }
            case 2: {
                this.enableAutomaticEmptyElements(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 3: {
                this.doAutoCloseOutput(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 5: {
                this.setAutomaticNsPrefix(object.toString());
                break;
            }
            case 6: {
                this.setTextEscaperFactory((EscapingWriterFactory)object);
                break;
            }
            case 7: {
                this.setAttrValueEscaperFactory((EscapingWriterFactory)object);
                break;
            }
            case 10: {
                this.doUseDoubleQuotesInXmlDecl(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 11: {
                this.doOutputCDataAsText(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 12: {
                this.doCopyDefaultAttrs(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 13: {
                this.doEscapeCr(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 14: {
                this.doAddSpaceAfterEmptyElem(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 15: {
                this.enableAutomaticEndElements(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 16: {
                this.doValidateStructure(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 17: {
                this.doValidateContent(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 18: {
                this.doValidateAttributes(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 19: {
                this.doValidateNames(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 20: {
                this.doFixContent(ArgUtil.convertToBoolean(string, object));
                break;
            }
            case 21: {
                this.setInvalidCharHandler((InvalidCharHandler)object);
                break;
            }
            case 22: {
                this.setEmptyElementHandler((EmptyElementHandler)object);
                break;
            }
            case 30: 
            case 31: {
                throw new IllegalStateException("Can not modify per-stream-writer properties via factory");
            }
            default: {
                throw new IllegalStateException("Internal error: no handler for property with internal id " + n2 + ".");
            }
        }
        return true;
    }

    public int getConfigFlags() {
        return this.mConfigFlags;
    }

    public boolean automaticNamespacesEnabled() {
        return this.hasConfigFlag(2);
    }

    public boolean automaticEmptyElementsEnabled() {
        return this.hasConfigFlag(4);
    }

    public boolean willAutoCloseOutput() {
        return this.hasConfigFlag(8192);
    }

    public boolean willSupportNamespaces() {
        return this.hasConfigFlag(1);
    }

    public boolean willUseDoubleQuotesInXmlDecl() {
        return this.hasConfigFlag(16384);
    }

    public boolean willOutputCDataAsText() {
        return this.hasConfigFlag(8);
    }

    public boolean willCopyDefaultAttrs() {
        return this.hasConfigFlag(16);
    }

    public boolean willEscapeCr() {
        return this.hasConfigFlag(32);
    }

    public boolean willAddSpaceAfterEmptyElem() {
        return this.hasConfigFlag(64);
    }

    public boolean automaticEndElementsEnabled() {
        return this.hasConfigFlag(128);
    }

    public boolean willValidateStructure() {
        return this.hasConfigFlag(256);
    }

    public boolean willValidateContent() {
        return this.hasConfigFlag(512);
    }

    public boolean willValidateAttributes() {
        return this.hasConfigFlag(2048);
    }

    public boolean willValidateNames() {
        return this.hasConfigFlag(1024);
    }

    public boolean willFixContent() {
        return this.hasConfigFlag(4096);
    }

    public String getAutomaticNsPrefix() {
        String string = (String)this.getSpecialProperty(0);
        if (string == null) {
            string = DEFAULT_AUTOMATIC_NS_PREFIX;
        }
        return string;
    }

    public EscapingWriterFactory getTextEscaperFactory() {
        return (EscapingWriterFactory)this.getSpecialProperty(1);
    }

    public EscapingWriterFactory getAttrValueEscaperFactory() {
        return (EscapingWriterFactory)this.getSpecialProperty(2);
    }

    public XMLReporter getProblemReporter() {
        return (XMLReporter)this.getSpecialProperty(3);
    }

    public InvalidCharHandler getInvalidCharHandler() {
        return (InvalidCharHandler)this.getSpecialProperty(4);
    }

    public EmptyElementHandler getEmptyElementHandler() {
        return (EmptyElementHandler)this.getSpecialProperty(5);
    }

    public void enableAutomaticNamespaces(boolean bl2) {
        this.setConfigFlag(2, bl2);
    }

    public void enableAutomaticEmptyElements(boolean bl2) {
        this.setConfigFlag(4, bl2);
    }

    public void doAutoCloseOutput(boolean bl2) {
        this.setConfigFlag(8192, bl2);
    }

    public void doSupportNamespaces(boolean bl2) {
        this.setConfigFlag(1, bl2);
    }

    public void doUseDoubleQuotesInXmlDecl(boolean bl2) {
        this.setConfigFlag(16384, bl2);
    }

    public void doOutputCDataAsText(boolean bl2) {
        this.setConfigFlag(8, bl2);
    }

    public void doCopyDefaultAttrs(boolean bl2) {
        this.setConfigFlag(16, bl2);
    }

    public void doEscapeCr(boolean bl2) {
        this.setConfigFlag(32, bl2);
    }

    public void doAddSpaceAfterEmptyElem(boolean bl2) {
        this.setConfigFlag(64, bl2);
    }

    public void enableAutomaticEndElements(boolean bl2) {
        this.setConfigFlag(128, bl2);
    }

    public void doValidateStructure(boolean bl2) {
        this.setConfigFlag(256, bl2);
    }

    public void doValidateContent(boolean bl2) {
        this.setConfigFlag(512, bl2);
    }

    public void doValidateAttributes(boolean bl2) {
        this.setConfigFlag(2048, bl2);
    }

    public void doValidateNames(boolean bl2) {
        this.setConfigFlag(1024, bl2);
    }

    public void doFixContent(boolean bl2) {
        this.setConfigFlag(4096, bl2);
    }

    public void setAutomaticNsPrefix(String string) {
        this.setSpecialProperty(0, string);
    }

    public void setTextEscaperFactory(EscapingWriterFactory escapingWriterFactory) {
        this.setSpecialProperty(1, escapingWriterFactory);
    }

    public void setAttrValueEscaperFactory(EscapingWriterFactory escapingWriterFactory) {
        this.setSpecialProperty(2, escapingWriterFactory);
    }

    public void setProblemReporter(XMLReporter xMLReporter) {
        this.setSpecialProperty(3, xMLReporter);
    }

    public void setInvalidCharHandler(InvalidCharHandler invalidCharHandler) {
        this.setSpecialProperty(4, invalidCharHandler);
    }

    public void setEmptyElementHandler(EmptyElementHandler emptyElementHandler) {
        this.setSpecialProperty(5, emptyElementHandler);
    }

    public void configureForXmlConformance() {
        this.doValidateAttributes(true);
        this.doValidateContent(true);
        this.doValidateStructure(true);
        this.doValidateNames(true);
    }

    public void configureForRobustness() {
        this.doValidateAttributes(true);
        this.doValidateStructure(true);
        this.doValidateNames(true);
        this.doValidateContent(true);
        this.doFixContent(true);
    }

    public void configureForSpeed() {
        this.doValidateAttributes(false);
        this.doValidateContent(false);
        this.doValidateNames(false);
    }

    public char[] allocMediumCBuffer(int n2) {
        char[] cArray;
        if (this.mCurrRecycler != null && (cArray = this.mCurrRecycler.getMediumCBuffer(n2)) != null) {
            return cArray;
        }
        return new char[n2];
    }

    public void freeMediumCBuffer(char[] cArray) {
        if (this.mCurrRecycler == null) {
            this.mCurrRecycler = this.createRecycler();
        }
        this.mCurrRecycler.returnMediumCBuffer(cArray);
    }

    public char[] allocFullCBuffer(int n2) {
        char[] cArray;
        if (this.mCurrRecycler != null && (cArray = this.mCurrRecycler.getFullCBuffer(n2)) != null) {
            return cArray;
        }
        return new char[n2];
    }

    public void freeFullCBuffer(char[] cArray) {
        if (this.mCurrRecycler == null) {
            this.mCurrRecycler = this.createRecycler();
        }
        this.mCurrRecycler.returnFullCBuffer(cArray);
    }

    public byte[] allocFullBBuffer(int n2) {
        byte[] byArray;
        if (this.mCurrRecycler != null && (byArray = this.mCurrRecycler.getFullBBuffer(n2)) != null) {
            return byArray;
        }
        return new byte[n2];
    }

    public void freeFullBBuffer(byte[] byArray) {
        if (this.mCurrRecycler == null) {
            this.mCurrRecycler = this.createRecycler();
        }
        this.mCurrRecycler.returnFullBBuffer(byArray);
    }

    private BufferRecycler createRecycler() {
        BufferRecycler bufferRecycler = new BufferRecycler();
        mRecyclerRef.set(new SoftReference<BufferRecycler>(bufferRecycler));
        return bufferRecycler;
    }

    private void setConfigFlag(int n2, boolean bl2) {
        this.mConfigFlags = bl2 ? (this.mConfigFlags |= n2) : (this.mConfigFlags &= ~n2);
    }

    private final boolean hasConfigFlag(int n2) {
        return (this.mConfigFlags & n2) == n2;
    }

    private final Object getSpecialProperty(int n2) {
        if (this.mSpecialProperties == null) {
            return null;
        }
        return this.mSpecialProperties[n2];
    }

    private final void setSpecialProperty(int n2, Object object) {
        if (this.mSpecialProperties == null) {
            this.mSpecialProperties = new Object[6];
        }
        this.mSpecialProperties[n2] = object;
    }

    static {
        sProperties.put("javax.xml.stream.isRepairingNamespaces", DataUtil.Integer(1));
        sProperties.put("javax.xml.stream.isNamespaceAware", DataUtil.Integer(4));
        sProperties.put("com.gradle.maven.extension.internal.dep.org.codehaus.stax2.automaticEmptyElements", DataUtil.Integer(2));
        sProperties.put("com.gradle.maven.extension.internal.dep.org.codehaus.stax2.autoCloseOutput", DataUtil.Integer(3));
        sProperties.put("com.gradle.maven.extension.internal.dep.org.codehaus.stax2.automaticNsPrefix", DataUtil.Integer(5));
        sProperties.put("com.gradle.maven.extension.internal.dep.org.codehaus.stax2.textEscaper", DataUtil.Integer(6));
        sProperties.put("com.gradle.maven.extension.internal.dep.org.codehaus.stax2.attrValueEscaper", DataUtil.Integer(7));
        sProperties.put("javax.xml.stream.reporter", DataUtil.Integer(8));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.useDoubleQuotesInXmlDecl", DataUtil.Integer(10));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.outputCDataAsText", DataUtil.Integer(11));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.copyDefaultAttrs", DataUtil.Integer(12));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.outputEscapeCr", DataUtil.Integer(13));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.addSpaceAfterEmptyElem", DataUtil.Integer(14));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.automaticEndElements", DataUtil.Integer(15));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.outputInvalidCharHandler", DataUtil.Integer(21));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.outputEmptyElementHandler", DataUtil.Integer(22));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.outputValidateStructure", DataUtil.Integer(16));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.outputValidateContent", DataUtil.Integer(17));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.outputValidateAttr", DataUtil.Integer(18));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.outputValidateNames", DataUtil.Integer(19));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.outputFixContent", DataUtil.Integer(20));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.outputUnderlyingStream", DataUtil.Integer(30));
        sProperties.put("com.gradle.maven.extension.internal.dep.com.ctc.wstx.outputUnderlyingStream", DataUtil.Integer(30));
        mRecyclerRef = new ThreadLocal();
    }
}

