/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.ErrorConsts;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DTDValidatorBase;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.Attribute;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.AttributeCollector;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.CompactNsContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.Element;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.InputProblemReporter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sr.NsDefaultProvider;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.BaseNsContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.DataUtil;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.EmptyNamespaceContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.StringVector;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.TextBuffer;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.AttributeInfo;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.ValidationContext;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.ValidatorPair;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidationProblem;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidationSchema;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.validation.XMLValidator;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public final class InputElementStack
implements NamespaceContext,
AttributeInfo,
ValidationContext {
    static final int ID_ATTR_NONE = -1;
    protected final boolean mNsAware;
    protected final AttributeCollector mAttrCollector;
    protected final ReaderConfig mConfig;
    protected InputProblemReporter mReporter = null;
    protected NsDefaultProvider mNsDefaultProvider;
    protected int mDepth = 0;
    protected long mTotalElements = 0L;
    protected final StringVector mNamespaces = new StringVector(64);
    protected Element mCurrElement;
    protected boolean mMayHaveNsDefaults = false;
    protected XMLValidator mValidator = null;
    protected int mIdAttrIndex = -1;
    protected String mLastLocalName = null;
    protected String mLastPrefix = null;
    protected String mLastNsURI = null;
    protected QName mLastName = null;
    protected BaseNsContext mLastNsContext = null;
    protected Element mFreeElement = null;

    protected InputElementStack(ReaderConfig readerConfig, boolean bl2) {
        this.mConfig = readerConfig;
        this.mNsAware = bl2;
        this.mAttrCollector = new AttributeCollector(readerConfig, bl2);
    }

    protected void connectReporter(InputProblemReporter inputProblemReporter) {
        this.mReporter = inputProblemReporter;
    }

    protected XMLValidator addValidator(XMLValidator xMLValidator) {
        this.mValidator = this.mValidator == null ? xMLValidator : new ValidatorPair(this.mValidator, xMLValidator);
        return xMLValidator;
    }

    protected void setAutomaticDTDValidator(XMLValidator xMLValidator, NsDefaultProvider nsDefaultProvider) {
        this.mNsDefaultProvider = nsDefaultProvider;
        this.addValidator(xMLValidator);
    }

    public XMLValidator validateAgainst(XMLValidationSchema xMLValidationSchema) throws XMLStreamException {
        return this.addValidator(xMLValidationSchema.createValidator(this));
    }

    public XMLValidator stopValidatingAgainst(XMLValidationSchema xMLValidationSchema) throws XMLStreamException {
        XMLValidator[] xMLValidatorArray = new XMLValidator[2];
        if (ValidatorPair.removeValidator(this.mValidator, xMLValidationSchema, xMLValidatorArray)) {
            XMLValidator xMLValidator = xMLValidatorArray[0];
            this.mValidator = xMLValidatorArray[1];
            xMLValidator.validationCompleted(false);
            return xMLValidator;
        }
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidator xMLValidator) throws XMLStreamException {
        XMLValidator[] xMLValidatorArray = new XMLValidator[2];
        if (ValidatorPair.removeValidator(this.mValidator, xMLValidator, xMLValidatorArray)) {
            XMLValidator xMLValidator2 = xMLValidatorArray[0];
            this.mValidator = xMLValidatorArray[1];
            xMLValidator2.validationCompleted(false);
            return xMLValidator2;
        }
        return null;
    }

    protected boolean reallyValidating() {
        if (this.mValidator == null) {
            return false;
        }
        if (!(this.mValidator instanceof DTDValidatorBase)) {
            return true;
        }
        return ((DTDValidatorBase)this.mValidator).reallyValidating();
    }

    public final AttributeCollector getAttrCollector() {
        return this.mAttrCollector;
    }

    public BaseNsContext createNonTransientNsContext(Location location) {
        if (this.mLastNsContext != null) {
            return this.mLastNsContext;
        }
        int n2 = this.mNamespaces.size();
        if (n2 < 1) {
            this.mLastNsContext = EmptyNamespaceContext.getInstance();
            return this.mLastNsContext;
        }
        int n3 = this.getCurrentNsCount() << 1;
        CompactNsContext compactNsContext = new CompactNsContext(location, this.mNamespaces.asArray(), n2, n2 - n3);
        if (n3 == 0) {
            this.mLastNsContext = compactNsContext;
        }
        return compactNsContext;
    }

    public final void push(String string, String string2) throws XMLStreamException {
        String string3;
        if (++this.mDepth > this.mConfig.getMaxElementDepth()) {
            throw new XMLStreamException("Maximum Element Depth limit (" + this.mConfig.getMaxElementDepth() + ") Exceeded");
        }
        if (++this.mTotalElements > this.mConfig.getMaxElementCount()) {
            throw new XMLStreamException("Maximum Element Count limit (" + this.mConfig.getMaxElementCount() + ") Exceeded");
        }
        String string4 = string3 = this.mCurrElement == null ? "" : this.mCurrElement.mDefaultNsURI;
        if (this.mCurrElement != null) {
            ++this.mCurrElement.mChildCount;
            int n2 = this.mConfig.getMaxChildrenPerElement();
            if (n2 > 0 && this.mCurrElement.mChildCount > n2) {
                throw new XMLStreamException("Maximum Number of Child Elements limit (" + n2 + ") Exceeded");
            }
        }
        if (this.mFreeElement == null) {
            this.mCurrElement = new Element(this.mCurrElement, this.mNamespaces.size(), string, string2);
        } else {
            Element element = this.mFreeElement;
            this.mFreeElement = element.mParent;
            element.reset(this.mCurrElement, this.mNamespaces.size(), string, string2);
            this.mCurrElement = element;
        }
        this.mCurrElement.mDefaultNsURI = string3;
        this.mAttrCollector.reset();
        if (this.mNsDefaultProvider != null) {
            this.mMayHaveNsDefaults = this.mNsDefaultProvider.mayHaveNsDefaults(string, string2);
        }
    }

    public final boolean pop() throws XMLStreamException {
        Element element;
        if (this.mCurrElement == null) {
            throw new IllegalStateException("Popping from empty stack");
        }
        --this.mDepth;
        Element element2 = this.mCurrElement;
        this.mCurrElement = element = element2.mParent;
        element2.relink(this.mFreeElement);
        this.mFreeElement = element2;
        int n2 = this.mNamespaces.size() - element2.mNsOffset;
        if (n2 > 0) {
            this.mLastNsContext = null;
            this.mNamespaces.removeLast(n2);
        }
        return element != null;
    }

    public int resolveAndValidateElement() throws XMLStreamException {
        String string;
        String string2;
        Object object;
        int n2;
        if (this.mDepth == 0) {
            throw new IllegalStateException("Calling validate() on empty stack.");
        }
        AttributeCollector attributeCollector = this.mAttrCollector;
        int n3 = attributeCollector.getNsCount();
        if (n3 > 0) {
            this.mLastNsContext = null;
            boolean bl2 = this.mConfig.willInternNsURIs();
            for (n2 = 0; n2 < n3; ++n2) {
                object = attributeCollector.resolveNamespaceDecl(n2, bl2);
                String string3 = ((Attribute)object).mNamespaceURI;
                String string4 = ((Attribute)object).mLocalName;
                if (string4 == "xmlns") {
                    this.mReporter.throwParseError(ErrorConsts.ERR_NS_REDECL_XMLNS);
                    continue;
                }
                if (string4 == "xml") {
                    if ("http://www.w3.org/XML/1998/namespace".equals(string3)) continue;
                    this.mReporter.throwParseError(ErrorConsts.ERR_NS_REDECL_XML, string3, null);
                    continue;
                }
                if (string3 == null || string3.length() == 0) {
                    string3 = "";
                }
                if (string4 == null) {
                    this.mCurrElement.mDefaultNsURI = string3;
                }
                if (bl2) {
                    if (string3 == "http://www.w3.org/XML/1998/namespace") {
                        this.mReporter.throwParseError(ErrorConsts.ERR_NS_REDECL_XML_URI, string4, null);
                    } else if (string3 == "http://www.w3.org/2000/xmlns/") {
                        this.mReporter.throwParseError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI);
                    }
                } else if (string3.equals("http://www.w3.org/XML/1998/namespace")) {
                    this.mReporter.throwParseError(ErrorConsts.ERR_NS_REDECL_XML_URI, string4, null);
                } else if (string3.equals("http://www.w3.org/2000/xmlns/")) {
                    this.mReporter.throwParseError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI);
                }
                this.mNamespaces.addStrings(string4, string3);
            }
        }
        if (this.mMayHaveNsDefaults) {
            this.mNsDefaultProvider.checkNsDefaults(this);
        }
        if ((string2 = this.mCurrElement.mPrefix) == null) {
            string = this.mCurrElement.mDefaultNsURI;
        } else if (string2 == "xml") {
            string = "http://www.w3.org/XML/1998/namespace";
        } else {
            string = this.mNamespaces.findLastFromMap(string2);
            if (string == null || string.length() == 0) {
                this.mReporter.throwParseError(ErrorConsts.ERR_NS_UNDECLARED, string2, null);
            }
        }
        this.mCurrElement.mNamespaceURI = string;
        this.mIdAttrIndex = n2 = attributeCollector.resolveNamespaces(this.mReporter, this.mNamespaces);
        object = this.mValidator;
        if (object == null) {
            if (n2 >= 0) {
                attributeCollector.normalizeSpacesInValue(n2);
            }
            return 4;
        }
        ((XMLValidator)object).validateElementStart(this.mCurrElement.mLocalName, this.mCurrElement.mNamespaceURI, this.mCurrElement.mPrefix);
        int n4 = attributeCollector.getCount();
        if (n4 > 0) {
            for (int i2 = 0; i2 < n4; ++i2) {
                attributeCollector.validateAttribute(i2, this.mValidator);
            }
        }
        return this.mValidator.validateElementAndAttributes();
    }

    public int validateEndElement() throws XMLStreamException {
        if (this.mValidator == null) {
            return 4;
        }
        int n2 = this.mValidator.validateElementEnd(this.mCurrElement.mLocalName, this.mCurrElement.mNamespaceURI, this.mCurrElement.mPrefix);
        if (this.mDepth == 1) {
            this.mValidator.validationCompleted(true);
        }
        return n2;
    }

    @Override
    public final int getAttributeCount() {
        return this.mAttrCollector.getCount();
    }

    @Override
    public final int findAttributeIndex(String string, String string2) {
        return this.mAttrCollector.findIndex(string, string2);
    }

    @Override
    public final int getIdAttributeIndex() {
        if (this.mIdAttrIndex >= 0) {
            return this.mIdAttrIndex;
        }
        return this.mValidator == null ? -1 : this.mValidator.getIdAttrIndex();
    }

    @Override
    public final int getNotationAttributeIndex() {
        return this.mValidator == null ? -1 : this.mValidator.getNotationAttrIndex();
    }

    @Override
    public final String getNamespaceURI(String string) {
        if (string == null) {
            throw new IllegalArgumentException(ErrorConsts.ERR_NULL_ARG);
        }
        if (string.length() == 0) {
            if (this.mDepth == 0) {
                return "";
            }
            return this.mCurrElement.mDefaultNsURI;
        }
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return this.mNamespaces.findLastNonInterned(string);
    }

    @Override
    public final String getPrefix(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        String string2 = null;
        String[] stringArray = this.mNamespaces.getInternalArray();
        int n2 = this.mNamespaces.size();
        block0: for (int i2 = n2 - 1; i2 > 0; i2 -= 2) {
            if (!string.equals(stringArray[i2])) continue;
            string2 = stringArray[i2 - 1];
            for (int i3 = i2 + 1; i3 < n2; i3 += 2) {
                if (stringArray[i3] != string2) continue;
                string2 = null;
                continue block0;
            }
            if (string2 != null) break;
            string2 = "";
            break;
        }
        return string2;
    }

    @Override
    public final Iterator<String> getPrefixes(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return DataUtil.singletonIterator("xml");
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            return DataUtil.singletonIterator("xmlns");
        }
        String[] stringArray = this.mNamespaces.getInternalArray();
        int n2 = this.mNamespaces.size();
        ArrayList<String> arrayList = null;
        block0: for (int i2 = n2 - 1; i2 > 0; i2 -= 2) {
            if (!string.equals(stringArray[i2])) continue;
            String string2 = stringArray[i2 - 1];
            for (int i3 = i2 + 1; i3 < n2; i3 += 2) {
                if (stringArray[i3] == string2) continue block0;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string2);
        }
        if (arrayList == null) {
            return DataUtil.emptyIterator();
        }
        return arrayList.iterator();
    }

    @Override
    public final String getXmlVersion() {
        return this.mConfig.isXml11() ? "1.1" : "1.0";
    }

    @Override
    public String getAttributeLocalName(int n2) {
        return this.getAttrCollector().getLocalName(n2);
    }

    @Override
    public String getAttributeNamespace(int n2) {
        return this.getAttrCollector().getURI(n2);
    }

    @Override
    public String getAttributePrefix(int n2) {
        return this.getAttrCollector().getPrefix(n2);
    }

    @Override
    public String getAttributeValue(int n2) {
        return this.getAttrCollector().getValue(n2);
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        int n2 = this.findAttributeIndex(string, string2);
        return n2 < 0 ? null : this.getAttributeValue(n2);
    }

    @Override
    public boolean isNotationDeclared(String string) {
        return false;
    }

    @Override
    public boolean isUnparsedEntityDeclared(String string) {
        return false;
    }

    @Override
    public String getBaseUri() {
        return null;
    }

    @Override
    public final QName getCurrentElementName() {
        QName qName;
        if (this.mDepth == 0) {
            return null;
        }
        String string = this.mCurrElement.mPrefix;
        if (string == null) {
            string = "";
        }
        String string2 = this.mCurrElement.mNamespaceURI;
        String string3 = this.mCurrElement.mLocalName;
        if (string3 != this.mLastLocalName) {
            this.mLastLocalName = string3;
            this.mLastPrefix = string;
            this.mLastNsURI = string2;
        } else if (string != this.mLastPrefix) {
            this.mLastPrefix = string;
            this.mLastNsURI = string2;
        } else if (string2 != this.mLastNsURI) {
            this.mLastNsURI = string2;
        } else {
            return this.mLastName;
        }
        this.mLastName = qName = new QName(string2, string3, string);
        return qName;
    }

    @Override
    public Location getValidationLocation() {
        return this.mReporter.getLocation();
    }

    @Override
    public void reportProblem(XMLValidationProblem xMLValidationProblem) throws XMLStreamException {
        this.mReporter.reportValidationProblem(xMLValidationProblem);
    }

    @Override
    public int addDefaultAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        return this.mAttrCollector.addDefaultAttribute(string, string2, string3, string4);
    }

    public boolean isPrefixLocallyDeclared(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        int n2 = this.mNamespaces.size();
        for (int i2 = this.mCurrElement.mNsOffset; i2 < n2; i2 += 2) {
            String string2 = this.mNamespaces.getString(i2);
            if (string2 != string) continue;
            return true;
        }
        return false;
    }

    public void addNsBinding(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            string2 = null;
        }
        if (string == null || string.length() == 0) {
            string = null;
            this.mCurrElement.mDefaultNsURI = string2;
        }
        this.mNamespaces.addStrings(string, string2);
    }

    public final void validateText(TextBuffer textBuffer, boolean bl2) throws XMLStreamException {
        textBuffer.validateText(this.mValidator, bl2);
    }

    public final void validateText(String string, boolean bl2) throws XMLStreamException {
        this.mValidator.validateText(string, bl2);
    }

    public final boolean isNamespaceAware() {
        return this.mNsAware;
    }

    public final boolean isEmpty() {
        return this.mDepth == 0;
    }

    public final int getDepth() {
        return this.mDepth;
    }

    public final String getDefaultNsURI() {
        if (this.mDepth == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mCurrElement.mDefaultNsURI;
    }

    public final String getNsURI() {
        if (this.mDepth == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mCurrElement.mNamespaceURI;
    }

    public final String getPrefix() {
        if (this.mDepth == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mCurrElement.mPrefix;
    }

    public final String getLocalName() {
        if (this.mDepth == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mCurrElement.mLocalName;
    }

    public final boolean matches(String string, String string2) {
        if (this.mDepth == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        String string3 = this.mCurrElement.mPrefix;
        if (string == null || string.length() == 0 ? string3 != null && string3.length() > 0 : string3 != string && !string.equals(string3)) {
            return false;
        }
        String string4 = this.mCurrElement.mLocalName;
        return string4 == string2 || string4.equals(string2);
    }

    public final String getTopElementDesc() {
        if (this.mDepth == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        String string = this.mCurrElement.mLocalName;
        String string2 = this.mCurrElement.mPrefix;
        if (string2 == null) {
            return string;
        }
        return string2 + ":" + string;
    }

    public final int getTotalNsCount() {
        return this.mNamespaces.size() >> 1;
    }

    public final int getCurrentNsCount() {
        return this.mNamespaces.size() - this.mCurrElement.mNsOffset >> 1;
    }

    public final String getLocalNsPrefix(int n2) {
        int n3 = this.mCurrElement.mNsOffset;
        int n4 = this.mNamespaces.size() - n3;
        if ((n2 <<= 1) < 0 || n2 >= n4) {
            this.throwIllegalIndex(n2 >> 1, n4 >> 1);
        }
        return this.mNamespaces.getString(n3 + n2);
    }

    public final String getLocalNsURI(int n2) {
        int n3 = this.mCurrElement.mNsOffset;
        int n4 = this.mNamespaces.size() - n3;
        if ((n2 <<= 1) < 0 || n2 >= n4) {
            this.throwIllegalIndex(n2 >> 1, n4 >> 1);
        }
        return this.mNamespaces.getString(n3 + n2 + 1);
    }

    private void throwIllegalIndex(int n2, int n3) {
        throw new IllegalArgumentException("Illegal namespace index " + (n2 >> 1) + "; current scope only has " + (n3 >> 1) + " namespace declarations.");
    }

    @Override
    public final String getAttributeType(int n2) {
        if (n2 == this.mIdAttrIndex && n2 >= 0) {
            return "ID";
        }
        return this.mValidator == null ? "CDATA" : this.mValidator.getAttributeType(n2);
    }
}

