/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.util;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.ExceptionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.regex.Pattern;

public final class URLUtil {
    private static final Pattern URI_WINDOWS_FILE_PATTERN = Pattern.compile("^file:///\\p{Alpha}|.*$");

    private URLUtil() {
    }

    public static URL urlFromSystemId(String string) throws IOException {
        try {
            string = URLUtil.cleanSystemId(string);
            int n2 = string.indexOf(58, 0);
            if (n2 >= 3 && n2 <= 8) {
                return new URL(string);
            }
            String string2 = new File(string).getAbsolutePath();
            char c2 = File.separatorChar;
            if (c2 != '/') {
                string2 = string2.replace(c2, '/');
            }
            if (string2.length() > 0 && string2.charAt(0) != '/') {
                string2 = "/" + string2;
            }
            return new URL("file", "", string2);
        }
        catch (MalformedURLException malformedURLException) {
            URLUtil.throwIOException(malformedURLException, string);
            return null;
        }
    }

    public static URI uriFromSystemId(String string) throws IOException {
        try {
            if (string.indexOf(124, 0) > 0 && URI_WINDOWS_FILE_PATTERN.matcher(string).matches()) {
                return new URI(string.replace('|', ':'));
            }
            int n2 = string.indexOf(58, 0);
            if (n2 >= 3 && n2 <= 8) {
                return new URI(string);
            }
            String string2 = new File(string).getAbsolutePath();
            char c2 = File.separatorChar;
            if (c2 != '/') {
                string2 = string2.replace(c2, '/');
            }
            if (string2.length() > 0 && string2.charAt(0) != '/') {
                string2 = "/" + string2;
            }
            return new URI("file", string2, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            URLUtil.throwIOException(uRISyntaxException, string);
            return null;
        }
    }

    public static URL urlFromSystemId(String string, URL uRL) throws IOException {
        if (uRL == null) {
            return URLUtil.urlFromSystemId(string);
        }
        try {
            string = URLUtil.cleanSystemId(string);
            return new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            URLUtil.throwIOException(malformedURLException, string);
            return null;
        }
    }

    public static URL urlFromCurrentDir() throws IOException {
        File file = new File("a").getAbsoluteFile().getParentFile();
        return URLUtil.toURL(file);
    }

    public static InputStream inputStreamFromURL(URL uRL) throws IOException {
        String string;
        if ("file".equals(uRL.getProtocol()) && ((string = uRL.getHost()) == null || string.length() == 0)) {
            String string2 = uRL.getPath();
            if (string2.indexOf(37) >= 0) {
                string2 = URLDecoder.decode(string2, "UTF-8");
            }
            return new FileInputStream(string2);
        }
        return uRL.openStream();
    }

    public static OutputStream outputStreamFromURL(URL uRL) throws IOException {
        String string;
        if ("file".equals(uRL.getProtocol()) && ((string = uRL.getHost()) == null || string.length() == 0)) {
            return new FileOutputStream(uRL.getPath());
        }
        return uRL.openConnection().getOutputStream();
    }

    public static URL toURL(File file) throws IOException {
        return file.toURI().toURL();
    }

    private static String cleanSystemId(String string) {
        int n2 = string.indexOf(124);
        if (n2 > 0 && URI_WINDOWS_FILE_PATTERN.matcher(string).matches()) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.setCharAt(n2, ':');
            return stringBuilder.toString();
        }
        return string;
    }

    private static void throwIOException(Exception exception, String string) throws IOException {
        String string2 = "[resolving systemId '" + string + "']: " + exception.toString();
        throw ExceptionUtil.constructIOException(string2, exception);
    }
}

