/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.util;

import java.util.TreeSet;

public final class WordSet {
    static final char CHAR_NULL = '\u0000';
    static final int NEGATIVE_OFFSET = 49152;
    static final int MIN_BINARY_SEARCH = 7;
    final char[] mData;

    private WordSet(char[] cArray) {
        this.mData = cArray;
    }

    public static WordSet constructSet(TreeSet<String> treeSet) {
        return new WordSet(new Builder(treeSet).construct());
    }

    public static char[] constructRaw(TreeSet<String> treeSet) {
        return new Builder(treeSet).construct();
    }

    public boolean contains(char[] cArray, int n2, int n3) {
        return WordSet.contains(this.mData, cArray, n2, n3);
    }

    public static boolean contains(char[] cArray, char[] cArray2, int n2, int n3) {
        int n4 = 0;
        block0: do {
            int n5;
            int n6;
            char c2;
            int n7;
            if ((n7 = n3 - n2) == 0) {
                return cArray[n4 + 1] == '\u0000';
            }
            if ((c2 = cArray[n4++]) >= '\uc000') {
                n6 = c2 - 49152;
                if (n7 != n6) {
                    return false;
                }
                while (n2 < n3) {
                    if (cArray[n4] != cArray2[n2]) {
                        return false;
                    }
                    ++n4;
                    ++n2;
                }
                return true;
            }
            n6 = cArray2[n2++];
            if (c2 < '\u0007') {
                if (cArray[n4] == n6) {
                    n4 = cArray[n4 + 1];
                    continue;
                }
                if (cArray[n4 + 2] == n6) {
                    n4 = cArray[n4 + 3];
                    continue;
                }
                n5 = n4 + (c2 << 1);
                n4 += 4;
                while (n4 < n5) {
                    if (cArray[n4] == n6) {
                        n4 = cArray[n4 + 1];
                        continue block0;
                    }
                    n4 += 2;
                }
                return false;
            }
            n5 = 0;
            int n8 = c2 - '\u0001';
            while (n5 <= n8) {
                int n9 = n5 + n8 >> 1;
                int n10 = n4 + (n9 << 1);
                int n11 = cArray[n10] - n6;
                if (n11 > 0) {
                    n8 = n9 - 1;
                    continue;
                }
                if (n11 < 0) {
                    n5 = n9 + 1;
                    continue;
                }
                n4 = cArray[n10 + 1];
                continue block0;
            }
            return false;
        } while (n4 != 0);
        return n2 == n3;
    }

    public boolean contains(String string) {
        return WordSet.contains(this.mData, string);
    }

    public static boolean contains(char[] cArray, String string) {
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        block0: do {
            int n5;
            int n6;
            char c2;
            int n7;
            if ((n7 = n4 - n3) == 0) {
                return cArray[n2 + 1] == '\u0000';
            }
            if ((c2 = cArray[n2++]) >= '\uc000') {
                n6 = c2 - 49152;
                if (n7 != n6) {
                    return false;
                }
                while (n3 < n4) {
                    if (cArray[n2] != string.charAt(n3)) {
                        return false;
                    }
                    ++n2;
                    ++n3;
                }
                return true;
            }
            n6 = string.charAt(n3++);
            if (c2 < '\u0007') {
                if (cArray[n2] == n6) {
                    n2 = cArray[n2 + 1];
                    continue;
                }
                if (cArray[n2 + 2] == n6) {
                    n2 = cArray[n2 + 3];
                    continue;
                }
                n5 = n2 + (c2 << 1);
                n2 += 4;
                while (n2 < n5) {
                    if (cArray[n2] == n6) {
                        n2 = cArray[n2 + 1];
                        continue block0;
                    }
                    n2 += 2;
                }
                return false;
            }
            n5 = 0;
            int n8 = c2 - '\u0001';
            while (n5 <= n8) {
                int n9 = n5 + n8 >> 1;
                int n10 = n2 + (n9 << 1);
                int n11 = cArray[n10] - n6;
                if (n11 > 0) {
                    n8 = n9 - 1;
                    continue;
                }
                if (n11 < 0) {
                    n5 = n9 + 1;
                    continue;
                }
                n2 = cArray[n10 + 1];
                continue block0;
            }
            return false;
        } while (n2 != 0);
        return n3 == n4;
    }

    private static final class Builder {
        final String[] mWords;
        char[] mData;
        int mSize;

        public Builder(TreeSet<String> treeSet) {
            int n2 = treeSet.size();
            this.mWords = new String[n2];
            treeSet.toArray(this.mWords);
            int n3 = n2 * 12;
            if (n3 < 256) {
                n3 = 256;
            }
            this.mData = new char[n3];
        }

        public char[] construct() {
            if (this.mWords.length == 1) {
                this.constructLeaf(0, 0);
            } else {
                this.constructBranch(0, 0, this.mWords.length);
            }
            char[] cArray = new char[this.mSize];
            System.arraycopy(this.mData, 0, cArray, 0, this.mSize);
            return cArray;
        }

        private void constructBranch(int n2, int n3, int n4) {
            int n5;
            if (this.mSize >= this.mData.length) {
                this.expand(1);
            }
            this.mData[this.mSize++] = '\u0000';
            int n6 = this.mSize + 1;
            int n7 = 0;
            String[] stringArray = this.mWords;
            int n8 = n3;
            if (stringArray[n8].length() == n2) {
                if (this.mSize + 2 > this.mData.length) {
                    this.expand(2);
                }
                this.mData[this.mSize++] = '\u0000';
                this.mData[this.mSize++] = '\u0000';
                ++n8;
                ++n7;
            }
            while (n8 < n4) {
                int n9;
                n5 = stringArray[n8].charAt(n2);
                for (n9 = n8 + 1; n9 < n4 && stringArray[n9].charAt(n2) == n5; ++n9) {
                }
                if (this.mSize + 2 > this.mData.length) {
                    this.expand(2);
                }
                this.mData[this.mSize++] = n5;
                this.mData[this.mSize++] = (char)(n9 - n8);
                n8 = n9;
                ++n7;
            }
            this.mData[n6 - 2] = (char)n7;
            n8 = n3;
            if (this.mData[n6] == '\u0000') {
                n6 += 2;
                ++n8;
            }
            n5 = this.mSize;
            ++n2;
            while (n6 < n5) {
                n7 = this.mData[n6];
                this.mData[n6] = (char)this.mSize;
                if (n7 == 1) {
                    String string = stringArray[n8];
                    if (string.length() == n2) {
                        this.mData[n6] = '\u0000';
                    } else {
                        this.constructLeaf(n2, n8);
                    }
                } else {
                    this.constructBranch(n2, n8, n8 + n7);
                }
                n8 += n7;
                n6 += 2;
            }
        }

        private void constructLeaf(int n2, int n3) {
            char[] cArray;
            String string = this.mWords[n3];
            int n4 = string.length();
            if (this.mSize + n4 + 1 >= (cArray = this.mData).length) {
                cArray = this.expand(n4 + 1);
            }
            cArray[this.mSize++] = (char)(49152 + (n4 - n2));
            while (n2 < n4) {
                cArray[this.mSize++] = string.charAt(n2);
                ++n2;
            }
        }

        private char[] expand(int n2) {
            int n3;
            char[] cArray = this.mData;
            int n4 = n3 + ((n3 = cArray.length) < 4096 ? n3 : n3 >> 1);
            if (n4 < this.mSize + n2) {
                n4 = this.mSize + n2 + 64;
            }
            this.mData = new char[n4];
            System.arraycopy(cArray, 0, this.mData, 0, n3);
            return this.mData;
        }
    }
}

