/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.util.concurrent.AbstractFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class Platform {
    static void restoreInterruptIfIsInterruptedException(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    static void interruptCurrentThread() {
        Thread.currentThread().interrupt();
    }

    static void rethrowIfErrorOtherThanStackOverflow(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        if (throwable instanceof Error && !(throwable instanceof StackOverflowError)) {
            throw (Error)throwable;
        }
    }

    static <V> V get(AbstractFuture<V> abstractFuture) throws InterruptedException, ExecutionException {
        return abstractFuture.blockingGet();
    }

    static <V> V get(AbstractFuture<V> abstractFuture, long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return abstractFuture.blockingGet(l2, timeUnit);
    }
}

