/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.expression;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.ClassLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaField;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.expression.AnnotationValue;
import java.util.List;
import java.util.StringTokenizer;

public class FieldRef
implements AnnotationValue {
    private final int[] parts;
    private final String name;
    private JavaClass declaringClass;
    private ClassLibrary classLibrary;
    private JavaField field;
    private int fieldIndex = -1;

    public FieldRef(String string) {
        this.name = string;
        int n2 = new StringTokenizer(string, ".").countTokens();
        this.parts = new int[n2 + 1];
        this.parts[0] = -1;
        for (int i2 = 1; i2 < n2; ++i2) {
            this.parts[i2] = string.indexOf(46, this.parts[i2 - 1] + 1);
        }
        this.parts[n2] = string.length();
    }

    public String getName() {
        return this.name;
    }

    public String getNamePrefix(int n2) {
        return this.name.substring(0, this.parts[n2 + 1]);
    }

    public String getNamePart(int n2) {
        return this.name.substring(this.parts[n2] + 1, this.parts[n2 + 1]);
    }

    @Override
    public String getParameterValue() {
        return this.getName();
    }

    public String toString() {
        JavaField javaField = this.getField();
        if (javaField != null && !this.getDeclaringClass().equals(javaField.getDeclaringClass())) {
            return javaField.getDeclaringClass().getCanonicalName() + "." + javaField.getName();
        }
        return this.name;
    }

    public void setDeclaringClass(JavaClass javaClass) {
        this.declaringClass = javaClass;
    }

    public void setClassLibrary(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
    }

    protected JavaField resolveField(JavaClass javaClass, int n2, int n3) {
        JavaField javaField = null;
        for (int i2 = n2; i2 < n3 && (javaField = javaClass.getFieldByName(this.getNamePart(i2))) == null; ++i2) {
        }
        return javaField;
    }

    public JavaField getField() {
        if (this.fieldIndex < 0) {
            ClassLibrary classLibrary;
            JavaClass javaClass = this.getDeclaringClass();
            if (javaClass != null) {
                this.field = this.resolveField(javaClass, 0, this.parts.length - 1);
                this.fieldIndex = 0;
            }
            if (this.field == null && (classLibrary = this.getClassLibrary()) != null) {
                for (int i2 = 0; i2 < this.parts.length - 1; ++i2) {
                    String string = this.getNamePrefix(i2);
                    if (!classLibrary.hasClassReference(string)) continue;
                    JavaClass object = classLibrary.getJavaClass(string);
                    this.fieldIndex = i2 + 1;
                    this.field = this.resolveField(object, i2 + 1, this.parts.length - 1);
                    break;
                }
            }
            if (this.field == null && (classLibrary = this.getClassLibrary()) != null) {
                List<String> list = this.getDeclaringClass().getSource().getImports();
                for (String string : list) {
                    String string2;
                    JavaClass javaClass2;
                    JavaField javaField;
                    String string3;
                    if (!string.startsWith("static") || !"*".equals(string3 = string.substring(string.lastIndexOf(46) + 1)) && !this.getNamePrefix(0).equals(string3) || (javaField = (javaClass2 = classLibrary.getJavaClass(string2 = string.substring(7, string.lastIndexOf(46)).trim())).getFieldByName(string3)) == null || !javaClass2.isInterface() && !javaField.isStatic()) continue;
                    this.field = javaField;
                    break;
                }
            }
        }
        return this.field;
    }

    private JavaClass getDeclaringClass() {
        return this.declaringClass;
    }

    private ClassLibrary getClassLibrary() {
        return this.classLibrary;
    }
}

