/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.buffer;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PoolChunk;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PoolThreadCache;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PooledDuplicatedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.PooledSlicedByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.util.Recycler;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectPool;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

abstract class PooledByteBuf<T>
extends AbstractReferenceCountedByteBuf {
    private final Recycler.EnhancedHandle<PooledByteBuf<T>> recyclerHandle;
    protected PoolChunk<T> chunk;
    protected long handle;
    protected T memory;
    protected int offset;
    protected int length;
    int maxLength;
    PoolThreadCache cache;
    ByteBuffer tmpNioBuf;
    private ByteBufAllocator allocator;

    protected PooledByteBuf(ObjectPool.Handle<? extends PooledByteBuf<T>> handle, int n2) {
        super(n2);
        this.recyclerHandle = (Recycler.EnhancedHandle)handle;
    }

    void init(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l2, int n2, int n3, int n4, PoolThreadCache poolThreadCache) {
        this.init0(poolChunk, byteBuffer, l2, n2, n3, n4, poolThreadCache);
    }

    void initUnpooled(PoolChunk<T> poolChunk, int n2) {
        this.init0(poolChunk, null, 0L, 0, n2, n2, null);
    }

    private void init0(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l2, int n2, int n3, int n4, PoolThreadCache poolThreadCache) {
        assert (l2 >= 0L);
        assert (poolChunk != null);
        assert (!PoolChunk.isSubpage(l2) || poolChunk.arena.sizeClass.size2SizeIdx(n4) <= poolChunk.arena.sizeClass.smallMaxSizeIdx) : "Allocated small sub-page handle for a buffer size that isn't \"small.\"";
        poolChunk.incrementPinnedMemory(n4);
        this.chunk = poolChunk;
        this.memory = poolChunk.memory;
        this.tmpNioBuf = byteBuffer;
        this.allocator = poolChunk.arena.parent;
        this.cache = poolThreadCache;
        this.handle = l2;
        this.offset = n2;
        this.length = n3;
        this.maxLength = n4;
    }

    final void reuse(int n2) {
        this.maxCapacity(n2);
        this.resetRefCnt();
        this.setIndex0(0, 0);
        this.discardMarks();
    }

    @Override
    public final int capacity() {
        return this.length;
    }

    @Override
    public int maxFastWritableBytes() {
        return Math.min(this.maxLength, this.maxCapacity()) - this.writerIndex;
    }

    @Override
    public final ByteBuf capacity(int n2) {
        if (n2 == this.length) {
            this.ensureAccessible();
            return this;
        }
        this.checkNewCapacity(n2);
        if (!this.chunk.unpooled) {
            if (n2 > this.length) {
                if (n2 <= this.maxLength) {
                    this.length = n2;
                    return this;
                }
            } else if (n2 > this.maxLength >>> 1 && (this.maxLength > 512 || n2 > this.maxLength - 16)) {
                this.length = n2;
                this.trimIndicesToCapacity(n2);
                return this;
            }
        }
        this.chunk.arena.reallocate(this, n2);
        return this;
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        return PooledDuplicatedByteBuf.newInstance(this, this, this.readerIndex(), this.writerIndex());
    }

    @Override
    public final ByteBuf retainedSlice() {
        int n2 = this.readerIndex();
        return this.retainedSlice(n2, this.writerIndex() - n2);
    }

    @Override
    public final ByteBuf retainedSlice(int n2, int n3) {
        return PooledSlicedByteBuf.newInstance(this, this, n2, n3);
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = this.newInternalNioBuffer(this.memory);
        } else {
            byteBuffer.clear();
        }
        return byteBuffer;
    }

    protected abstract ByteBuffer newInternalNioBuffer(T var1);

    @Override
    protected final void deallocate() {
        if (this.handle >= 0L) {
            long l2 = this.handle;
            this.handle = -1L;
            this.memory = null;
            this.chunk.arena.free(this.chunk, this.tmpNioBuf, l2, this.maxLength, this.cache);
            this.tmpNioBuf = null;
            this.chunk = null;
            this.cache = null;
            this.recyclerHandle.unguardedRecycle(this);
        }
    }

    protected final int idx(int n2) {
        return this.offset + n2;
    }

    final ByteBuffer _internalNioBuffer(int n2, int n3, boolean bl2) {
        n2 = this.idx(n2);
        ByteBuffer byteBuffer = bl2 ? this.newInternalNioBuffer(this.memory) : this.internalNioBuffer();
        byteBuffer.limit(n2 + n3).position(n2);
        return byteBuffer;
    }

    ByteBuffer duplicateInternalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this._internalNioBuffer(n2, n3, true);
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this._internalNioBuffer(n2, n3, false);
    }

    @Override
    public final int nioBufferCount() {
        return 1;
    }

    @Override
    public final ByteBuffer nioBuffer(int n2, int n3) {
        return this.duplicateInternalNioBuffer(n2, n3).slice();
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{this.nioBuffer(n2, n3)};
    }

    @Override
    public final boolean isContiguous() {
        return true;
    }

    @Override
    public final int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) throws IOException {
        return gatheringByteChannel.write(this.duplicateInternalNioBuffer(n2, n3));
    }

    @Override
    public final int readBytes(GatheringByteChannel gatheringByteChannel, int n2) throws IOException {
        this.checkReadableBytes(n2);
        int n3 = gatheringByteChannel.write(this._internalNioBuffer(this.readerIndex, n2, false));
        this.readerIndex += n3;
        return n3;
    }

    @Override
    public final int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) throws IOException {
        try {
            return scatteringByteChannel.read(this.internalNioBuffer(n2, n3));
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }
}

