/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.channel;

import com.gradle.maven.extension.internal.dep.io.netty.channel.AbstractChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.Channel;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerAdapter;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelInboundHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOption;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOutboundBuffer;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOutboundHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPipelineException;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.DefaultChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.channel.FailedChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.MessageSizeEstimator;
import com.gradle.maven.extension.internal.dep.io.netty.channel.SucceededChannelFuture;
import com.gradle.maven.extension.internal.dep.io.netty.channel.VoidChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.ResourceLeakDetector;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutorGroup;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.FastThreadLocal;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.StringUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultChannelPipeline
implements ChannelPipeline {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelPipeline.class);
    private static final String HEAD_NAME = DefaultChannelPipeline.generateName0(HeadContext.class);
    private static final String TAIL_NAME = DefaultChannelPipeline.generateName0(TailContext.class);
    private static final FastThreadLocal<Map<Class<?>, String>> nameCaches = new FastThreadLocal<Map<Class<?>, String>>(){

        @Override
        protected Map<Class<?>, String> initialValue() {
            return new WeakHashMap();
        }
    };
    private static final AtomicReferenceFieldUpdater<DefaultChannelPipeline, MessageSizeEstimator.Handle> ESTIMATOR = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelPipeline.class, MessageSizeEstimator.Handle.class, "estimatorHandle");
    final HeadContext head;
    final TailContext tail;
    private final Channel channel;
    private final ChannelFuture succeededFuture;
    private final VoidChannelPromise voidPromise;
    private final boolean touch = ResourceLeakDetector.isEnabled();
    private Map<EventExecutorGroup, EventExecutor> childExecutors;
    private volatile MessageSizeEstimator.Handle estimatorHandle;
    private boolean firstRegistration = true;
    private PendingHandlerCallback pendingHandlerCallbackHead;
    private boolean registered;

    protected DefaultChannelPipeline(Channel channel) {
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
        this.succeededFuture = new SucceededChannelFuture(channel, null);
        this.voidPromise = new VoidChannelPromise(channel, true);
        this.tail = new TailContext(this);
        this.head = new HeadContext(this);
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    final MessageSizeEstimator.Handle estimatorHandle() {
        MessageSizeEstimator.Handle handle = this.estimatorHandle;
        if (handle == null && !ESTIMATOR.compareAndSet(this, null, handle = this.channel.config().getMessageSizeEstimator().newHandle())) {
            handle = this.estimatorHandle;
        }
        return handle;
    }

    final Object touch(Object object, AbstractChannelHandlerContext abstractChannelHandlerContext) {
        return this.touch ? ReferenceCountUtil.touch(object, abstractChannelHandlerContext) : object;
    }

    private AbstractChannelHandlerContext newContext(EventExecutorGroup eventExecutorGroup, String string, ChannelHandler channelHandler) {
        return new DefaultChannelHandlerContext(this, this.childExecutor(eventExecutorGroup), string, channelHandler);
    }

    private EventExecutor childExecutor(EventExecutorGroup eventExecutorGroup) {
        EventExecutor eventExecutor;
        if (eventExecutorGroup == null) {
            return null;
        }
        Boolean bl2 = this.channel.config().getOption(ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP);
        if (bl2 != null && !bl2.booleanValue()) {
            return eventExecutorGroup.next();
        }
        Map<EventExecutorGroup, EventExecutor> map = this.childExecutors;
        if (map == null) {
            map = this.childExecutors = new IdentityHashMap<EventExecutorGroup, EventExecutor>(4);
        }
        if ((eventExecutor = map.get(eventExecutorGroup)) == null) {
            eventExecutor = eventExecutorGroup.next();
            map.put(eventExecutorGroup, eventExecutor);
        }
        return eventExecutor;
    }

    public final Channel channel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelPipeline internalAdd(EventExecutorGroup eventExecutorGroup, String string, ChannelHandler channelHandler, String string2, AddStrategy addStrategy) {
        AbstractChannelHandlerContext abstractChannelHandlerContext;
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelPipeline.checkMultiplicity(channelHandler);
            string = this.filterName(string, channelHandler);
            abstractChannelHandlerContext = this.newContext(eventExecutorGroup, string, channelHandler);
            switch (addStrategy) {
                case ADD_FIRST: {
                    this.addFirst0(abstractChannelHandlerContext);
                    break;
                }
                case ADD_LAST: {
                    this.addLast0(abstractChannelHandlerContext);
                    break;
                }
                case ADD_BEFORE: {
                    DefaultChannelPipeline.addBefore0(this.getContextOrDie(string2), abstractChannelHandlerContext);
                    break;
                }
                case ADD_AFTER: {
                    DefaultChannelPipeline.addAfter0(this.getContextOrDie(string2), abstractChannelHandlerContext);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown add strategy: " + (Object)((Object)addStrategy));
                }
            }
            if (!this.registered) {
                abstractChannelHandlerContext.setAddPending();
                this.callHandlerCallbackLater(abstractChannelHandlerContext, true);
                return this;
            }
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (!eventExecutor.inEventLoop()) {
                this.callHandlerAddedInEventLoop(abstractChannelHandlerContext, eventExecutor);
                return this;
            }
        }
        this.callHandlerAdded0(abstractChannelHandlerContext);
        return this;
    }

    public final ChannelPipeline addFirst(EventExecutorGroup eventExecutorGroup, String string, ChannelHandler channelHandler) {
        return this.internalAdd(eventExecutorGroup, string, channelHandler, null, AddStrategy.ADD_FIRST);
    }

    private void addFirst0(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        AbstractChannelHandlerContext abstractChannelHandlerContext2 = this.head.next;
        abstractChannelHandlerContext.prev = this.head;
        abstractChannelHandlerContext.next = abstractChannelHandlerContext2;
        this.head.next = abstractChannelHandlerContext;
        abstractChannelHandlerContext2.prev = abstractChannelHandlerContext;
    }

    @Override
    public final ChannelPipeline addLast(String string, ChannelHandler channelHandler) {
        return this.addLast(null, string, channelHandler);
    }

    public final ChannelPipeline addLast(EventExecutorGroup eventExecutorGroup, String string, ChannelHandler channelHandler) {
        return this.internalAdd(eventExecutorGroup, string, channelHandler, null, AddStrategy.ADD_LAST);
    }

    private void addLast0(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        AbstractChannelHandlerContext abstractChannelHandlerContext2;
        abstractChannelHandlerContext.prev = abstractChannelHandlerContext2 = this.tail.prev;
        abstractChannelHandlerContext.next = this.tail;
        abstractChannelHandlerContext2.next = abstractChannelHandlerContext;
        this.tail.prev = abstractChannelHandlerContext;
    }

    @Override
    public final ChannelPipeline addBefore(String string, String string2, ChannelHandler channelHandler) {
        return this.addBefore(null, string, string2, channelHandler);
    }

    public final ChannelPipeline addBefore(EventExecutorGroup eventExecutorGroup, String string, String string2, ChannelHandler channelHandler) {
        return this.internalAdd(eventExecutorGroup, string2, channelHandler, string, AddStrategy.ADD_BEFORE);
    }

    private static void addBefore0(AbstractChannelHandlerContext abstractChannelHandlerContext, AbstractChannelHandlerContext abstractChannelHandlerContext2) {
        abstractChannelHandlerContext2.prev = abstractChannelHandlerContext.prev;
        abstractChannelHandlerContext2.next = abstractChannelHandlerContext;
        abstractChannelHandlerContext.prev.next = abstractChannelHandlerContext2;
        abstractChannelHandlerContext.prev = abstractChannelHandlerContext2;
    }

    private String filterName(String string, ChannelHandler channelHandler) {
        if (string == null) {
            return this.generateName(channelHandler);
        }
        this.checkDuplicateName(string);
        return string;
    }

    @Override
    public final ChannelPipeline addAfter(String string, String string2, ChannelHandler channelHandler) {
        return this.addAfter(null, string, string2, channelHandler);
    }

    public final ChannelPipeline addAfter(EventExecutorGroup eventExecutorGroup, String string, String string2, ChannelHandler channelHandler) {
        return this.internalAdd(eventExecutorGroup, string2, channelHandler, string, AddStrategy.ADD_AFTER);
    }

    private static void addAfter0(AbstractChannelHandlerContext abstractChannelHandlerContext, AbstractChannelHandlerContext abstractChannelHandlerContext2) {
        abstractChannelHandlerContext2.prev = abstractChannelHandlerContext;
        abstractChannelHandlerContext2.next = abstractChannelHandlerContext.next;
        abstractChannelHandlerContext.next.prev = abstractChannelHandlerContext2;
        abstractChannelHandlerContext.next = abstractChannelHandlerContext2;
    }

    @Override
    public final ChannelPipeline addFirst(ChannelHandler ... channelHandlerArray) {
        return this.addFirst((EventExecutorGroup)null, channelHandlerArray);
    }

    public final ChannelPipeline addFirst(EventExecutorGroup eventExecutorGroup, ChannelHandler ... channelHandlerArray) {
        ObjectUtil.checkNotNull(channelHandlerArray, "handlers");
        if (channelHandlerArray.length == 0 || channelHandlerArray[0] == null) {
            return this;
        }
        for (int i2 = 1; i2 < channelHandlerArray.length && channelHandlerArray[i2] != null; ++i2) {
        }
        for (int i3 = i2 - 1; i3 >= 0; --i3) {
            ChannelHandler channelHandler = channelHandlerArray[i3];
            this.addFirst(eventExecutorGroup, (String)null, channelHandler);
        }
        return this;
    }

    @Override
    public final ChannelPipeline addLast(ChannelHandler ... channelHandlerArray) {
        return this.addLast((EventExecutorGroup)null, channelHandlerArray);
    }

    public final ChannelPipeline addLast(EventExecutorGroup eventExecutorGroup, ChannelHandler ... channelHandlerArray) {
        ObjectUtil.checkNotNull(channelHandlerArray, "handlers");
        for (ChannelHandler channelHandler : channelHandlerArray) {
            if (channelHandler == null) break;
            this.addLast(eventExecutorGroup, (String)null, channelHandler);
        }
        return this;
    }

    private String generateName(ChannelHandler channelHandler) {
        Class<?> clazz;
        Map<Class<?>, String> map = nameCaches.get();
        String string = map.get(clazz = channelHandler.getClass());
        if (string == null) {
            string = DefaultChannelPipeline.generateName0(clazz);
            map.put(clazz, string);
        }
        if (this.context0(string) != null) {
            String string2 = string.substring(0, string.length() - 1);
            int n2 = 1;
            while (true) {
                String string3;
                if (this.context0(string3 = string2 + n2) == null) {
                    string = string3;
                    break;
                }
                ++n2;
            }
        }
        return string;
    }

    private static String generateName0(Class<?> clazz) {
        return StringUtil.simpleClassName(clazz) + "#0";
    }

    @Override
    public final ChannelPipeline remove(ChannelHandler channelHandler) {
        this.remove(this.getContextOrDie(channelHandler));
        return this;
    }

    @Override
    public final <T extends ChannelHandler> T remove(Class<T> clazz) {
        return (T)this.remove(this.getContextOrDie(clazz)).handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractChannelHandlerContext remove(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        assert (abstractChannelHandlerContext != this.head && abstractChannelHandlerContext != this.tail);
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            this.atomicRemoveFromHandlerList(abstractChannelHandlerContext);
            if (!this.registered) {
                this.callHandlerCallbackLater(abstractChannelHandlerContext, false);
                return abstractChannelHandlerContext;
            }
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (!eventExecutor.inEventLoop()) {
                eventExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelPipeline.this.callHandlerRemoved0(abstractChannelHandlerContext);
                    }
                });
                return abstractChannelHandlerContext;
            }
        }
        this.callHandlerRemoved0(abstractChannelHandlerContext);
        return abstractChannelHandlerContext;
    }

    private synchronized void atomicRemoveFromHandlerList(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        AbstractChannelHandlerContext abstractChannelHandlerContext2;
        AbstractChannelHandlerContext abstractChannelHandlerContext3 = abstractChannelHandlerContext.prev;
        abstractChannelHandlerContext3.next = abstractChannelHandlerContext2 = abstractChannelHandlerContext.next;
        abstractChannelHandlerContext2.prev = abstractChannelHandlerContext3;
    }

    private static void checkMultiplicity(ChannelHandler channelHandler) {
        if (channelHandler instanceof ChannelHandlerAdapter) {
            ChannelHandlerAdapter channelHandlerAdapter = (ChannelHandlerAdapter)channelHandler;
            if (!channelHandlerAdapter.isSharable() && channelHandlerAdapter.added) {
                throw new ChannelPipelineException(channelHandlerAdapter.getClass().getName() + " is not a @Sharable handler, so can't be added or removed multiple times.");
            }
            channelHandlerAdapter.added = true;
        }
    }

    private void callHandlerAdded0(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        try {
            abstractChannelHandlerContext.callHandlerAdded();
        }
        catch (Throwable throwable) {
            boolean bl2;
            block5: {
                bl2 = false;
                try {
                    this.atomicRemoveFromHandlerList(abstractChannelHandlerContext);
                    abstractChannelHandlerContext.callHandlerRemoved();
                    bl2 = true;
                }
                catch (Throwable throwable2) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn("Failed to remove a handler: " + abstractChannelHandlerContext.name(), throwable2);
                }
            }
            if (bl2) {
                this.fireExceptionCaught(new ChannelPipelineException(abstractChannelHandlerContext.handler().getClass().getName() + ".handlerAdded() has thrown an exception; removed.", throwable));
            }
            this.fireExceptionCaught(new ChannelPipelineException(abstractChannelHandlerContext.handler().getClass().getName() + ".handlerAdded() has thrown an exception; also failed to remove.", throwable));
        }
    }

    private void callHandlerRemoved0(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        try {
            abstractChannelHandlerContext.callHandlerRemoved();
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(new ChannelPipelineException(abstractChannelHandlerContext.handler().getClass().getName() + ".handlerRemoved() has thrown an exception.", throwable));
        }
    }

    final void invokeHandlerAddedIfNeeded() {
        assert (this.channel.eventLoop().inEventLoop());
        if (this.firstRegistration) {
            this.firstRegistration = false;
            this.callHandlerAddedForAllHandlers();
        }
    }

    @Override
    public final <T extends ChannelHandler> T get(Class<T> clazz) {
        ChannelHandlerContext channelHandlerContext = this.context(clazz);
        if (channelHandlerContext == null) {
            return null;
        }
        return (T)channelHandlerContext.handler();
    }

    public final ChannelHandlerContext context(String string) {
        return this.context0(ObjectUtil.checkNotNull(string, "name"));
    }

    public final ChannelHandlerContext context(ChannelHandler channelHandler) {
        ObjectUtil.checkNotNull(channelHandler, "handler");
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != null) {
            if (abstractChannelHandlerContext.handler() == channelHandler) {
                return abstractChannelHandlerContext;
            }
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return null;
    }

    @Override
    public final ChannelHandlerContext context(Class<? extends ChannelHandler> clazz) {
        ObjectUtil.checkNotNull(clazz, "handlerType");
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != null) {
            if (clazz.isAssignableFrom(abstractChannelHandlerContext.handler().getClass())) {
                return abstractChannelHandlerContext;
            }
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return null;
    }

    @Override
    public final List<String> names() {
        ArrayList<String> arrayList = new ArrayList<String>();
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != null) {
            arrayList.add(abstractChannelHandlerContext.name());
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return arrayList;
    }

    public final Map<String, ChannelHandler> toMap() {
        LinkedHashMap<String, ChannelHandler> linkedHashMap = new LinkedHashMap<String, ChannelHandler>();
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != this.tail) {
            linkedHashMap.put(abstractChannelHandlerContext.name(), abstractChannelHandlerContext.handler());
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return linkedHashMap;
    }

    @Override
    public final Iterator<Map.Entry<String, ChannelHandler>> iterator() {
        return this.toMap().entrySet().iterator();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName(this)).append('{');
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != this.tail) {
            stringBuilder.append('(').append(abstractChannelHandlerContext.name()).append(" = ").append(abstractChannelHandlerContext.handler().getClass().getName()).append(')');
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
            if (abstractChannelHandlerContext == this.tail) break;
            stringBuilder.append(", ");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public final ChannelPipeline fireChannelRegistered() {
        AbstractChannelHandlerContext.invokeChannelRegistered(this.head);
        return this;
    }

    public final ChannelPipeline fireChannelUnregistered() {
        AbstractChannelHandlerContext.invokeChannelUnregistered(this.head);
        return this;
    }

    private synchronized void destroy() {
        this.destroyUp(this.head.next, false);
    }

    private void destroyUp(AbstractChannelHandlerContext abstractChannelHandlerContext, boolean bl2) {
        Thread thread = Thread.currentThread();
        TailContext tailContext = this.tail;
        while (true) {
            if (abstractChannelHandlerContext == tailContext) {
                this.destroyDown(thread, tailContext.prev, bl2);
                break;
            }
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (!bl2 && !eventExecutor.inEventLoop(thread)) {
                final AbstractChannelHandlerContext abstractChannelHandlerContext2 = abstractChannelHandlerContext;
                eventExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelPipeline.this.destroyUp(abstractChannelHandlerContext2, true);
                    }
                });
                break;
            }
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
            bl2 = false;
        }
    }

    private void destroyDown(Thread thread, AbstractChannelHandlerContext abstractChannelHandlerContext, boolean bl2) {
        HeadContext headContext = this.head;
        while (abstractChannelHandlerContext != headContext) {
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (!bl2 && !eventExecutor.inEventLoop(thread)) {
                final AbstractChannelHandlerContext abstractChannelHandlerContext2 = abstractChannelHandlerContext;
                eventExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelPipeline.this.destroyDown(Thread.currentThread(), abstractChannelHandlerContext2, true);
                    }
                });
                break;
            }
            this.atomicRemoveFromHandlerList(abstractChannelHandlerContext);
            this.callHandlerRemoved0(abstractChannelHandlerContext);
            abstractChannelHandlerContext = abstractChannelHandlerContext.prev;
            bl2 = false;
        }
    }

    @Override
    public final ChannelPipeline fireChannelActive() {
        AbstractChannelHandlerContext.invokeChannelActive(this.head);
        return this;
    }

    public final ChannelPipeline fireChannelInactive() {
        AbstractChannelHandlerContext.invokeChannelInactive(this.head);
        return this;
    }

    @Override
    public final ChannelPipeline fireExceptionCaught(Throwable throwable) {
        AbstractChannelHandlerContext.invokeExceptionCaught(this.head, throwable);
        return this;
    }

    @Override
    public final ChannelPipeline fireUserEventTriggered(Object object) {
        AbstractChannelHandlerContext.invokeUserEventTriggered(this.head, object);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelRead(Object object) {
        AbstractChannelHandlerContext.invokeChannelRead(this.head, object);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelReadComplete() {
        AbstractChannelHandlerContext.invokeChannelReadComplete(this.head);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelWritabilityChanged() {
        AbstractChannelHandlerContext.invokeChannelWritabilityChanged(this.head);
        return this;
    }

    @Override
    public final ChannelFuture close() {
        return this.tail.close();
    }

    @Override
    public final ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.tail.bind(socketAddress, channelPromise);
    }

    @Override
    public final ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.tail.connect(socketAddress, channelPromise);
    }

    @Override
    public final ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        return this.tail.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public final ChannelFuture disconnect(ChannelPromise channelPromise) {
        return this.tail.disconnect(channelPromise);
    }

    @Override
    public final ChannelFuture close(ChannelPromise channelPromise) {
        return this.tail.close(channelPromise);
    }

    @Override
    public final ChannelFuture deregister(ChannelPromise channelPromise) {
        return this.tail.deregister(channelPromise);
    }

    public final ChannelPipeline read() {
        this.tail.read();
        return this;
    }

    @Override
    public final ChannelFuture write(Object object) {
        return this.tail.write(object);
    }

    @Override
    public final ChannelFuture write(Object object, ChannelPromise channelPromise) {
        return this.tail.write(object, channelPromise);
    }

    @Override
    public final ChannelFuture writeAndFlush(Object object) {
        return this.tail.writeAndFlush(object);
    }

    @Override
    public final ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel);
    }

    @Override
    public final ChannelFuture newFailedFuture(Throwable throwable) {
        return new FailedChannelFuture(this.channel, null, throwable);
    }

    @Override
    public final ChannelPromise voidPromise() {
        return this.voidPromise;
    }

    private void checkDuplicateName(String string) {
        if (this.context0(string) != null) {
            throw new IllegalArgumentException("Duplicate handler name: " + string);
        }
    }

    private AbstractChannelHandlerContext context0(String string) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != this.tail) {
            if (abstractChannelHandlerContext.name().equals(string)) {
                return abstractChannelHandlerContext;
            }
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return null;
    }

    private AbstractChannelHandlerContext getContextOrDie(String string) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = (AbstractChannelHandlerContext)this.context(string);
        if (abstractChannelHandlerContext == null) {
            throw new NoSuchElementException(string);
        }
        return abstractChannelHandlerContext;
    }

    private AbstractChannelHandlerContext getContextOrDie(ChannelHandler channelHandler) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = (AbstractChannelHandlerContext)this.context(channelHandler);
        if (abstractChannelHandlerContext == null) {
            throw new NoSuchElementException(channelHandler.getClass().getName());
        }
        return abstractChannelHandlerContext;
    }

    private AbstractChannelHandlerContext getContextOrDie(Class<? extends ChannelHandler> clazz) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = (AbstractChannelHandlerContext)this.context(clazz);
        if (abstractChannelHandlerContext == null) {
            throw new NoSuchElementException(clazz.getName());
        }
        return abstractChannelHandlerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callHandlerAddedForAllHandlers() {
        PendingHandlerCallback pendingHandlerCallback;
        Object object = this;
        synchronized (object) {
            assert (!this.registered);
            this.registered = true;
            pendingHandlerCallback = this.pendingHandlerCallbackHead;
            this.pendingHandlerCallbackHead = null;
        }
        object = pendingHandlerCallback;
        while (object != null) {
            ((PendingHandlerCallback)object).execute();
            object = ((PendingHandlerCallback)object).next;
        }
    }

    private void callHandlerCallbackLater(AbstractChannelHandlerContext abstractChannelHandlerContext, boolean bl2) {
        assert (!this.registered);
        PendingHandlerCallback pendingHandlerCallback = bl2 ? new PendingHandlerAddedTask(abstractChannelHandlerContext) : new PendingHandlerRemovedTask(abstractChannelHandlerContext);
        PendingHandlerCallback pendingHandlerCallback2 = this.pendingHandlerCallbackHead;
        if (pendingHandlerCallback2 == null) {
            this.pendingHandlerCallbackHead = pendingHandlerCallback;
        } else {
            while (pendingHandlerCallback2.next != null) {
                pendingHandlerCallback2 = pendingHandlerCallback2.next;
            }
            pendingHandlerCallback2.next = pendingHandlerCallback;
        }
    }

    private void callHandlerAddedInEventLoop(final AbstractChannelHandlerContext abstractChannelHandlerContext, EventExecutor eventExecutor) {
        abstractChannelHandlerContext.setAddPending();
        eventExecutor.execute(new Runnable(){

            @Override
            public void run() {
                DefaultChannelPipeline.this.callHandlerAdded0(abstractChannelHandlerContext);
            }
        });
    }

    protected void onUnhandledInboundException(Throwable throwable) {
        try {
            logger.warn("An exceptionCaught() event was fired, and it reached at the tail of the pipeline. It usually means the last handler in the pipeline did not handle the exception.", throwable);
        }
        finally {
            ReferenceCountUtil.release(throwable);
        }
    }

    protected void onUnhandledInboundChannelActive() {
    }

    protected void onUnhandledInboundChannelInactive() {
    }

    protected void onUnhandledInboundMessage(Object object) {
        try {
            logger.debug("Discarded inbound message {} that reached at the tail of the pipeline. Please check your pipeline configuration.", object);
        }
        finally {
            ReferenceCountUtil.release(object);
        }
    }

    protected void onUnhandledInboundMessage(ChannelHandlerContext channelHandlerContext, Object object) {
        this.onUnhandledInboundMessage(object);
        if (logger.isDebugEnabled()) {
            logger.debug("Discarded message pipeline : {}. Channel : {}.", (Object)channelHandlerContext.pipeline().names(), (Object)channelHandlerContext.channel());
        }
    }

    protected void onUnhandledInboundChannelReadComplete() {
    }

    protected void onUnhandledInboundUserEventTriggered(Object object) {
        ReferenceCountUtil.release(object);
    }

    protected void onUnhandledChannelWritabilityChanged() {
    }

    protected void incrementPendingOutboundBytes(long l2) {
        ChannelOutboundBuffer channelOutboundBuffer = this.channel.unsafe().outboundBuffer();
        if (channelOutboundBuffer != null) {
            channelOutboundBuffer.incrementPendingOutboundBytes(l2);
        }
    }

    protected void decrementPendingOutboundBytes(long l2) {
        ChannelOutboundBuffer channelOutboundBuffer = this.channel.unsafe().outboundBuffer();
        if (channelOutboundBuffer != null) {
            channelOutboundBuffer.decrementPendingOutboundBytes(l2);
        }
    }

    private final class PendingHandlerRemovedTask
    extends PendingHandlerCallback {
        PendingHandlerRemovedTask(AbstractChannelHandlerContext abstractChannelHandlerContext) {
            super(abstractChannelHandlerContext);
        }

        @Override
        public void run() {
            DefaultChannelPipeline.this.callHandlerRemoved0(this.ctx);
        }

        @Override
        void execute() {
            EventExecutor eventExecutor = this.ctx.executor();
            if (eventExecutor.inEventLoop()) {
                DefaultChannelPipeline.this.callHandlerRemoved0(this.ctx);
            } else {
                try {
                    eventExecutor.execute(this);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Can't invoke handlerRemoved() as the EventExecutor {} rejected it, removing handler {}.", eventExecutor, this.ctx.name(), rejectedExecutionException);
                    }
                    this.ctx.setRemoved();
                }
            }
        }
    }

    private final class PendingHandlerAddedTask
    extends PendingHandlerCallback {
        PendingHandlerAddedTask(AbstractChannelHandlerContext abstractChannelHandlerContext) {
            super(abstractChannelHandlerContext);
        }

        @Override
        public void run() {
            DefaultChannelPipeline.this.callHandlerAdded0(this.ctx);
        }

        @Override
        void execute() {
            EventExecutor eventExecutor = this.ctx.executor();
            if (eventExecutor.inEventLoop()) {
                DefaultChannelPipeline.this.callHandlerAdded0(this.ctx);
            } else {
                try {
                    eventExecutor.execute(this);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Can't invoke handlerAdded() as the EventExecutor {} rejected it, removing handler {}.", eventExecutor, this.ctx.name(), rejectedExecutionException);
                    }
                    DefaultChannelPipeline.this.atomicRemoveFromHandlerList(this.ctx);
                    this.ctx.setRemoved();
                }
            }
        }
    }

    private static abstract class PendingHandlerCallback
    implements Runnable {
        final AbstractChannelHandlerContext ctx;
        PendingHandlerCallback next;

        PendingHandlerCallback(AbstractChannelHandlerContext abstractChannelHandlerContext) {
            this.ctx = abstractChannelHandlerContext;
        }

        abstract void execute();
    }

    final class HeadContext
    extends AbstractChannelHandlerContext
    implements ChannelInboundHandler,
    ChannelOutboundHandler {
        private final Channel.Unsafe unsafe;

        HeadContext(DefaultChannelPipeline defaultChannelPipeline2) {
            super(defaultChannelPipeline2, null, HEAD_NAME, HeadContext.class);
            this.unsafe = defaultChannelPipeline2.channel().unsafe();
            this.setAddComplete();
        }

        @Override
        public ChannelHandler handler() {
            return this;
        }

        @Override
        public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        }

        @Override
        public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        }

        @Override
        public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
            this.unsafe.bind(socketAddress, channelPromise);
        }

        @Override
        public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            this.unsafe.connect(socketAddress, socketAddress2, channelPromise);
        }

        @Override
        public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
            this.unsafe.disconnect(channelPromise);
        }

        @Override
        public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
            this.unsafe.close(channelPromise);
        }

        @Override
        public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
            this.unsafe.deregister(channelPromise);
        }

        @Override
        public void read(ChannelHandlerContext channelHandlerContext) {
            this.unsafe.beginRead();
        }

        @Override
        public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
            this.unsafe.write(object, channelPromise);
        }

        @Override
        public void flush(ChannelHandlerContext channelHandlerContext) {
            this.unsafe.flush();
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
            channelHandlerContext.fireExceptionCaught(throwable);
        }

        @Override
        public void channelRegistered(ChannelHandlerContext channelHandlerContext) {
            DefaultChannelPipeline.this.invokeHandlerAddedIfNeeded();
            channelHandlerContext.fireChannelRegistered();
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext channelHandlerContext) {
            channelHandlerContext.fireChannelUnregistered();
            if (!DefaultChannelPipeline.this.channel.isOpen()) {
                DefaultChannelPipeline.this.destroy();
            }
        }

        @Override
        public void channelActive(ChannelHandlerContext channelHandlerContext) {
            channelHandlerContext.fireChannelActive();
            this.readIfIsAutoRead();
        }

        @Override
        public void channelInactive(ChannelHandlerContext channelHandlerContext) {
            channelHandlerContext.fireChannelInactive();
        }

        @Override
        public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
            channelHandlerContext.fireChannelRead(object);
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
            channelHandlerContext.fireChannelReadComplete();
            this.readIfIsAutoRead();
        }

        private void readIfIsAutoRead() {
            if (DefaultChannelPipeline.this.channel.config().isAutoRead()) {
                DefaultChannelPipeline.this.channel.read();
            }
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
            channelHandlerContext.fireUserEventTriggered(object);
        }

        @Override
        public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
            channelHandlerContext.fireChannelWritabilityChanged();
        }
    }

    final class TailContext
    extends AbstractChannelHandlerContext
    implements ChannelInboundHandler {
        TailContext(DefaultChannelPipeline defaultChannelPipeline2) {
            super(defaultChannelPipeline2, null, TAIL_NAME, TailContext.class);
            this.setAddComplete();
        }

        @Override
        public ChannelHandler handler() {
            return this;
        }

        @Override
        public void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext channelHandlerContext) {
        }

        @Override
        public void channelActive(ChannelHandlerContext channelHandlerContext) {
            DefaultChannelPipeline.this.onUnhandledInboundChannelActive();
        }

        @Override
        public void channelInactive(ChannelHandlerContext channelHandlerContext) {
            DefaultChannelPipeline.this.onUnhandledInboundChannelInactive();
        }

        @Override
        public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
            DefaultChannelPipeline.this.onUnhandledChannelWritabilityChanged();
        }

        @Override
        public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        }

        @Override
        public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
            DefaultChannelPipeline.this.onUnhandledInboundUserEventTriggered(object);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
            DefaultChannelPipeline.this.onUnhandledInboundException(throwable);
        }

        @Override
        public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
            DefaultChannelPipeline.this.onUnhandledInboundMessage(channelHandlerContext, object);
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
            DefaultChannelPipeline.this.onUnhandledInboundChannelReadComplete();
        }
    }

    private static enum AddStrategy {
        ADD_FIRST,
        ADD_LAST,
        ADD_BEFORE,
        ADD_AFTER;

    }
}

