/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http;

import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.DefaultHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.CombinedHttpHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.DefaultHttpHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaderNames;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaderValidationUtil;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeadersFactory;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;

public final class DefaultHttpHeadersFactory
implements HttpHeadersFactory {
    private static final DefaultHeaders.NameValidator<CharSequence> DEFAULT_NAME_VALIDATOR = new DefaultHeaders.NameValidator<CharSequence>(){

        @Override
        public void validateName(CharSequence charSequence) {
            if (charSequence == null || charSequence.length() == 0) {
                throw new IllegalArgumentException("empty headers are not allowed [" + charSequence + ']');
            }
            int n2 = HttpHeaderValidationUtil.validateToken(charSequence);
            if (n2 != -1) {
                throw new IllegalArgumentException("a header name can only contain \"token\" characters, but found invalid character 0x" + Integer.toHexString(charSequence.charAt(n2)) + " at index " + n2 + " of header '" + charSequence + "'.");
            }
        }
    };
    private static final DefaultHeaders.ValueValidator<CharSequence> DEFAULT_VALUE_VALIDATOR = new DefaultHeaders.ValueValidator<CharSequence>(){

        @Override
        public void validate(CharSequence charSequence) {
            int n2 = HttpHeaderValidationUtil.validateValidHeaderValue(charSequence);
            if (n2 != -1) {
                throw new IllegalArgumentException("a header value contains prohibited character 0x" + Integer.toHexString(charSequence.charAt(n2)) + " at index " + n2 + '.');
            }
        }
    };
    private static final DefaultHeaders.NameValidator<CharSequence> DEFAULT_TRAILER_NAME_VALIDATOR = new DefaultHeaders.NameValidator<CharSequence>(){

        @Override
        public void validateName(CharSequence charSequence) {
            DEFAULT_NAME_VALIDATOR.validateName(charSequence);
            if (HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase(charSequence) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase(charSequence) || HttpHeaderNames.TRAILER.contentEqualsIgnoreCase(charSequence)) {
                throw new IllegalArgumentException("prohibited trailing header: " + charSequence);
            }
        }
    };
    private static final DefaultHeaders.NameValidator<CharSequence> NO_NAME_VALIDATOR = DefaultHeaders.NameValidator.NOT_NULL;
    private static final DefaultHeaders.ValueValidator<CharSequence> NO_VALUE_VALIDATOR = DefaultHeaders.ValueValidator.NO_VALIDATION;
    private static final DefaultHttpHeadersFactory DEFAULT = new DefaultHttpHeadersFactory(DEFAULT_NAME_VALIDATOR, DEFAULT_VALUE_VALIDATOR, false);
    private static final DefaultHttpHeadersFactory DEFAULT_TRAILER = new DefaultHttpHeadersFactory(DEFAULT_TRAILER_NAME_VALIDATOR, DEFAULT_VALUE_VALIDATOR, false);
    private static final DefaultHttpHeadersFactory DEFAULT_COMBINING = new DefaultHttpHeadersFactory(DefaultHttpHeadersFactory.DEFAULT.nameValidator, DefaultHttpHeadersFactory.DEFAULT.valueValidator, true);
    private static final DefaultHttpHeadersFactory DEFAULT_NO_VALIDATION = new DefaultHttpHeadersFactory(NO_NAME_VALIDATOR, NO_VALUE_VALIDATOR, false);
    private final DefaultHeaders.NameValidator<CharSequence> nameValidator;
    private final DefaultHeaders.ValueValidator<CharSequence> valueValidator;
    private final boolean combiningHeaders;

    private DefaultHttpHeadersFactory(DefaultHeaders.NameValidator<CharSequence> nameValidator, DefaultHeaders.ValueValidator<CharSequence> valueValidator, boolean bl2) {
        this.nameValidator = ObjectUtil.checkNotNull(nameValidator, "nameValidator");
        this.valueValidator = ObjectUtil.checkNotNull(valueValidator, "valueValidator");
        this.combiningHeaders = bl2;
    }

    public static DefaultHttpHeadersFactory headersFactory() {
        return DEFAULT;
    }

    public static DefaultHttpHeadersFactory trailersFactory() {
        return DEFAULT_TRAILER;
    }

    @Override
    public HttpHeaders newHeaders() {
        if (this.isCombiningHeaders()) {
            return new CombinedHttpHeaders(this.getNameValidator(), this.getValueValidator());
        }
        return new DefaultHttpHeaders(this.getNameValidator(), this.getValueValidator());
    }

    public DefaultHttpHeadersFactory withNameValidation(boolean bl2) {
        return this.withNameValidator(bl2 ? DEFAULT_NAME_VALIDATOR : NO_NAME_VALIDATOR);
    }

    public DefaultHttpHeadersFactory withNameValidator(DefaultHeaders.NameValidator<CharSequence> nameValidator) {
        if (this.nameValidator == ObjectUtil.checkNotNull(nameValidator, "validator")) {
            return this;
        }
        if (nameValidator == DEFAULT_NAME_VALIDATOR && this.valueValidator == DEFAULT_VALUE_VALIDATOR) {
            return this.combiningHeaders ? DEFAULT_COMBINING : DEFAULT;
        }
        return new DefaultHttpHeadersFactory(nameValidator, this.valueValidator, this.combiningHeaders);
    }

    public DefaultHttpHeadersFactory withValueValidation(boolean bl2) {
        return this.withValueValidator(bl2 ? DEFAULT_VALUE_VALIDATOR : NO_VALUE_VALIDATOR);
    }

    public DefaultHttpHeadersFactory withValueValidator(DefaultHeaders.ValueValidator<CharSequence> valueValidator) {
        if (this.valueValidator == ObjectUtil.checkNotNull(valueValidator, "validator")) {
            return this;
        }
        if (this.nameValidator == DEFAULT_NAME_VALIDATOR && valueValidator == DEFAULT_VALUE_VALIDATOR) {
            return this.combiningHeaders ? DEFAULT_COMBINING : DEFAULT;
        }
        return new DefaultHttpHeadersFactory(this.nameValidator, valueValidator, this.combiningHeaders);
    }

    public DefaultHttpHeadersFactory withValidation(boolean bl2) {
        if (this == DEFAULT && !bl2) {
            return DEFAULT_NO_VALIDATION;
        }
        if (this == DEFAULT_NO_VALIDATION && bl2) {
            return DEFAULT;
        }
        return this.withNameValidation(bl2).withValueValidation(bl2);
    }

    public DefaultHeaders.NameValidator<CharSequence> getNameValidator() {
        return this.nameValidator;
    }

    public DefaultHeaders.ValueValidator<CharSequence> getValueValidator() {
        return this.valueValidator;
    }

    public boolean isCombiningHeaders() {
        return this.combiningHeaders;
    }

    public boolean isValidatingHeaderNames() {
        return this.nameValidator != NO_NAME_VALIDATOR;
    }

    public boolean isValidatingHeaderValues() {
        return this.valueValidator != NO_VALUE_VALIDATOR;
    }
}

