/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.resolver;

import com.gradle.maven.extension.internal.dep.io.netty.resolver.NameResolver;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.maven.extension.internal.dep.io.netty.util.concurrent.Promise;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;

public abstract class SimpleNameResolver<T>
implements NameResolver<T> {
    private final EventExecutor executor;

    protected SimpleNameResolver(EventExecutor eventExecutor) {
        this.executor = ObjectUtil.checkNotNull(eventExecutor, "executor");
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    @Override
    public final Future<T> resolve(String string) {
        Promise promise = this.executor().newPromise();
        return this.resolve(string, promise);
    }

    public Future<T> resolve(String string, Promise<T> promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        try {
            this.doResolve(string, promise);
            return promise;
        }
        catch (Exception exception) {
            return promise.setFailure(exception);
        }
    }

    protected abstract void doResolve(String var1, Promise<T> var2) throws Exception;

    @Override
    public void close() {
    }
}

