/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats;

import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatArrays;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatCollection;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatIterator;
import com.gradle.maven.extension.internal.dep.it.unimi.dsi.fastutil.floats.FloatIterators;
import java.util.AbstractCollection;
import java.util.Collection;

public abstract class AbstractFloatCollection
extends AbstractCollection<Float>
implements FloatCollection {
    protected AbstractFloatCollection() {
    }

    @Override
    public abstract FloatIterator iterator();

    @Override
    public boolean add(float f2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(float f2) {
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            if (f2 != floatIterator.nextFloat()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(float f2) {
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            if (f2 != floatIterator.nextFloat()) continue;
            floatIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Float f2) {
        return FloatCollection.super.add(f2);
    }

    @Override
    @Deprecated
    public boolean contains(Object object) {
        return FloatCollection.super.contains(object);
    }

    @Override
    @Deprecated
    public boolean remove(Object object) {
        return FloatCollection.super.remove(object);
    }

    @Override
    public float[] toFloatArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return FloatArrays.EMPTY_ARRAY;
        }
        float[] fArray = new float[n2];
        FloatIterators.unwrap(this.iterator(), fArray);
        return fArray;
    }

    public boolean addAll(FloatCollection floatCollection) {
        boolean bl2 = false;
        FloatIterator floatIterator = floatCollection.iterator();
        while (floatIterator.hasNext()) {
            if (!this.add(floatIterator.nextFloat())) continue;
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean addAll(Collection<? extends Float> collection) {
        if (collection instanceof FloatCollection) {
            return this.addAll((FloatCollection)collection);
        }
        return super.addAll(collection);
    }

    public boolean containsAll(FloatCollection floatCollection) {
        FloatIterator floatIterator = floatCollection.iterator();
        while (floatIterator.hasNext()) {
            if (this.contains(floatIterator.nextFloat())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof FloatCollection) {
            return this.containsAll((FloatCollection)collection);
        }
        return super.containsAll(collection);
    }

    public boolean removeAll(FloatCollection floatCollection) {
        boolean bl2 = false;
        FloatIterator floatIterator = floatCollection.iterator();
        while (floatIterator.hasNext()) {
            if (!this.rem(floatIterator.nextFloat())) continue;
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection instanceof FloatCollection) {
            return this.removeAll((FloatCollection)collection);
        }
        return super.removeAll(collection);
    }

    public boolean retainAll(FloatCollection floatCollection) {
        boolean bl2 = false;
        FloatIterator floatIterator = this.iterator();
        while (floatIterator.hasNext()) {
            if (floatCollection.contains(floatIterator.nextFloat())) continue;
            floatIterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (collection instanceof FloatCollection) {
            return this.retainAll((FloatCollection)collection);
        }
        return super.retainAll(collection);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        FloatIterator floatIterator = this.iterator();
        int n2 = this.size();
        boolean bl2 = true;
        stringBuilder.append("{");
        while (n2-- != 0) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(", ");
            }
            float f2 = floatIterator.nextFloat();
            stringBuilder.append(String.valueOf(f2));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

