/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.input;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.ByteOrderMark;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.IOUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.input.ProxyInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class BOMInputStream
extends ProxyInputStream {
    private static final Comparator<ByteOrderMark> ByteOrderMarkLengthComparator = Comparator.comparing(ByteOrderMark::length).reversed();
    private final List<ByteOrderMark> boms;
    private ByteOrderMark byteOrderMark;
    private int fbIndex;
    private int fbLength;
    private int[] firstBytes;
    private final boolean include;
    private boolean markedAtStart;
    private int markFbIndex;

    @Deprecated
    public BOMInputStream(InputStream inputStream, boolean bl2, ByteOrderMark ... byteOrderMarkArray) {
        super(inputStream);
        if (IOUtils.length(byteOrderMarkArray) == 0) {
            throw new IllegalArgumentException("No BOMs specified");
        }
        this.include = bl2;
        List<ByteOrderMark> list = Arrays.asList(byteOrderMarkArray);
        list.sort(ByteOrderMarkLengthComparator);
        this.boms = list;
    }

    private ByteOrderMark find() {
        return this.boms.stream().filter(this::matches).findFirst().orElse(null);
    }

    public ByteOrderMark getBOM() throws IOException {
        if (this.firstBytes == null) {
            this.fbLength = 0;
            int n2 = this.boms.get(0).length();
            this.firstBytes = new int[n2];
            for (int i2 = 0; i2 < this.firstBytes.length; ++i2) {
                this.firstBytes[i2] = this.in.read();
                this.afterRead(this.firstBytes[i2]);
                ++this.fbLength;
                if (this.firstBytes[i2] < 0) break;
            }
            this.byteOrderMark = this.find();
            if (this.byteOrderMark != null && !this.include) {
                if (this.byteOrderMark.length() < this.firstBytes.length) {
                    this.fbIndex = this.byteOrderMark.length();
                } else {
                    this.fbLength = 0;
                }
            }
        }
        return this.byteOrderMark;
    }

    public String getBOMCharsetName() throws IOException {
        this.getBOM();
        return this.byteOrderMark == null ? null : this.byteOrderMark.getCharsetName();
    }

    @Override
    public synchronized void mark(int n2) {
        this.markFbIndex = this.fbIndex;
        this.markedAtStart = this.firstBytes == null;
        this.in.mark(n2);
    }

    private boolean matches(ByteOrderMark byteOrderMark) {
        for (int i2 = 0; i2 < byteOrderMark.length(); ++i2) {
            if (byteOrderMark.get(i2) == this.firstBytes[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        int n2 = this.readFirstBytes();
        return n2 >= 0 ? n2 : this.in.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        while (n3 > 0 && n5 >= 0) {
            n5 = this.readFirstBytes();
            if (n5 < 0) continue;
            byArray[n2++] = (byte)(n5 & 0xFF);
            --n3;
            ++n4;
        }
        int n6 = this.in.read(byArray, n2, n3);
        this.afterRead(n6);
        return n6 < 0 ? (n4 > 0 ? n4 : -1) : n4 + n6;
    }

    private int readFirstBytes() throws IOException {
        this.getBOM();
        return this.fbIndex < this.fbLength ? this.firstBytes[this.fbIndex++] : -1;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.fbIndex = this.markFbIndex;
        if (this.markedAtStart) {
            this.firstBytes = null;
        }
        this.in.reset();
    }

    @Override
    public long skip(long l2) throws IOException {
        int n2 = 0;
        while (l2 > (long)n2 && this.readFirstBytes() >= 0) {
            ++n2;
        }
        return this.in.skip(l2 - (long)n2) + (long)n2;
    }
}

