/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.input;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.ByteOrderMark;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.IOUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.build.AbstractStreamBuilder;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.function.IOConsumer;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.input.BOMInputStream;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.input.XmlStreamReaderException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlStreamReader
extends Reader {
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final String US_ASCII = StandardCharsets.US_ASCII.name();
    private static final String UTF_16BE = StandardCharsets.UTF_16BE.name();
    private static final String UTF_16LE = StandardCharsets.UTF_16LE.name();
    private static final String UTF_16 = StandardCharsets.UTF_16.name();
    private static final ByteOrderMark[] BOMS = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE};
    private static final ByteOrderMark[] XML_GUESS_BYTES = new ByteOrderMark[]{new ByteOrderMark(UTF_8, 60, 63, 120, 109), new ByteOrderMark(UTF_16BE, 0, 60, 0, 63), new ByteOrderMark(UTF_16LE, 60, 0, 63, 0), new ByteOrderMark("UTF-32BE", 0, 0, 0, 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 109), new ByteOrderMark("UTF-32LE", 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 109, 0, 0, 0), new ByteOrderMark("CP1047", 76, 111, 167, 148)};
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=[\"']?([.[^; \"']]*)[\"']?");
    public static final Pattern ENCODING_PATTERN = Pattern.compile("^<\\?xml\\s+(?:version\\s*=\\s*(?:(?:\"1\\.[0-9]+\")|(?:'1.[0-9]+'))\\s+)??encoding\\s*=\\s*((?:\"[A-Za-z0-9][A-Za-z0-9._+:-]*\")|(?:'[A-Za-z0-9][A-Za-z0-9._+:-]*'))", 8);
    private final Reader reader;
    private final String encoding;
    private final String defaultEncoding;

    public static Builder builder() {
        return new Builder();
    }

    static String getContentTypeEncoding(String string) {
        int n2;
        String string2 = null;
        if (string != null && (n2 = string.indexOf(";")) > -1) {
            String string3 = string.substring(n2 + 1);
            Matcher matcher = CHARSET_PATTERN.matcher(string3);
            string2 = matcher.find() ? matcher.group(1) : null;
            string2 = string2 != null ? string2.toUpperCase(Locale.ROOT) : null;
        }
        return string2;
    }

    static String getContentTypeMime(String string) {
        String string2 = null;
        if (string != null) {
            int n2 = string.indexOf(";");
            string2 = n2 >= 0 ? string.substring(0, n2) : string;
            string2 = string2.trim();
        }
        return string2;
    }

    private static String getXmlProlog(InputStream inputStream, String string2) throws IOException {
        String string3 = null;
        if (string2 != null) {
            byte[] byArray = IOUtils.byteArray();
            inputStream.mark(8192);
            int n2 = 0;
            int n3 = 8192;
            int n4 = inputStream.read(byArray, n2, n3);
            int n5 = -1;
            String string4 = "";
            while (n4 != -1 && n5 == -1 && n2 < 8192) {
                n4 = inputStream.read(byArray, n2 += n4, n3 -= n4);
                string4 = new String(byArray, 0, n2, string2);
                n5 = string4.indexOf(62);
            }
            if (n5 == -1) {
                if (n4 == -1) {
                    throw new IOException("Unexpected end of XML stream");
                }
                throw new IOException("XML prolog or ROOT element not found on first " + n2 + " bytes");
            }
            int n6 = n2;
            if (n6 > 0) {
                inputStream.reset();
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string4.substring(0, n5 + 1)));
                StringBuilder stringBuilder = new StringBuilder();
                IOConsumer.forEach(bufferedReader.lines(), string -> stringBuilder.append((String)string).append(' '));
                Matcher matcher = ENCODING_PATTERN.matcher(stringBuilder);
                if (matcher.find()) {
                    string3 = matcher.group(1).toUpperCase(Locale.ROOT);
                    string3 = string3.substring(1, string3.length() - 1);
                }
            }
        }
        return string3;
    }

    static boolean isAppXml(String string) {
        return string != null && (string.equals("application/xml") || string.equals("application/xml-dtd") || string.equals("application/xml-external-parsed-entity") || string.startsWith("application/") && string.endsWith("+xml"));
    }

    static boolean isTextXml(String string) {
        return string != null && (string.equals("text/xml") || string.equals("text/xml-external-parsed-entity") || string.startsWith("text/") && string.endsWith("+xml"));
    }

    @Deprecated
    public XmlStreamReader(InputStream inputStream, boolean bl2, String string) throws IOException {
        this.defaultEncoding = string;
        BOMInputStream bOMInputStream = new BOMInputStream(new BufferedInputStream(Objects.requireNonNull(inputStream, "inputStream"), 8192), false, BOMS);
        BOMInputStream bOMInputStream2 = new BOMInputStream(bOMInputStream, true, XML_GUESS_BYTES);
        this.encoding = this.processHttpStream(bOMInputStream, bOMInputStream2, bl2);
        this.reader = new InputStreamReader((InputStream)bOMInputStream2, this.encoding);
    }

    @Deprecated
    public XmlStreamReader(InputStream inputStream, String string, boolean bl2, String string2) throws IOException {
        this.defaultEncoding = string2;
        BOMInputStream bOMInputStream = new BOMInputStream(new BufferedInputStream(Objects.requireNonNull(inputStream, "inputStream"), 8192), false, BOMS);
        BOMInputStream bOMInputStream2 = new BOMInputStream(bOMInputStream, true, XML_GUESS_BYTES);
        this.encoding = this.processHttpStream(bOMInputStream, bOMInputStream2, bl2, string);
        this.reader = new InputStreamReader((InputStream)bOMInputStream2, this.encoding);
    }

    String calculateHttpEncoding(String string, String string2, String string3, boolean bl2, String string4) throws IOException {
        if (bl2 && string3 != null) {
            return string3;
        }
        String string5 = XmlStreamReader.getContentTypeMime(string4);
        String string6 = XmlStreamReader.getContentTypeEncoding(string4);
        boolean bl3 = XmlStreamReader.isAppXml(string5);
        boolean bl4 = XmlStreamReader.isTextXml(string5);
        if (!bl3 && !bl4) {
            String string7 = MessageFormat.format("Illegal encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], Illegal MIME", string5, string6, string, string2, string3);
            throw new XmlStreamReaderException(string7, string5, string6, string, string2, string3);
        }
        if (string6 == null) {
            if (bl3) {
                return this.calculateRawEncoding(string, string2, string3);
            }
            return this.defaultEncoding == null ? US_ASCII : this.defaultEncoding;
        }
        if (string6.equals(UTF_16BE) || string6.equals(UTF_16LE)) {
            if (string != null) {
                String string8 = MessageFormat.format("Illegal encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], BOM must be null", string5, string6, string, string2, string3);
                throw new XmlStreamReaderException(string8, string5, string6, string, string2, string3);
            }
            return string6;
        }
        if (string6.equals(UTF_16)) {
            if (string != null && string.startsWith(UTF_16)) {
                return string;
            }
            String string9 = MessageFormat.format("Illegal encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], encoding mismatch", string5, string6, string, string2, string3);
            throw new XmlStreamReaderException(string9, string5, string6, string, string2, string3);
        }
        if (string6.equals("UTF-32BE") || string6.equals("UTF-32LE")) {
            if (string != null) {
                String string10 = MessageFormat.format("Illegal encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], BOM must be null", string5, string6, string, string2, string3);
                throw new XmlStreamReaderException(string10, string5, string6, string, string2, string3);
            }
            return string6;
        }
        if (string6.equals("UTF-32")) {
            if (string != null && string.startsWith("UTF-32")) {
                return string;
            }
            String string11 = MessageFormat.format("Illegal encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], encoding mismatch", string5, string6, string, string2, string3);
            throw new XmlStreamReaderException(string11, string5, string6, string, string2, string3);
        }
        return string6;
    }

    String calculateRawEncoding(String string, String string2, String string3) throws IOException {
        if (string == null) {
            if (string2 == null || string3 == null) {
                return this.defaultEncoding == null ? UTF_8 : this.defaultEncoding;
            }
            if (string3.equals(UTF_16) && (string2.equals(UTF_16BE) || string2.equals(UTF_16LE))) {
                return string2;
            }
            return string3;
        }
        if (string.equals(UTF_8)) {
            if (string2 != null && !string2.equals(UTF_8)) {
                String string4 = MessageFormat.format("Illegal encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch", string, string2, string3);
                throw new XmlStreamReaderException(string4, string, string2, string3);
            }
            if (string3 != null && !string3.equals(UTF_8)) {
                String string5 = MessageFormat.format("Illegal encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch", string, string2, string3);
                throw new XmlStreamReaderException(string5, string, string2, string3);
            }
            return string;
        }
        if (string.equals(UTF_16BE) || string.equals(UTF_16LE)) {
            if (string2 != null && !string2.equals(string)) {
                String string6 = MessageFormat.format("Illegal encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch", string, string2, string3);
                throw new XmlStreamReaderException(string6, string, string2, string3);
            }
            if (string3 != null && !string3.equals(UTF_16) && !string3.equals(string)) {
                String string7 = MessageFormat.format("Illegal encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch", string, string2, string3);
                throw new XmlStreamReaderException(string7, string, string2, string3);
            }
            return string;
        }
        if (string.equals("UTF-32BE") || string.equals("UTF-32LE")) {
            if (string2 != null && !string2.equals(string)) {
                String string8 = MessageFormat.format("Illegal encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch", string, string2, string3);
                throw new XmlStreamReaderException(string8, string, string2, string3);
            }
            if (string3 != null && !string3.equals("UTF-32") && !string3.equals(string)) {
                String string9 = MessageFormat.format("Illegal encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch", string, string2, string3);
                throw new XmlStreamReaderException(string9, string, string2, string3);
            }
            return string;
        }
        String string10 = MessageFormat.format("Illegal encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] unknown BOM", string, string2, string3);
        throw new XmlStreamReaderException(string10, string, string2, string3);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private String doLenientDetection(String string, XmlStreamReaderException xmlStreamReaderException) throws IOException {
        String string2;
        if (string != null && string.startsWith("text/html")) {
            string = string.substring("text/html".length());
            string = "text/xml" + string;
            try {
                return this.calculateHttpEncoding(xmlStreamReaderException.getBomEncoding(), xmlStreamReaderException.getXmlGuessEncoding(), xmlStreamReaderException.getXmlEncoding(), true, string);
            }
            catch (XmlStreamReaderException xmlStreamReaderException2) {
                xmlStreamReaderException = xmlStreamReaderException2;
            }
        }
        if ((string2 = xmlStreamReaderException.getXmlEncoding()) == null) {
            string2 = xmlStreamReaderException.getContentTypeEncoding();
        }
        if (string2 == null) {
            string2 = this.defaultEncoding == null ? UTF_8 : this.defaultEncoding;
        }
        return string2;
    }

    private String processHttpStream(BOMInputStream bOMInputStream, BOMInputStream bOMInputStream2, boolean bl2) throws IOException {
        String string = bOMInputStream.getBOMCharsetName();
        String string2 = bOMInputStream2.getBOMCharsetName();
        String string3 = XmlStreamReader.getXmlProlog(bOMInputStream2, string2);
        try {
            return this.calculateRawEncoding(string, string2, string3);
        }
        catch (XmlStreamReaderException xmlStreamReaderException) {
            if (bl2) {
                return this.doLenientDetection(null, xmlStreamReaderException);
            }
            throw xmlStreamReaderException;
        }
    }

    private String processHttpStream(BOMInputStream bOMInputStream, BOMInputStream bOMInputStream2, boolean bl2, String string) throws IOException {
        String string2 = bOMInputStream.getBOMCharsetName();
        String string3 = bOMInputStream2.getBOMCharsetName();
        String string4 = XmlStreamReader.getXmlProlog(bOMInputStream2, string3);
        try {
            return this.calculateHttpEncoding(string2, string3, string4, bl2, string);
        }
        catch (XmlStreamReaderException xmlStreamReaderException) {
            if (bl2) {
                return this.doLenientDetection(string, xmlStreamReaderException);
            }
            throw xmlStreamReaderException;
        }
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        return this.reader.read(cArray, n2, n3);
    }

    public static class Builder
    extends AbstractStreamBuilder<XmlStreamReader, Builder> {
        private boolean nullCharset = true;
        private boolean lenient = true;
        private String httpContentType;

        public XmlStreamReader get() throws IOException {
            String string = this.nullCharset ? null : this.getCharset().name();
            return this.httpContentType == null ? new XmlStreamReader(this.getInputStream(), this.lenient, string) : new XmlStreamReader(this.getInputStream(), this.httpContentType, this.lenient, string);
        }
    }
}

