/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core;

import com.gradle.maven.extension.internal.dep.org.springframework.core.ResolvableType;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ConcurrentReferenceHashMap;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class BridgeMethodResolver {
    private static final Map<Method, Method> cache = new ConcurrentReferenceHashMap<Method, Method>();

    public static Method findBridgedMethod(Method method) {
        if (!method.isBridge()) {
            return method;
        }
        Method method3 = cache.get(method);
        if (method3 == null) {
            ArrayList<Method> arrayList = new ArrayList<Method>();
            ReflectionUtils.MethodFilter methodFilter = method2 -> BridgeMethodResolver.isBridgedCandidateFor(method2, method);
            ReflectionUtils.doWithMethods(method.getDeclaringClass(), arrayList::add, methodFilter);
            if (!arrayList.isEmpty()) {
                Method method4 = method3 = arrayList.size() == 1 ? (Method)arrayList.get(0) : BridgeMethodResolver.searchCandidates(arrayList, method);
            }
            if (method3 == null) {
                method3 = method;
            }
            cache.put(method, method3);
        }
        return method3;
    }

    private static boolean isBridgedCandidateFor(Method method, Method method2) {
        return !method.isBridge() && method.getName().equals(method2.getName()) && method.getParameterCount() == method2.getParameterCount();
    }

    private static Method searchCandidates(List<Method> list, Method method) {
        if (list.isEmpty()) {
            return null;
        }
        Method method2 = null;
        boolean bl2 = true;
        for (Method method3 : list) {
            if (BridgeMethodResolver.isBridgeMethodFor(method, method3, method.getDeclaringClass())) {
                return method3;
            }
            if (method2 != null) {
                bl2 = bl2 && Arrays.equals(method3.getGenericParameterTypes(), method2.getGenericParameterTypes());
            }
            method2 = method3;
        }
        return bl2 ? list.get(0) : null;
    }

    static boolean isBridgeMethodFor(Method method, Method method2, Class<?> clazz) {
        if (BridgeMethodResolver.isResolvedTypeMatch(method2, method, clazz)) {
            return true;
        }
        Method method3 = BridgeMethodResolver.findGenericDeclaration(method);
        return method3 != null && BridgeMethodResolver.isResolvedTypeMatch(method3, method2, clazz);
    }

    private static boolean isResolvedTypeMatch(Method method, Method method2, Class<?> clazz) {
        Type[] typeArray = method.getGenericParameterTypes();
        if (typeArray.length != method2.getParameterCount()) {
            return false;
        }
        Class<?>[] classArray = method2.getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            ResolvableType resolvableType = ResolvableType.forMethodParameter(method, i2, clazz);
            Class<?> clazz2 = classArray[i2];
            if (clazz2.isArray() && !clazz2.getComponentType().equals(resolvableType.getComponentType().toClass())) {
                return false;
            }
            if (ClassUtils.resolvePrimitiveIfNecessary(clazz2).equals(ClassUtils.resolvePrimitiveIfNecessary(resolvableType.toClass()))) continue;
            return false;
        }
        return true;
    }

    private static Method findGenericDeclaration(Method method) {
        Object object;
        for (Class<?> clazz = method.getDeclaringClass().getSuperclass(); clazz != null && Object.class != clazz; clazz = clazz.getSuperclass()) {
            object = BridgeMethodResolver.searchForMatch(clazz, method);
            if (object == null || ((Method)object).isBridge()) continue;
            return object;
        }
        object = ClassUtils.getAllInterfacesForClass(method.getDeclaringClass());
        return BridgeMethodResolver.searchInterfaces(object, method);
    }

    private static Method searchInterfaces(Class<?>[] classArray, Method method) {
        for (Class<?> clazz : classArray) {
            Method method2 = BridgeMethodResolver.searchForMatch(clazz, method);
            if (method2 != null && !method2.isBridge()) {
                return method2;
            }
            method2 = BridgeMethodResolver.searchInterfaces(clazz.getInterfaces(), method);
            if (method2 == null) continue;
            return method2;
        }
        return null;
    }

    private static Method searchForMatch(Class<?> clazz, Method method) {
        try {
            return clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

