/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConditionalConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.Converter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConverterFactory;
import com.gradle.maven.extension.internal.dep.org.springframework.util.NumberUtils;

final class NumberToNumberConverterFactory
implements ConditionalConverter,
ConverterFactory<Number, Number> {
    NumberToNumberConverterFactory() {
    }

    @Override
    public <T extends Number> Converter<Number, T> getConverter(Class<T> clazz) {
        return new NumberToNumber<T>(clazz);
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return !typeDescriptor.equals(typeDescriptor2);
    }

    private static final class NumberToNumber<T extends Number>
    implements Converter<Number, T> {
        private final Class<T> targetType;

        NumberToNumber(Class<T> clazz) {
            this.targetType = clazz;
        }

        @Override
        public T convert(Number number) {
            return NumberUtils.convertNumberToTargetClass(number, this.targetType);
        }
    }
}

