/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.ValueRef;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.CollectionUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Selection
extends SpelNodeImpl {
    private final int variant;
    private final boolean nullSafe;

    public Selection(boolean bl2, int n2, int n3, int n4, SpelNodeImpl spelNodeImpl) {
        super(n3, n4, spelNodeImpl);
        this.nullSafe = bl2;
        this.variant = n2;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        return this.getValueRef(expressionState).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState expressionState) throws EvaluationException {
        TypedValue typedValue = expressionState.getActiveContextObject();
        Object object = typedValue.getValue();
        SpelNodeImpl spelNodeImpl = this.children[0];
        if (object instanceof Map) {
            Map map = (Map)object;
            HashMap hashMap = new HashMap();
            Object k2 = null;
            for (Map.Entry entry : map.entrySet()) {
                try {
                    TypedValue typedValue2 = new TypedValue(entry);
                    expressionState.pushActiveContextObject(typedValue2);
                    expressionState.enterScope();
                    Object object2 = spelNodeImpl.getValueInternal(expressionState).getValue();
                    if (object2 instanceof Boolean) {
                        if (!((Boolean)object2).booleanValue()) continue;
                        if (this.variant == 1) {
                            hashMap.put(entry.getKey(), entry.getValue());
                            ValueRef.TypedValueHolderValueRef typedValueHolderValueRef = new ValueRef.TypedValueHolderValueRef(new TypedValue(hashMap), this);
                            return typedValueHolderValueRef;
                        }
                        hashMap.put(entry.getKey(), entry.getValue());
                        k2 = entry.getKey();
                        continue;
                    }
                    throw new SpelEvaluationException(spelNodeImpl.getStartPosition(), SpelMessage.RESULT_OF_SELECTION_CRITERIA_IS_NOT_BOOLEAN, new Object[0]);
                }
                finally {
                    expressionState.popActiveContextObject();
                    expressionState.exitScope();
                }
            }
            if ((this.variant == 1 || this.variant == 2) && hashMap.isEmpty()) {
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(null), this);
            }
            if (this.variant == 2) {
                Map.Entry entry;
                HashMap hashMap2 = new HashMap();
                entry = hashMap.get(k2);
                hashMap2.put(k2, entry);
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(hashMap2), this);
            }
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(hashMap), this);
        }
        if (object instanceof Iterable || ObjectUtils.isArray(object)) {
            Object object3;
            Object object42;
            List<Object> list = object instanceof Iterable ? (List<Object>)object : Arrays.asList(ObjectUtils.toObjectArray(object));
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n2 = 0;
            for (Object object42 : list) {
                try {
                    expressionState.pushActiveContextObject(new TypedValue(object42));
                    expressionState.enterScope("index", n2);
                    object3 = spelNodeImpl.getValueInternal(expressionState).getValue();
                    if (object3 instanceof Boolean) {
                        if (((Boolean)object3).booleanValue()) {
                            if (this.variant == 1) {
                                ValueRef.TypedValueHolderValueRef typedValueHolderValueRef = new ValueRef.TypedValueHolderValueRef(new TypedValue(object42), this);
                                return typedValueHolderValueRef;
                            }
                            arrayList.add(object42);
                        }
                    } else {
                        throw new SpelEvaluationException(spelNodeImpl.getStartPosition(), SpelMessage.RESULT_OF_SELECTION_CRITERIA_IS_NOT_BOOLEAN, new Object[0]);
                    }
                    ++n2;
                }
                finally {
                    expressionState.exitScope();
                    expressionState.popActiveContextObject();
                }
            }
            if ((this.variant == 1 || this.variant == 2) && arrayList.isEmpty()) {
                return ValueRef.NullValueRef.INSTANCE;
            }
            if (this.variant == 2) {
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(CollectionUtils.lastElement(arrayList)), this);
            }
            if (object instanceof Iterable) {
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(arrayList), this);
            }
            Object object5 = null;
            object42 = typedValue.getTypeDescriptor();
            if (object42 != null && (object3 = ((TypeDescriptor)object42).getElementTypeDescriptor()) != null) {
                object5 = ClassUtils.resolvePrimitiveIfNecessary(((TypeDescriptor)object3).getType());
            }
            Assert.state(object5 != null, "Unresolvable element type");
            object3 = Array.newInstance(object5, arrayList.size());
            System.arraycopy(arrayList.toArray(), 0, object3, 0, arrayList.size());
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(object3), this);
        }
        if (object == null) {
            if (this.nullSafe) {
                return ValueRef.NullValueRef.INSTANCE;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INVALID_TYPE_FOR_SELECTION, "null");
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INVALID_TYPE_FOR_SELECTION, object.getClass().getName());
    }

    @Override
    public String toStringAST() {
        return this.prefix() + this.getChild(0).toStringAST() + "]";
    }

    private String prefix() {
        switch (this.variant) {
            case 0: {
                return "?[";
            }
            case 1: {
                return "^[";
            }
            case 2: {
                return "$[";
            }
        }
        return "";
    }
}

