/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Optional;
import java.util.Set;
import org.gradle.cache.internal.locklistener.FileLockCommunicator;
import org.gradle.cache.internal.locklistener.FileLockPacketPayload;
import org.gradle.cache.internal.locklistener.FileLockPacketType;
import org.gradle.cache.internal.locklistener.InetAddressProvider;
import org.gradle.internal.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileLockCommunicator
implements FileLockCommunicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileLockCommunicator.class);
    private final DatagramSocket socket;

    public DefaultFileLockCommunicator(InetAddressProvider inetAddressProvider) {
        try {
            this.socket = new DatagramSocket(0, inetAddressProvider.getWildcardBindingAddress());
        }
        catch (SocketException socketException) {
            throw UncheckedException.throwAsUncheckedException(socketException);
        }
    }

    @Override
    public boolean pingOwner(InetAddress inetAddress, int n2, long l2, String string) {
        boolean bl2 = false;
        byte[] byArray = FileLockPacketPayload.encode(l2, FileLockPacketType.UNLOCK_REQUEST);
        try {
            this.socket.send(new DatagramPacket(byArray, byArray.length, inetAddress, n2));
            bl2 = true;
        }
        catch (IOException iOException) {
            LOGGER.debug("Failed attempt to ping owner of lock for {} (lock id: {}, port: {}, address: {})", new Object[]{string, l2, n2, inetAddress});
        }
        return bl2;
    }

    @Override
    public Optional<DatagramPacket> receive() throws IOException {
        try {
            byte[] byArray = new byte[10];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            this.socket.receive(datagramPacket);
            return Optional.of(datagramPacket);
        }
        catch (IOException iOException) {
            if (this.socket.isClosed()) {
                return Optional.empty();
            }
            throw iOException;
        }
    }

    @Override
    public FileLockPacketPayload decode(DatagramPacket datagramPacket) {
        return FileLockPacketPayload.decode(datagramPacket.getData(), datagramPacket.getLength());
    }

    @Override
    public void confirmUnlockRequest(SocketAddress socketAddress, long l2) {
        byte[] byArray = FileLockPacketPayload.encode(l2, FileLockPacketType.UNLOCK_REQUEST_CONFIRMATION);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        datagramPacket.setSocketAddress(socketAddress);
        LOGGER.debug("Confirming unlock request to process at port {} for lock with id {}.", (Object)datagramPacket.getPort(), (Object)l2);
        try {
            this.socket.send(datagramPacket);
        }
        catch (IOException iOException) {
            LOGGER.debug("Failed to confirm unlock request to process at port {} for lock with id {}.", (Object)datagramPacket.getPort(), (Object)l2);
        }
    }

    @Override
    public void confirmLockRelease(Set<SocketAddress> set, long l2) {
        byte[] byArray = FileLockPacketPayload.encode(l2, FileLockPacketType.LOCK_RELEASE_CONFIRMATION);
        for (SocketAddress socketAddress : set) {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            datagramPacket.setSocketAddress(socketAddress);
            LOGGER.debug("Confirming lock release to process at port {} for lock with id {}.", (Object)datagramPacket.getPort(), (Object)l2);
            try {
                this.socket.send(datagramPacket);
            }
            catch (IOException iOException) {
                LOGGER.debug("Failed to confirm lock release to process at port {} for lock with id {}.", (Object)datagramPacket.getPort(), (Object)l2);
            }
        }
    }

    @Override
    public void stop() {
        this.socket.close();
    }

    @Override
    public int getPort() {
        return this.socket.getLocalPort();
    }
}

