/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.gradle.cache.FileLockReleasedSignal;
import org.gradle.cache.internal.locklistener.DefaultFileLockCommunicator;
import org.gradle.cache.internal.locklistener.FileLockCommunicator;
import org.gradle.cache.internal.locklistener.FileLockContentionHandler;
import org.gradle.cache.internal.locklistener.FileLockPacketPayload;
import org.gradle.cache.internal.locklistener.FileLockPacketType;
import org.gradle.cache.internal.locklistener.InetAddressProvider;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileLockContentionHandler
implements FileLockContentionHandler,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileLockContentionHandler.class);
    private final Lock lock = new ReentrantLock();
    private final Map<Long, ContendedAction> contendedActions = new HashMap<Long, ContendedAction>();
    private final Map<Long, FileLockReleasedSignal> lockReleasedSignals = new HashMap<Long, FileLockReleasedSignal>();
    private final Map<Long, Integer> unlocksRequestedFrom = new HashMap<Long, Integer>();
    private final Map<Long, Integer> unlocksConfirmedFrom = new HashMap<Long, Integer>();
    private final FileLockCommunicator communicator;
    private final InetAddressProvider inetAddressProvider;
    private final ExecutorFactory executorFactory;
    private ManagedExecutor fileLockRequestListener;
    private ManagedExecutor unlockActionExecutor;
    private boolean stopped;
    private volatile boolean listenerFailed;

    public DefaultFileLockContentionHandler(ExecutorFactory executorFactory, InetAddressProvider inetAddressProvider) {
        this(new DefaultFileLockCommunicator(inetAddressProvider), inetAddressProvider, executorFactory);
    }

    DefaultFileLockContentionHandler(FileLockCommunicator fileLockCommunicator, InetAddressProvider inetAddressProvider, ExecutorFactory executorFactory) {
        this.communicator = fileLockCommunicator;
        this.inetAddressProvider = inetAddressProvider;
        this.executorFactory = executorFactory;
    }

    private Runnable listener() {
        return new Runnable(){
            private int failureCount = 0;

            @Override
            public void run() {
                try {
                    LOGGER.debug("Starting file lock listener thread.");
                    this.doRun();
                }
                finally {
                    LOGGER.debug("File lock listener thread completed.");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            private void doRun() {
                while (true) {
                    try {
                        while (true) lbl-1000:
                        // 4 sources

                        {
                            DefaultFileLockContentionHandler.access$100(DefaultFileLockContentionHandler.this).lock();
                            try {
                                if (DefaultFileLockContentionHandler.access$200(DefaultFileLockContentionHandler.this)) {
                                    return;
                                }
                            }
                            finally {
                                DefaultFileLockContentionHandler.access$100(DefaultFileLockContentionHandler.this).unlock();
                            }
                            var1_1 = DefaultFileLockContentionHandler.access$300(DefaultFileLockContentionHandler.this).receive();
                            if (!var1_1.isPresent()) continue;
                            var2_4 = var1_1.get();
                            var3_5 = DefaultFileLockContentionHandler.access$300(DefaultFileLockContentionHandler.this).decode(var2_4);
                            DefaultFileLockContentionHandler.access$100(DefaultFileLockContentionHandler.this).lock();
                            try {
                                var4_6 = (ContendedAction)DefaultFileLockContentionHandler.access$400(DefaultFileLockContentionHandler.this).get(var3_5.getLockId());
                                if (var4_6 == null) {
                                    DefaultFileLockContentionHandler.access$500(DefaultFileLockContentionHandler.this, var3_5, var2_4.getPort());
                                } else {
                                    ContendedAction.access$600(var4_6, var2_4.getSocketAddress());
                                    if (!ContendedAction.access$700(var4_6)) {
                                        DefaultFileLockContentionHandler.access$800(DefaultFileLockContentionHandler.this, var4_6);
                                    }
                                    DefaultFileLockContentionHandler.access$300(DefaultFileLockContentionHandler.this).confirmUnlockRequest(var2_4.getSocketAddress(), var3_5.getLockId());
                                }
                                this.failureCount = 0;
                            }
                            finally {
                                DefaultFileLockContentionHandler.access$100(DefaultFileLockContentionHandler.this).unlock();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable var1_3) {
                        ++this.failureCount;
                        if (this.failureCount < 100) continue;
                        DefaultFileLockContentionHandler.access$000().error("Problems handling incoming lock requests.", var1_3);
                        DefaultFileLockContentionHandler.access$902(DefaultFileLockContentionHandler.this, true);
                        return;
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
        };
    }

    private void startLockReleaseAsLockHolder(ContendedAction contendedAction) {
        contendedAction.running = true;
        this.unlockActionExecutor.execute(contendedAction);
    }

    private void acceptConfirmationAsLockRequester(FileLockPacketPayload fileLockPacketPayload, Integer n2) {
        long l2 = fileLockPacketPayload.getLockId();
        if (fileLockPacketPayload.getType() == FileLockPacketType.LOCK_RELEASE_CONFIRMATION) {
            LOGGER.debug("Process at port {} confirmed lock release for lock with id {}.", (Object)n2, (Object)l2);
            FileLockReleasedSignal fileLockReleasedSignal = this.lockReleasedSignals.get(l2);
            if (fileLockReleasedSignal != null) {
                LOGGER.debug("Triggering lock release signal for lock with id {}.", (Object)l2);
                fileLockReleasedSignal.trigger();
            }
        } else {
            LOGGER.debug("Process at port {} confirmed unlock request for lock with id {}.", (Object)n2, (Object)l2);
            this.unlocksConfirmedFrom.put(l2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(long l2, Consumer<FileLockReleasedSignal> consumer) {
        this.lock.lock();
        try {
            if (this.unlockActionExecutor == null) {
                this.unlockActionExecutor = this.executorFactory.create("File lock release action executor");
            }
            if (this.fileLockRequestListener == null) {
                this.fileLockRequestListener = this.executorFactory.create("File lock request listener");
                this.fileLockRequestListener.execute(this.listener());
            }
            this.lockReleasedSignals.remove(l2);
            this.unlocksRequestedFrom.remove(l2);
            this.unlocksConfirmedFrom.remove(l2);
            this.assertNotStopped();
            if (this.contendedActions.containsKey(l2)) {
                throw new UnsupportedOperationException("Multiple contention actions for a given lock are currently not supported.");
            }
            this.contendedActions.put(l2, new ContendedAction(l2, consumer));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean maybePingOwner(int n2, long l2, String string, long l3, FileLockReleasedSignal fileLockReleasedSignal) {
        if (Integer.valueOf(n2).equals(this.unlocksConfirmedFrom.get(l2))) {
            return false;
        }
        if (Integer.valueOf(n2).equals(this.unlocksRequestedFrom.get(l2)) && l3 < 1000L) {
            return false;
        }
        boolean bl2 = this.getCommunicator().pingOwner(this.inetAddressProvider.getCommunicationAddress(), n2, l2, string);
        if (bl2) {
            this.lock.lock();
            try {
                this.unlocksRequestedFrom.put(l2, n2);
                this.lockReleasedSignals.put(l2, fileLockReleasedSignal);
            }
            finally {
                this.lock.unlock();
            }
        }
        return bl2;
    }

    private void assertNotStopped() {
        if (this.stopped) {
            throw new IllegalStateException("Cannot start managing file contention because this handler has been closed.");
        }
    }

    @Override
    public void stop(long l2) {
        this.lock.lock();
        try {
            this.contendedActions.remove(l2);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.stopped = true;
            this.contendedActions.clear();
            this.communicator.stop();
        }
        finally {
            this.lock.unlock();
        }
        if (this.unlockActionExecutor != null) {
            this.unlockActionExecutor.stop();
        }
        if (this.fileLockRequestListener != null) {
            this.fileLockRequestListener.stop();
        }
    }

    @Override
    public int reservePort() {
        this.lock.lock();
        try {
            this.assertNotStopped();
        }
        finally {
            this.lock.unlock();
        }
        return this.getCommunicator().getPort();
    }

    private FileLockCommunicator getCommunicator() {
        return this.communicator;
    }

    static /* synthetic */ Lock access$100(DefaultFileLockContentionHandler defaultFileLockContentionHandler) {
        return defaultFileLockContentionHandler.lock;
    }

    static /* synthetic */ boolean access$200(DefaultFileLockContentionHandler defaultFileLockContentionHandler) {
        return defaultFileLockContentionHandler.stopped;
    }

    static /* synthetic */ Map access$400(DefaultFileLockContentionHandler defaultFileLockContentionHandler) {
        return defaultFileLockContentionHandler.contendedActions;
    }

    static /* synthetic */ void access$500(DefaultFileLockContentionHandler defaultFileLockContentionHandler, FileLockPacketPayload fileLockPacketPayload, Integer n2) {
        defaultFileLockContentionHandler.acceptConfirmationAsLockRequester(fileLockPacketPayload, n2);
    }

    static /* synthetic */ void access$800(DefaultFileLockContentionHandler defaultFileLockContentionHandler, ContendedAction contendedAction) {
        defaultFileLockContentionHandler.startLockReleaseAsLockHolder(contendedAction);
    }

    static /* synthetic */ boolean access$902(DefaultFileLockContentionHandler defaultFileLockContentionHandler, boolean bl2) {
        defaultFileLockContentionHandler.listenerFailed = bl2;
        return defaultFileLockContentionHandler.listenerFailed;
    }

    private class ContendedAction
    implements Runnable {
        private final Lock lock = new ReentrantLock();
        private final long lockId;
        private final Consumer<FileLockReleasedSignal> action;
        private Set<SocketAddress> requesters = new LinkedHashSet<SocketAddress>();
        private boolean running;

        private ContendedAction(long l2, Consumer<FileLockReleasedSignal> consumer) {
            this.lockId = l2;
            this.action = consumer;
        }

        @Override
        public void run() {
            this.action.accept(() -> {
                Set<SocketAddress> set = this.consumeRequesters();
                if (set == null) {
                    throw new IllegalStateException("trigger() has already been called and must at most be called once");
                }
                DefaultFileLockContentionHandler.this.communicator.confirmLockRelease(set, this.lockId);
            });
        }

        private void addRequester(SocketAddress socketAddress) {
            this.lock.lock();
            try {
                if (this.requesters != null) {
                    this.requesters.add(socketAddress);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private Set<SocketAddress> consumeRequesters() {
            this.lock.lock();
            try {
                Set<SocketAddress> set = this.requesters;
                return set;
            }
            finally {
                this.requesters = null;
                this.lock.unlock();
            }
        }

        static /* synthetic */ void access$600(ContendedAction contendedAction, SocketAddress socketAddress) {
            contendedAction.addRequester(socketAddress);
        }

        static /* synthetic */ boolean access$700(ContendedAction contendedAction) {
            return contendedAction.running;
        }
    }
}

