/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.base.CharMatcher;
import java.util.ArrayDeque;
import java.util.Deque;
import org.gradle.internal.file.FilePathUtil;

public class RelativePathParser {
    private static final CharMatcher IS_SLASH = CharMatcher.is('/');
    private final Deque<String> directoryPaths = new ArrayDeque<String>();
    private final Deque<String> directoryNames = new ArrayDeque<String>();
    private final int rootLength;
    private String currentPath;
    private int sizeOfCommonPrefix;

    public RelativePathParser(String string) {
        this.directoryPaths.addLast(string.substring(0, string.length() - 1));
        this.rootLength = string.length();
        this.currentPath = string;
    }

    public String getRelativePath() {
        return this.currentPath.substring(this.rootLength);
    }

    public String getName() {
        return this.currentPath.substring(this.sizeOfCommonPrefix + 1);
    }

    public boolean nextPath(String string, boolean bl2, Runnable runnable) {
        this.currentPath = bl2 ? string.substring(0, string.length() - 1) : string;
        String string2 = this.directoryPaths.peekLast();
        this.sizeOfCommonPrefix = FilePathUtil.sizeOfCommonPrefix(string2, this.currentPath, 0, '/');
        int n2 = RelativePathParser.determineDirectoriesExited(string2, this.sizeOfCommonPrefix);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.exitDirectory(runnable)) continue;
            return true;
        }
        String string3 = this.currentPath.substring(this.sizeOfCommonPrefix + 1);
        if (bl2) {
            this.directoryPaths.addLast(this.currentPath);
            this.directoryNames.addLast(string3);
        }
        return this.isRoot();
    }

    private boolean exitDirectory(Runnable runnable) {
        if (this.directoryPaths.pollLast() == null) {
            return true;
        }
        if (this.directoryNames.pollLast() == null) {
            return true;
        }
        runnable.run();
        return false;
    }

    private static int determineDirectoriesExited(String string, int n2) {
        if (n2 == string.length()) {
            return 0;
        }
        int n3 = n2 == 0 ? 1 : 0;
        return n3 + IS_SLASH.countIn(string.substring(n2));
    }

    public boolean isRoot() {
        return this.directoryNames.isEmpty() && this.currentPath.length() == this.rootLength;
    }

    public void exitToRoot(Runnable runnable) {
        while (!this.exitDirectory(runnable)) {
        }
    }
}

