/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.AbstractDelegatingExecutorService;
import org.gradle.internal.concurrent.ExecutorPolicy;
import org.gradle.internal.concurrent.ManagedExecutor;

public abstract class AbstractManagedExecutor<S extends ExecutorService>
extends AbstractDelegatingExecutorService<S>
implements ManagedExecutor {
    private final ThreadLocal<Object> executing = new ThreadLocal();
    private final ExecutorPolicy executorPolicy;

    public AbstractManagedExecutor(S s2, ExecutorPolicy executorPolicy) {
        super(s2);
        this.executorPolicy = executorPolicy;
    }

    @Override
    public void execute(Runnable runnable) {
        this.delegate.execute(this.trackedCommand(runnable));
    }

    protected Runnable trackedCommand(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                AbstractManagedExecutor.this.executing.set(runnable);
                try {
                    AbstractManagedExecutor.this.executorPolicy.onExecute(runnable);
                }
                finally {
                    AbstractManagedExecutor.this.executing.remove();
                }
            }
        };
    }

    public void requestStop() {
        this.delegate.shutdown();
    }

    @Override
    public void stop() {
        this.stop(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    public void stop(int n2, TimeUnit timeUnit) throws IllegalStateException {
        this.requestStop();
        if (this.executing.get() != null) {
            throw new IllegalStateException("Cannot stop this executor from an executor thread.");
        }
        try {
            if (!this.delegate.awaitTermination(n2, timeUnit)) {
                this.delegate.shutdownNow();
                throw new IllegalStateException("Timeout waiting for concurrent jobs to complete.");
            }
        }
        catch (InterruptedException interruptedException) {
            this.delegate.shutdownNow();
            throw UncheckedException.throwAsUncheckedException(interruptedException);
        }
        this.executorPolicy.onStop();
    }
}

