/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.QuarkusBuildCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class QuarkusExtensionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuarkusBuildCache.class);
    private static final String LOG_PREFIX = "[quarkus-build-caching-extension] ";

    QuarkusExtensionUtil() {
    }

    static Properties loadProperties(String baseDir, String propertyFile) {
        Properties props = new Properties();
        File configFile = new File(baseDir, propertyFile);
        if (configFile.exists()) {
            try (InputStream input = Files.newInputStream(configFile.toPath(), new OpenOption[0]);){
                props.load(input);
            }
            catch (IOException e) {
                LOGGER.error(QuarkusExtensionUtil.getLogMessage("Error while loading " + propertyFile), (Throwable)e);
            }
        } else {
            LOGGER.debug(QuarkusExtensionUtil.getLogMessage(propertyFile + " not found"));
        }
        return props;
    }

    static boolean isNotEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    static String getLogMessage(String msg) {
        return LOG_PREFIX + msg;
    }
}

