/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.QuarkusExtensionConfiguration;
import com.gradle.develocity.agent.maven.api.cache.MojoMetadataProvider;
import org.codehaus.plexus.util.xml.Xpp3Dom;

class TestConfiguration {
    private static final String TEST_GOAL_KEY_ADD_QUARKUS_INPUTS = "addQuarkusInputs";
    private static final String TEST_GOAL_KEY_ADD_QUARKUS_PACKAGE_INPUTS = "addQuarkusPackageInputs";
    private static final String TEST_GOAL_KEY_QUARKUS_PACKAGE_PATTERN = "quarkusPackagePattern";
    private static final String TEST_GOAL_DEFAULT_QUARKUS_PACKAGE_JAR_PATTERN = "*.jar";
    private static final String TEST_GOAL_DEFAULT_QUARKUS_PACKAGE_EXE_PATTERN = "*-runner";
    private boolean addQuarkusInputs;
    private boolean addQuarkusPackageInputs;
    private String quarkusPackagePattern;

    TestConfiguration(MojoMetadataProvider.Context context, QuarkusExtensionConfiguration extensionConfiguration) {
        Xpp3Dom properties;
        if (extensionConfiguration.isQuarkusCacheEnabled() && (properties = context.getMojoExecution().getConfiguration().getChild("properties")) != null) {
            Xpp3Dom quarkusPackagePatternProperty;
            Xpp3Dom addQuarkusPackageInputsProperty;
            Xpp3Dom addQuarkusInputsProperty = properties.getChild(TEST_GOAL_KEY_ADD_QUARKUS_INPUTS);
            if (addQuarkusInputsProperty != null) {
                this.addQuarkusInputs = Boolean.parseBoolean(addQuarkusInputsProperty.getValue());
            }
            if ((addQuarkusPackageInputsProperty = properties.getChild(TEST_GOAL_KEY_ADD_QUARKUS_PACKAGE_INPUTS)) != null) {
                this.addQuarkusPackageInputs = Boolean.parseBoolean(addQuarkusPackageInputsProperty.getValue());
            }
            if ((quarkusPackagePatternProperty = properties.getChild(TEST_GOAL_KEY_QUARKUS_PACKAGE_PATTERN)) != null) {
                this.quarkusPackagePattern = quarkusPackagePatternProperty.getValue();
            }
        }
    }

    boolean isAddQuarkusInputs() {
        return this.addQuarkusInputs;
    }

    boolean isAddQuarkusPackageInputs() {
        return this.addQuarkusPackageInputs;
    }

    String getQuarkusJarFilePattern() {
        return this.quarkusPackagePattern != null ? this.quarkusPackagePattern : TEST_GOAL_DEFAULT_QUARKUS_PACKAGE_JAR_PATTERN;
    }

    String getQuarkusExeFilePattern() {
        return this.quarkusPackagePattern != null ? this.quarkusPackagePattern : TEST_GOAL_DEFAULT_QUARKUS_PACKAGE_EXE_PATTERN;
    }

    public String toString() {
        return "TestConfiguration{addQuarkusInputs=" + this.addQuarkusInputs + ", addQuarkusPackageInputs=" + this.addQuarkusPackageInputs + ", quarkusPackagePattern='" + this.quarkusPackagePattern + '\'' + '}';
    }
}

