/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.rpc.server.spring.actionhandlervalidator;

import com.gwtplatform.dispatch.rpc.server.actionhandler.ActionHandler;
import com.gwtplatform.dispatch.rpc.server.actionhandlervalidator.ActionHandlerValidatorClass;
import com.gwtplatform.dispatch.rpc.server.actionhandlervalidator.ActionHandlerValidatorInstance;
import com.gwtplatform.dispatch.rpc.server.actionhandlervalidator.LazyActionHandlerValidatorRegistry;
import com.gwtplatform.dispatch.rpc.server.actionvalidator.ActionValidator;
import com.gwtplatform.dispatch.rpc.server.spring.utils.SpringUtils;
import com.gwtplatform.dispatch.rpc.shared.Action;
import com.gwtplatform.dispatch.rpc.shared.Result;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class LazyActionHandlerValidatorRegistryImpl
implements LazyActionHandlerValidatorRegistry,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private final Map<Class<? extends Action<?>>, ActionHandlerValidatorClass<? extends Action<?>, ? extends Result>> actionHandlerValidatorClasses = new ConcurrentHashMap();
    private final Map<Class<? extends Action<?>>, ActionHandlerValidatorInstance> actionHandlerValidatorInstances = new ConcurrentHashMap();
    private final Map<Class<? extends ActionValidator>, ActionValidator> validators = new ConcurrentHashMap<Class<? extends ActionValidator>, ActionValidator>();

    public <A extends Action<R>, R extends Result> void addActionHandlerValidatorClass(Class<A> actionClass, ActionHandlerValidatorClass<A, R> actionHandlerValidatorClass) {
        this.actionHandlerValidatorClasses.put(actionClass, actionHandlerValidatorClass);
    }

    public void clearActionHandlerValidators() {
        this.actionHandlerValidatorInstances.clear();
        this.validators.clear();
    }

    public <A extends Action<R>, R extends Result> ActionHandlerValidatorInstance findActionHandlerValidator(A action) {
        ActionHandlerValidatorClass<? extends Action<?>, ? extends Result> actionHandlerValidatorClass;
        ActionHandlerValidatorInstance actionHandlerValidatorInstance = this.actionHandlerValidatorInstances.get(action.getClass());
        if (actionHandlerValidatorInstance == null && (actionHandlerValidatorClass = this.actionHandlerValidatorClasses.get(action.getClass())) != null && (actionHandlerValidatorInstance = this.createInstance(actionHandlerValidatorClass)) != null) {
            this.actionHandlerValidatorInstances.put(action.getClass(), actionHandlerValidatorInstance);
        }
        return actionHandlerValidatorInstance;
    }

    public ActionValidator findActionValidator(Class<? extends ActionValidator> actionValidatorClass) {
        return this.validators.get(actionValidatorClass);
    }

    public <A extends Action<R>, R extends Result> void removeActionHandlerValidatorClass(Class<A> actionClass, ActionHandlerValidatorClass<A, R> actionHandlerValidatorClass) {
        ActionHandlerValidatorClass<? extends Action<?>, ? extends Result> oldActionHandlerValidatorClass = this.actionHandlerValidatorClasses.get(actionClass);
        if (oldActionHandlerValidatorClass == actionHandlerValidatorClass) {
            this.actionHandlerValidatorClasses.remove(actionClass);
            ActionHandlerValidatorInstance instance = this.actionHandlerValidatorInstances.remove(actionClass);
            if (!this.containValidator(instance.getActionValidator())) {
                this.validators.remove(instance.getActionValidator().getClass());
            }
        }
    }

    private boolean containValidator(ActionValidator actionValidator) {
        for (ActionHandlerValidatorInstance validator : this.actionHandlerValidatorInstances.values()) {
            if (!validator.getActionValidator().getClass().equals(actionValidator.getClass())) continue;
            return true;
        }
        return false;
    }

    private ActionHandlerValidatorInstance createInstance(ActionHandlerValidatorClass<? extends Action<?>, ? extends Result> actionHandlerValidatorClass) {
        ActionHandlerValidatorInstance actionHandlerValidatorInstance;
        ActionValidator actionValidator = this.findActionValidator(actionHandlerValidatorClass.getActionValidatorClass());
        ActionHandler actionHandler = (ActionHandler)SpringUtils.getInstance(this.applicationContext, actionHandlerValidatorClass.getActionHandlerClass());
        if (actionValidator == null) {
            actionValidator = (ActionValidator)SpringUtils.getInstance(this.applicationContext, actionHandlerValidatorClass.getActionValidatorClass());
            actionHandlerValidatorInstance = new ActionHandlerValidatorInstance(actionValidator, actionHandler);
            this.validators.put(actionValidator.getClass(), actionValidator);
        } else {
            actionHandlerValidatorInstance = new ActionHandlerValidatorInstance(actionValidator, actionHandler);
        }
        if (actionHandlerValidatorInstance.getActionHandler() == null || actionHandlerValidatorInstance.getActionValidator() == null) {
            return null;
        }
        return actionHandlerValidatorInstance;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

