/*
 * Decompiled with CFR 0.152.
 */
package com.gwtplatform.dispatch.rpc.server.spring.utils;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.AbstractRefreshableWebApplicationContext;

public class SpringUtils {
    public static <B> B getOrCreate(ApplicationContext applicationContext, Class<B> clazz) throws BeansException {
        try {
            return SpringUtils.getInstance(applicationContext, clazz);
        }
        catch (BeansException beansException) {
            return SpringUtils.instantiate(applicationContext, clazz);
        }
    }

    public static <B> B instantiate(ApplicationContext applicationContext, Class<B> clazz) throws BeansException {
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory((BeanFactory)applicationContext);
        return (B)beanFactory.createBean(clazz, 3, false);
    }

    public static <B> void registerBean(ApplicationContext applicationContext, B instance) throws BeansException {
        if (applicationContext instanceof GenericApplicationContext) {
            ConfigurableListableBeanFactory beanFactory = ((GenericApplicationContext)applicationContext).getBeanFactory();
            beanFactory.registerSingleton(SpringUtils.generateName(beanFactory, SpringUtils.createBeanDefinition(instance)), instance);
        } else if (applicationContext instanceof AbstractRefreshableWebApplicationContext) {
            ConfigurableListableBeanFactory beanFactory = ((AbstractRefreshableWebApplicationContext)applicationContext).getBeanFactory();
            beanFactory.registerSingleton(SpringUtils.generateName(beanFactory, SpringUtils.createBeanDefinition(instance)), instance);
        }
    }

    public static <B> B getInstance(ApplicationContext applicationContext, Class<B> clazz) throws BeansException {
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory((BeanFactory)applicationContext);
        return (B)beanFactory.getBean(clazz);
    }

    private static <B> RootBeanDefinition createBeanDefinition(B instance) {
        RootBeanDefinition bd = new RootBeanDefinition(instance.getClass(), 3, false);
        bd.setScope("singleton");
        return bd;
    }

    private static String generateName(ConfigurableListableBeanFactory registry, RootBeanDefinition definition) {
        String generatedBeanName = definition.getBeanClassName();
        if (generatedBeanName == null) {
            if (definition.getParentName() != null) {
                generatedBeanName = definition.getParentName() + "$child";
            } else if (definition.getFactoryBeanName() != null) {
                generatedBeanName = definition.getFactoryBeanName() + "$created";
            }
        }
        if (!StringUtils.hasText((String)generatedBeanName)) {
            throw new BeanDefinitionStoreException("Unnamed bean definition specifies neither 'class' nor 'parent' nor 'factory-bean' - can't generate bean name");
        }
        String id = generatedBeanName;
        int counter = -1;
        while (counter == -1 || registry.containsSingleton(id)) {
            id = generatedBeanName + "#" + ++counter;
        }
        return id;
    }
}

