
package un.unece.uncefact.data.standard.crossindustryinvoice._100;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ExchangedDocumentContextType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ExchangedDocumentType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.SupplyChainTradeTransactionType;
import un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100.ValuationBreakdownStatementType;


/**
 * <p>Java class for CrossIndustryInvoiceType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="CrossIndustryInvoiceType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ExchangedDocumentContext" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ExchangedDocumentContextType"/>
 *         <element name="ExchangedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ExchangedDocumentType"/>
 *         <element name="SupplyChainTradeTransaction" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SupplyChainTradeTransactionType"/>
 *         <element name="ValuationBreakdownStatement" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ValuationBreakdownStatementType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CrossIndustryInvoiceType", propOrder = {
    "exchangedDocumentContext",
    "exchangedDocument",
    "supplyChainTradeTransaction",
    "valuationBreakdownStatement"
})
@CodingStyleguideUnaware
public class CrossIndustryInvoiceType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ExchangedDocumentContext", required = true)
    private ExchangedDocumentContextType exchangedDocumentContext;
    @XmlElement(name = "ExchangedDocument", required = true)
    private ExchangedDocumentType exchangedDocument;
    @XmlElement(name = "SupplyChainTradeTransaction", required = true)
    private SupplyChainTradeTransactionType supplyChainTradeTransaction;
    @XmlElement(name = "ValuationBreakdownStatement")
    private ValuationBreakdownStatementType valuationBreakdownStatement;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public CrossIndustryInvoiceType() {
    }

    /**
     * Gets the value of the exchangedDocumentContext property.
     * 
     * @return
     *     possible object is
     *     {@link ExchangedDocumentContextType }
     *     
     */
    @Nullable
    public ExchangedDocumentContextType getExchangedDocumentContext() {
        return exchangedDocumentContext;
    }

    /**
     * Sets the value of the exchangedDocumentContext property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExchangedDocumentContextType }
     *     
     */
    public void setExchangedDocumentContext(
        @Nullable
        ExchangedDocumentContextType value) {
        this.exchangedDocumentContext = value;
    }

    /**
     * Gets the value of the exchangedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ExchangedDocumentType }
     *     
     */
    @Nullable
    public ExchangedDocumentType getExchangedDocument() {
        return exchangedDocument;
    }

    /**
     * Sets the value of the exchangedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExchangedDocumentType }
     *     
     */
    public void setExchangedDocument(
        @Nullable
        ExchangedDocumentType value) {
        this.exchangedDocument = value;
    }

    /**
     * Gets the value of the supplyChainTradeTransaction property.
     * 
     * @return
     *     possible object is
     *     {@link SupplyChainTradeTransactionType }
     *     
     */
    @Nullable
    public SupplyChainTradeTransactionType getSupplyChainTradeTransaction() {
        return supplyChainTradeTransaction;
    }

    /**
     * Sets the value of the supplyChainTradeTransaction property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupplyChainTradeTransactionType }
     *     
     */
    public void setSupplyChainTradeTransaction(
        @Nullable
        SupplyChainTradeTransactionType value) {
        this.supplyChainTradeTransaction = value;
    }

    /**
     * Gets the value of the valuationBreakdownStatement property.
     * 
     * @return
     *     possible object is
     *     {@link ValuationBreakdownStatementType }
     *     
     */
    @Nullable
    public ValuationBreakdownStatementType getValuationBreakdownStatement() {
        return valuationBreakdownStatement;
    }

    /**
     * Sets the value of the valuationBreakdownStatement property.
     * 
     * @param value
     *     allowed object is
     *     {@link ValuationBreakdownStatementType }
     *     
     */
    public void setValuationBreakdownStatement(
        @Nullable
        ValuationBreakdownStatementType value) {
        this.valuationBreakdownStatement = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final CrossIndustryInvoiceType rhs = ((CrossIndustryInvoiceType) o);
        if (!EqualsHelper.equals(exchangedDocument, rhs.exchangedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(exchangedDocumentContext, rhs.exchangedDocumentContext)) {
            return false;
        }
        if (!EqualsHelper.equals(supplyChainTradeTransaction, rhs.supplyChainTradeTransaction)) {
            return false;
        }
        if (!EqualsHelper.equals(valuationBreakdownStatement, rhs.valuationBreakdownStatement)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(exchangedDocument).append(exchangedDocumentContext).append(supplyChainTradeTransaction).append(valuationBreakdownStatement).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("exchangedDocument", exchangedDocument).append("exchangedDocumentContext", exchangedDocumentContext).append("supplyChainTradeTransaction", supplyChainTradeTransaction).append("valuationBreakdownStatement", valuationBreakdownStatement).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CrossIndustryInvoiceType ret) {
        ret.exchangedDocument = ((exchangedDocument == null)?null:exchangedDocument.clone());
        ret.exchangedDocumentContext = ((exchangedDocumentContext == null)?null:exchangedDocumentContext.clone());
        ret.supplyChainTradeTransaction = ((supplyChainTradeTransaction == null)?null:supplyChainTradeTransaction.clone());
        ret.valuationBreakdownStatement = ((valuationBreakdownStatement == null)?null:valuationBreakdownStatement.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CrossIndustryInvoiceType clone() {
        CrossIndustryInvoiceType ret = new CrossIndustryInvoiceType();
        cloneTo(ret);
        return ret;
    }

}
