
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.FormattedDateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;


/**
 * <p>Java class for AdvancePaymentType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="AdvancePaymentType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="PaidAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType"/>
 *         <element name="FormattedReceivedDateTime" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}FormattedDateTimeType" minOccurs="0"/>
 *         <element name="IncludedTradeTax" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeTaxType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AdvancePaymentType", propOrder = {
    "paidAmount",
    "formattedReceivedDateTime",
    "includedTradeTax"
})
@CodingStyleguideUnaware
public class AdvancePaymentType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "PaidAmount", required = true)
    private AmountType paidAmount;
    @XmlElement(name = "FormattedReceivedDateTime")
    private FormattedDateTimeType formattedReceivedDateTime;
    @XmlElement(name = "IncludedTradeTax")
    private List<TradeTaxType> includedTradeTax;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public AdvancePaymentType() {
    }

    /**
     * Gets the value of the paidAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getPaidAmount() {
        return paidAmount;
    }

    /**
     * Sets the value of the paidAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setPaidAmount(
        @Nullable
        AmountType value) {
        this.paidAmount = value;
    }

    /**
     * Gets the value of the formattedReceivedDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link FormattedDateTimeType }
     *     
     */
    @Nullable
    public FormattedDateTimeType getFormattedReceivedDateTime() {
        return formattedReceivedDateTime;
    }

    /**
     * Sets the value of the formattedReceivedDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link FormattedDateTimeType }
     *     
     */
    public void setFormattedReceivedDateTime(
        @Nullable
        FormattedDateTimeType value) {
        this.formattedReceivedDateTime = value;
    }

    /**
     * Gets the value of the includedTradeTax property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the includedTradeTax property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIncludedTradeTax().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeTaxType }
     * 
     * 
     * @return
     *     The value of the includedTradeTax property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeTaxType> getIncludedTradeTax() {
        if (includedTradeTax == null) {
            includedTradeTax = new ArrayList<>();
        }
        return this.includedTradeTax;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final AdvancePaymentType rhs = ((AdvancePaymentType) o);
        if (!EqualsHelper.equals(formattedReceivedDateTime, rhs.formattedReceivedDateTime)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(includedTradeTax, rhs.includedTradeTax)) {
            return false;
        }
        if (!EqualsHelper.equals(paidAmount, rhs.paidAmount)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(formattedReceivedDateTime).append(includedTradeTax).append(paidAmount).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("formattedReceivedDateTime", formattedReceivedDateTime).append("includedTradeTax", includedTradeTax).append("paidAmount", paidAmount).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setIncludedTradeTax(
        @Nullable
        final List<TradeTaxType> aList) {
        includedTradeTax = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIncludedTradeTaxEntries() {
        return (!getIncludedTradeTax().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIncludedTradeTaxEntries() {
        return getIncludedTradeTax().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIncludedTradeTaxCount() {
        return getIncludedTradeTax().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeTaxType getIncludedTradeTaxAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIncludedTradeTax().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addIncludedTradeTax(
        @Nonnull
        final TradeTaxType elem) {
        getIncludedTradeTax().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        AdvancePaymentType ret) {
        ret.formattedReceivedDateTime = ((formattedReceivedDateTime == null)?null:formattedReceivedDateTime.clone());
        if (includedTradeTax == null) {
            ret.includedTradeTax = null;
        } else {
            List<TradeTaxType> retIncludedTradeTax = new ArrayList<>();
            for (TradeTaxType aItem: getIncludedTradeTax()) {
                retIncludedTradeTax.add(((aItem == null)?null:aItem.clone()));
            }
            ret.includedTradeTax = retIncludedTradeTax;
        }
        ret.paidAmount = ((paidAmount == null)?null:paidAmount.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public AdvancePaymentType clone() {
        AdvancePaymentType ret = new AdvancePaymentType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setPaidAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getPaidAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setPaidAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPaidAmountValue() {
        AmountType aObj = getPaidAmount();
        return (aObj == null)?null:aObj.getValue();
    }

}
