
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IndicatorType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.PercentType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for AppliedAllowanceChargeType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="AppliedAllowanceChargeType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ActualAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" minOccurs="0"/>
 *         <element name="Description" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="ReasonCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="CalculationPercent" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}PercentType" minOccurs="0"/>
 *         <element name="BasisAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" minOccurs="0"/>
 *         <element name="ChargeIndicator" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IndicatorType"/>
 *         <element name="CategoryAppliedTax" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}AppliedTaxType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AppliedAllowanceChargeType", propOrder = {
    "actualAmount",
    "description",
    "reasonCode",
    "calculationPercent",
    "basisAmount",
    "chargeIndicator",
    "categoryAppliedTax"
})
@CodingStyleguideUnaware
public class AppliedAllowanceChargeType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ActualAmount")
    private AmountType actualAmount;
    @XmlElement(name = "Description")
    private TextType description;
    @XmlElement(name = "ReasonCode")
    private CodeType reasonCode;
    @XmlElement(name = "CalculationPercent")
    private PercentType calculationPercent;
    @XmlElement(name = "BasisAmount")
    private AmountType basisAmount;
    @XmlElement(name = "ChargeIndicator", required = true)
    private IndicatorType chargeIndicator;
    @XmlElement(name = "CategoryAppliedTax")
    private AppliedTaxType categoryAppliedTax;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public AppliedAllowanceChargeType() {
    }

    /**
     * Gets the value of the actualAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getActualAmount() {
        return actualAmount;
    }

    /**
     * Sets the value of the actualAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setActualAmount(
        @Nullable
        AmountType value) {
        this.actualAmount = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setDescription(
        @Nullable
        TextType value) {
        this.description = value;
    }

    /**
     * Gets the value of the reasonCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getReasonCode() {
        return reasonCode;
    }

    /**
     * Sets the value of the reasonCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setReasonCode(
        @Nullable
        CodeType value) {
        this.reasonCode = value;
    }

    /**
     * Gets the value of the calculationPercent property.
     * 
     * @return
     *     possible object is
     *     {@link PercentType }
     *     
     */
    @Nullable
    public PercentType getCalculationPercent() {
        return calculationPercent;
    }

    /**
     * Sets the value of the calculationPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link PercentType }
     *     
     */
    public void setCalculationPercent(
        @Nullable
        PercentType value) {
        this.calculationPercent = value;
    }

    /**
     * Gets the value of the basisAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getBasisAmount() {
        return basisAmount;
    }

    /**
     * Sets the value of the basisAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setBasisAmount(
        @Nullable
        AmountType value) {
        this.basisAmount = value;
    }

    /**
     * Gets the value of the chargeIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link IndicatorType }
     *     
     */
    @Nullable
    public IndicatorType getChargeIndicator() {
        return chargeIndicator;
    }

    /**
     * Sets the value of the chargeIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link IndicatorType }
     *     
     */
    public void setChargeIndicator(
        @Nullable
        IndicatorType value) {
        this.chargeIndicator = value;
    }

    /**
     * Gets the value of the categoryAppliedTax property.
     * 
     * @return
     *     possible object is
     *     {@link AppliedTaxType }
     *     
     */
    @Nullable
    public AppliedTaxType getCategoryAppliedTax() {
        return categoryAppliedTax;
    }

    /**
     * Sets the value of the categoryAppliedTax property.
     * 
     * @param value
     *     allowed object is
     *     {@link AppliedTaxType }
     *     
     */
    public void setCategoryAppliedTax(
        @Nullable
        AppliedTaxType value) {
        this.categoryAppliedTax = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final AppliedAllowanceChargeType rhs = ((AppliedAllowanceChargeType) o);
        if (!EqualsHelper.equals(actualAmount, rhs.actualAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(basisAmount, rhs.basisAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(calculationPercent, rhs.calculationPercent)) {
            return false;
        }
        if (!EqualsHelper.equals(categoryAppliedTax, rhs.categoryAppliedTax)) {
            return false;
        }
        if (!EqualsHelper.equals(chargeIndicator, rhs.chargeIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(reasonCode, rhs.reasonCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(actualAmount).append(basisAmount).append(calculationPercent).append(categoryAppliedTax).append(chargeIndicator).append(description).append(reasonCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("actualAmount", actualAmount).append("basisAmount", basisAmount).append("calculationPercent", calculationPercent).append("categoryAppliedTax", categoryAppliedTax).append("chargeIndicator", chargeIndicator).append("description", description).append("reasonCode", reasonCode).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        AppliedAllowanceChargeType ret) {
        ret.actualAmount = ((actualAmount == null)?null:actualAmount.clone());
        ret.basisAmount = ((basisAmount == null)?null:basisAmount.clone());
        ret.calculationPercent = ((calculationPercent == null)?null:calculationPercent.clone());
        ret.categoryAppliedTax = ((categoryAppliedTax == null)?null:categoryAppliedTax.clone());
        ret.chargeIndicator = ((chargeIndicator == null)?null:chargeIndicator.clone());
        ret.description = ((description == null)?null:description.clone());
        ret.reasonCode = ((reasonCode == null)?null:reasonCode.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public AppliedAllowanceChargeType clone() {
        AppliedAllowanceChargeType ret = new AppliedAllowanceChargeType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setActualAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getActualAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setActualAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setDescription(
        @Nullable
        final String valueParam) {
        TextType aObj = getDescription();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setDescription(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setReasonCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getReasonCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setReasonCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PercentType and never <code>null</code>
     */
    @Nonnull
    public PercentType setCalculationPercent(
        @Nullable
        final BigDecimal valueParam) {
        PercentType aObj = getCalculationPercent();
        if (aObj == null) {
            aObj = new PercentType(valueParam);
            setCalculationPercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setBasisAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getBasisAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setBasisAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getActualAmountValue() {
        AmountType aObj = getActualAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getDescriptionValue() {
        TextType aObj = getDescription();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getReasonCodeValue() {
        CodeType aObj = getReasonCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getCalculationPercentValue() {
        PercentType aObj = getCalculationPercent();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getBasisAmountValue() {
        AmountType aObj = getBasisAmount();
        return (aObj == null)?null:aObj.getValue();
    }

}
