
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.BinaryObjectType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.ValueType;


/**
 * <p>Java class for BasicWorkItemType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="BasicWorkItemType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType"/>
 *         <element name="ReferenceID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="PrimaryClassificationCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="AlternativeClassificationCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="Comment" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TotalQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="TotalQuantityClassificationCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="IndexValue" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}ValueType" minOccurs="0"/>
 *         <element name="StatusCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ReferenceFileBinaryObject" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}BinaryObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="Index" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="RequestedActionCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="PriceListItemID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="ContractualLanguageCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="ActualWorkItemComplexDescription" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}WorkItemComplexDescriptionType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TotalQuantityWorkItemQuantityAnalysis" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}WorkItemQuantityAnalysisType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="UnitCalculatedPrice" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}CalculatedPriceType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TotalCalculatedPrice" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}CalculatedPriceType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="SubordinateBasicWorkItem" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}BasicWorkItemType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ChangedRecordedStatus" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}RecordedStatusType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ItemBasicWorkItem" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}BasicWorkItemType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ReferencedSpecifiedBinaryFile" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpecifiedBinaryFileType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BasicWorkItemType", propOrder = {
    "id",
    "referenceID",
    "primaryClassificationCode",
    "alternativeClassificationCode",
    "typeCode",
    "comment",
    "totalQuantity",
    "totalQuantityClassificationCode",
    "indexValue",
    "statusCode",
    "referenceFileBinaryObject",
    "index",
    "requestedActionCode",
    "priceListItemID",
    "contractualLanguageCode",
    "actualWorkItemComplexDescription",
    "totalQuantityWorkItemQuantityAnalysis",
    "unitCalculatedPrice",
    "totalCalculatedPrice",
    "subordinateBasicWorkItem",
    "changedRecordedStatus",
    "itemBasicWorkItem",
    "referencedSpecifiedBinaryFile"
})
@CodingStyleguideUnaware
public class BasicWorkItemType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID", required = true)
    private IDType id;
    @XmlElement(name = "ReferenceID")
    private IDType referenceID;
    @XmlElement(name = "PrimaryClassificationCode")
    private List<CodeType> primaryClassificationCode;
    @XmlElement(name = "AlternativeClassificationCode")
    private List<CodeType> alternativeClassificationCode;
    @XmlElement(name = "TypeCode")
    private List<CodeType> typeCode;
    @XmlElement(name = "Comment")
    private List<TextType> comment;
    @XmlElement(name = "TotalQuantity")
    private QuantityType totalQuantity;
    @XmlElement(name = "TotalQuantityClassificationCode")
    private CodeType totalQuantityClassificationCode;
    @XmlElement(name = "IndexValue")
    private ValueType indexValue;
    @XmlElement(name = "StatusCode")
    private List<CodeType> statusCode;
    @XmlElement(name = "ReferenceFileBinaryObject")
    private List<BinaryObjectType> referenceFileBinaryObject;
    @XmlElement(name = "Index")
    private TextType index;
    @XmlElement(name = "RequestedActionCode")
    private List<CodeType> requestedActionCode;
    @XmlElement(name = "PriceListItemID")
    private IDType priceListItemID;
    @XmlElement(name = "ContractualLanguageCode")
    private CodeType contractualLanguageCode;
    @XmlElement(name = "ActualWorkItemComplexDescription")
    private List<WorkItemComplexDescriptionType> actualWorkItemComplexDescription;
    @XmlElement(name = "TotalQuantityWorkItemQuantityAnalysis")
    private List<WorkItemQuantityAnalysisType> totalQuantityWorkItemQuantityAnalysis;
    @XmlElement(name = "UnitCalculatedPrice")
    private List<CalculatedPriceType> unitCalculatedPrice;
    @XmlElement(name = "TotalCalculatedPrice")
    private List<CalculatedPriceType> totalCalculatedPrice;
    @XmlElement(name = "SubordinateBasicWorkItem")
    private List<BasicWorkItemType> subordinateBasicWorkItem;
    @XmlElement(name = "ChangedRecordedStatus")
    private List<RecordedStatusType> changedRecordedStatus;
    @XmlElement(name = "ItemBasicWorkItem")
    private List<BasicWorkItemType> itemBasicWorkItem;
    @XmlElement(name = "ReferencedSpecifiedBinaryFile")
    private List<SpecifiedBinaryFileType> referencedSpecifiedBinaryFile;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public BasicWorkItemType() {
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the referenceID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getReferenceID() {
        return referenceID;
    }

    /**
     * Sets the value of the referenceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setReferenceID(
        @Nullable
        IDType value) {
        this.referenceID = value;
    }

    /**
     * Gets the value of the primaryClassificationCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the primaryClassificationCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPrimaryClassificationCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the primaryClassificationCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getPrimaryClassificationCode() {
        if (primaryClassificationCode == null) {
            primaryClassificationCode = new ArrayList<>();
        }
        return this.primaryClassificationCode;
    }

    /**
     * Gets the value of the alternativeClassificationCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the alternativeClassificationCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAlternativeClassificationCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the alternativeClassificationCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getAlternativeClassificationCode() {
        if (alternativeClassificationCode == null) {
            alternativeClassificationCode = new ArrayList<>();
        }
        return this.alternativeClassificationCode;
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the typeCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTypeCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the typeCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getTypeCode() {
        if (typeCode == null) {
            typeCode = new ArrayList<>();
        }
        return this.typeCode;
    }

    /**
     * Gets the value of the comment property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the comment property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getComment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the comment property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getComment() {
        if (comment == null) {
            comment = new ArrayList<>();
        }
        return this.comment;
    }

    /**
     * Gets the value of the totalQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getTotalQuantity() {
        return totalQuantity;
    }

    /**
     * Sets the value of the totalQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setTotalQuantity(
        @Nullable
        QuantityType value) {
        this.totalQuantity = value;
    }

    /**
     * Gets the value of the totalQuantityClassificationCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getTotalQuantityClassificationCode() {
        return totalQuantityClassificationCode;
    }

    /**
     * Sets the value of the totalQuantityClassificationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setTotalQuantityClassificationCode(
        @Nullable
        CodeType value) {
        this.totalQuantityClassificationCode = value;
    }

    /**
     * Gets the value of the indexValue property.
     * 
     * @return
     *     possible object is
     *     {@link ValueType }
     *     
     */
    @Nullable
    public ValueType getIndexValue() {
        return indexValue;
    }

    /**
     * Sets the value of the indexValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link ValueType }
     *     
     */
    public void setIndexValue(
        @Nullable
        ValueType value) {
        this.indexValue = value;
    }

    /**
     * Gets the value of the statusCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the statusCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getStatusCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the statusCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getStatusCode() {
        if (statusCode == null) {
            statusCode = new ArrayList<>();
        }
        return this.statusCode;
    }

    /**
     * Gets the value of the referenceFileBinaryObject property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the referenceFileBinaryObject property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReferenceFileBinaryObject().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BinaryObjectType }
     * 
     * 
     * @return
     *     The value of the referenceFileBinaryObject property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<BinaryObjectType> getReferenceFileBinaryObject() {
        if (referenceFileBinaryObject == null) {
            referenceFileBinaryObject = new ArrayList<>();
        }
        return this.referenceFileBinaryObject;
    }

    /**
     * Gets the value of the index property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getIndex() {
        return index;
    }

    /**
     * Sets the value of the index property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setIndex(
        @Nullable
        TextType value) {
        this.index = value;
    }

    /**
     * Gets the value of the requestedActionCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the requestedActionCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRequestedActionCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the requestedActionCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getRequestedActionCode() {
        if (requestedActionCode == null) {
            requestedActionCode = new ArrayList<>();
        }
        return this.requestedActionCode;
    }

    /**
     * Gets the value of the priceListItemID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getPriceListItemID() {
        return priceListItemID;
    }

    /**
     * Sets the value of the priceListItemID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setPriceListItemID(
        @Nullable
        IDType value) {
        this.priceListItemID = value;
    }

    /**
     * Gets the value of the contractualLanguageCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getContractualLanguageCode() {
        return contractualLanguageCode;
    }

    /**
     * Sets the value of the contractualLanguageCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setContractualLanguageCode(
        @Nullable
        CodeType value) {
        this.contractualLanguageCode = value;
    }

    /**
     * Gets the value of the actualWorkItemComplexDescription property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the actualWorkItemComplexDescription property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getActualWorkItemComplexDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkItemComplexDescriptionType }
     * 
     * 
     * @return
     *     The value of the actualWorkItemComplexDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<WorkItemComplexDescriptionType> getActualWorkItemComplexDescription() {
        if (actualWorkItemComplexDescription == null) {
            actualWorkItemComplexDescription = new ArrayList<>();
        }
        return this.actualWorkItemComplexDescription;
    }

    /**
     * Gets the value of the totalQuantityWorkItemQuantityAnalysis property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the totalQuantityWorkItemQuantityAnalysis property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTotalQuantityWorkItemQuantityAnalysis().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkItemQuantityAnalysisType }
     * 
     * 
     * @return
     *     The value of the totalQuantityWorkItemQuantityAnalysis property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<WorkItemQuantityAnalysisType> getTotalQuantityWorkItemQuantityAnalysis() {
        if (totalQuantityWorkItemQuantityAnalysis == null) {
            totalQuantityWorkItemQuantityAnalysis = new ArrayList<>();
        }
        return this.totalQuantityWorkItemQuantityAnalysis;
    }

    /**
     * Gets the value of the unitCalculatedPrice property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the unitCalculatedPrice property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getUnitCalculatedPrice().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CalculatedPriceType }
     * 
     * 
     * @return
     *     The value of the unitCalculatedPrice property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CalculatedPriceType> getUnitCalculatedPrice() {
        if (unitCalculatedPrice == null) {
            unitCalculatedPrice = new ArrayList<>();
        }
        return this.unitCalculatedPrice;
    }

    /**
     * Gets the value of the totalCalculatedPrice property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the totalCalculatedPrice property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTotalCalculatedPrice().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CalculatedPriceType }
     * 
     * 
     * @return
     *     The value of the totalCalculatedPrice property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CalculatedPriceType> getTotalCalculatedPrice() {
        if (totalCalculatedPrice == null) {
            totalCalculatedPrice = new ArrayList<>();
        }
        return this.totalCalculatedPrice;
    }

    /**
     * Gets the value of the subordinateBasicWorkItem property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the subordinateBasicWorkItem property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSubordinateBasicWorkItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BasicWorkItemType }
     * 
     * 
     * @return
     *     The value of the subordinateBasicWorkItem property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<BasicWorkItemType> getSubordinateBasicWorkItem() {
        if (subordinateBasicWorkItem == null) {
            subordinateBasicWorkItem = new ArrayList<>();
        }
        return this.subordinateBasicWorkItem;
    }

    /**
     * Gets the value of the changedRecordedStatus property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the changedRecordedStatus property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getChangedRecordedStatus().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RecordedStatusType }
     * 
     * 
     * @return
     *     The value of the changedRecordedStatus property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RecordedStatusType> getChangedRecordedStatus() {
        if (changedRecordedStatus == null) {
            changedRecordedStatus = new ArrayList<>();
        }
        return this.changedRecordedStatus;
    }

    /**
     * Gets the value of the itemBasicWorkItem property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the itemBasicWorkItem property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getItemBasicWorkItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BasicWorkItemType }
     * 
     * 
     * @return
     *     The value of the itemBasicWorkItem property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<BasicWorkItemType> getItemBasicWorkItem() {
        if (itemBasicWorkItem == null) {
            itemBasicWorkItem = new ArrayList<>();
        }
        return this.itemBasicWorkItem;
    }

    /**
     * Gets the value of the referencedSpecifiedBinaryFile property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the referencedSpecifiedBinaryFile property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReferencedSpecifiedBinaryFile().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SpecifiedBinaryFileType }
     * 
     * 
     * @return
     *     The value of the referencedSpecifiedBinaryFile property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SpecifiedBinaryFileType> getReferencedSpecifiedBinaryFile() {
        if (referencedSpecifiedBinaryFile == null) {
            referencedSpecifiedBinaryFile = new ArrayList<>();
        }
        return this.referencedSpecifiedBinaryFile;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final BasicWorkItemType rhs = ((BasicWorkItemType) o);
        if (!EqualsHelper.equalsCollection(actualWorkItemComplexDescription, rhs.actualWorkItemComplexDescription)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(alternativeClassificationCode, rhs.alternativeClassificationCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(changedRecordedStatus, rhs.changedRecordedStatus)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(comment, rhs.comment)) {
            return false;
        }
        if (!EqualsHelper.equals(contractualLanguageCode, rhs.contractualLanguageCode)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(index, rhs.index)) {
            return false;
        }
        if (!EqualsHelper.equals(indexValue, rhs.indexValue)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(itemBasicWorkItem, rhs.itemBasicWorkItem)) {
            return false;
        }
        if (!EqualsHelper.equals(priceListItemID, rhs.priceListItemID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(primaryClassificationCode, rhs.primaryClassificationCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(referenceFileBinaryObject, rhs.referenceFileBinaryObject)) {
            return false;
        }
        if (!EqualsHelper.equals(referenceID, rhs.referenceID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(referencedSpecifiedBinaryFile, rhs.referencedSpecifiedBinaryFile)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(requestedActionCode, rhs.requestedActionCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(statusCode, rhs.statusCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(subordinateBasicWorkItem, rhs.subordinateBasicWorkItem)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(totalCalculatedPrice, rhs.totalCalculatedPrice)) {
            return false;
        }
        if (!EqualsHelper.equals(totalQuantity, rhs.totalQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(totalQuantityClassificationCode, rhs.totalQuantityClassificationCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(totalQuantityWorkItemQuantityAnalysis, rhs.totalQuantityWorkItemQuantityAnalysis)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(typeCode, rhs.typeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(unitCalculatedPrice, rhs.unitCalculatedPrice)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(actualWorkItemComplexDescription).append(alternativeClassificationCode).append(changedRecordedStatus).append(comment).append(contractualLanguageCode).append(id).append(index).append(indexValue).append(itemBasicWorkItem).append(priceListItemID).append(primaryClassificationCode).append(referenceFileBinaryObject).append(referenceID).append(referencedSpecifiedBinaryFile).append(requestedActionCode).append(statusCode).append(subordinateBasicWorkItem).append(totalCalculatedPrice).append(totalQuantity).append(totalQuantityClassificationCode).append(totalQuantityWorkItemQuantityAnalysis).append(typeCode).append(unitCalculatedPrice).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("actualWorkItemComplexDescription", actualWorkItemComplexDescription).append("alternativeClassificationCode", alternativeClassificationCode).append("changedRecordedStatus", changedRecordedStatus).append("comment", comment).append("contractualLanguageCode", contractualLanguageCode).append("id", id).append("index", index).append("indexValue", indexValue).append("itemBasicWorkItem", itemBasicWorkItem).append("priceListItemID", priceListItemID).append("primaryClassificationCode", primaryClassificationCode).append("referenceFileBinaryObject", referenceFileBinaryObject).append("referenceID", referenceID).append("referencedSpecifiedBinaryFile", referencedSpecifiedBinaryFile).append("requestedActionCode", requestedActionCode).append("statusCode", statusCode).append("subordinateBasicWorkItem", subordinateBasicWorkItem).append("totalCalculatedPrice", totalCalculatedPrice).append("totalQuantity", totalQuantity).append("totalQuantityClassificationCode", totalQuantityClassificationCode).append("totalQuantityWorkItemQuantityAnalysis", totalQuantityWorkItemQuantityAnalysis).append("typeCode", typeCode).append("unitCalculatedPrice", unitCalculatedPrice).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPrimaryClassificationCode(
        @Nullable
        final List<CodeType> aList) {
        primaryClassificationCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAlternativeClassificationCode(
        @Nullable
        final List<CodeType> aList) {
        alternativeClassificationCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTypeCode(
        @Nullable
        final List<CodeType> aList) {
        typeCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setComment(
        @Nullable
        final List<TextType> aList) {
        comment = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setStatusCode(
        @Nullable
        final List<CodeType> aList) {
        statusCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setReferenceFileBinaryObject(
        @Nullable
        final List<BinaryObjectType> aList) {
        referenceFileBinaryObject = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRequestedActionCode(
        @Nullable
        final List<CodeType> aList) {
        requestedActionCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setActualWorkItemComplexDescription(
        @Nullable
        final List<WorkItemComplexDescriptionType> aList) {
        actualWorkItemComplexDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTotalQuantityWorkItemQuantityAnalysis(
        @Nullable
        final List<WorkItemQuantityAnalysisType> aList) {
        totalQuantityWorkItemQuantityAnalysis = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setUnitCalculatedPrice(
        @Nullable
        final List<CalculatedPriceType> aList) {
        unitCalculatedPrice = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTotalCalculatedPrice(
        @Nullable
        final List<CalculatedPriceType> aList) {
        totalCalculatedPrice = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSubordinateBasicWorkItem(
        @Nullable
        final List<BasicWorkItemType> aList) {
        subordinateBasicWorkItem = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setChangedRecordedStatus(
        @Nullable
        final List<RecordedStatusType> aList) {
        changedRecordedStatus = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setItemBasicWorkItem(
        @Nullable
        final List<BasicWorkItemType> aList) {
        itemBasicWorkItem = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setReferencedSpecifiedBinaryFile(
        @Nullable
        final List<SpecifiedBinaryFileType> aList) {
        referencedSpecifiedBinaryFile = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPrimaryClassificationCodeEntries() {
        return (!getPrimaryClassificationCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPrimaryClassificationCodeEntries() {
        return getPrimaryClassificationCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPrimaryClassificationCodeCount() {
        return getPrimaryClassificationCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getPrimaryClassificationCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPrimaryClassificationCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPrimaryClassificationCode(
        @Nonnull
        final CodeType elem) {
        getPrimaryClassificationCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAlternativeClassificationCodeEntries() {
        return (!getAlternativeClassificationCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAlternativeClassificationCodeEntries() {
        return getAlternativeClassificationCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAlternativeClassificationCodeCount() {
        return getAlternativeClassificationCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getAlternativeClassificationCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAlternativeClassificationCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAlternativeClassificationCode(
        @Nonnull
        final CodeType elem) {
        getAlternativeClassificationCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTypeCodeEntries() {
        return (!getTypeCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTypeCodeEntries() {
        return getTypeCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTypeCodeCount() {
        return getTypeCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getTypeCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTypeCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTypeCode(
        @Nonnull
        final CodeType elem) {
        getTypeCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCommentEntries() {
        return (!getComment().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCommentEntries() {
        return getComment().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCommentCount() {
        return getComment().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getCommentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getComment().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addComment(
        @Nonnull
        final TextType elem) {
        getComment().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasStatusCodeEntries() {
        return (!getStatusCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoStatusCodeEntries() {
        return getStatusCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getStatusCodeCount() {
        return getStatusCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getStatusCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getStatusCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addStatusCode(
        @Nonnull
        final CodeType elem) {
        getStatusCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasReferenceFileBinaryObjectEntries() {
        return (!getReferenceFileBinaryObject().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoReferenceFileBinaryObjectEntries() {
        return getReferenceFileBinaryObject().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getReferenceFileBinaryObjectCount() {
        return getReferenceFileBinaryObject().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public BinaryObjectType getReferenceFileBinaryObjectAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getReferenceFileBinaryObject().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addReferenceFileBinaryObject(
        @Nonnull
        final BinaryObjectType elem) {
        getReferenceFileBinaryObject().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRequestedActionCodeEntries() {
        return (!getRequestedActionCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRequestedActionCodeEntries() {
        return getRequestedActionCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRequestedActionCodeCount() {
        return getRequestedActionCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getRequestedActionCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRequestedActionCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRequestedActionCode(
        @Nonnull
        final CodeType elem) {
        getRequestedActionCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasActualWorkItemComplexDescriptionEntries() {
        return (!getActualWorkItemComplexDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoActualWorkItemComplexDescriptionEntries() {
        return getActualWorkItemComplexDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getActualWorkItemComplexDescriptionCount() {
        return getActualWorkItemComplexDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public WorkItemComplexDescriptionType getActualWorkItemComplexDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getActualWorkItemComplexDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addActualWorkItemComplexDescription(
        @Nonnull
        final WorkItemComplexDescriptionType elem) {
        getActualWorkItemComplexDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTotalQuantityWorkItemQuantityAnalysisEntries() {
        return (!getTotalQuantityWorkItemQuantityAnalysis().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTotalQuantityWorkItemQuantityAnalysisEntries() {
        return getTotalQuantityWorkItemQuantityAnalysis().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTotalQuantityWorkItemQuantityAnalysisCount() {
        return getTotalQuantityWorkItemQuantityAnalysis().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public WorkItemQuantityAnalysisType getTotalQuantityWorkItemQuantityAnalysisAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTotalQuantityWorkItemQuantityAnalysis().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTotalQuantityWorkItemQuantityAnalysis(
        @Nonnull
        final WorkItemQuantityAnalysisType elem) {
        getTotalQuantityWorkItemQuantityAnalysis().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasUnitCalculatedPriceEntries() {
        return (!getUnitCalculatedPrice().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoUnitCalculatedPriceEntries() {
        return getUnitCalculatedPrice().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getUnitCalculatedPriceCount() {
        return getUnitCalculatedPrice().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CalculatedPriceType getUnitCalculatedPriceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getUnitCalculatedPrice().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addUnitCalculatedPrice(
        @Nonnull
        final CalculatedPriceType elem) {
        getUnitCalculatedPrice().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTotalCalculatedPriceEntries() {
        return (!getTotalCalculatedPrice().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTotalCalculatedPriceEntries() {
        return getTotalCalculatedPrice().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTotalCalculatedPriceCount() {
        return getTotalCalculatedPrice().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CalculatedPriceType getTotalCalculatedPriceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTotalCalculatedPrice().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTotalCalculatedPrice(
        @Nonnull
        final CalculatedPriceType elem) {
        getTotalCalculatedPrice().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSubordinateBasicWorkItemEntries() {
        return (!getSubordinateBasicWorkItem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSubordinateBasicWorkItemEntries() {
        return getSubordinateBasicWorkItem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSubordinateBasicWorkItemCount() {
        return getSubordinateBasicWorkItem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public BasicWorkItemType getSubordinateBasicWorkItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSubordinateBasicWorkItem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSubordinateBasicWorkItem(
        @Nonnull
        final BasicWorkItemType elem) {
        getSubordinateBasicWorkItem().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasChangedRecordedStatusEntries() {
        return (!getChangedRecordedStatus().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoChangedRecordedStatusEntries() {
        return getChangedRecordedStatus().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getChangedRecordedStatusCount() {
        return getChangedRecordedStatus().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RecordedStatusType getChangedRecordedStatusAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getChangedRecordedStatus().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addChangedRecordedStatus(
        @Nonnull
        final RecordedStatusType elem) {
        getChangedRecordedStatus().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasItemBasicWorkItemEntries() {
        return (!getItemBasicWorkItem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoItemBasicWorkItemEntries() {
        return getItemBasicWorkItem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getItemBasicWorkItemCount() {
        return getItemBasicWorkItem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public BasicWorkItemType getItemBasicWorkItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getItemBasicWorkItem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addItemBasicWorkItem(
        @Nonnull
        final BasicWorkItemType elem) {
        getItemBasicWorkItem().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasReferencedSpecifiedBinaryFileEntries() {
        return (!getReferencedSpecifiedBinaryFile().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoReferencedSpecifiedBinaryFileEntries() {
        return getReferencedSpecifiedBinaryFile().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getReferencedSpecifiedBinaryFileCount() {
        return getReferencedSpecifiedBinaryFile().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SpecifiedBinaryFileType getReferencedSpecifiedBinaryFileAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getReferencedSpecifiedBinaryFile().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addReferencedSpecifiedBinaryFile(
        @Nonnull
        final SpecifiedBinaryFileType elem) {
        getReferencedSpecifiedBinaryFile().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        BasicWorkItemType ret) {
        if (actualWorkItemComplexDescription == null) {
            ret.actualWorkItemComplexDescription = null;
        } else {
            List<WorkItemComplexDescriptionType> retActualWorkItemComplexDescription = new ArrayList<>();
            for (WorkItemComplexDescriptionType aItem: getActualWorkItemComplexDescription()) {
                retActualWorkItemComplexDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.actualWorkItemComplexDescription = retActualWorkItemComplexDescription;
        }
        if (alternativeClassificationCode == null) {
            ret.alternativeClassificationCode = null;
        } else {
            List<CodeType> retAlternativeClassificationCode = new ArrayList<>();
            for (CodeType aItem: getAlternativeClassificationCode()) {
                retAlternativeClassificationCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.alternativeClassificationCode = retAlternativeClassificationCode;
        }
        if (changedRecordedStatus == null) {
            ret.changedRecordedStatus = null;
        } else {
            List<RecordedStatusType> retChangedRecordedStatus = new ArrayList<>();
            for (RecordedStatusType aItem: getChangedRecordedStatus()) {
                retChangedRecordedStatus.add(((aItem == null)?null:aItem.clone()));
            }
            ret.changedRecordedStatus = retChangedRecordedStatus;
        }
        if (comment == null) {
            ret.comment = null;
        } else {
            List<TextType> retComment = new ArrayList<>();
            for (TextType aItem: getComment()) {
                retComment.add(((aItem == null)?null:aItem.clone()));
            }
            ret.comment = retComment;
        }
        ret.contractualLanguageCode = ((contractualLanguageCode == null)?null:contractualLanguageCode.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.index = ((index == null)?null:index.clone());
        ret.indexValue = ((indexValue == null)?null:indexValue.clone());
        if (itemBasicWorkItem == null) {
            ret.itemBasicWorkItem = null;
        } else {
            List<BasicWorkItemType> retItemBasicWorkItem = new ArrayList<>();
            for (BasicWorkItemType aItem: getItemBasicWorkItem()) {
                retItemBasicWorkItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.itemBasicWorkItem = retItemBasicWorkItem;
        }
        ret.priceListItemID = ((priceListItemID == null)?null:priceListItemID.clone());
        if (primaryClassificationCode == null) {
            ret.primaryClassificationCode = null;
        } else {
            List<CodeType> retPrimaryClassificationCode = new ArrayList<>();
            for (CodeType aItem: getPrimaryClassificationCode()) {
                retPrimaryClassificationCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.primaryClassificationCode = retPrimaryClassificationCode;
        }
        if (referenceFileBinaryObject == null) {
            ret.referenceFileBinaryObject = null;
        } else {
            List<BinaryObjectType> retReferenceFileBinaryObject = new ArrayList<>();
            for (BinaryObjectType aItem: getReferenceFileBinaryObject()) {
                retReferenceFileBinaryObject.add(((aItem == null)?null:aItem.clone()));
            }
            ret.referenceFileBinaryObject = retReferenceFileBinaryObject;
        }
        ret.referenceID = ((referenceID == null)?null:referenceID.clone());
        if (referencedSpecifiedBinaryFile == null) {
            ret.referencedSpecifiedBinaryFile = null;
        } else {
            List<SpecifiedBinaryFileType> retReferencedSpecifiedBinaryFile = new ArrayList<>();
            for (SpecifiedBinaryFileType aItem: getReferencedSpecifiedBinaryFile()) {
                retReferencedSpecifiedBinaryFile.add(((aItem == null)?null:aItem.clone()));
            }
            ret.referencedSpecifiedBinaryFile = retReferencedSpecifiedBinaryFile;
        }
        if (requestedActionCode == null) {
            ret.requestedActionCode = null;
        } else {
            List<CodeType> retRequestedActionCode = new ArrayList<>();
            for (CodeType aItem: getRequestedActionCode()) {
                retRequestedActionCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.requestedActionCode = retRequestedActionCode;
        }
        if (statusCode == null) {
            ret.statusCode = null;
        } else {
            List<CodeType> retStatusCode = new ArrayList<>();
            for (CodeType aItem: getStatusCode()) {
                retStatusCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.statusCode = retStatusCode;
        }
        if (subordinateBasicWorkItem == null) {
            ret.subordinateBasicWorkItem = null;
        } else {
            List<BasicWorkItemType> retSubordinateBasicWorkItem = new ArrayList<>();
            for (BasicWorkItemType aItem: getSubordinateBasicWorkItem()) {
                retSubordinateBasicWorkItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.subordinateBasicWorkItem = retSubordinateBasicWorkItem;
        }
        if (totalCalculatedPrice == null) {
            ret.totalCalculatedPrice = null;
        } else {
            List<CalculatedPriceType> retTotalCalculatedPrice = new ArrayList<>();
            for (CalculatedPriceType aItem: getTotalCalculatedPrice()) {
                retTotalCalculatedPrice.add(((aItem == null)?null:aItem.clone()));
            }
            ret.totalCalculatedPrice = retTotalCalculatedPrice;
        }
        ret.totalQuantity = ((totalQuantity == null)?null:totalQuantity.clone());
        ret.totalQuantityClassificationCode = ((totalQuantityClassificationCode == null)?null:totalQuantityClassificationCode.clone());
        if (totalQuantityWorkItemQuantityAnalysis == null) {
            ret.totalQuantityWorkItemQuantityAnalysis = null;
        } else {
            List<WorkItemQuantityAnalysisType> retTotalQuantityWorkItemQuantityAnalysis = new ArrayList<>();
            for (WorkItemQuantityAnalysisType aItem: getTotalQuantityWorkItemQuantityAnalysis()) {
                retTotalQuantityWorkItemQuantityAnalysis.add(((aItem == null)?null:aItem.clone()));
            }
            ret.totalQuantityWorkItemQuantityAnalysis = retTotalQuantityWorkItemQuantityAnalysis;
        }
        if (typeCode == null) {
            ret.typeCode = null;
        } else {
            List<CodeType> retTypeCode = new ArrayList<>();
            for (CodeType aItem: getTypeCode()) {
                retTypeCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.typeCode = retTypeCode;
        }
        if (unitCalculatedPrice == null) {
            ret.unitCalculatedPrice = null;
        } else {
            List<CalculatedPriceType> retUnitCalculatedPrice = new ArrayList<>();
            for (CalculatedPriceType aItem: getUnitCalculatedPrice()) {
                retUnitCalculatedPrice.add(((aItem == null)?null:aItem.clone()));
            }
            ret.unitCalculatedPrice = retUnitCalculatedPrice;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public BasicWorkItemType clone() {
        BasicWorkItemType ret = new BasicWorkItemType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setReferenceID(
        @Nullable
        final String valueParam) {
        IDType aObj = getReferenceID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setReferenceID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setTotalQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getTotalQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setTotalQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setTotalQuantityClassificationCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getTotalQuantityClassificationCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setTotalQuantityClassificationCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ValueType and never <code>null</code>
     */
    @Nonnull
    public ValueType setIndexValue(
        @Nullable
        final BigDecimal valueParam) {
        ValueType aObj = getIndexValue();
        if (aObj == null) {
            aObj = new ValueType(valueParam);
            setIndexValue(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setIndex(
        @Nullable
        final String valueParam) {
        TextType aObj = getIndex();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setIndex(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setPriceListItemID(
        @Nullable
        final String valueParam) {
        IDType aObj = getPriceListItemID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setPriceListItemID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setContractualLanguageCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getContractualLanguageCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setContractualLanguageCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getReferenceIDValue() {
        IDType aObj = getReferenceID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTotalQuantityValue() {
        QuantityType aObj = getTotalQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getTotalQuantityClassificationCodeValue() {
        CodeType aObj = getTotalQuantityClassificationCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ValueType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ValueType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getIndexValueValue() {
        ValueType aObj = getIndexValue();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getPriceListItemIDValue() {
        IDType aObj = getPriceListItemID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getContractualLanguageCodeValue() {
        CodeType aObj = getContractualLanguageCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
