
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.LineStatusCodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;


/**
 * <p>Java class for DocumentLineDocumentType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="DocumentLineDocumentType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="LineID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="ParentLineID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="LineStatusCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}LineStatusCodeType" minOccurs="0"/>
 *         <element name="LineStatusReasonCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="IncludedNote" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}NoteType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DocumentLineDocumentType", propOrder = {
    "lineID",
    "parentLineID",
    "lineStatusCode",
    "lineStatusReasonCode",
    "includedNote"
})
@CodingStyleguideUnaware
public class DocumentLineDocumentType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "LineID")
    private IDType lineID;
    @XmlElement(name = "ParentLineID")
    private IDType parentLineID;
    @XmlElement(name = "LineStatusCode")
    private LineStatusCodeType lineStatusCode;
    @XmlElement(name = "LineStatusReasonCode")
    private CodeType lineStatusReasonCode;
    @XmlElement(name = "IncludedNote")
    private List<NoteType> includedNote;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public DocumentLineDocumentType() {
    }

    /**
     * Gets the value of the lineID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getLineID() {
        return lineID;
    }

    /**
     * Sets the value of the lineID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setLineID(
        @Nullable
        IDType value) {
        this.lineID = value;
    }

    /**
     * Gets the value of the parentLineID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getParentLineID() {
        return parentLineID;
    }

    /**
     * Sets the value of the parentLineID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setParentLineID(
        @Nullable
        IDType value) {
        this.parentLineID = value;
    }

    /**
     * Gets the value of the lineStatusCode property.
     * 
     * @return
     *     possible object is
     *     {@link LineStatusCodeType }
     *     
     */
    @Nullable
    public LineStatusCodeType getLineStatusCode() {
        return lineStatusCode;
    }

    /**
     * Sets the value of the lineStatusCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link LineStatusCodeType }
     *     
     */
    public void setLineStatusCode(
        @Nullable
        LineStatusCodeType value) {
        this.lineStatusCode = value;
    }

    /**
     * Gets the value of the lineStatusReasonCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getLineStatusReasonCode() {
        return lineStatusReasonCode;
    }

    /**
     * Sets the value of the lineStatusReasonCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setLineStatusReasonCode(
        @Nullable
        CodeType value) {
        this.lineStatusReasonCode = value;
    }

    /**
     * Gets the value of the includedNote property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the includedNote property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIncludedNote().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     * @return
     *     The value of the includedNote property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getIncludedNote() {
        if (includedNote == null) {
            includedNote = new ArrayList<>();
        }
        return this.includedNote;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final DocumentLineDocumentType rhs = ((DocumentLineDocumentType) o);
        if (!EqualsHelper.equalsCollection(includedNote, rhs.includedNote)) {
            return false;
        }
        if (!EqualsHelper.equals(lineID, rhs.lineID)) {
            return false;
        }
        if (!EqualsHelper.equals(lineStatusCode, rhs.lineStatusCode)) {
            return false;
        }
        if (!EqualsHelper.equals(lineStatusReasonCode, rhs.lineStatusReasonCode)) {
            return false;
        }
        if (!EqualsHelper.equals(parentLineID, rhs.parentLineID)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(includedNote).append(lineID).append(lineStatusCode).append(lineStatusReasonCode).append(parentLineID).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("includedNote", includedNote).append("lineID", lineID).append("lineStatusCode", lineStatusCode).append("lineStatusReasonCode", lineStatusReasonCode).append("parentLineID", parentLineID).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setIncludedNote(
        @Nullable
        final List<NoteType> aList) {
        includedNote = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIncludedNoteEntries() {
        return (!getIncludedNote().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIncludedNoteEntries() {
        return getIncludedNote().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIncludedNoteCount() {
        return getIncludedNote().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getIncludedNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIncludedNote().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addIncludedNote(
        @Nonnull
        final NoteType elem) {
        getIncludedNote().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        DocumentLineDocumentType ret) {
        if (includedNote == null) {
            ret.includedNote = null;
        } else {
            List<NoteType> retIncludedNote = new ArrayList<>();
            for (NoteType aItem: getIncludedNote()) {
                retIncludedNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.includedNote = retIncludedNote;
        }
        ret.lineID = ((lineID == null)?null:lineID.clone());
        ret.lineStatusCode = ((lineStatusCode == null)?null:lineStatusCode.clone());
        ret.lineStatusReasonCode = ((lineStatusReasonCode == null)?null:lineStatusReasonCode.clone());
        ret.parentLineID = ((parentLineID == null)?null:parentLineID.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DocumentLineDocumentType clone() {
        DocumentLineDocumentType ret = new DocumentLineDocumentType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setLineID(
        @Nullable
        final String valueParam) {
        IDType aObj = getLineID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setLineID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setParentLineID(
        @Nullable
        final String valueParam) {
        IDType aObj = getParentLineID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setParentLineID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LineStatusCodeType and never <code>null</code>
     */
    @Nonnull
    public LineStatusCodeType setLineStatusCode(
        @Nullable
        final String valueParam) {
        LineStatusCodeType aObj = getLineStatusCode();
        if (aObj == null) {
            aObj = new LineStatusCodeType(valueParam);
            setLineStatusCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setLineStatusReasonCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getLineStatusReasonCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setLineStatusReasonCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getLineIDValue() {
        IDType aObj = getLineID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getParentLineIDValue() {
        IDType aObj = getParentLineID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LineStatusCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LineStatusCodeType object or <code>null</code>
     */
    @Nullable
    public String getLineStatusCodeValue() {
        LineStatusCodeType aObj = getLineStatusCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getLineStatusReasonCodeValue() {
        CodeType aObj = getLineStatusReasonCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
