
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.DocumentCodeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.MessageFunctionCodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IndicatorType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for ExchangedDocumentType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ExchangedDocumentType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType"/>
 *         <element name="Name" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}DocumentCodeType" minOccurs="0"/>
 *         <element name="IssueDateTime" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}DateTimeType"/>
 *         <element name="CopyIndicator" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IndicatorType" minOccurs="0"/>
 *         <element name="Purpose" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="ControlRequirementIndicator" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IndicatorType" minOccurs="0"/>
 *         <element name="LanguageID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="PurposeCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}MessageFunctionCodeType" minOccurs="0"/>
 *         <element name="RevisionDateTime" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}DateTimeType" minOccurs="0"/>
 *         <element name="VersionID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="GlobalID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="RevisionID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="PreviousRevisionID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="CategoryCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="IncludedNote" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}NoteType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="EffectiveSpecifiedPeriod" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpecifiedPeriodType" minOccurs="0"/>
 *         <element name="IssuerTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ExchangedDocumentType", propOrder = {
    "id",
    "name",
    "typeCode",
    "issueDateTime",
    "copyIndicator",
    "purpose",
    "controlRequirementIndicator",
    "languageID",
    "purposeCode",
    "revisionDateTime",
    "versionID",
    "globalID",
    "revisionID",
    "previousRevisionID",
    "categoryCode",
    "includedNote",
    "effectiveSpecifiedPeriod",
    "issuerTradeParty"
})
@CodingStyleguideUnaware
public class ExchangedDocumentType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID", required = true)
    private IDType id;
    @XmlElement(name = "Name")
    private List<TextType> name;
    @XmlElement(name = "TypeCode")
    private DocumentCodeType typeCode;
    @XmlElement(name = "IssueDateTime", required = true)
    private DateTimeType issueDateTime;
    @XmlElement(name = "CopyIndicator")
    private IndicatorType copyIndicator;
    @XmlElement(name = "Purpose")
    private TextType purpose;
    @XmlElement(name = "ControlRequirementIndicator")
    private IndicatorType controlRequirementIndicator;
    @XmlElement(name = "LanguageID")
    private List<IDType> languageID;
    @XmlElement(name = "PurposeCode")
    private MessageFunctionCodeType purposeCode;
    @XmlElement(name = "RevisionDateTime")
    private DateTimeType revisionDateTime;
    @XmlElement(name = "VersionID")
    private IDType versionID;
    @XmlElement(name = "GlobalID")
    private IDType globalID;
    @XmlElement(name = "RevisionID")
    private IDType revisionID;
    @XmlElement(name = "PreviousRevisionID")
    private IDType previousRevisionID;
    @XmlElement(name = "CategoryCode")
    private CodeType categoryCode;
    @XmlElement(name = "IncludedNote")
    private List<NoteType> includedNote;
    @XmlElement(name = "EffectiveSpecifiedPeriod")
    private SpecifiedPeriodType effectiveSpecifiedPeriod;
    @XmlElement(name = "IssuerTradeParty")
    private TradePartyType issuerTradeParty;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ExchangedDocumentType() {
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the name property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the name property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getName() {
        if (name == null) {
            name = new ArrayList<>();
        }
        return this.name;
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentCodeType }
     *     
     */
    @Nullable
    public DocumentCodeType getTypeCode() {
        return typeCode;
    }

    /**
     * Sets the value of the typeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentCodeType }
     *     
     */
    public void setTypeCode(
        @Nullable
        DocumentCodeType value) {
        this.typeCode = value;
    }

    /**
     * Gets the value of the issueDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link DateTimeType }
     *     
     */
    @Nullable
    public DateTimeType getIssueDateTime() {
        return issueDateTime;
    }

    /**
     * Sets the value of the issueDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateTimeType }
     *     
     */
    public void setIssueDateTime(
        @Nullable
        DateTimeType value) {
        this.issueDateTime = value;
    }

    /**
     * Gets the value of the copyIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link IndicatorType }
     *     
     */
    @Nullable
    public IndicatorType getCopyIndicator() {
        return copyIndicator;
    }

    /**
     * Sets the value of the copyIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link IndicatorType }
     *     
     */
    public void setCopyIndicator(
        @Nullable
        IndicatorType value) {
        this.copyIndicator = value;
    }

    /**
     * Gets the value of the purpose property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getPurpose() {
        return purpose;
    }

    /**
     * Sets the value of the purpose property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setPurpose(
        @Nullable
        TextType value) {
        this.purpose = value;
    }

    /**
     * Gets the value of the controlRequirementIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link IndicatorType }
     *     
     */
    @Nullable
    public IndicatorType getControlRequirementIndicator() {
        return controlRequirementIndicator;
    }

    /**
     * Sets the value of the controlRequirementIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link IndicatorType }
     *     
     */
    public void setControlRequirementIndicator(
        @Nullable
        IndicatorType value) {
        this.controlRequirementIndicator = value;
    }

    /**
     * Gets the value of the languageID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the languageID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLanguageID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDType }
     * 
     * 
     * @return
     *     The value of the languageID property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDType> getLanguageID() {
        if (languageID == null) {
            languageID = new ArrayList<>();
        }
        return this.languageID;
    }

    /**
     * Gets the value of the purposeCode property.
     * 
     * @return
     *     possible object is
     *     {@link MessageFunctionCodeType }
     *     
     */
    @Nullable
    public MessageFunctionCodeType getPurposeCode() {
        return purposeCode;
    }

    /**
     * Sets the value of the purposeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link MessageFunctionCodeType }
     *     
     */
    public void setPurposeCode(
        @Nullable
        MessageFunctionCodeType value) {
        this.purposeCode = value;
    }

    /**
     * Gets the value of the revisionDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link DateTimeType }
     *     
     */
    @Nullable
    public DateTimeType getRevisionDateTime() {
        return revisionDateTime;
    }

    /**
     * Sets the value of the revisionDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateTimeType }
     *     
     */
    public void setRevisionDateTime(
        @Nullable
        DateTimeType value) {
        this.revisionDateTime = value;
    }

    /**
     * Gets the value of the versionID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getVersionID() {
        return versionID;
    }

    /**
     * Sets the value of the versionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setVersionID(
        @Nullable
        IDType value) {
        this.versionID = value;
    }

    /**
     * Gets the value of the globalID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getGlobalID() {
        return globalID;
    }

    /**
     * Sets the value of the globalID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setGlobalID(
        @Nullable
        IDType value) {
        this.globalID = value;
    }

    /**
     * Gets the value of the revisionID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getRevisionID() {
        return revisionID;
    }

    /**
     * Sets the value of the revisionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setRevisionID(
        @Nullable
        IDType value) {
        this.revisionID = value;
    }

    /**
     * Gets the value of the previousRevisionID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getPreviousRevisionID() {
        return previousRevisionID;
    }

    /**
     * Sets the value of the previousRevisionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setPreviousRevisionID(
        @Nullable
        IDType value) {
        this.previousRevisionID = value;
    }

    /**
     * Gets the value of the categoryCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getCategoryCode() {
        return categoryCode;
    }

    /**
     * Sets the value of the categoryCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setCategoryCode(
        @Nullable
        CodeType value) {
        this.categoryCode = value;
    }

    /**
     * Gets the value of the includedNote property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the includedNote property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIncludedNote().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     * @return
     *     The value of the includedNote property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getIncludedNote() {
        if (includedNote == null) {
            includedNote = new ArrayList<>();
        }
        return this.includedNote;
    }

    /**
     * Gets the value of the effectiveSpecifiedPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link SpecifiedPeriodType }
     *     
     */
    @Nullable
    public SpecifiedPeriodType getEffectiveSpecifiedPeriod() {
        return effectiveSpecifiedPeriod;
    }

    /**
     * Sets the value of the effectiveSpecifiedPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpecifiedPeriodType }
     *     
     */
    public void setEffectiveSpecifiedPeriod(
        @Nullable
        SpecifiedPeriodType value) {
        this.effectiveSpecifiedPeriod = value;
    }

    /**
     * Gets the value of the issuerTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getIssuerTradeParty() {
        return issuerTradeParty;
    }

    /**
     * Sets the value of the issuerTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setIssuerTradeParty(
        @Nullable
        TradePartyType value) {
        this.issuerTradeParty = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ExchangedDocumentType rhs = ((ExchangedDocumentType) o);
        if (!EqualsHelper.equals(categoryCode, rhs.categoryCode)) {
            return false;
        }
        if (!EqualsHelper.equals(controlRequirementIndicator, rhs.controlRequirementIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(copyIndicator, rhs.copyIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(effectiveSpecifiedPeriod, rhs.effectiveSpecifiedPeriod)) {
            return false;
        }
        if (!EqualsHelper.equals(globalID, rhs.globalID)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(includedNote, rhs.includedNote)) {
            return false;
        }
        if (!EqualsHelper.equals(issueDateTime, rhs.issueDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(issuerTradeParty, rhs.issuerTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(languageID, rhs.languageID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equals(previousRevisionID, rhs.previousRevisionID)) {
            return false;
        }
        if (!EqualsHelper.equals(purpose, rhs.purpose)) {
            return false;
        }
        if (!EqualsHelper.equals(purposeCode, rhs.purposeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(revisionDateTime, rhs.revisionDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(revisionID, rhs.revisionID)) {
            return false;
        }
        if (!EqualsHelper.equals(typeCode, rhs.typeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(versionID, rhs.versionID)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(categoryCode).append(controlRequirementIndicator).append(copyIndicator).append(effectiveSpecifiedPeriod).append(globalID).append(id).append(includedNote).append(issueDateTime).append(issuerTradeParty).append(languageID).append(name).append(previousRevisionID).append(purpose).append(purposeCode).append(revisionDateTime).append(revisionID).append(typeCode).append(versionID).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("categoryCode", categoryCode).append("controlRequirementIndicator", controlRequirementIndicator).append("copyIndicator", copyIndicator).append("effectiveSpecifiedPeriod", effectiveSpecifiedPeriod).append("globalID", globalID).append("id", id).append("includedNote", includedNote).append("issueDateTime", issueDateTime).append("issuerTradeParty", issuerTradeParty).append("languageID", languageID).append("name", name).append("previousRevisionID", previousRevisionID).append("purpose", purpose).append("purposeCode", purposeCode).append("revisionDateTime", revisionDateTime).append("revisionID", revisionID).append("typeCode", typeCode).append("versionID", versionID).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setName(
        @Nullable
        final List<TextType> aList) {
        name = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLanguageID(
        @Nullable
        final List<IDType> aList) {
        languageID = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setIncludedNote(
        @Nullable
        final List<NoteType> aList) {
        includedNote = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNameEntries() {
        return (!getName().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNameEntries() {
        return getName().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNameCount() {
        return getName().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getName().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addName(
        @Nonnull
        final TextType elem) {
        getName().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLanguageIDEntries() {
        return (!getLanguageID().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLanguageIDEntries() {
        return getLanguageID().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLanguageIDCount() {
        return getLanguageID().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDType getLanguageIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLanguageID().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLanguageID(
        @Nonnull
        final IDType elem) {
        getLanguageID().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIncludedNoteEntries() {
        return (!getIncludedNote().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIncludedNoteEntries() {
        return getIncludedNote().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIncludedNoteCount() {
        return getIncludedNote().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getIncludedNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIncludedNote().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addIncludedNote(
        @Nonnull
        final NoteType elem) {
        getIncludedNote().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ExchangedDocumentType ret) {
        ret.categoryCode = ((categoryCode == null)?null:categoryCode.clone());
        ret.controlRequirementIndicator = ((controlRequirementIndicator == null)?null:controlRequirementIndicator.clone());
        ret.copyIndicator = ((copyIndicator == null)?null:copyIndicator.clone());
        ret.effectiveSpecifiedPeriod = ((effectiveSpecifiedPeriod == null)?null:effectiveSpecifiedPeriod.clone());
        ret.globalID = ((globalID == null)?null:globalID.clone());
        ret.id = ((id == null)?null:id.clone());
        if (includedNote == null) {
            ret.includedNote = null;
        } else {
            List<NoteType> retIncludedNote = new ArrayList<>();
            for (NoteType aItem: getIncludedNote()) {
                retIncludedNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.includedNote = retIncludedNote;
        }
        ret.issueDateTime = ((issueDateTime == null)?null:issueDateTime.clone());
        ret.issuerTradeParty = ((issuerTradeParty == null)?null:issuerTradeParty.clone());
        if (languageID == null) {
            ret.languageID = null;
        } else {
            List<IDType> retLanguageID = new ArrayList<>();
            for (IDType aItem: getLanguageID()) {
                retLanguageID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.languageID = retLanguageID;
        }
        if (name == null) {
            ret.name = null;
        } else {
            List<TextType> retName = new ArrayList<>();
            for (TextType aItem: getName()) {
                retName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.name = retName;
        }
        ret.previousRevisionID = ((previousRevisionID == null)?null:previousRevisionID.clone());
        ret.purpose = ((purpose == null)?null:purpose.clone());
        ret.purposeCode = ((purposeCode == null)?null:purposeCode.clone());
        ret.revisionDateTime = ((revisionDateTime == null)?null:revisionDateTime.clone());
        ret.revisionID = ((revisionID == null)?null:revisionID.clone());
        ret.typeCode = ((typeCode == null)?null:typeCode.clone());
        ret.versionID = ((versionID == null)?null:versionID.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ExchangedDocumentType clone() {
        ExchangedDocumentType ret = new ExchangedDocumentType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DocumentCodeType and never <code>null</code>
     */
    @Nonnull
    public DocumentCodeType setTypeCode(
        @Nullable
        final String valueParam) {
        DocumentCodeType aObj = getTypeCode();
        if (aObj == null) {
            aObj = new DocumentCodeType(valueParam);
            setTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setPurpose(
        @Nullable
        final String valueParam) {
        TextType aObj = getPurpose();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setPurpose(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MessageFunctionCodeType and never <code>null</code>
     */
    @Nonnull
    public MessageFunctionCodeType setPurposeCode(
        @Nullable
        final String valueParam) {
        MessageFunctionCodeType aObj = getPurposeCode();
        if (aObj == null) {
            aObj = new MessageFunctionCodeType(valueParam);
            setPurposeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setVersionID(
        @Nullable
        final String valueParam) {
        IDType aObj = getVersionID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setVersionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setGlobalID(
        @Nullable
        final String valueParam) {
        IDType aObj = getGlobalID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setGlobalID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setRevisionID(
        @Nullable
        final String valueParam) {
        IDType aObj = getRevisionID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setRevisionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setPreviousRevisionID(
        @Nullable
        final String valueParam) {
        IDType aObj = getPreviousRevisionID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setPreviousRevisionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setCategoryCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getCategoryCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setCategoryCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DocumentCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DocumentCodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeCodeValue() {
        DocumentCodeType aObj = getTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getPurposeValue() {
        TextType aObj = getPurpose();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MessageFunctionCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MessageFunctionCodeType object or <code>null</code>
     */
    @Nullable
    public String getPurposeCodeValue() {
        MessageFunctionCodeType aObj = getPurposeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getVersionIDValue() {
        IDType aObj = getVersionID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getGlobalIDValue() {
        IDType aObj = getGlobalID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getRevisionIDValue() {
        IDType aObj = getRevisionID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getPreviousRevisionIDValue() {
        IDType aObj = getPreviousRevisionID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getCategoryCodeValue() {
        CodeType aObj = getCategoryCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
