
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for FinancialAdjustmentType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="FinancialAdjustmentType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ReasonCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="Reason" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ActualAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ActualQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="ActualDateTime" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}DateTimeType" minOccurs="0"/>
 *         <element name="ClaimRelatedTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="InvoiceReferenceReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FinancialAdjustmentType", propOrder = {
    "reasonCode",
    "reason",
    "actualAmount",
    "actualQuantity",
    "actualDateTime",
    "claimRelatedTradeParty",
    "invoiceReferenceReferencedDocument"
})
@CodingStyleguideUnaware
public class FinancialAdjustmentType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ReasonCode")
    private CodeType reasonCode;
    @XmlElement(name = "Reason")
    private List<TextType> reason;
    @XmlElement(name = "ActualAmount")
    private List<AmountType> actualAmount;
    @XmlElement(name = "ActualQuantity")
    private QuantityType actualQuantity;
    @XmlElement(name = "ActualDateTime")
    private DateTimeType actualDateTime;
    @XmlElement(name = "ClaimRelatedTradeParty")
    private TradePartyType claimRelatedTradeParty;
    @XmlElement(name = "InvoiceReferenceReferencedDocument")
    private ReferencedDocumentType invoiceReferenceReferencedDocument;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public FinancialAdjustmentType() {
    }

    /**
     * Gets the value of the reasonCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getReasonCode() {
        return reasonCode;
    }

    /**
     * Sets the value of the reasonCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setReasonCode(
        @Nullable
        CodeType value) {
        this.reasonCode = value;
    }

    /**
     * Gets the value of the reason property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the reason property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReason().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the reason property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getReason() {
        if (reason == null) {
            reason = new ArrayList<>();
        }
        return this.reason;
    }

    /**
     * Gets the value of the actualAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the actualAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getActualAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the actualAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getActualAmount() {
        if (actualAmount == null) {
            actualAmount = new ArrayList<>();
        }
        return this.actualAmount;
    }

    /**
     * Gets the value of the actualQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getActualQuantity() {
        return actualQuantity;
    }

    /**
     * Sets the value of the actualQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setActualQuantity(
        @Nullable
        QuantityType value) {
        this.actualQuantity = value;
    }

    /**
     * Gets the value of the actualDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link DateTimeType }
     *     
     */
    @Nullable
    public DateTimeType getActualDateTime() {
        return actualDateTime;
    }

    /**
     * Sets the value of the actualDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateTimeType }
     *     
     */
    public void setActualDateTime(
        @Nullable
        DateTimeType value) {
        this.actualDateTime = value;
    }

    /**
     * Gets the value of the claimRelatedTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getClaimRelatedTradeParty() {
        return claimRelatedTradeParty;
    }

    /**
     * Sets the value of the claimRelatedTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setClaimRelatedTradeParty(
        @Nullable
        TradePartyType value) {
        this.claimRelatedTradeParty = value;
    }

    /**
     * Gets the value of the invoiceReferenceReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getInvoiceReferenceReferencedDocument() {
        return invoiceReferenceReferencedDocument;
    }

    /**
     * Sets the value of the invoiceReferenceReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setInvoiceReferenceReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.invoiceReferenceReferencedDocument = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final FinancialAdjustmentType rhs = ((FinancialAdjustmentType) o);
        if (!EqualsHelper.equalsCollection(actualAmount, rhs.actualAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(actualDateTime, rhs.actualDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(actualQuantity, rhs.actualQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(claimRelatedTradeParty, rhs.claimRelatedTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(invoiceReferenceReferencedDocument, rhs.invoiceReferenceReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(reason, rhs.reason)) {
            return false;
        }
        if (!EqualsHelper.equals(reasonCode, rhs.reasonCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(actualAmount).append(actualDateTime).append(actualQuantity).append(claimRelatedTradeParty).append(invoiceReferenceReferencedDocument).append(reason).append(reasonCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("actualAmount", actualAmount).append("actualDateTime", actualDateTime).append("actualQuantity", actualQuantity).append("claimRelatedTradeParty", claimRelatedTradeParty).append("invoiceReferenceReferencedDocument", invoiceReferenceReferencedDocument).append("reason", reason).append("reasonCode", reasonCode).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setReason(
        @Nullable
        final List<TextType> aList) {
        reason = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setActualAmount(
        @Nullable
        final List<AmountType> aList) {
        actualAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasReasonEntries() {
        return (!getReason().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoReasonEntries() {
        return getReason().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getReasonCount() {
        return getReason().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getReasonAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getReason().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addReason(
        @Nonnull
        final TextType elem) {
        getReason().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasActualAmountEntries() {
        return (!getActualAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoActualAmountEntries() {
        return getActualAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getActualAmountCount() {
        return getActualAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getActualAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getActualAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addActualAmount(
        @Nonnull
        final AmountType elem) {
        getActualAmount().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        FinancialAdjustmentType ret) {
        if (actualAmount == null) {
            ret.actualAmount = null;
        } else {
            List<AmountType> retActualAmount = new ArrayList<>();
            for (AmountType aItem: getActualAmount()) {
                retActualAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.actualAmount = retActualAmount;
        }
        ret.actualDateTime = ((actualDateTime == null)?null:actualDateTime.clone());
        ret.actualQuantity = ((actualQuantity == null)?null:actualQuantity.clone());
        ret.claimRelatedTradeParty = ((claimRelatedTradeParty == null)?null:claimRelatedTradeParty.clone());
        ret.invoiceReferenceReferencedDocument = ((invoiceReferenceReferencedDocument == null)?null:invoiceReferenceReferencedDocument.clone());
        if (reason == null) {
            ret.reason = null;
        } else {
            List<TextType> retReason = new ArrayList<>();
            for (TextType aItem: getReason()) {
                retReason.add(((aItem == null)?null:aItem.clone()));
            }
            ret.reason = retReason;
        }
        ret.reasonCode = ((reasonCode == null)?null:reasonCode.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public FinancialAdjustmentType clone() {
        FinancialAdjustmentType ret = new FinancialAdjustmentType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setReasonCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getReasonCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setReasonCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setActualQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getActualQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setActualQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getReasonCodeValue() {
        CodeType aObj = getReasonCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getActualQuantityValue() {
        QuantityType aObj = getActualQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

}
