
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for GroupedWorkItemType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="GroupedWorkItemType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType"/>
 *         <element name="PrimaryClassificationCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="AlternativeClassificationCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="Comment" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TotalQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="Index" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="RequestedActionCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="PriceListItemID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="ContractualLanguageCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="TotalCalculatedPrice" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}CalculatedPriceType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ItemGroupedWorkItem" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}GroupedWorkItemType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ItemBasicWorkItem" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}BasicWorkItemType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ChangedRecordedStatus" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}RecordedStatusType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ActualWorkItemComplexDescription" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}WorkItemComplexDescriptionType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ReferencedSpecifiedBinaryFile" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpecifiedBinaryFileType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "GroupedWorkItemType", propOrder = {
    "id",
    "primaryClassificationCode",
    "alternativeClassificationCode",
    "typeCode",
    "comment",
    "totalQuantity",
    "index",
    "requestedActionCode",
    "priceListItemID",
    "contractualLanguageCode",
    "totalCalculatedPrice",
    "itemGroupedWorkItem",
    "itemBasicWorkItem",
    "changedRecordedStatus",
    "actualWorkItemComplexDescription",
    "referencedSpecifiedBinaryFile"
})
@CodingStyleguideUnaware
public class GroupedWorkItemType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID", required = true)
    private IDType id;
    @XmlElement(name = "PrimaryClassificationCode")
    private List<CodeType> primaryClassificationCode;
    @XmlElement(name = "AlternativeClassificationCode")
    private List<CodeType> alternativeClassificationCode;
    @XmlElement(name = "TypeCode")
    private List<CodeType> typeCode;
    @XmlElement(name = "Comment")
    private List<TextType> comment;
    @XmlElement(name = "TotalQuantity")
    private QuantityType totalQuantity;
    @XmlElement(name = "Index")
    private TextType index;
    @XmlElement(name = "RequestedActionCode")
    private List<CodeType> requestedActionCode;
    @XmlElement(name = "PriceListItemID")
    private IDType priceListItemID;
    @XmlElement(name = "ContractualLanguageCode")
    private CodeType contractualLanguageCode;
    @XmlElement(name = "TotalCalculatedPrice")
    private List<CalculatedPriceType> totalCalculatedPrice;
    @XmlElement(name = "ItemGroupedWorkItem")
    private List<GroupedWorkItemType> itemGroupedWorkItem;
    @XmlElement(name = "ItemBasicWorkItem")
    private List<BasicWorkItemType> itemBasicWorkItem;
    @XmlElement(name = "ChangedRecordedStatus")
    private List<RecordedStatusType> changedRecordedStatus;
    @XmlElement(name = "ActualWorkItemComplexDescription")
    private List<WorkItemComplexDescriptionType> actualWorkItemComplexDescription;
    @XmlElement(name = "ReferencedSpecifiedBinaryFile")
    private List<SpecifiedBinaryFileType> referencedSpecifiedBinaryFile;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public GroupedWorkItemType() {
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the primaryClassificationCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the primaryClassificationCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPrimaryClassificationCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the primaryClassificationCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getPrimaryClassificationCode() {
        if (primaryClassificationCode == null) {
            primaryClassificationCode = new ArrayList<>();
        }
        return this.primaryClassificationCode;
    }

    /**
     * Gets the value of the alternativeClassificationCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the alternativeClassificationCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAlternativeClassificationCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the alternativeClassificationCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getAlternativeClassificationCode() {
        if (alternativeClassificationCode == null) {
            alternativeClassificationCode = new ArrayList<>();
        }
        return this.alternativeClassificationCode;
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the typeCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTypeCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the typeCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getTypeCode() {
        if (typeCode == null) {
            typeCode = new ArrayList<>();
        }
        return this.typeCode;
    }

    /**
     * Gets the value of the comment property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the comment property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getComment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the comment property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getComment() {
        if (comment == null) {
            comment = new ArrayList<>();
        }
        return this.comment;
    }

    /**
     * Gets the value of the totalQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getTotalQuantity() {
        return totalQuantity;
    }

    /**
     * Sets the value of the totalQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setTotalQuantity(
        @Nullable
        QuantityType value) {
        this.totalQuantity = value;
    }

    /**
     * Gets the value of the index property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getIndex() {
        return index;
    }

    /**
     * Sets the value of the index property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setIndex(
        @Nullable
        TextType value) {
        this.index = value;
    }

    /**
     * Gets the value of the requestedActionCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the requestedActionCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRequestedActionCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the requestedActionCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getRequestedActionCode() {
        if (requestedActionCode == null) {
            requestedActionCode = new ArrayList<>();
        }
        return this.requestedActionCode;
    }

    /**
     * Gets the value of the priceListItemID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getPriceListItemID() {
        return priceListItemID;
    }

    /**
     * Sets the value of the priceListItemID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setPriceListItemID(
        @Nullable
        IDType value) {
        this.priceListItemID = value;
    }

    /**
     * Gets the value of the contractualLanguageCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getContractualLanguageCode() {
        return contractualLanguageCode;
    }

    /**
     * Sets the value of the contractualLanguageCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setContractualLanguageCode(
        @Nullable
        CodeType value) {
        this.contractualLanguageCode = value;
    }

    /**
     * Gets the value of the totalCalculatedPrice property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the totalCalculatedPrice property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTotalCalculatedPrice().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CalculatedPriceType }
     * 
     * 
     * @return
     *     The value of the totalCalculatedPrice property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CalculatedPriceType> getTotalCalculatedPrice() {
        if (totalCalculatedPrice == null) {
            totalCalculatedPrice = new ArrayList<>();
        }
        return this.totalCalculatedPrice;
    }

    /**
     * Gets the value of the itemGroupedWorkItem property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the itemGroupedWorkItem property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getItemGroupedWorkItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GroupedWorkItemType }
     * 
     * 
     * @return
     *     The value of the itemGroupedWorkItem property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<GroupedWorkItemType> getItemGroupedWorkItem() {
        if (itemGroupedWorkItem == null) {
            itemGroupedWorkItem = new ArrayList<>();
        }
        return this.itemGroupedWorkItem;
    }

    /**
     * Gets the value of the itemBasicWorkItem property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the itemBasicWorkItem property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getItemBasicWorkItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BasicWorkItemType }
     * 
     * 
     * @return
     *     The value of the itemBasicWorkItem property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<BasicWorkItemType> getItemBasicWorkItem() {
        if (itemBasicWorkItem == null) {
            itemBasicWorkItem = new ArrayList<>();
        }
        return this.itemBasicWorkItem;
    }

    /**
     * Gets the value of the changedRecordedStatus property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the changedRecordedStatus property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getChangedRecordedStatus().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RecordedStatusType }
     * 
     * 
     * @return
     *     The value of the changedRecordedStatus property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RecordedStatusType> getChangedRecordedStatus() {
        if (changedRecordedStatus == null) {
            changedRecordedStatus = new ArrayList<>();
        }
        return this.changedRecordedStatus;
    }

    /**
     * Gets the value of the actualWorkItemComplexDescription property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the actualWorkItemComplexDescription property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getActualWorkItemComplexDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkItemComplexDescriptionType }
     * 
     * 
     * @return
     *     The value of the actualWorkItemComplexDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<WorkItemComplexDescriptionType> getActualWorkItemComplexDescription() {
        if (actualWorkItemComplexDescription == null) {
            actualWorkItemComplexDescription = new ArrayList<>();
        }
        return this.actualWorkItemComplexDescription;
    }

    /**
     * Gets the value of the referencedSpecifiedBinaryFile property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the referencedSpecifiedBinaryFile property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReferencedSpecifiedBinaryFile().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SpecifiedBinaryFileType }
     * 
     * 
     * @return
     *     The value of the referencedSpecifiedBinaryFile property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SpecifiedBinaryFileType> getReferencedSpecifiedBinaryFile() {
        if (referencedSpecifiedBinaryFile == null) {
            referencedSpecifiedBinaryFile = new ArrayList<>();
        }
        return this.referencedSpecifiedBinaryFile;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final GroupedWorkItemType rhs = ((GroupedWorkItemType) o);
        if (!EqualsHelper.equalsCollection(actualWorkItemComplexDescription, rhs.actualWorkItemComplexDescription)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(alternativeClassificationCode, rhs.alternativeClassificationCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(changedRecordedStatus, rhs.changedRecordedStatus)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(comment, rhs.comment)) {
            return false;
        }
        if (!EqualsHelper.equals(contractualLanguageCode, rhs.contractualLanguageCode)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(index, rhs.index)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(itemBasicWorkItem, rhs.itemBasicWorkItem)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(itemGroupedWorkItem, rhs.itemGroupedWorkItem)) {
            return false;
        }
        if (!EqualsHelper.equals(priceListItemID, rhs.priceListItemID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(primaryClassificationCode, rhs.primaryClassificationCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(referencedSpecifiedBinaryFile, rhs.referencedSpecifiedBinaryFile)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(requestedActionCode, rhs.requestedActionCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(totalCalculatedPrice, rhs.totalCalculatedPrice)) {
            return false;
        }
        if (!EqualsHelper.equals(totalQuantity, rhs.totalQuantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(typeCode, rhs.typeCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(actualWorkItemComplexDescription).append(alternativeClassificationCode).append(changedRecordedStatus).append(comment).append(contractualLanguageCode).append(id).append(index).append(itemBasicWorkItem).append(itemGroupedWorkItem).append(priceListItemID).append(primaryClassificationCode).append(referencedSpecifiedBinaryFile).append(requestedActionCode).append(totalCalculatedPrice).append(totalQuantity).append(typeCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("actualWorkItemComplexDescription", actualWorkItemComplexDescription).append("alternativeClassificationCode", alternativeClassificationCode).append("changedRecordedStatus", changedRecordedStatus).append("comment", comment).append("contractualLanguageCode", contractualLanguageCode).append("id", id).append("index", index).append("itemBasicWorkItem", itemBasicWorkItem).append("itemGroupedWorkItem", itemGroupedWorkItem).append("priceListItemID", priceListItemID).append("primaryClassificationCode", primaryClassificationCode).append("referencedSpecifiedBinaryFile", referencedSpecifiedBinaryFile).append("requestedActionCode", requestedActionCode).append("totalCalculatedPrice", totalCalculatedPrice).append("totalQuantity", totalQuantity).append("typeCode", typeCode).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPrimaryClassificationCode(
        @Nullable
        final List<CodeType> aList) {
        primaryClassificationCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAlternativeClassificationCode(
        @Nullable
        final List<CodeType> aList) {
        alternativeClassificationCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTypeCode(
        @Nullable
        final List<CodeType> aList) {
        typeCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setComment(
        @Nullable
        final List<TextType> aList) {
        comment = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRequestedActionCode(
        @Nullable
        final List<CodeType> aList) {
        requestedActionCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTotalCalculatedPrice(
        @Nullable
        final List<CalculatedPriceType> aList) {
        totalCalculatedPrice = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setItemGroupedWorkItem(
        @Nullable
        final List<GroupedWorkItemType> aList) {
        itemGroupedWorkItem = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setItemBasicWorkItem(
        @Nullable
        final List<BasicWorkItemType> aList) {
        itemBasicWorkItem = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setChangedRecordedStatus(
        @Nullable
        final List<RecordedStatusType> aList) {
        changedRecordedStatus = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setActualWorkItemComplexDescription(
        @Nullable
        final List<WorkItemComplexDescriptionType> aList) {
        actualWorkItemComplexDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setReferencedSpecifiedBinaryFile(
        @Nullable
        final List<SpecifiedBinaryFileType> aList) {
        referencedSpecifiedBinaryFile = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPrimaryClassificationCodeEntries() {
        return (!getPrimaryClassificationCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPrimaryClassificationCodeEntries() {
        return getPrimaryClassificationCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPrimaryClassificationCodeCount() {
        return getPrimaryClassificationCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getPrimaryClassificationCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPrimaryClassificationCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPrimaryClassificationCode(
        @Nonnull
        final CodeType elem) {
        getPrimaryClassificationCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAlternativeClassificationCodeEntries() {
        return (!getAlternativeClassificationCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAlternativeClassificationCodeEntries() {
        return getAlternativeClassificationCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAlternativeClassificationCodeCount() {
        return getAlternativeClassificationCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getAlternativeClassificationCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAlternativeClassificationCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAlternativeClassificationCode(
        @Nonnull
        final CodeType elem) {
        getAlternativeClassificationCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTypeCodeEntries() {
        return (!getTypeCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTypeCodeEntries() {
        return getTypeCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTypeCodeCount() {
        return getTypeCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getTypeCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTypeCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTypeCode(
        @Nonnull
        final CodeType elem) {
        getTypeCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCommentEntries() {
        return (!getComment().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCommentEntries() {
        return getComment().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCommentCount() {
        return getComment().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getCommentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getComment().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addComment(
        @Nonnull
        final TextType elem) {
        getComment().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRequestedActionCodeEntries() {
        return (!getRequestedActionCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRequestedActionCodeEntries() {
        return getRequestedActionCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRequestedActionCodeCount() {
        return getRequestedActionCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getRequestedActionCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRequestedActionCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRequestedActionCode(
        @Nonnull
        final CodeType elem) {
        getRequestedActionCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTotalCalculatedPriceEntries() {
        return (!getTotalCalculatedPrice().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTotalCalculatedPriceEntries() {
        return getTotalCalculatedPrice().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTotalCalculatedPriceCount() {
        return getTotalCalculatedPrice().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CalculatedPriceType getTotalCalculatedPriceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTotalCalculatedPrice().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTotalCalculatedPrice(
        @Nonnull
        final CalculatedPriceType elem) {
        getTotalCalculatedPrice().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasItemGroupedWorkItemEntries() {
        return (!getItemGroupedWorkItem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoItemGroupedWorkItemEntries() {
        return getItemGroupedWorkItem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getItemGroupedWorkItemCount() {
        return getItemGroupedWorkItem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public GroupedWorkItemType getItemGroupedWorkItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getItemGroupedWorkItem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addItemGroupedWorkItem(
        @Nonnull
        final GroupedWorkItemType elem) {
        getItemGroupedWorkItem().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasItemBasicWorkItemEntries() {
        return (!getItemBasicWorkItem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoItemBasicWorkItemEntries() {
        return getItemBasicWorkItem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getItemBasicWorkItemCount() {
        return getItemBasicWorkItem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public BasicWorkItemType getItemBasicWorkItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getItemBasicWorkItem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addItemBasicWorkItem(
        @Nonnull
        final BasicWorkItemType elem) {
        getItemBasicWorkItem().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasChangedRecordedStatusEntries() {
        return (!getChangedRecordedStatus().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoChangedRecordedStatusEntries() {
        return getChangedRecordedStatus().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getChangedRecordedStatusCount() {
        return getChangedRecordedStatus().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RecordedStatusType getChangedRecordedStatusAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getChangedRecordedStatus().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addChangedRecordedStatus(
        @Nonnull
        final RecordedStatusType elem) {
        getChangedRecordedStatus().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasActualWorkItemComplexDescriptionEntries() {
        return (!getActualWorkItemComplexDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoActualWorkItemComplexDescriptionEntries() {
        return getActualWorkItemComplexDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getActualWorkItemComplexDescriptionCount() {
        return getActualWorkItemComplexDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public WorkItemComplexDescriptionType getActualWorkItemComplexDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getActualWorkItemComplexDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addActualWorkItemComplexDescription(
        @Nonnull
        final WorkItemComplexDescriptionType elem) {
        getActualWorkItemComplexDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasReferencedSpecifiedBinaryFileEntries() {
        return (!getReferencedSpecifiedBinaryFile().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoReferencedSpecifiedBinaryFileEntries() {
        return getReferencedSpecifiedBinaryFile().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getReferencedSpecifiedBinaryFileCount() {
        return getReferencedSpecifiedBinaryFile().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SpecifiedBinaryFileType getReferencedSpecifiedBinaryFileAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getReferencedSpecifiedBinaryFile().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addReferencedSpecifiedBinaryFile(
        @Nonnull
        final SpecifiedBinaryFileType elem) {
        getReferencedSpecifiedBinaryFile().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        GroupedWorkItemType ret) {
        if (actualWorkItemComplexDescription == null) {
            ret.actualWorkItemComplexDescription = null;
        } else {
            List<WorkItemComplexDescriptionType> retActualWorkItemComplexDescription = new ArrayList<>();
            for (WorkItemComplexDescriptionType aItem: getActualWorkItemComplexDescription()) {
                retActualWorkItemComplexDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.actualWorkItemComplexDescription = retActualWorkItemComplexDescription;
        }
        if (alternativeClassificationCode == null) {
            ret.alternativeClassificationCode = null;
        } else {
            List<CodeType> retAlternativeClassificationCode = new ArrayList<>();
            for (CodeType aItem: getAlternativeClassificationCode()) {
                retAlternativeClassificationCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.alternativeClassificationCode = retAlternativeClassificationCode;
        }
        if (changedRecordedStatus == null) {
            ret.changedRecordedStatus = null;
        } else {
            List<RecordedStatusType> retChangedRecordedStatus = new ArrayList<>();
            for (RecordedStatusType aItem: getChangedRecordedStatus()) {
                retChangedRecordedStatus.add(((aItem == null)?null:aItem.clone()));
            }
            ret.changedRecordedStatus = retChangedRecordedStatus;
        }
        if (comment == null) {
            ret.comment = null;
        } else {
            List<TextType> retComment = new ArrayList<>();
            for (TextType aItem: getComment()) {
                retComment.add(((aItem == null)?null:aItem.clone()));
            }
            ret.comment = retComment;
        }
        ret.contractualLanguageCode = ((contractualLanguageCode == null)?null:contractualLanguageCode.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.index = ((index == null)?null:index.clone());
        if (itemBasicWorkItem == null) {
            ret.itemBasicWorkItem = null;
        } else {
            List<BasicWorkItemType> retItemBasicWorkItem = new ArrayList<>();
            for (BasicWorkItemType aItem: getItemBasicWorkItem()) {
                retItemBasicWorkItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.itemBasicWorkItem = retItemBasicWorkItem;
        }
        if (itemGroupedWorkItem == null) {
            ret.itemGroupedWorkItem = null;
        } else {
            List<GroupedWorkItemType> retItemGroupedWorkItem = new ArrayList<>();
            for (GroupedWorkItemType aItem: getItemGroupedWorkItem()) {
                retItemGroupedWorkItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.itemGroupedWorkItem = retItemGroupedWorkItem;
        }
        ret.priceListItemID = ((priceListItemID == null)?null:priceListItemID.clone());
        if (primaryClassificationCode == null) {
            ret.primaryClassificationCode = null;
        } else {
            List<CodeType> retPrimaryClassificationCode = new ArrayList<>();
            for (CodeType aItem: getPrimaryClassificationCode()) {
                retPrimaryClassificationCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.primaryClassificationCode = retPrimaryClassificationCode;
        }
        if (referencedSpecifiedBinaryFile == null) {
            ret.referencedSpecifiedBinaryFile = null;
        } else {
            List<SpecifiedBinaryFileType> retReferencedSpecifiedBinaryFile = new ArrayList<>();
            for (SpecifiedBinaryFileType aItem: getReferencedSpecifiedBinaryFile()) {
                retReferencedSpecifiedBinaryFile.add(((aItem == null)?null:aItem.clone()));
            }
            ret.referencedSpecifiedBinaryFile = retReferencedSpecifiedBinaryFile;
        }
        if (requestedActionCode == null) {
            ret.requestedActionCode = null;
        } else {
            List<CodeType> retRequestedActionCode = new ArrayList<>();
            for (CodeType aItem: getRequestedActionCode()) {
                retRequestedActionCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.requestedActionCode = retRequestedActionCode;
        }
        if (totalCalculatedPrice == null) {
            ret.totalCalculatedPrice = null;
        } else {
            List<CalculatedPriceType> retTotalCalculatedPrice = new ArrayList<>();
            for (CalculatedPriceType aItem: getTotalCalculatedPrice()) {
                retTotalCalculatedPrice.add(((aItem == null)?null:aItem.clone()));
            }
            ret.totalCalculatedPrice = retTotalCalculatedPrice;
        }
        ret.totalQuantity = ((totalQuantity == null)?null:totalQuantity.clone());
        if (typeCode == null) {
            ret.typeCode = null;
        } else {
            List<CodeType> retTypeCode = new ArrayList<>();
            for (CodeType aItem: getTypeCode()) {
                retTypeCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.typeCode = retTypeCode;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public GroupedWorkItemType clone() {
        GroupedWorkItemType ret = new GroupedWorkItemType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setTotalQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getTotalQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setTotalQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setIndex(
        @Nullable
        final String valueParam) {
        TextType aObj = getIndex();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setIndex(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setPriceListItemID(
        @Nullable
        final String valueParam) {
        IDType aObj = getPriceListItemID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setPriceListItemID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setContractualLanguageCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getContractualLanguageCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setContractualLanguageCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTotalQuantityValue() {
        QuantityType aObj = getTotalQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getIndexValue() {
        TextType aObj = getIndex();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getPriceListItemIDValue() {
        IDType aObj = getPriceListItemID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getContractualLanguageCodeValue() {
        CodeType aObj = getContractualLanguageCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
