
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for HeaderTradeAgreementType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="HeaderTradeAgreementType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="Reference" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="BuyerReference" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="SellerTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="BuyerTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="SalesAgentTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="BuyerRequisitionerTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="BuyerAssignedAccountantTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="SellerAssignedAccountantTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="BuyerTaxRepresentativeTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="SellerTaxRepresentativeTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="ProductEndUserTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="ApplicableTradeDeliveryTerms" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeDeliveryTermsType" minOccurs="0"/>
 *         <element name="SellerOrderReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="BuyerOrderReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="QuotationReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="OrderResponseReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="ContractReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="DemandForecastReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="SupplyInstructionReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="PromotionalDealReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="PriceListReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="AdditionalReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="RequisitionerReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="BuyerAgentTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="PurchaseConditionsReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="SpecifiedProcuringProject" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ProcuringProjectType" minOccurs="0"/>
 *         <element name="UltimateCustomerOrderReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "HeaderTradeAgreementType", propOrder = {
    "reference",
    "buyerReference",
    "sellerTradeParty",
    "buyerTradeParty",
    "salesAgentTradeParty",
    "buyerRequisitionerTradeParty",
    "buyerAssignedAccountantTradeParty",
    "sellerAssignedAccountantTradeParty",
    "buyerTaxRepresentativeTradeParty",
    "sellerTaxRepresentativeTradeParty",
    "productEndUserTradeParty",
    "applicableTradeDeliveryTerms",
    "sellerOrderReferencedDocument",
    "buyerOrderReferencedDocument",
    "quotationReferencedDocument",
    "orderResponseReferencedDocument",
    "contractReferencedDocument",
    "demandForecastReferencedDocument",
    "supplyInstructionReferencedDocument",
    "promotionalDealReferencedDocument",
    "priceListReferencedDocument",
    "additionalReferencedDocument",
    "requisitionerReferencedDocument",
    "buyerAgentTradeParty",
    "purchaseConditionsReferencedDocument",
    "specifiedProcuringProject",
    "ultimateCustomerOrderReferencedDocument"
})
@CodingStyleguideUnaware
public class HeaderTradeAgreementType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "Reference")
    private List<TextType> reference;
    @XmlElement(name = "BuyerReference")
    private TextType buyerReference;
    @XmlElement(name = "SellerTradeParty")
    private TradePartyType sellerTradeParty;
    @XmlElement(name = "BuyerTradeParty")
    private TradePartyType buyerTradeParty;
    @XmlElement(name = "SalesAgentTradeParty")
    private TradePartyType salesAgentTradeParty;
    @XmlElement(name = "BuyerRequisitionerTradeParty")
    private List<TradePartyType> buyerRequisitionerTradeParty;
    @XmlElement(name = "BuyerAssignedAccountantTradeParty")
    private TradePartyType buyerAssignedAccountantTradeParty;
    @XmlElement(name = "SellerAssignedAccountantTradeParty")
    private TradePartyType sellerAssignedAccountantTradeParty;
    @XmlElement(name = "BuyerTaxRepresentativeTradeParty")
    private TradePartyType buyerTaxRepresentativeTradeParty;
    @XmlElement(name = "SellerTaxRepresentativeTradeParty")
    private TradePartyType sellerTaxRepresentativeTradeParty;
    @XmlElement(name = "ProductEndUserTradeParty")
    private TradePartyType productEndUserTradeParty;
    @XmlElement(name = "ApplicableTradeDeliveryTerms")
    private TradeDeliveryTermsType applicableTradeDeliveryTerms;
    @XmlElement(name = "SellerOrderReferencedDocument")
    private ReferencedDocumentType sellerOrderReferencedDocument;
    @XmlElement(name = "BuyerOrderReferencedDocument")
    private ReferencedDocumentType buyerOrderReferencedDocument;
    @XmlElement(name = "QuotationReferencedDocument")
    private ReferencedDocumentType quotationReferencedDocument;
    @XmlElement(name = "OrderResponseReferencedDocument")
    private ReferencedDocumentType orderResponseReferencedDocument;
    @XmlElement(name = "ContractReferencedDocument")
    private ReferencedDocumentType contractReferencedDocument;
    @XmlElement(name = "DemandForecastReferencedDocument")
    private ReferencedDocumentType demandForecastReferencedDocument;
    @XmlElement(name = "SupplyInstructionReferencedDocument")
    private ReferencedDocumentType supplyInstructionReferencedDocument;
    @XmlElement(name = "PromotionalDealReferencedDocument")
    private ReferencedDocumentType promotionalDealReferencedDocument;
    @XmlElement(name = "PriceListReferencedDocument")
    private ReferencedDocumentType priceListReferencedDocument;
    @XmlElement(name = "AdditionalReferencedDocument")
    private List<ReferencedDocumentType> additionalReferencedDocument;
    @XmlElement(name = "RequisitionerReferencedDocument")
    private List<ReferencedDocumentType> requisitionerReferencedDocument;
    @XmlElement(name = "BuyerAgentTradeParty")
    private TradePartyType buyerAgentTradeParty;
    @XmlElement(name = "PurchaseConditionsReferencedDocument")
    private List<ReferencedDocumentType> purchaseConditionsReferencedDocument;
    @XmlElement(name = "SpecifiedProcuringProject")
    private ProcuringProjectType specifiedProcuringProject;
    @XmlElement(name = "UltimateCustomerOrderReferencedDocument")
    private List<ReferencedDocumentType> ultimateCustomerOrderReferencedDocument;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public HeaderTradeAgreementType() {
    }

    /**
     * Gets the value of the reference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the reference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the reference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getReference() {
        if (reference == null) {
            reference = new ArrayList<>();
        }
        return this.reference;
    }

    /**
     * Gets the value of the buyerReference property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getBuyerReference() {
        return buyerReference;
    }

    /**
     * Sets the value of the buyerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setBuyerReference(
        @Nullable
        TextType value) {
        this.buyerReference = value;
    }

    /**
     * Gets the value of the sellerTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getSellerTradeParty() {
        return sellerTradeParty;
    }

    /**
     * Sets the value of the sellerTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setSellerTradeParty(
        @Nullable
        TradePartyType value) {
        this.sellerTradeParty = value;
    }

    /**
     * Gets the value of the buyerTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getBuyerTradeParty() {
        return buyerTradeParty;
    }

    /**
     * Sets the value of the buyerTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setBuyerTradeParty(
        @Nullable
        TradePartyType value) {
        this.buyerTradeParty = value;
    }

    /**
     * Gets the value of the salesAgentTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getSalesAgentTradeParty() {
        return salesAgentTradeParty;
    }

    /**
     * Sets the value of the salesAgentTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setSalesAgentTradeParty(
        @Nullable
        TradePartyType value) {
        this.salesAgentTradeParty = value;
    }

    /**
     * Gets the value of the buyerRequisitionerTradeParty property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the buyerRequisitionerTradeParty property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBuyerRequisitionerTradeParty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradePartyType }
     * 
     * 
     * @return
     *     The value of the buyerRequisitionerTradeParty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradePartyType> getBuyerRequisitionerTradeParty() {
        if (buyerRequisitionerTradeParty == null) {
            buyerRequisitionerTradeParty = new ArrayList<>();
        }
        return this.buyerRequisitionerTradeParty;
    }

    /**
     * Gets the value of the buyerAssignedAccountantTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getBuyerAssignedAccountantTradeParty() {
        return buyerAssignedAccountantTradeParty;
    }

    /**
     * Sets the value of the buyerAssignedAccountantTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setBuyerAssignedAccountantTradeParty(
        @Nullable
        TradePartyType value) {
        this.buyerAssignedAccountantTradeParty = value;
    }

    /**
     * Gets the value of the sellerAssignedAccountantTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getSellerAssignedAccountantTradeParty() {
        return sellerAssignedAccountantTradeParty;
    }

    /**
     * Sets the value of the sellerAssignedAccountantTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setSellerAssignedAccountantTradeParty(
        @Nullable
        TradePartyType value) {
        this.sellerAssignedAccountantTradeParty = value;
    }

    /**
     * Gets the value of the buyerTaxRepresentativeTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getBuyerTaxRepresentativeTradeParty() {
        return buyerTaxRepresentativeTradeParty;
    }

    /**
     * Sets the value of the buyerTaxRepresentativeTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setBuyerTaxRepresentativeTradeParty(
        @Nullable
        TradePartyType value) {
        this.buyerTaxRepresentativeTradeParty = value;
    }

    /**
     * Gets the value of the sellerTaxRepresentativeTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getSellerTaxRepresentativeTradeParty() {
        return sellerTaxRepresentativeTradeParty;
    }

    /**
     * Sets the value of the sellerTaxRepresentativeTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setSellerTaxRepresentativeTradeParty(
        @Nullable
        TradePartyType value) {
        this.sellerTaxRepresentativeTradeParty = value;
    }

    /**
     * Gets the value of the productEndUserTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getProductEndUserTradeParty() {
        return productEndUserTradeParty;
    }

    /**
     * Sets the value of the productEndUserTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setProductEndUserTradeParty(
        @Nullable
        TradePartyType value) {
        this.productEndUserTradeParty = value;
    }

    /**
     * Gets the value of the applicableTradeDeliveryTerms property.
     * 
     * @return
     *     possible object is
     *     {@link TradeDeliveryTermsType }
     *     
     */
    @Nullable
    public TradeDeliveryTermsType getApplicableTradeDeliveryTerms() {
        return applicableTradeDeliveryTerms;
    }

    /**
     * Sets the value of the applicableTradeDeliveryTerms property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeDeliveryTermsType }
     *     
     */
    public void setApplicableTradeDeliveryTerms(
        @Nullable
        TradeDeliveryTermsType value) {
        this.applicableTradeDeliveryTerms = value;
    }

    /**
     * Gets the value of the sellerOrderReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getSellerOrderReferencedDocument() {
        return sellerOrderReferencedDocument;
    }

    /**
     * Sets the value of the sellerOrderReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setSellerOrderReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.sellerOrderReferencedDocument = value;
    }

    /**
     * Gets the value of the buyerOrderReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getBuyerOrderReferencedDocument() {
        return buyerOrderReferencedDocument;
    }

    /**
     * Sets the value of the buyerOrderReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setBuyerOrderReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.buyerOrderReferencedDocument = value;
    }

    /**
     * Gets the value of the quotationReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getQuotationReferencedDocument() {
        return quotationReferencedDocument;
    }

    /**
     * Sets the value of the quotationReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setQuotationReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.quotationReferencedDocument = value;
    }

    /**
     * Gets the value of the orderResponseReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getOrderResponseReferencedDocument() {
        return orderResponseReferencedDocument;
    }

    /**
     * Sets the value of the orderResponseReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setOrderResponseReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.orderResponseReferencedDocument = value;
    }

    /**
     * Gets the value of the contractReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getContractReferencedDocument() {
        return contractReferencedDocument;
    }

    /**
     * Sets the value of the contractReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setContractReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.contractReferencedDocument = value;
    }

    /**
     * Gets the value of the demandForecastReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getDemandForecastReferencedDocument() {
        return demandForecastReferencedDocument;
    }

    /**
     * Sets the value of the demandForecastReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setDemandForecastReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.demandForecastReferencedDocument = value;
    }

    /**
     * Gets the value of the supplyInstructionReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getSupplyInstructionReferencedDocument() {
        return supplyInstructionReferencedDocument;
    }

    /**
     * Sets the value of the supplyInstructionReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setSupplyInstructionReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.supplyInstructionReferencedDocument = value;
    }

    /**
     * Gets the value of the promotionalDealReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getPromotionalDealReferencedDocument() {
        return promotionalDealReferencedDocument;
    }

    /**
     * Sets the value of the promotionalDealReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setPromotionalDealReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.promotionalDealReferencedDocument = value;
    }

    /**
     * Gets the value of the priceListReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getPriceListReferencedDocument() {
        return priceListReferencedDocument;
    }

    /**
     * Sets the value of the priceListReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setPriceListReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.priceListReferencedDocument = value;
    }

    /**
     * Gets the value of the additionalReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the additionalReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAdditionalReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the additionalReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getAdditionalReferencedDocument() {
        if (additionalReferencedDocument == null) {
            additionalReferencedDocument = new ArrayList<>();
        }
        return this.additionalReferencedDocument;
    }

    /**
     * Gets the value of the requisitionerReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the requisitionerReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRequisitionerReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the requisitionerReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getRequisitionerReferencedDocument() {
        if (requisitionerReferencedDocument == null) {
            requisitionerReferencedDocument = new ArrayList<>();
        }
        return this.requisitionerReferencedDocument;
    }

    /**
     * Gets the value of the buyerAgentTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getBuyerAgentTradeParty() {
        return buyerAgentTradeParty;
    }

    /**
     * Sets the value of the buyerAgentTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setBuyerAgentTradeParty(
        @Nullable
        TradePartyType value) {
        this.buyerAgentTradeParty = value;
    }

    /**
     * Gets the value of the purchaseConditionsReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the purchaseConditionsReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPurchaseConditionsReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the purchaseConditionsReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getPurchaseConditionsReferencedDocument() {
        if (purchaseConditionsReferencedDocument == null) {
            purchaseConditionsReferencedDocument = new ArrayList<>();
        }
        return this.purchaseConditionsReferencedDocument;
    }

    /**
     * Gets the value of the specifiedProcuringProject property.
     * 
     * @return
     *     possible object is
     *     {@link ProcuringProjectType }
     *     
     */
    @Nullable
    public ProcuringProjectType getSpecifiedProcuringProject() {
        return specifiedProcuringProject;
    }

    /**
     * Sets the value of the specifiedProcuringProject property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProcuringProjectType }
     *     
     */
    public void setSpecifiedProcuringProject(
        @Nullable
        ProcuringProjectType value) {
        this.specifiedProcuringProject = value;
    }

    /**
     * Gets the value of the ultimateCustomerOrderReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the ultimateCustomerOrderReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getUltimateCustomerOrderReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the ultimateCustomerOrderReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getUltimateCustomerOrderReferencedDocument() {
        if (ultimateCustomerOrderReferencedDocument == null) {
            ultimateCustomerOrderReferencedDocument = new ArrayList<>();
        }
        return this.ultimateCustomerOrderReferencedDocument;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final HeaderTradeAgreementType rhs = ((HeaderTradeAgreementType) o);
        if (!EqualsHelper.equalsCollection(additionalReferencedDocument, rhs.additionalReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(applicableTradeDeliveryTerms, rhs.applicableTradeDeliveryTerms)) {
            return false;
        }
        if (!EqualsHelper.equals(buyerAgentTradeParty, rhs.buyerAgentTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(buyerAssignedAccountantTradeParty, rhs.buyerAssignedAccountantTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(buyerOrderReferencedDocument, rhs.buyerOrderReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(buyerReference, rhs.buyerReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(buyerRequisitionerTradeParty, rhs.buyerRequisitionerTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(buyerTaxRepresentativeTradeParty, rhs.buyerTaxRepresentativeTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(buyerTradeParty, rhs.buyerTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(contractReferencedDocument, rhs.contractReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(demandForecastReferencedDocument, rhs.demandForecastReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(orderResponseReferencedDocument, rhs.orderResponseReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(priceListReferencedDocument, rhs.priceListReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(productEndUserTradeParty, rhs.productEndUserTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(promotionalDealReferencedDocument, rhs.promotionalDealReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(purchaseConditionsReferencedDocument, rhs.purchaseConditionsReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(quotationReferencedDocument, rhs.quotationReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(reference, rhs.reference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(requisitionerReferencedDocument, rhs.requisitionerReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(salesAgentTradeParty, rhs.salesAgentTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(sellerAssignedAccountantTradeParty, rhs.sellerAssignedAccountantTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(sellerOrderReferencedDocument, rhs.sellerOrderReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(sellerTaxRepresentativeTradeParty, rhs.sellerTaxRepresentativeTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(sellerTradeParty, rhs.sellerTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(specifiedProcuringProject, rhs.specifiedProcuringProject)) {
            return false;
        }
        if (!EqualsHelper.equals(supplyInstructionReferencedDocument, rhs.supplyInstructionReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(ultimateCustomerOrderReferencedDocument, rhs.ultimateCustomerOrderReferencedDocument)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalReferencedDocument).append(applicableTradeDeliveryTerms).append(buyerAgentTradeParty).append(buyerAssignedAccountantTradeParty).append(buyerOrderReferencedDocument).append(buyerReference).append(buyerRequisitionerTradeParty).append(buyerTaxRepresentativeTradeParty).append(buyerTradeParty).append(contractReferencedDocument).append(demandForecastReferencedDocument).append(orderResponseReferencedDocument).append(priceListReferencedDocument).append(productEndUserTradeParty).append(promotionalDealReferencedDocument).append(purchaseConditionsReferencedDocument).append(quotationReferencedDocument).append(reference).append(requisitionerReferencedDocument).append(salesAgentTradeParty).append(sellerAssignedAccountantTradeParty).append(sellerOrderReferencedDocument).append(sellerTaxRepresentativeTradeParty).append(sellerTradeParty).append(specifiedProcuringProject).append(supplyInstructionReferencedDocument).append(ultimateCustomerOrderReferencedDocument).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalReferencedDocument", additionalReferencedDocument).append("applicableTradeDeliveryTerms", applicableTradeDeliveryTerms).append("buyerAgentTradeParty", buyerAgentTradeParty).append("buyerAssignedAccountantTradeParty", buyerAssignedAccountantTradeParty).append("buyerOrderReferencedDocument", buyerOrderReferencedDocument).append("buyerReference", buyerReference).append("buyerRequisitionerTradeParty", buyerRequisitionerTradeParty).append("buyerTaxRepresentativeTradeParty", buyerTaxRepresentativeTradeParty).append("buyerTradeParty", buyerTradeParty).append("contractReferencedDocument", contractReferencedDocument).append("demandForecastReferencedDocument", demandForecastReferencedDocument).append("orderResponseReferencedDocument", orderResponseReferencedDocument).append("priceListReferencedDocument", priceListReferencedDocument).append("productEndUserTradeParty", productEndUserTradeParty).append("promotionalDealReferencedDocument", promotionalDealReferencedDocument).append("purchaseConditionsReferencedDocument", purchaseConditionsReferencedDocument).append("quotationReferencedDocument", quotationReferencedDocument).append("reference", reference).append("requisitionerReferencedDocument", requisitionerReferencedDocument).append("salesAgentTradeParty", salesAgentTradeParty).append("sellerAssignedAccountantTradeParty", sellerAssignedAccountantTradeParty).append("sellerOrderReferencedDocument", sellerOrderReferencedDocument).append("sellerTaxRepresentativeTradeParty", sellerTaxRepresentativeTradeParty).append("sellerTradeParty", sellerTradeParty).append("specifiedProcuringProject", specifiedProcuringProject).append("supplyInstructionReferencedDocument", supplyInstructionReferencedDocument).append("ultimateCustomerOrderReferencedDocument", ultimateCustomerOrderReferencedDocument).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setReference(
        @Nullable
        final List<TextType> aList) {
        reference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setBuyerRequisitionerTradeParty(
        @Nullable
        final List<TradePartyType> aList) {
        buyerRequisitionerTradeParty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        additionalReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRequisitionerReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        requisitionerReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPurchaseConditionsReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        purchaseConditionsReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setUltimateCustomerOrderReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        ultimateCustomerOrderReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasReferenceEntries() {
        return (!getReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoReferenceEntries() {
        return getReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getReferenceCount() {
        return getReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addReference(
        @Nonnull
        final TextType elem) {
        getReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasBuyerRequisitionerTradePartyEntries() {
        return (!getBuyerRequisitionerTradeParty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoBuyerRequisitionerTradePartyEntries() {
        return getBuyerRequisitionerTradeParty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getBuyerRequisitionerTradePartyCount() {
        return getBuyerRequisitionerTradeParty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradePartyType getBuyerRequisitionerTradePartyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getBuyerRequisitionerTradeParty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addBuyerRequisitionerTradeParty(
        @Nonnull
        final TradePartyType elem) {
        getBuyerRequisitionerTradeParty().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalReferencedDocumentEntries() {
        return (!getAdditionalReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalReferencedDocumentEntries() {
        return getAdditionalReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalReferencedDocumentCount() {
        return getAdditionalReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getAdditionalReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getAdditionalReferencedDocument().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRequisitionerReferencedDocumentEntries() {
        return (!getRequisitionerReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRequisitionerReferencedDocumentEntries() {
        return getRequisitionerReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRequisitionerReferencedDocumentCount() {
        return getRequisitionerReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getRequisitionerReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRequisitionerReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRequisitionerReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getRequisitionerReferencedDocument().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPurchaseConditionsReferencedDocumentEntries() {
        return (!getPurchaseConditionsReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPurchaseConditionsReferencedDocumentEntries() {
        return getPurchaseConditionsReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPurchaseConditionsReferencedDocumentCount() {
        return getPurchaseConditionsReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getPurchaseConditionsReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPurchaseConditionsReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPurchaseConditionsReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getPurchaseConditionsReferencedDocument().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasUltimateCustomerOrderReferencedDocumentEntries() {
        return (!getUltimateCustomerOrderReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoUltimateCustomerOrderReferencedDocumentEntries() {
        return getUltimateCustomerOrderReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getUltimateCustomerOrderReferencedDocumentCount() {
        return getUltimateCustomerOrderReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getUltimateCustomerOrderReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getUltimateCustomerOrderReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addUltimateCustomerOrderReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getUltimateCustomerOrderReferencedDocument().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        HeaderTradeAgreementType ret) {
        if (additionalReferencedDocument == null) {
            ret.additionalReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retAdditionalReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getAdditionalReferencedDocument()) {
                retAdditionalReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalReferencedDocument = retAdditionalReferencedDocument;
        }
        ret.applicableTradeDeliveryTerms = ((applicableTradeDeliveryTerms == null)?null:applicableTradeDeliveryTerms.clone());
        ret.buyerAgentTradeParty = ((buyerAgentTradeParty == null)?null:buyerAgentTradeParty.clone());
        ret.buyerAssignedAccountantTradeParty = ((buyerAssignedAccountantTradeParty == null)?null:buyerAssignedAccountantTradeParty.clone());
        ret.buyerOrderReferencedDocument = ((buyerOrderReferencedDocument == null)?null:buyerOrderReferencedDocument.clone());
        ret.buyerReference = ((buyerReference == null)?null:buyerReference.clone());
        if (buyerRequisitionerTradeParty == null) {
            ret.buyerRequisitionerTradeParty = null;
        } else {
            List<TradePartyType> retBuyerRequisitionerTradeParty = new ArrayList<>();
            for (TradePartyType aItem: getBuyerRequisitionerTradeParty()) {
                retBuyerRequisitionerTradeParty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.buyerRequisitionerTradeParty = retBuyerRequisitionerTradeParty;
        }
        ret.buyerTaxRepresentativeTradeParty = ((buyerTaxRepresentativeTradeParty == null)?null:buyerTaxRepresentativeTradeParty.clone());
        ret.buyerTradeParty = ((buyerTradeParty == null)?null:buyerTradeParty.clone());
        ret.contractReferencedDocument = ((contractReferencedDocument == null)?null:contractReferencedDocument.clone());
        ret.demandForecastReferencedDocument = ((demandForecastReferencedDocument == null)?null:demandForecastReferencedDocument.clone());
        ret.orderResponseReferencedDocument = ((orderResponseReferencedDocument == null)?null:orderResponseReferencedDocument.clone());
        ret.priceListReferencedDocument = ((priceListReferencedDocument == null)?null:priceListReferencedDocument.clone());
        ret.productEndUserTradeParty = ((productEndUserTradeParty == null)?null:productEndUserTradeParty.clone());
        ret.promotionalDealReferencedDocument = ((promotionalDealReferencedDocument == null)?null:promotionalDealReferencedDocument.clone());
        if (purchaseConditionsReferencedDocument == null) {
            ret.purchaseConditionsReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retPurchaseConditionsReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getPurchaseConditionsReferencedDocument()) {
                retPurchaseConditionsReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.purchaseConditionsReferencedDocument = retPurchaseConditionsReferencedDocument;
        }
        ret.quotationReferencedDocument = ((quotationReferencedDocument == null)?null:quotationReferencedDocument.clone());
        if (reference == null) {
            ret.reference = null;
        } else {
            List<TextType> retReference = new ArrayList<>();
            for (TextType aItem: getReference()) {
                retReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.reference = retReference;
        }
        if (requisitionerReferencedDocument == null) {
            ret.requisitionerReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retRequisitionerReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getRequisitionerReferencedDocument()) {
                retRequisitionerReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.requisitionerReferencedDocument = retRequisitionerReferencedDocument;
        }
        ret.salesAgentTradeParty = ((salesAgentTradeParty == null)?null:salesAgentTradeParty.clone());
        ret.sellerAssignedAccountantTradeParty = ((sellerAssignedAccountantTradeParty == null)?null:sellerAssignedAccountantTradeParty.clone());
        ret.sellerOrderReferencedDocument = ((sellerOrderReferencedDocument == null)?null:sellerOrderReferencedDocument.clone());
        ret.sellerTaxRepresentativeTradeParty = ((sellerTaxRepresentativeTradeParty == null)?null:sellerTaxRepresentativeTradeParty.clone());
        ret.sellerTradeParty = ((sellerTradeParty == null)?null:sellerTradeParty.clone());
        ret.specifiedProcuringProject = ((specifiedProcuringProject == null)?null:specifiedProcuringProject.clone());
        ret.supplyInstructionReferencedDocument = ((supplyInstructionReferencedDocument == null)?null:supplyInstructionReferencedDocument.clone());
        if (ultimateCustomerOrderReferencedDocument == null) {
            ret.ultimateCustomerOrderReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retUltimateCustomerOrderReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getUltimateCustomerOrderReferencedDocument()) {
                retUltimateCustomerOrderReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.ultimateCustomerOrderReferencedDocument = retUltimateCustomerOrderReferencedDocument;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public HeaderTradeAgreementType clone() {
        HeaderTradeAgreementType ret = new HeaderTradeAgreementType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setBuyerReference(
        @Nullable
        final String valueParam) {
        TextType aObj = getBuyerReference();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setBuyerReference(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getBuyerReferenceValue() {
        TextType aObj = getBuyerReference();
        return (aObj == null)?null:aObj.getValue();
    }

}
