
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for LegalOrganizationType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="LegalOrganizationType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="LegalClassificationCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="Name" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="ID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="TradingBusinessName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="PostalTradeAddress" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeAddressType" minOccurs="0"/>
 *         <element name="AuthorizedLegalRegistration" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}LegalRegistrationType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LegalOrganizationType", propOrder = {
    "legalClassificationCode",
    "name",
    "id",
    "tradingBusinessName",
    "postalTradeAddress",
    "authorizedLegalRegistration"
})
@CodingStyleguideUnaware
public class LegalOrganizationType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "LegalClassificationCode")
    private CodeType legalClassificationCode;
    @XmlElement(name = "Name")
    private TextType name;
    @XmlElement(name = "ID")
    private IDType id;
    @XmlElement(name = "TradingBusinessName")
    private TextType tradingBusinessName;
    @XmlElement(name = "PostalTradeAddress")
    private TradeAddressType postalTradeAddress;
    @XmlElement(name = "AuthorizedLegalRegistration")
    private List<LegalRegistrationType> authorizedLegalRegistration;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public LegalOrganizationType() {
    }

    /**
     * Gets the value of the legalClassificationCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getLegalClassificationCode() {
        return legalClassificationCode;
    }

    /**
     * Sets the value of the legalClassificationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setLegalClassificationCode(
        @Nullable
        CodeType value) {
        this.legalClassificationCode = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setName(
        @Nullable
        TextType value) {
        this.name = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the tradingBusinessName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getTradingBusinessName() {
        return tradingBusinessName;
    }

    /**
     * Sets the value of the tradingBusinessName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setTradingBusinessName(
        @Nullable
        TextType value) {
        this.tradingBusinessName = value;
    }

    /**
     * Gets the value of the postalTradeAddress property.
     * 
     * @return
     *     possible object is
     *     {@link TradeAddressType }
     *     
     */
    @Nullable
    public TradeAddressType getPostalTradeAddress() {
        return postalTradeAddress;
    }

    /**
     * Sets the value of the postalTradeAddress property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeAddressType }
     *     
     */
    public void setPostalTradeAddress(
        @Nullable
        TradeAddressType value) {
        this.postalTradeAddress = value;
    }

    /**
     * Gets the value of the authorizedLegalRegistration property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the authorizedLegalRegistration property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAuthorizedLegalRegistration().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LegalRegistrationType }
     * 
     * 
     * @return
     *     The value of the authorizedLegalRegistration property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LegalRegistrationType> getAuthorizedLegalRegistration() {
        if (authorizedLegalRegistration == null) {
            authorizedLegalRegistration = new ArrayList<>();
        }
        return this.authorizedLegalRegistration;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final LegalOrganizationType rhs = ((LegalOrganizationType) o);
        if (!EqualsHelper.equalsCollection(authorizedLegalRegistration, rhs.authorizedLegalRegistration)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(legalClassificationCode, rhs.legalClassificationCode)) {
            return false;
        }
        if (!EqualsHelper.equals(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equals(postalTradeAddress, rhs.postalTradeAddress)) {
            return false;
        }
        if (!EqualsHelper.equals(tradingBusinessName, rhs.tradingBusinessName)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(authorizedLegalRegistration).append(id).append(legalClassificationCode).append(name).append(postalTradeAddress).append(tradingBusinessName).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("authorizedLegalRegistration", authorizedLegalRegistration).append("id", id).append("legalClassificationCode", legalClassificationCode).append("name", name).append("postalTradeAddress", postalTradeAddress).append("tradingBusinessName", tradingBusinessName).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAuthorizedLegalRegistration(
        @Nullable
        final List<LegalRegistrationType> aList) {
        authorizedLegalRegistration = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAuthorizedLegalRegistrationEntries() {
        return (!getAuthorizedLegalRegistration().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAuthorizedLegalRegistrationEntries() {
        return getAuthorizedLegalRegistration().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAuthorizedLegalRegistrationCount() {
        return getAuthorizedLegalRegistration().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LegalRegistrationType getAuthorizedLegalRegistrationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAuthorizedLegalRegistration().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAuthorizedLegalRegistration(
        @Nonnull
        final LegalRegistrationType elem) {
        getAuthorizedLegalRegistration().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        LegalOrganizationType ret) {
        if (authorizedLegalRegistration == null) {
            ret.authorizedLegalRegistration = null;
        } else {
            List<LegalRegistrationType> retAuthorizedLegalRegistration = new ArrayList<>();
            for (LegalRegistrationType aItem: getAuthorizedLegalRegistration()) {
                retAuthorizedLegalRegistration.add(((aItem == null)?null:aItem.clone()));
            }
            ret.authorizedLegalRegistration = retAuthorizedLegalRegistration;
        }
        ret.id = ((id == null)?null:id.clone());
        ret.legalClassificationCode = ((legalClassificationCode == null)?null:legalClassificationCode.clone());
        ret.name = ((name == null)?null:name.clone());
        ret.postalTradeAddress = ((postalTradeAddress == null)?null:postalTradeAddress.clone());
        ret.tradingBusinessName = ((tradingBusinessName == null)?null:tradingBusinessName.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public LegalOrganizationType clone() {
        LegalOrganizationType ret = new LegalOrganizationType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setLegalClassificationCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getLegalClassificationCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setLegalClassificationCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setName(
        @Nullable
        final String valueParam) {
        TextType aObj = getName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setTradingBusinessName(
        @Nullable
        final String valueParam) {
        TextType aObj = getTradingBusinessName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setTradingBusinessName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getLegalClassificationCodeValue() {
        CodeType aObj = getLegalClassificationCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getNameValue() {
        TextType aObj = getName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getTradingBusinessNameValue() {
        TextType aObj = getTradingBusinessName();
        return (aObj == null)?null:aObj.getValue();
    }

}
