
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for LineTradeAgreementType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="LineTradeAgreementType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="BuyerReference" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="BuyerRequisitionerTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ApplicableTradeDeliveryTerms" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeDeliveryTermsType" minOccurs="0"/>
 *         <element name="SellerOrderReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="BuyerOrderReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="QuotationReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="ContractReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="DemandForecastReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="PromotionalDealReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="AdditionalReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="GrossPriceProductTradePrice" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePriceType" minOccurs="0"/>
 *         <element name="NetPriceProductTradePrice" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePriceType" minOccurs="0"/>
 *         <element name="RequisitionerReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ItemSellerTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="ItemBuyerTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="IncludedSpecifiedMarketplace" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpecifiedMarketplaceType" minOccurs="0"/>
 *         <element name="UltimateCustomerOrderReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LineTradeAgreementType", propOrder = {
    "buyerReference",
    "buyerRequisitionerTradeParty",
    "applicableTradeDeliveryTerms",
    "sellerOrderReferencedDocument",
    "buyerOrderReferencedDocument",
    "quotationReferencedDocument",
    "contractReferencedDocument",
    "demandForecastReferencedDocument",
    "promotionalDealReferencedDocument",
    "additionalReferencedDocument",
    "grossPriceProductTradePrice",
    "netPriceProductTradePrice",
    "requisitionerReferencedDocument",
    "itemSellerTradeParty",
    "itemBuyerTradeParty",
    "includedSpecifiedMarketplace",
    "ultimateCustomerOrderReferencedDocument"
})
@CodingStyleguideUnaware
public class LineTradeAgreementType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "BuyerReference")
    private TextType buyerReference;
    @XmlElement(name = "BuyerRequisitionerTradeParty")
    private List<TradePartyType> buyerRequisitionerTradeParty;
    @XmlElement(name = "ApplicableTradeDeliveryTerms")
    private TradeDeliveryTermsType applicableTradeDeliveryTerms;
    @XmlElement(name = "SellerOrderReferencedDocument")
    private ReferencedDocumentType sellerOrderReferencedDocument;
    @XmlElement(name = "BuyerOrderReferencedDocument")
    private ReferencedDocumentType buyerOrderReferencedDocument;
    @XmlElement(name = "QuotationReferencedDocument")
    private ReferencedDocumentType quotationReferencedDocument;
    @XmlElement(name = "ContractReferencedDocument")
    private ReferencedDocumentType contractReferencedDocument;
    @XmlElement(name = "DemandForecastReferencedDocument")
    private ReferencedDocumentType demandForecastReferencedDocument;
    @XmlElement(name = "PromotionalDealReferencedDocument")
    private ReferencedDocumentType promotionalDealReferencedDocument;
    @XmlElement(name = "AdditionalReferencedDocument")
    private List<ReferencedDocumentType> additionalReferencedDocument;
    @XmlElement(name = "GrossPriceProductTradePrice")
    private TradePriceType grossPriceProductTradePrice;
    @XmlElement(name = "NetPriceProductTradePrice")
    private TradePriceType netPriceProductTradePrice;
    @XmlElement(name = "RequisitionerReferencedDocument")
    private List<ReferencedDocumentType> requisitionerReferencedDocument;
    @XmlElement(name = "ItemSellerTradeParty")
    private TradePartyType itemSellerTradeParty;
    @XmlElement(name = "ItemBuyerTradeParty")
    private TradePartyType itemBuyerTradeParty;
    @XmlElement(name = "IncludedSpecifiedMarketplace")
    private SpecifiedMarketplaceType includedSpecifiedMarketplace;
    @XmlElement(name = "UltimateCustomerOrderReferencedDocument")
    private List<ReferencedDocumentType> ultimateCustomerOrderReferencedDocument;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public LineTradeAgreementType() {
    }

    /**
     * Gets the value of the buyerReference property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getBuyerReference() {
        return buyerReference;
    }

    /**
     * Sets the value of the buyerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setBuyerReference(
        @Nullable
        TextType value) {
        this.buyerReference = value;
    }

    /**
     * Gets the value of the buyerRequisitionerTradeParty property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the buyerRequisitionerTradeParty property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBuyerRequisitionerTradeParty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradePartyType }
     * 
     * 
     * @return
     *     The value of the buyerRequisitionerTradeParty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradePartyType> getBuyerRequisitionerTradeParty() {
        if (buyerRequisitionerTradeParty == null) {
            buyerRequisitionerTradeParty = new ArrayList<>();
        }
        return this.buyerRequisitionerTradeParty;
    }

    /**
     * Gets the value of the applicableTradeDeliveryTerms property.
     * 
     * @return
     *     possible object is
     *     {@link TradeDeliveryTermsType }
     *     
     */
    @Nullable
    public TradeDeliveryTermsType getApplicableTradeDeliveryTerms() {
        return applicableTradeDeliveryTerms;
    }

    /**
     * Sets the value of the applicableTradeDeliveryTerms property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeDeliveryTermsType }
     *     
     */
    public void setApplicableTradeDeliveryTerms(
        @Nullable
        TradeDeliveryTermsType value) {
        this.applicableTradeDeliveryTerms = value;
    }

    /**
     * Gets the value of the sellerOrderReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getSellerOrderReferencedDocument() {
        return sellerOrderReferencedDocument;
    }

    /**
     * Sets the value of the sellerOrderReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setSellerOrderReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.sellerOrderReferencedDocument = value;
    }

    /**
     * Gets the value of the buyerOrderReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getBuyerOrderReferencedDocument() {
        return buyerOrderReferencedDocument;
    }

    /**
     * Sets the value of the buyerOrderReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setBuyerOrderReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.buyerOrderReferencedDocument = value;
    }

    /**
     * Gets the value of the quotationReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getQuotationReferencedDocument() {
        return quotationReferencedDocument;
    }

    /**
     * Sets the value of the quotationReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setQuotationReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.quotationReferencedDocument = value;
    }

    /**
     * Gets the value of the contractReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getContractReferencedDocument() {
        return contractReferencedDocument;
    }

    /**
     * Sets the value of the contractReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setContractReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.contractReferencedDocument = value;
    }

    /**
     * Gets the value of the demandForecastReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getDemandForecastReferencedDocument() {
        return demandForecastReferencedDocument;
    }

    /**
     * Sets the value of the demandForecastReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setDemandForecastReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.demandForecastReferencedDocument = value;
    }

    /**
     * Gets the value of the promotionalDealReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getPromotionalDealReferencedDocument() {
        return promotionalDealReferencedDocument;
    }

    /**
     * Sets the value of the promotionalDealReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setPromotionalDealReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.promotionalDealReferencedDocument = value;
    }

    /**
     * Gets the value of the additionalReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the additionalReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAdditionalReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the additionalReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getAdditionalReferencedDocument() {
        if (additionalReferencedDocument == null) {
            additionalReferencedDocument = new ArrayList<>();
        }
        return this.additionalReferencedDocument;
    }

    /**
     * Gets the value of the grossPriceProductTradePrice property.
     * 
     * @return
     *     possible object is
     *     {@link TradePriceType }
     *     
     */
    @Nullable
    public TradePriceType getGrossPriceProductTradePrice() {
        return grossPriceProductTradePrice;
    }

    /**
     * Sets the value of the grossPriceProductTradePrice property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePriceType }
     *     
     */
    public void setGrossPriceProductTradePrice(
        @Nullable
        TradePriceType value) {
        this.grossPriceProductTradePrice = value;
    }

    /**
     * Gets the value of the netPriceProductTradePrice property.
     * 
     * @return
     *     possible object is
     *     {@link TradePriceType }
     *     
     */
    @Nullable
    public TradePriceType getNetPriceProductTradePrice() {
        return netPriceProductTradePrice;
    }

    /**
     * Sets the value of the netPriceProductTradePrice property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePriceType }
     *     
     */
    public void setNetPriceProductTradePrice(
        @Nullable
        TradePriceType value) {
        this.netPriceProductTradePrice = value;
    }

    /**
     * Gets the value of the requisitionerReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the requisitionerReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRequisitionerReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the requisitionerReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getRequisitionerReferencedDocument() {
        if (requisitionerReferencedDocument == null) {
            requisitionerReferencedDocument = new ArrayList<>();
        }
        return this.requisitionerReferencedDocument;
    }

    /**
     * Gets the value of the itemSellerTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getItemSellerTradeParty() {
        return itemSellerTradeParty;
    }

    /**
     * Sets the value of the itemSellerTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setItemSellerTradeParty(
        @Nullable
        TradePartyType value) {
        this.itemSellerTradeParty = value;
    }

    /**
     * Gets the value of the itemBuyerTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getItemBuyerTradeParty() {
        return itemBuyerTradeParty;
    }

    /**
     * Sets the value of the itemBuyerTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setItemBuyerTradeParty(
        @Nullable
        TradePartyType value) {
        this.itemBuyerTradeParty = value;
    }

    /**
     * Gets the value of the includedSpecifiedMarketplace property.
     * 
     * @return
     *     possible object is
     *     {@link SpecifiedMarketplaceType }
     *     
     */
    @Nullable
    public SpecifiedMarketplaceType getIncludedSpecifiedMarketplace() {
        return includedSpecifiedMarketplace;
    }

    /**
     * Sets the value of the includedSpecifiedMarketplace property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpecifiedMarketplaceType }
     *     
     */
    public void setIncludedSpecifiedMarketplace(
        @Nullable
        SpecifiedMarketplaceType value) {
        this.includedSpecifiedMarketplace = value;
    }

    /**
     * Gets the value of the ultimateCustomerOrderReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the ultimateCustomerOrderReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getUltimateCustomerOrderReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the ultimateCustomerOrderReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getUltimateCustomerOrderReferencedDocument() {
        if (ultimateCustomerOrderReferencedDocument == null) {
            ultimateCustomerOrderReferencedDocument = new ArrayList<>();
        }
        return this.ultimateCustomerOrderReferencedDocument;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final LineTradeAgreementType rhs = ((LineTradeAgreementType) o);
        if (!EqualsHelper.equalsCollection(additionalReferencedDocument, rhs.additionalReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(applicableTradeDeliveryTerms, rhs.applicableTradeDeliveryTerms)) {
            return false;
        }
        if (!EqualsHelper.equals(buyerOrderReferencedDocument, rhs.buyerOrderReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(buyerReference, rhs.buyerReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(buyerRequisitionerTradeParty, rhs.buyerRequisitionerTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(contractReferencedDocument, rhs.contractReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(demandForecastReferencedDocument, rhs.demandForecastReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(grossPriceProductTradePrice, rhs.grossPriceProductTradePrice)) {
            return false;
        }
        if (!EqualsHelper.equals(includedSpecifiedMarketplace, rhs.includedSpecifiedMarketplace)) {
            return false;
        }
        if (!EqualsHelper.equals(itemBuyerTradeParty, rhs.itemBuyerTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(itemSellerTradeParty, rhs.itemSellerTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(netPriceProductTradePrice, rhs.netPriceProductTradePrice)) {
            return false;
        }
        if (!EqualsHelper.equals(promotionalDealReferencedDocument, rhs.promotionalDealReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(quotationReferencedDocument, rhs.quotationReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(requisitionerReferencedDocument, rhs.requisitionerReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(sellerOrderReferencedDocument, rhs.sellerOrderReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(ultimateCustomerOrderReferencedDocument, rhs.ultimateCustomerOrderReferencedDocument)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalReferencedDocument).append(applicableTradeDeliveryTerms).append(buyerOrderReferencedDocument).append(buyerReference).append(buyerRequisitionerTradeParty).append(contractReferencedDocument).append(demandForecastReferencedDocument).append(grossPriceProductTradePrice).append(includedSpecifiedMarketplace).append(itemBuyerTradeParty).append(itemSellerTradeParty).append(netPriceProductTradePrice).append(promotionalDealReferencedDocument).append(quotationReferencedDocument).append(requisitionerReferencedDocument).append(sellerOrderReferencedDocument).append(ultimateCustomerOrderReferencedDocument).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalReferencedDocument", additionalReferencedDocument).append("applicableTradeDeliveryTerms", applicableTradeDeliveryTerms).append("buyerOrderReferencedDocument", buyerOrderReferencedDocument).append("buyerReference", buyerReference).append("buyerRequisitionerTradeParty", buyerRequisitionerTradeParty).append("contractReferencedDocument", contractReferencedDocument).append("demandForecastReferencedDocument", demandForecastReferencedDocument).append("grossPriceProductTradePrice", grossPriceProductTradePrice).append("includedSpecifiedMarketplace", includedSpecifiedMarketplace).append("itemBuyerTradeParty", itemBuyerTradeParty).append("itemSellerTradeParty", itemSellerTradeParty).append("netPriceProductTradePrice", netPriceProductTradePrice).append("promotionalDealReferencedDocument", promotionalDealReferencedDocument).append("quotationReferencedDocument", quotationReferencedDocument).append("requisitionerReferencedDocument", requisitionerReferencedDocument).append("sellerOrderReferencedDocument", sellerOrderReferencedDocument).append("ultimateCustomerOrderReferencedDocument", ultimateCustomerOrderReferencedDocument).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setBuyerRequisitionerTradeParty(
        @Nullable
        final List<TradePartyType> aList) {
        buyerRequisitionerTradeParty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        additionalReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRequisitionerReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        requisitionerReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setUltimateCustomerOrderReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        ultimateCustomerOrderReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasBuyerRequisitionerTradePartyEntries() {
        return (!getBuyerRequisitionerTradeParty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoBuyerRequisitionerTradePartyEntries() {
        return getBuyerRequisitionerTradeParty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getBuyerRequisitionerTradePartyCount() {
        return getBuyerRequisitionerTradeParty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradePartyType getBuyerRequisitionerTradePartyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getBuyerRequisitionerTradeParty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addBuyerRequisitionerTradeParty(
        @Nonnull
        final TradePartyType elem) {
        getBuyerRequisitionerTradeParty().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalReferencedDocumentEntries() {
        return (!getAdditionalReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalReferencedDocumentEntries() {
        return getAdditionalReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalReferencedDocumentCount() {
        return getAdditionalReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getAdditionalReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getAdditionalReferencedDocument().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRequisitionerReferencedDocumentEntries() {
        return (!getRequisitionerReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRequisitionerReferencedDocumentEntries() {
        return getRequisitionerReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRequisitionerReferencedDocumentCount() {
        return getRequisitionerReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getRequisitionerReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRequisitionerReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRequisitionerReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getRequisitionerReferencedDocument().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasUltimateCustomerOrderReferencedDocumentEntries() {
        return (!getUltimateCustomerOrderReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoUltimateCustomerOrderReferencedDocumentEntries() {
        return getUltimateCustomerOrderReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getUltimateCustomerOrderReferencedDocumentCount() {
        return getUltimateCustomerOrderReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getUltimateCustomerOrderReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getUltimateCustomerOrderReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addUltimateCustomerOrderReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getUltimateCustomerOrderReferencedDocument().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        LineTradeAgreementType ret) {
        if (additionalReferencedDocument == null) {
            ret.additionalReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retAdditionalReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getAdditionalReferencedDocument()) {
                retAdditionalReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalReferencedDocument = retAdditionalReferencedDocument;
        }
        ret.applicableTradeDeliveryTerms = ((applicableTradeDeliveryTerms == null)?null:applicableTradeDeliveryTerms.clone());
        ret.buyerOrderReferencedDocument = ((buyerOrderReferencedDocument == null)?null:buyerOrderReferencedDocument.clone());
        ret.buyerReference = ((buyerReference == null)?null:buyerReference.clone());
        if (buyerRequisitionerTradeParty == null) {
            ret.buyerRequisitionerTradeParty = null;
        } else {
            List<TradePartyType> retBuyerRequisitionerTradeParty = new ArrayList<>();
            for (TradePartyType aItem: getBuyerRequisitionerTradeParty()) {
                retBuyerRequisitionerTradeParty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.buyerRequisitionerTradeParty = retBuyerRequisitionerTradeParty;
        }
        ret.contractReferencedDocument = ((contractReferencedDocument == null)?null:contractReferencedDocument.clone());
        ret.demandForecastReferencedDocument = ((demandForecastReferencedDocument == null)?null:demandForecastReferencedDocument.clone());
        ret.grossPriceProductTradePrice = ((grossPriceProductTradePrice == null)?null:grossPriceProductTradePrice.clone());
        ret.includedSpecifiedMarketplace = ((includedSpecifiedMarketplace == null)?null:includedSpecifiedMarketplace.clone());
        ret.itemBuyerTradeParty = ((itemBuyerTradeParty == null)?null:itemBuyerTradeParty.clone());
        ret.itemSellerTradeParty = ((itemSellerTradeParty == null)?null:itemSellerTradeParty.clone());
        ret.netPriceProductTradePrice = ((netPriceProductTradePrice == null)?null:netPriceProductTradePrice.clone());
        ret.promotionalDealReferencedDocument = ((promotionalDealReferencedDocument == null)?null:promotionalDealReferencedDocument.clone());
        ret.quotationReferencedDocument = ((quotationReferencedDocument == null)?null:quotationReferencedDocument.clone());
        if (requisitionerReferencedDocument == null) {
            ret.requisitionerReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retRequisitionerReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getRequisitionerReferencedDocument()) {
                retRequisitionerReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.requisitionerReferencedDocument = retRequisitionerReferencedDocument;
        }
        ret.sellerOrderReferencedDocument = ((sellerOrderReferencedDocument == null)?null:sellerOrderReferencedDocument.clone());
        if (ultimateCustomerOrderReferencedDocument == null) {
            ret.ultimateCustomerOrderReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retUltimateCustomerOrderReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getUltimateCustomerOrderReferencedDocument()) {
                retUltimateCustomerOrderReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.ultimateCustomerOrderReferencedDocument = retUltimateCustomerOrderReferencedDocument;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public LineTradeAgreementType clone() {
        LineTradeAgreementType ret = new LineTradeAgreementType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setBuyerReference(
        @Nullable
        final String valueParam) {
        TextType aObj = getBuyerReference();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setBuyerReference(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getBuyerReferenceValue() {
        TextType aObj = getBuyerReference();
        return (aObj == null)?null:aObj.getValue();
    }

}
