
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.WeightUnitMeasureType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;


/**
 * <p>Java class for LineTradeDeliveryType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="LineTradeDeliveryType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="RequestedQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="ReceivedQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="BilledQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="ChargeFreeQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="PackageQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="ProductUnitQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="PerPackageUnitQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="NetWeightMeasure" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}WeightUnitMeasureType" minOccurs="0"/>
 *         <element name="GrossWeightMeasure" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}WeightUnitMeasureType" minOccurs="0"/>
 *         <element name="TheoreticalWeightMeasure" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}WeightUnitMeasureType" minOccurs="0"/>
 *         <element name="DespatchedQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="SpecifiedDeliveryAdjustment" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}DeliveryAdjustmentType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="IncludedSupplyChainPackaging" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SupplyChainPackagingType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="RelatedSupplyChainConsignment" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SupplyChainConsignmentType" minOccurs="0"/>
 *         <element name="ShipToTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="UltimateShipToTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="ShipFromTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="ActualDespatchSupplyChainEvent" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SupplyChainEventType" minOccurs="0"/>
 *         <element name="ActualPickUpSupplyChainEvent" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SupplyChainEventType" minOccurs="0"/>
 *         <element name="RequestedDeliverySupplyChainEvent" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SupplyChainEventType" minOccurs="0"/>
 *         <element name="ActualDeliverySupplyChainEvent" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SupplyChainEventType" minOccurs="0"/>
 *         <element name="ActualReceiptSupplyChainEvent" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SupplyChainEventType" minOccurs="0"/>
 *         <element name="AdditionalReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="DespatchAdviceReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="ReceivingAdviceReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="DeliveryNoteReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="ConsumptionReportReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="PackingListReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LineTradeDeliveryType", propOrder = {
    "requestedQuantity",
    "receivedQuantity",
    "billedQuantity",
    "chargeFreeQuantity",
    "packageQuantity",
    "productUnitQuantity",
    "perPackageUnitQuantity",
    "netWeightMeasure",
    "grossWeightMeasure",
    "theoreticalWeightMeasure",
    "despatchedQuantity",
    "specifiedDeliveryAdjustment",
    "includedSupplyChainPackaging",
    "relatedSupplyChainConsignment",
    "shipToTradeParty",
    "ultimateShipToTradeParty",
    "shipFromTradeParty",
    "actualDespatchSupplyChainEvent",
    "actualPickUpSupplyChainEvent",
    "requestedDeliverySupplyChainEvent",
    "actualDeliverySupplyChainEvent",
    "actualReceiptSupplyChainEvent",
    "additionalReferencedDocument",
    "despatchAdviceReferencedDocument",
    "receivingAdviceReferencedDocument",
    "deliveryNoteReferencedDocument",
    "consumptionReportReferencedDocument",
    "packingListReferencedDocument"
})
@CodingStyleguideUnaware
public class LineTradeDeliveryType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "RequestedQuantity")
    private QuantityType requestedQuantity;
    @XmlElement(name = "ReceivedQuantity")
    private QuantityType receivedQuantity;
    @XmlElement(name = "BilledQuantity")
    private QuantityType billedQuantity;
    @XmlElement(name = "ChargeFreeQuantity")
    private QuantityType chargeFreeQuantity;
    @XmlElement(name = "PackageQuantity")
    private QuantityType packageQuantity;
    @XmlElement(name = "ProductUnitQuantity")
    private QuantityType productUnitQuantity;
    @XmlElement(name = "PerPackageUnitQuantity")
    private QuantityType perPackageUnitQuantity;
    @XmlElement(name = "NetWeightMeasure")
    private WeightUnitMeasureType netWeightMeasure;
    @XmlElement(name = "GrossWeightMeasure")
    private WeightUnitMeasureType grossWeightMeasure;
    @XmlElement(name = "TheoreticalWeightMeasure")
    private WeightUnitMeasureType theoreticalWeightMeasure;
    @XmlElement(name = "DespatchedQuantity")
    private QuantityType despatchedQuantity;
    @XmlElement(name = "SpecifiedDeliveryAdjustment")
    private List<DeliveryAdjustmentType> specifiedDeliveryAdjustment;
    @XmlElement(name = "IncludedSupplyChainPackaging")
    private List<SupplyChainPackagingType> includedSupplyChainPackaging;
    @XmlElement(name = "RelatedSupplyChainConsignment")
    private SupplyChainConsignmentType relatedSupplyChainConsignment;
    @XmlElement(name = "ShipToTradeParty")
    private TradePartyType shipToTradeParty;
    @XmlElement(name = "UltimateShipToTradeParty")
    private TradePartyType ultimateShipToTradeParty;
    @XmlElement(name = "ShipFromTradeParty")
    private TradePartyType shipFromTradeParty;
    @XmlElement(name = "ActualDespatchSupplyChainEvent")
    private SupplyChainEventType actualDespatchSupplyChainEvent;
    @XmlElement(name = "ActualPickUpSupplyChainEvent")
    private SupplyChainEventType actualPickUpSupplyChainEvent;
    @XmlElement(name = "RequestedDeliverySupplyChainEvent")
    private SupplyChainEventType requestedDeliverySupplyChainEvent;
    @XmlElement(name = "ActualDeliverySupplyChainEvent")
    private SupplyChainEventType actualDeliverySupplyChainEvent;
    @XmlElement(name = "ActualReceiptSupplyChainEvent")
    private SupplyChainEventType actualReceiptSupplyChainEvent;
    @XmlElement(name = "AdditionalReferencedDocument")
    private List<ReferencedDocumentType> additionalReferencedDocument;
    @XmlElement(name = "DespatchAdviceReferencedDocument")
    private ReferencedDocumentType despatchAdviceReferencedDocument;
    @XmlElement(name = "ReceivingAdviceReferencedDocument")
    private ReferencedDocumentType receivingAdviceReferencedDocument;
    @XmlElement(name = "DeliveryNoteReferencedDocument")
    private ReferencedDocumentType deliveryNoteReferencedDocument;
    @XmlElement(name = "ConsumptionReportReferencedDocument")
    private ReferencedDocumentType consumptionReportReferencedDocument;
    @XmlElement(name = "PackingListReferencedDocument")
    private ReferencedDocumentType packingListReferencedDocument;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public LineTradeDeliveryType() {
    }

    /**
     * Gets the value of the requestedQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getRequestedQuantity() {
        return requestedQuantity;
    }

    /**
     * Sets the value of the requestedQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setRequestedQuantity(
        @Nullable
        QuantityType value) {
        this.requestedQuantity = value;
    }

    /**
     * Gets the value of the receivedQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getReceivedQuantity() {
        return receivedQuantity;
    }

    /**
     * Sets the value of the receivedQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setReceivedQuantity(
        @Nullable
        QuantityType value) {
        this.receivedQuantity = value;
    }

    /**
     * Gets the value of the billedQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getBilledQuantity() {
        return billedQuantity;
    }

    /**
     * Sets the value of the billedQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setBilledQuantity(
        @Nullable
        QuantityType value) {
        this.billedQuantity = value;
    }

    /**
     * Gets the value of the chargeFreeQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getChargeFreeQuantity() {
        return chargeFreeQuantity;
    }

    /**
     * Sets the value of the chargeFreeQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setChargeFreeQuantity(
        @Nullable
        QuantityType value) {
        this.chargeFreeQuantity = value;
    }

    /**
     * Gets the value of the packageQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getPackageQuantity() {
        return packageQuantity;
    }

    /**
     * Sets the value of the packageQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setPackageQuantity(
        @Nullable
        QuantityType value) {
        this.packageQuantity = value;
    }

    /**
     * Gets the value of the productUnitQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getProductUnitQuantity() {
        return productUnitQuantity;
    }

    /**
     * Sets the value of the productUnitQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setProductUnitQuantity(
        @Nullable
        QuantityType value) {
        this.productUnitQuantity = value;
    }

    /**
     * Gets the value of the perPackageUnitQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getPerPackageUnitQuantity() {
        return perPackageUnitQuantity;
    }

    /**
     * Sets the value of the perPackageUnitQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setPerPackageUnitQuantity(
        @Nullable
        QuantityType value) {
        this.perPackageUnitQuantity = value;
    }

    /**
     * Gets the value of the netWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link WeightUnitMeasureType }
     *     
     */
    @Nullable
    public WeightUnitMeasureType getNetWeightMeasure() {
        return netWeightMeasure;
    }

    /**
     * Sets the value of the netWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link WeightUnitMeasureType }
     *     
     */
    public void setNetWeightMeasure(
        @Nullable
        WeightUnitMeasureType value) {
        this.netWeightMeasure = value;
    }

    /**
     * Gets the value of the grossWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link WeightUnitMeasureType }
     *     
     */
    @Nullable
    public WeightUnitMeasureType getGrossWeightMeasure() {
        return grossWeightMeasure;
    }

    /**
     * Sets the value of the grossWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link WeightUnitMeasureType }
     *     
     */
    public void setGrossWeightMeasure(
        @Nullable
        WeightUnitMeasureType value) {
        this.grossWeightMeasure = value;
    }

    /**
     * Gets the value of the theoreticalWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link WeightUnitMeasureType }
     *     
     */
    @Nullable
    public WeightUnitMeasureType getTheoreticalWeightMeasure() {
        return theoreticalWeightMeasure;
    }

    /**
     * Sets the value of the theoreticalWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link WeightUnitMeasureType }
     *     
     */
    public void setTheoreticalWeightMeasure(
        @Nullable
        WeightUnitMeasureType value) {
        this.theoreticalWeightMeasure = value;
    }

    /**
     * Gets the value of the despatchedQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getDespatchedQuantity() {
        return despatchedQuantity;
    }

    /**
     * Sets the value of the despatchedQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setDespatchedQuantity(
        @Nullable
        QuantityType value) {
        this.despatchedQuantity = value;
    }

    /**
     * Gets the value of the specifiedDeliveryAdjustment property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the specifiedDeliveryAdjustment property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpecifiedDeliveryAdjustment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DeliveryAdjustmentType }
     * 
     * 
     * @return
     *     The value of the specifiedDeliveryAdjustment property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DeliveryAdjustmentType> getSpecifiedDeliveryAdjustment() {
        if (specifiedDeliveryAdjustment == null) {
            specifiedDeliveryAdjustment = new ArrayList<>();
        }
        return this.specifiedDeliveryAdjustment;
    }

    /**
     * Gets the value of the includedSupplyChainPackaging property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the includedSupplyChainPackaging property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIncludedSupplyChainPackaging().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupplyChainPackagingType }
     * 
     * 
     * @return
     *     The value of the includedSupplyChainPackaging property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SupplyChainPackagingType> getIncludedSupplyChainPackaging() {
        if (includedSupplyChainPackaging == null) {
            includedSupplyChainPackaging = new ArrayList<>();
        }
        return this.includedSupplyChainPackaging;
    }

    /**
     * Gets the value of the relatedSupplyChainConsignment property.
     * 
     * @return
     *     possible object is
     *     {@link SupplyChainConsignmentType }
     *     
     */
    @Nullable
    public SupplyChainConsignmentType getRelatedSupplyChainConsignment() {
        return relatedSupplyChainConsignment;
    }

    /**
     * Sets the value of the relatedSupplyChainConsignment property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupplyChainConsignmentType }
     *     
     */
    public void setRelatedSupplyChainConsignment(
        @Nullable
        SupplyChainConsignmentType value) {
        this.relatedSupplyChainConsignment = value;
    }

    /**
     * Gets the value of the shipToTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getShipToTradeParty() {
        return shipToTradeParty;
    }

    /**
     * Sets the value of the shipToTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setShipToTradeParty(
        @Nullable
        TradePartyType value) {
        this.shipToTradeParty = value;
    }

    /**
     * Gets the value of the ultimateShipToTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getUltimateShipToTradeParty() {
        return ultimateShipToTradeParty;
    }

    /**
     * Sets the value of the ultimateShipToTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setUltimateShipToTradeParty(
        @Nullable
        TradePartyType value) {
        this.ultimateShipToTradeParty = value;
    }

    /**
     * Gets the value of the shipFromTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getShipFromTradeParty() {
        return shipFromTradeParty;
    }

    /**
     * Sets the value of the shipFromTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setShipFromTradeParty(
        @Nullable
        TradePartyType value) {
        this.shipFromTradeParty = value;
    }

    /**
     * Gets the value of the actualDespatchSupplyChainEvent property.
     * 
     * @return
     *     possible object is
     *     {@link SupplyChainEventType }
     *     
     */
    @Nullable
    public SupplyChainEventType getActualDespatchSupplyChainEvent() {
        return actualDespatchSupplyChainEvent;
    }

    /**
     * Sets the value of the actualDespatchSupplyChainEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupplyChainEventType }
     *     
     */
    public void setActualDespatchSupplyChainEvent(
        @Nullable
        SupplyChainEventType value) {
        this.actualDespatchSupplyChainEvent = value;
    }

    /**
     * Gets the value of the actualPickUpSupplyChainEvent property.
     * 
     * @return
     *     possible object is
     *     {@link SupplyChainEventType }
     *     
     */
    @Nullable
    public SupplyChainEventType getActualPickUpSupplyChainEvent() {
        return actualPickUpSupplyChainEvent;
    }

    /**
     * Sets the value of the actualPickUpSupplyChainEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupplyChainEventType }
     *     
     */
    public void setActualPickUpSupplyChainEvent(
        @Nullable
        SupplyChainEventType value) {
        this.actualPickUpSupplyChainEvent = value;
    }

    /**
     * Gets the value of the requestedDeliverySupplyChainEvent property.
     * 
     * @return
     *     possible object is
     *     {@link SupplyChainEventType }
     *     
     */
    @Nullable
    public SupplyChainEventType getRequestedDeliverySupplyChainEvent() {
        return requestedDeliverySupplyChainEvent;
    }

    /**
     * Sets the value of the requestedDeliverySupplyChainEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupplyChainEventType }
     *     
     */
    public void setRequestedDeliverySupplyChainEvent(
        @Nullable
        SupplyChainEventType value) {
        this.requestedDeliverySupplyChainEvent = value;
    }

    /**
     * Gets the value of the actualDeliverySupplyChainEvent property.
     * 
     * @return
     *     possible object is
     *     {@link SupplyChainEventType }
     *     
     */
    @Nullable
    public SupplyChainEventType getActualDeliverySupplyChainEvent() {
        return actualDeliverySupplyChainEvent;
    }

    /**
     * Sets the value of the actualDeliverySupplyChainEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupplyChainEventType }
     *     
     */
    public void setActualDeliverySupplyChainEvent(
        @Nullable
        SupplyChainEventType value) {
        this.actualDeliverySupplyChainEvent = value;
    }

    /**
     * Gets the value of the actualReceiptSupplyChainEvent property.
     * 
     * @return
     *     possible object is
     *     {@link SupplyChainEventType }
     *     
     */
    @Nullable
    public SupplyChainEventType getActualReceiptSupplyChainEvent() {
        return actualReceiptSupplyChainEvent;
    }

    /**
     * Sets the value of the actualReceiptSupplyChainEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupplyChainEventType }
     *     
     */
    public void setActualReceiptSupplyChainEvent(
        @Nullable
        SupplyChainEventType value) {
        this.actualReceiptSupplyChainEvent = value;
    }

    /**
     * Gets the value of the additionalReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the additionalReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAdditionalReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the additionalReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getAdditionalReferencedDocument() {
        if (additionalReferencedDocument == null) {
            additionalReferencedDocument = new ArrayList<>();
        }
        return this.additionalReferencedDocument;
    }

    /**
     * Gets the value of the despatchAdviceReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getDespatchAdviceReferencedDocument() {
        return despatchAdviceReferencedDocument;
    }

    /**
     * Sets the value of the despatchAdviceReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setDespatchAdviceReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.despatchAdviceReferencedDocument = value;
    }

    /**
     * Gets the value of the receivingAdviceReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getReceivingAdviceReferencedDocument() {
        return receivingAdviceReferencedDocument;
    }

    /**
     * Sets the value of the receivingAdviceReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setReceivingAdviceReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.receivingAdviceReferencedDocument = value;
    }

    /**
     * Gets the value of the deliveryNoteReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getDeliveryNoteReferencedDocument() {
        return deliveryNoteReferencedDocument;
    }

    /**
     * Sets the value of the deliveryNoteReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setDeliveryNoteReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.deliveryNoteReferencedDocument = value;
    }

    /**
     * Gets the value of the consumptionReportReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getConsumptionReportReferencedDocument() {
        return consumptionReportReferencedDocument;
    }

    /**
     * Sets the value of the consumptionReportReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setConsumptionReportReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.consumptionReportReferencedDocument = value;
    }

    /**
     * Gets the value of the packingListReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getPackingListReferencedDocument() {
        return packingListReferencedDocument;
    }

    /**
     * Sets the value of the packingListReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setPackingListReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.packingListReferencedDocument = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final LineTradeDeliveryType rhs = ((LineTradeDeliveryType) o);
        if (!EqualsHelper.equals(actualDeliverySupplyChainEvent, rhs.actualDeliverySupplyChainEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(actualDespatchSupplyChainEvent, rhs.actualDespatchSupplyChainEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(actualPickUpSupplyChainEvent, rhs.actualPickUpSupplyChainEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(actualReceiptSupplyChainEvent, rhs.actualReceiptSupplyChainEvent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(additionalReferencedDocument, rhs.additionalReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(billedQuantity, rhs.billedQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(chargeFreeQuantity, rhs.chargeFreeQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(consumptionReportReferencedDocument, rhs.consumptionReportReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(deliveryNoteReferencedDocument, rhs.deliveryNoteReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(despatchAdviceReferencedDocument, rhs.despatchAdviceReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(despatchedQuantity, rhs.despatchedQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(grossWeightMeasure, rhs.grossWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(includedSupplyChainPackaging, rhs.includedSupplyChainPackaging)) {
            return false;
        }
        if (!EqualsHelper.equals(netWeightMeasure, rhs.netWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(packageQuantity, rhs.packageQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(packingListReferencedDocument, rhs.packingListReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(perPackageUnitQuantity, rhs.perPackageUnitQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(productUnitQuantity, rhs.productUnitQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(receivedQuantity, rhs.receivedQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(receivingAdviceReferencedDocument, rhs.receivingAdviceReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(relatedSupplyChainConsignment, rhs.relatedSupplyChainConsignment)) {
            return false;
        }
        if (!EqualsHelper.equals(requestedDeliverySupplyChainEvent, rhs.requestedDeliverySupplyChainEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(requestedQuantity, rhs.requestedQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(shipFromTradeParty, rhs.shipFromTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(shipToTradeParty, rhs.shipToTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(specifiedDeliveryAdjustment, rhs.specifiedDeliveryAdjustment)) {
            return false;
        }
        if (!EqualsHelper.equals(theoreticalWeightMeasure, rhs.theoreticalWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(ultimateShipToTradeParty, rhs.ultimateShipToTradeParty)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(actualDeliverySupplyChainEvent).append(actualDespatchSupplyChainEvent).append(actualPickUpSupplyChainEvent).append(actualReceiptSupplyChainEvent).append(additionalReferencedDocument).append(billedQuantity).append(chargeFreeQuantity).append(consumptionReportReferencedDocument).append(deliveryNoteReferencedDocument).append(despatchAdviceReferencedDocument).append(despatchedQuantity).append(grossWeightMeasure).append(includedSupplyChainPackaging).append(netWeightMeasure).append(packageQuantity).append(packingListReferencedDocument).append(perPackageUnitQuantity).append(productUnitQuantity).append(receivedQuantity).append(receivingAdviceReferencedDocument).append(relatedSupplyChainConsignment).append(requestedDeliverySupplyChainEvent).append(requestedQuantity).append(shipFromTradeParty).append(shipToTradeParty).append(specifiedDeliveryAdjustment).append(theoreticalWeightMeasure).append(ultimateShipToTradeParty).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("actualDeliverySupplyChainEvent", actualDeliverySupplyChainEvent).append("actualDespatchSupplyChainEvent", actualDespatchSupplyChainEvent).append("actualPickUpSupplyChainEvent", actualPickUpSupplyChainEvent).append("actualReceiptSupplyChainEvent", actualReceiptSupplyChainEvent).append("additionalReferencedDocument", additionalReferencedDocument).append("billedQuantity", billedQuantity).append("chargeFreeQuantity", chargeFreeQuantity).append("consumptionReportReferencedDocument", consumptionReportReferencedDocument).append("deliveryNoteReferencedDocument", deliveryNoteReferencedDocument).append("despatchAdviceReferencedDocument", despatchAdviceReferencedDocument).append("despatchedQuantity", despatchedQuantity).append("grossWeightMeasure", grossWeightMeasure).append("includedSupplyChainPackaging", includedSupplyChainPackaging).append("netWeightMeasure", netWeightMeasure).append("packageQuantity", packageQuantity).append("packingListReferencedDocument", packingListReferencedDocument).append("perPackageUnitQuantity", perPackageUnitQuantity).append("productUnitQuantity", productUnitQuantity).append("receivedQuantity", receivedQuantity).append("receivingAdviceReferencedDocument", receivingAdviceReferencedDocument).append("relatedSupplyChainConsignment", relatedSupplyChainConsignment).append("requestedDeliverySupplyChainEvent", requestedDeliverySupplyChainEvent).append("requestedQuantity", requestedQuantity).append("shipFromTradeParty", shipFromTradeParty).append("shipToTradeParty", shipToTradeParty).append("specifiedDeliveryAdjustment", specifiedDeliveryAdjustment).append("theoreticalWeightMeasure", theoreticalWeightMeasure).append("ultimateShipToTradeParty", ultimateShipToTradeParty).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpecifiedDeliveryAdjustment(
        @Nullable
        final List<DeliveryAdjustmentType> aList) {
        specifiedDeliveryAdjustment = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setIncludedSupplyChainPackaging(
        @Nullable
        final List<SupplyChainPackagingType> aList) {
        includedSupplyChainPackaging = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        additionalReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpecifiedDeliveryAdjustmentEntries() {
        return (!getSpecifiedDeliveryAdjustment().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpecifiedDeliveryAdjustmentEntries() {
        return getSpecifiedDeliveryAdjustment().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpecifiedDeliveryAdjustmentCount() {
        return getSpecifiedDeliveryAdjustment().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DeliveryAdjustmentType getSpecifiedDeliveryAdjustmentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpecifiedDeliveryAdjustment().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpecifiedDeliveryAdjustment(
        @Nonnull
        final DeliveryAdjustmentType elem) {
        getSpecifiedDeliveryAdjustment().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIncludedSupplyChainPackagingEntries() {
        return (!getIncludedSupplyChainPackaging().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIncludedSupplyChainPackagingEntries() {
        return getIncludedSupplyChainPackaging().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIncludedSupplyChainPackagingCount() {
        return getIncludedSupplyChainPackaging().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SupplyChainPackagingType getIncludedSupplyChainPackagingAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIncludedSupplyChainPackaging().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addIncludedSupplyChainPackaging(
        @Nonnull
        final SupplyChainPackagingType elem) {
        getIncludedSupplyChainPackaging().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalReferencedDocumentEntries() {
        return (!getAdditionalReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalReferencedDocumentEntries() {
        return getAdditionalReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalReferencedDocumentCount() {
        return getAdditionalReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getAdditionalReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getAdditionalReferencedDocument().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        LineTradeDeliveryType ret) {
        ret.actualDeliverySupplyChainEvent = ((actualDeliverySupplyChainEvent == null)?null:actualDeliverySupplyChainEvent.clone());
        ret.actualDespatchSupplyChainEvent = ((actualDespatchSupplyChainEvent == null)?null:actualDespatchSupplyChainEvent.clone());
        ret.actualPickUpSupplyChainEvent = ((actualPickUpSupplyChainEvent == null)?null:actualPickUpSupplyChainEvent.clone());
        ret.actualReceiptSupplyChainEvent = ((actualReceiptSupplyChainEvent == null)?null:actualReceiptSupplyChainEvent.clone());
        if (additionalReferencedDocument == null) {
            ret.additionalReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retAdditionalReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getAdditionalReferencedDocument()) {
                retAdditionalReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalReferencedDocument = retAdditionalReferencedDocument;
        }
        ret.billedQuantity = ((billedQuantity == null)?null:billedQuantity.clone());
        ret.chargeFreeQuantity = ((chargeFreeQuantity == null)?null:chargeFreeQuantity.clone());
        ret.consumptionReportReferencedDocument = ((consumptionReportReferencedDocument == null)?null:consumptionReportReferencedDocument.clone());
        ret.deliveryNoteReferencedDocument = ((deliveryNoteReferencedDocument == null)?null:deliveryNoteReferencedDocument.clone());
        ret.despatchAdviceReferencedDocument = ((despatchAdviceReferencedDocument == null)?null:despatchAdviceReferencedDocument.clone());
        ret.despatchedQuantity = ((despatchedQuantity == null)?null:despatchedQuantity.clone());
        ret.grossWeightMeasure = ((grossWeightMeasure == null)?null:grossWeightMeasure.clone());
        if (includedSupplyChainPackaging == null) {
            ret.includedSupplyChainPackaging = null;
        } else {
            List<SupplyChainPackagingType> retIncludedSupplyChainPackaging = new ArrayList<>();
            for (SupplyChainPackagingType aItem: getIncludedSupplyChainPackaging()) {
                retIncludedSupplyChainPackaging.add(((aItem == null)?null:aItem.clone()));
            }
            ret.includedSupplyChainPackaging = retIncludedSupplyChainPackaging;
        }
        ret.netWeightMeasure = ((netWeightMeasure == null)?null:netWeightMeasure.clone());
        ret.packageQuantity = ((packageQuantity == null)?null:packageQuantity.clone());
        ret.packingListReferencedDocument = ((packingListReferencedDocument == null)?null:packingListReferencedDocument.clone());
        ret.perPackageUnitQuantity = ((perPackageUnitQuantity == null)?null:perPackageUnitQuantity.clone());
        ret.productUnitQuantity = ((productUnitQuantity == null)?null:productUnitQuantity.clone());
        ret.receivedQuantity = ((receivedQuantity == null)?null:receivedQuantity.clone());
        ret.receivingAdviceReferencedDocument = ((receivingAdviceReferencedDocument == null)?null:receivingAdviceReferencedDocument.clone());
        ret.relatedSupplyChainConsignment = ((relatedSupplyChainConsignment == null)?null:relatedSupplyChainConsignment.clone());
        ret.requestedDeliverySupplyChainEvent = ((requestedDeliverySupplyChainEvent == null)?null:requestedDeliverySupplyChainEvent.clone());
        ret.requestedQuantity = ((requestedQuantity == null)?null:requestedQuantity.clone());
        ret.shipFromTradeParty = ((shipFromTradeParty == null)?null:shipFromTradeParty.clone());
        ret.shipToTradeParty = ((shipToTradeParty == null)?null:shipToTradeParty.clone());
        if (specifiedDeliveryAdjustment == null) {
            ret.specifiedDeliveryAdjustment = null;
        } else {
            List<DeliveryAdjustmentType> retSpecifiedDeliveryAdjustment = new ArrayList<>();
            for (DeliveryAdjustmentType aItem: getSpecifiedDeliveryAdjustment()) {
                retSpecifiedDeliveryAdjustment.add(((aItem == null)?null:aItem.clone()));
            }
            ret.specifiedDeliveryAdjustment = retSpecifiedDeliveryAdjustment;
        }
        ret.theoreticalWeightMeasure = ((theoreticalWeightMeasure == null)?null:theoreticalWeightMeasure.clone());
        ret.ultimateShipToTradeParty = ((ultimateShipToTradeParty == null)?null:ultimateShipToTradeParty.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public LineTradeDeliveryType clone() {
        LineTradeDeliveryType ret = new LineTradeDeliveryType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setRequestedQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getRequestedQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setRequestedQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setReceivedQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getReceivedQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setReceivedQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setBilledQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getBilledQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setBilledQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setChargeFreeQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getChargeFreeQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setChargeFreeQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setPackageQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getPackageQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setPackageQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setProductUnitQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getProductUnitQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setProductUnitQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setPerPackageUnitQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getPerPackageUnitQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setPerPackageUnitQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WeightUnitMeasureType and never <code>null</code>
     */
    @Nonnull
    public WeightUnitMeasureType setNetWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        WeightUnitMeasureType aObj = getNetWeightMeasure();
        if (aObj == null) {
            aObj = new WeightUnitMeasureType(valueParam);
            setNetWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WeightUnitMeasureType and never <code>null</code>
     */
    @Nonnull
    public WeightUnitMeasureType setGrossWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        WeightUnitMeasureType aObj = getGrossWeightMeasure();
        if (aObj == null) {
            aObj = new WeightUnitMeasureType(valueParam);
            setGrossWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WeightUnitMeasureType and never <code>null</code>
     */
    @Nonnull
    public WeightUnitMeasureType setTheoreticalWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        WeightUnitMeasureType aObj = getTheoreticalWeightMeasure();
        if (aObj == null) {
            aObj = new WeightUnitMeasureType(valueParam);
            setTheoreticalWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setDespatchedQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getDespatchedQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setDespatchedQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getRequestedQuantityValue() {
        QuantityType aObj = getRequestedQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getReceivedQuantityValue() {
        QuantityType aObj = getReceivedQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getBilledQuantityValue() {
        QuantityType aObj = getBilledQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getChargeFreeQuantityValue() {
        QuantityType aObj = getChargeFreeQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPackageQuantityValue() {
        QuantityType aObj = getPackageQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getProductUnitQuantityValue() {
        QuantityType aObj = getProductUnitQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPerPackageUnitQuantityValue() {
        QuantityType aObj = getPerPackageUnitQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained WeightUnitMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WeightUnitMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getNetWeightMeasureValue() {
        WeightUnitMeasureType aObj = getNetWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained WeightUnitMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WeightUnitMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getGrossWeightMeasureValue() {
        WeightUnitMeasureType aObj = getGrossWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained WeightUnitMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WeightUnitMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTheoreticalWeightMeasureValue() {
        WeightUnitMeasureType aObj = getTheoreticalWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getDespatchedQuantityValue() {
        QuantityType aObj = getDespatchedQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

}
