
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IndicatorType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for LineTradeSettlementType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="LineTradeSettlementType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="PaymentReference" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="InvoiceIssuerReference" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="TotalAdjustmentAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" minOccurs="0"/>
 *         <element name="DiscountIndicator" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IndicatorType" minOccurs="0"/>
 *         <element name="ApplicableTradeTax" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeTaxType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="BillingSpecifiedPeriod" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpecifiedPeriodType" minOccurs="0"/>
 *         <element name="SpecifiedTradeAllowanceCharge" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeAllowanceChargeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="SubtotalCalculatedTradeTax" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeTaxType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="SpecifiedLogisticsServiceCharge" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}LogisticsServiceChargeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="SpecifiedTradePaymentTerms" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePaymentTermsType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="SpecifiedTradeSettlementLineMonetarySummation" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeSettlementLineMonetarySummationType" minOccurs="0"/>
 *         <element name="SpecifiedFinancialAdjustment" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}FinancialAdjustmentType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="InvoiceReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="AdditionalReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="PayableSpecifiedTradeAccountingAccount" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeAccountingAccountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ReceivableSpecifiedTradeAccountingAccount" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeAccountingAccountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="PurchaseSpecifiedTradeAccountingAccount" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeAccountingAccountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="SalesSpecifiedTradeAccountingAccount" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeAccountingAccountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="SpecifiedTradeSettlementFinancialCard" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeSettlementFinancialCardType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LineTradeSettlementType", propOrder = {
    "paymentReference",
    "invoiceIssuerReference",
    "totalAdjustmentAmount",
    "discountIndicator",
    "applicableTradeTax",
    "billingSpecifiedPeriod",
    "specifiedTradeAllowanceCharge",
    "subtotalCalculatedTradeTax",
    "specifiedLogisticsServiceCharge",
    "specifiedTradePaymentTerms",
    "specifiedTradeSettlementLineMonetarySummation",
    "specifiedFinancialAdjustment",
    "invoiceReferencedDocument",
    "additionalReferencedDocument",
    "payableSpecifiedTradeAccountingAccount",
    "receivableSpecifiedTradeAccountingAccount",
    "purchaseSpecifiedTradeAccountingAccount",
    "salesSpecifiedTradeAccountingAccount",
    "specifiedTradeSettlementFinancialCard"
})
@CodingStyleguideUnaware
public class LineTradeSettlementType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "PaymentReference")
    private List<TextType> paymentReference;
    @XmlElement(name = "InvoiceIssuerReference")
    private TextType invoiceIssuerReference;
    @XmlElement(name = "TotalAdjustmentAmount")
    private AmountType totalAdjustmentAmount;
    @XmlElement(name = "DiscountIndicator")
    private IndicatorType discountIndicator;
    @XmlElement(name = "ApplicableTradeTax")
    private List<TradeTaxType> applicableTradeTax;
    @XmlElement(name = "BillingSpecifiedPeriod")
    private SpecifiedPeriodType billingSpecifiedPeriod;
    @XmlElement(name = "SpecifiedTradeAllowanceCharge")
    private List<TradeAllowanceChargeType> specifiedTradeAllowanceCharge;
    @XmlElement(name = "SubtotalCalculatedTradeTax")
    private List<TradeTaxType> subtotalCalculatedTradeTax;
    @XmlElement(name = "SpecifiedLogisticsServiceCharge")
    private List<LogisticsServiceChargeType> specifiedLogisticsServiceCharge;
    @XmlElement(name = "SpecifiedTradePaymentTerms")
    private List<TradePaymentTermsType> specifiedTradePaymentTerms;
    @XmlElement(name = "SpecifiedTradeSettlementLineMonetarySummation")
    private TradeSettlementLineMonetarySummationType specifiedTradeSettlementLineMonetarySummation;
    @XmlElement(name = "SpecifiedFinancialAdjustment")
    private List<FinancialAdjustmentType> specifiedFinancialAdjustment;
    @XmlElement(name = "InvoiceReferencedDocument")
    private ReferencedDocumentType invoiceReferencedDocument;
    @XmlElement(name = "AdditionalReferencedDocument")
    private List<ReferencedDocumentType> additionalReferencedDocument;
    @XmlElement(name = "PayableSpecifiedTradeAccountingAccount")
    private List<TradeAccountingAccountType> payableSpecifiedTradeAccountingAccount;
    @XmlElement(name = "ReceivableSpecifiedTradeAccountingAccount")
    private List<TradeAccountingAccountType> receivableSpecifiedTradeAccountingAccount;
    @XmlElement(name = "PurchaseSpecifiedTradeAccountingAccount")
    private List<TradeAccountingAccountType> purchaseSpecifiedTradeAccountingAccount;
    @XmlElement(name = "SalesSpecifiedTradeAccountingAccount")
    private List<TradeAccountingAccountType> salesSpecifiedTradeAccountingAccount;
    @XmlElement(name = "SpecifiedTradeSettlementFinancialCard")
    private TradeSettlementFinancialCardType specifiedTradeSettlementFinancialCard;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public LineTradeSettlementType() {
    }

    /**
     * Gets the value of the paymentReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the paymentReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPaymentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the paymentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getPaymentReference() {
        if (paymentReference == null) {
            paymentReference = new ArrayList<>();
        }
        return this.paymentReference;
    }

    /**
     * Gets the value of the invoiceIssuerReference property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getInvoiceIssuerReference() {
        return invoiceIssuerReference;
    }

    /**
     * Sets the value of the invoiceIssuerReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setInvoiceIssuerReference(
        @Nullable
        TextType value) {
        this.invoiceIssuerReference = value;
    }

    /**
     * Gets the value of the totalAdjustmentAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getTotalAdjustmentAmount() {
        return totalAdjustmentAmount;
    }

    /**
     * Sets the value of the totalAdjustmentAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setTotalAdjustmentAmount(
        @Nullable
        AmountType value) {
        this.totalAdjustmentAmount = value;
    }

    /**
     * Gets the value of the discountIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link IndicatorType }
     *     
     */
    @Nullable
    public IndicatorType getDiscountIndicator() {
        return discountIndicator;
    }

    /**
     * Sets the value of the discountIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link IndicatorType }
     *     
     */
    public void setDiscountIndicator(
        @Nullable
        IndicatorType value) {
        this.discountIndicator = value;
    }

    /**
     * Gets the value of the applicableTradeTax property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the applicableTradeTax property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getApplicableTradeTax().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeTaxType }
     * 
     * 
     * @return
     *     The value of the applicableTradeTax property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeTaxType> getApplicableTradeTax() {
        if (applicableTradeTax == null) {
            applicableTradeTax = new ArrayList<>();
        }
        return this.applicableTradeTax;
    }

    /**
     * Gets the value of the billingSpecifiedPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link SpecifiedPeriodType }
     *     
     */
    @Nullable
    public SpecifiedPeriodType getBillingSpecifiedPeriod() {
        return billingSpecifiedPeriod;
    }

    /**
     * Sets the value of the billingSpecifiedPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpecifiedPeriodType }
     *     
     */
    public void setBillingSpecifiedPeriod(
        @Nullable
        SpecifiedPeriodType value) {
        this.billingSpecifiedPeriod = value;
    }

    /**
     * Gets the value of the specifiedTradeAllowanceCharge property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the specifiedTradeAllowanceCharge property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpecifiedTradeAllowanceCharge().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeAllowanceChargeType }
     * 
     * 
     * @return
     *     The value of the specifiedTradeAllowanceCharge property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeAllowanceChargeType> getSpecifiedTradeAllowanceCharge() {
        if (specifiedTradeAllowanceCharge == null) {
            specifiedTradeAllowanceCharge = new ArrayList<>();
        }
        return this.specifiedTradeAllowanceCharge;
    }

    /**
     * Gets the value of the subtotalCalculatedTradeTax property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the subtotalCalculatedTradeTax property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSubtotalCalculatedTradeTax().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeTaxType }
     * 
     * 
     * @return
     *     The value of the subtotalCalculatedTradeTax property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeTaxType> getSubtotalCalculatedTradeTax() {
        if (subtotalCalculatedTradeTax == null) {
            subtotalCalculatedTradeTax = new ArrayList<>();
        }
        return this.subtotalCalculatedTradeTax;
    }

    /**
     * Gets the value of the specifiedLogisticsServiceCharge property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the specifiedLogisticsServiceCharge property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpecifiedLogisticsServiceCharge().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LogisticsServiceChargeType }
     * 
     * 
     * @return
     *     The value of the specifiedLogisticsServiceCharge property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LogisticsServiceChargeType> getSpecifiedLogisticsServiceCharge() {
        if (specifiedLogisticsServiceCharge == null) {
            specifiedLogisticsServiceCharge = new ArrayList<>();
        }
        return this.specifiedLogisticsServiceCharge;
    }

    /**
     * Gets the value of the specifiedTradePaymentTerms property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the specifiedTradePaymentTerms property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpecifiedTradePaymentTerms().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradePaymentTermsType }
     * 
     * 
     * @return
     *     The value of the specifiedTradePaymentTerms property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradePaymentTermsType> getSpecifiedTradePaymentTerms() {
        if (specifiedTradePaymentTerms == null) {
            specifiedTradePaymentTerms = new ArrayList<>();
        }
        return this.specifiedTradePaymentTerms;
    }

    /**
     * Gets the value of the specifiedTradeSettlementLineMonetarySummation property.
     * 
     * @return
     *     possible object is
     *     {@link TradeSettlementLineMonetarySummationType }
     *     
     */
    @Nullable
    public TradeSettlementLineMonetarySummationType getSpecifiedTradeSettlementLineMonetarySummation() {
        return specifiedTradeSettlementLineMonetarySummation;
    }

    /**
     * Sets the value of the specifiedTradeSettlementLineMonetarySummation property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeSettlementLineMonetarySummationType }
     *     
     */
    public void setSpecifiedTradeSettlementLineMonetarySummation(
        @Nullable
        TradeSettlementLineMonetarySummationType value) {
        this.specifiedTradeSettlementLineMonetarySummation = value;
    }

    /**
     * Gets the value of the specifiedFinancialAdjustment property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the specifiedFinancialAdjustment property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpecifiedFinancialAdjustment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FinancialAdjustmentType }
     * 
     * 
     * @return
     *     The value of the specifiedFinancialAdjustment property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FinancialAdjustmentType> getSpecifiedFinancialAdjustment() {
        if (specifiedFinancialAdjustment == null) {
            specifiedFinancialAdjustment = new ArrayList<>();
        }
        return this.specifiedFinancialAdjustment;
    }

    /**
     * Gets the value of the invoiceReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getInvoiceReferencedDocument() {
        return invoiceReferencedDocument;
    }

    /**
     * Sets the value of the invoiceReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setInvoiceReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.invoiceReferencedDocument = value;
    }

    /**
     * Gets the value of the additionalReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the additionalReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAdditionalReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the additionalReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getAdditionalReferencedDocument() {
        if (additionalReferencedDocument == null) {
            additionalReferencedDocument = new ArrayList<>();
        }
        return this.additionalReferencedDocument;
    }

    /**
     * Gets the value of the payableSpecifiedTradeAccountingAccount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the payableSpecifiedTradeAccountingAccount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPayableSpecifiedTradeAccountingAccount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeAccountingAccountType }
     * 
     * 
     * @return
     *     The value of the payableSpecifiedTradeAccountingAccount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeAccountingAccountType> getPayableSpecifiedTradeAccountingAccount() {
        if (payableSpecifiedTradeAccountingAccount == null) {
            payableSpecifiedTradeAccountingAccount = new ArrayList<>();
        }
        return this.payableSpecifiedTradeAccountingAccount;
    }

    /**
     * Gets the value of the receivableSpecifiedTradeAccountingAccount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the receivableSpecifiedTradeAccountingAccount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getReceivableSpecifiedTradeAccountingAccount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeAccountingAccountType }
     * 
     * 
     * @return
     *     The value of the receivableSpecifiedTradeAccountingAccount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeAccountingAccountType> getReceivableSpecifiedTradeAccountingAccount() {
        if (receivableSpecifiedTradeAccountingAccount == null) {
            receivableSpecifiedTradeAccountingAccount = new ArrayList<>();
        }
        return this.receivableSpecifiedTradeAccountingAccount;
    }

    /**
     * Gets the value of the purchaseSpecifiedTradeAccountingAccount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the purchaseSpecifiedTradeAccountingAccount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPurchaseSpecifiedTradeAccountingAccount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeAccountingAccountType }
     * 
     * 
     * @return
     *     The value of the purchaseSpecifiedTradeAccountingAccount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeAccountingAccountType> getPurchaseSpecifiedTradeAccountingAccount() {
        if (purchaseSpecifiedTradeAccountingAccount == null) {
            purchaseSpecifiedTradeAccountingAccount = new ArrayList<>();
        }
        return this.purchaseSpecifiedTradeAccountingAccount;
    }

    /**
     * Gets the value of the salesSpecifiedTradeAccountingAccount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the salesSpecifiedTradeAccountingAccount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSalesSpecifiedTradeAccountingAccount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeAccountingAccountType }
     * 
     * 
     * @return
     *     The value of the salesSpecifiedTradeAccountingAccount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeAccountingAccountType> getSalesSpecifiedTradeAccountingAccount() {
        if (salesSpecifiedTradeAccountingAccount == null) {
            salesSpecifiedTradeAccountingAccount = new ArrayList<>();
        }
        return this.salesSpecifiedTradeAccountingAccount;
    }

    /**
     * Gets the value of the specifiedTradeSettlementFinancialCard property.
     * 
     * @return
     *     possible object is
     *     {@link TradeSettlementFinancialCardType }
     *     
     */
    @Nullable
    public TradeSettlementFinancialCardType getSpecifiedTradeSettlementFinancialCard() {
        return specifiedTradeSettlementFinancialCard;
    }

    /**
     * Sets the value of the specifiedTradeSettlementFinancialCard property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeSettlementFinancialCardType }
     *     
     */
    public void setSpecifiedTradeSettlementFinancialCard(
        @Nullable
        TradeSettlementFinancialCardType value) {
        this.specifiedTradeSettlementFinancialCard = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final LineTradeSettlementType rhs = ((LineTradeSettlementType) o);
        if (!EqualsHelper.equalsCollection(additionalReferencedDocument, rhs.additionalReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(applicableTradeTax, rhs.applicableTradeTax)) {
            return false;
        }
        if (!EqualsHelper.equals(billingSpecifiedPeriod, rhs.billingSpecifiedPeriod)) {
            return false;
        }
        if (!EqualsHelper.equals(discountIndicator, rhs.discountIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(invoiceIssuerReference, rhs.invoiceIssuerReference)) {
            return false;
        }
        if (!EqualsHelper.equals(invoiceReferencedDocument, rhs.invoiceReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(payableSpecifiedTradeAccountingAccount, rhs.payableSpecifiedTradeAccountingAccount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(paymentReference, rhs.paymentReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(purchaseSpecifiedTradeAccountingAccount, rhs.purchaseSpecifiedTradeAccountingAccount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(receivableSpecifiedTradeAccountingAccount, rhs.receivableSpecifiedTradeAccountingAccount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(salesSpecifiedTradeAccountingAccount, rhs.salesSpecifiedTradeAccountingAccount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(specifiedFinancialAdjustment, rhs.specifiedFinancialAdjustment)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(specifiedLogisticsServiceCharge, rhs.specifiedLogisticsServiceCharge)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(specifiedTradeAllowanceCharge, rhs.specifiedTradeAllowanceCharge)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(specifiedTradePaymentTerms, rhs.specifiedTradePaymentTerms)) {
            return false;
        }
        if (!EqualsHelper.equals(specifiedTradeSettlementFinancialCard, rhs.specifiedTradeSettlementFinancialCard)) {
            return false;
        }
        if (!EqualsHelper.equals(specifiedTradeSettlementLineMonetarySummation, rhs.specifiedTradeSettlementLineMonetarySummation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(subtotalCalculatedTradeTax, rhs.subtotalCalculatedTradeTax)) {
            return false;
        }
        if (!EqualsHelper.equals(totalAdjustmentAmount, rhs.totalAdjustmentAmount)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalReferencedDocument).append(applicableTradeTax).append(billingSpecifiedPeriod).append(discountIndicator).append(invoiceIssuerReference).append(invoiceReferencedDocument).append(payableSpecifiedTradeAccountingAccount).append(paymentReference).append(purchaseSpecifiedTradeAccountingAccount).append(receivableSpecifiedTradeAccountingAccount).append(salesSpecifiedTradeAccountingAccount).append(specifiedFinancialAdjustment).append(specifiedLogisticsServiceCharge).append(specifiedTradeAllowanceCharge).append(specifiedTradePaymentTerms).append(specifiedTradeSettlementFinancialCard).append(specifiedTradeSettlementLineMonetarySummation).append(subtotalCalculatedTradeTax).append(totalAdjustmentAmount).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalReferencedDocument", additionalReferencedDocument).append("applicableTradeTax", applicableTradeTax).append("billingSpecifiedPeriod", billingSpecifiedPeriod).append("discountIndicator", discountIndicator).append("invoiceIssuerReference", invoiceIssuerReference).append("invoiceReferencedDocument", invoiceReferencedDocument).append("payableSpecifiedTradeAccountingAccount", payableSpecifiedTradeAccountingAccount).append("paymentReference", paymentReference).append("purchaseSpecifiedTradeAccountingAccount", purchaseSpecifiedTradeAccountingAccount).append("receivableSpecifiedTradeAccountingAccount", receivableSpecifiedTradeAccountingAccount).append("salesSpecifiedTradeAccountingAccount", salesSpecifiedTradeAccountingAccount).append("specifiedFinancialAdjustment", specifiedFinancialAdjustment).append("specifiedLogisticsServiceCharge", specifiedLogisticsServiceCharge).append("specifiedTradeAllowanceCharge", specifiedTradeAllowanceCharge).append("specifiedTradePaymentTerms", specifiedTradePaymentTerms).append("specifiedTradeSettlementFinancialCard", specifiedTradeSettlementFinancialCard).append("specifiedTradeSettlementLineMonetarySummation", specifiedTradeSettlementLineMonetarySummation).append("subtotalCalculatedTradeTax", subtotalCalculatedTradeTax).append("totalAdjustmentAmount", totalAdjustmentAmount).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPaymentReference(
        @Nullable
        final List<TextType> aList) {
        paymentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setApplicableTradeTax(
        @Nullable
        final List<TradeTaxType> aList) {
        applicableTradeTax = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpecifiedTradeAllowanceCharge(
        @Nullable
        final List<TradeAllowanceChargeType> aList) {
        specifiedTradeAllowanceCharge = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSubtotalCalculatedTradeTax(
        @Nullable
        final List<TradeTaxType> aList) {
        subtotalCalculatedTradeTax = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpecifiedLogisticsServiceCharge(
        @Nullable
        final List<LogisticsServiceChargeType> aList) {
        specifiedLogisticsServiceCharge = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpecifiedTradePaymentTerms(
        @Nullable
        final List<TradePaymentTermsType> aList) {
        specifiedTradePaymentTerms = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpecifiedFinancialAdjustment(
        @Nullable
        final List<FinancialAdjustmentType> aList) {
        specifiedFinancialAdjustment = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        additionalReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPayableSpecifiedTradeAccountingAccount(
        @Nullable
        final List<TradeAccountingAccountType> aList) {
        payableSpecifiedTradeAccountingAccount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setReceivableSpecifiedTradeAccountingAccount(
        @Nullable
        final List<TradeAccountingAccountType> aList) {
        receivableSpecifiedTradeAccountingAccount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPurchaseSpecifiedTradeAccountingAccount(
        @Nullable
        final List<TradeAccountingAccountType> aList) {
        purchaseSpecifiedTradeAccountingAccount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSalesSpecifiedTradeAccountingAccount(
        @Nullable
        final List<TradeAccountingAccountType> aList) {
        salesSpecifiedTradeAccountingAccount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPaymentReferenceEntries() {
        return (!getPaymentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPaymentReferenceEntries() {
        return getPaymentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPaymentReferenceCount() {
        return getPaymentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getPaymentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPaymentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPaymentReference(
        @Nonnull
        final TextType elem) {
        getPaymentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasApplicableTradeTaxEntries() {
        return (!getApplicableTradeTax().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoApplicableTradeTaxEntries() {
        return getApplicableTradeTax().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getApplicableTradeTaxCount() {
        return getApplicableTradeTax().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeTaxType getApplicableTradeTaxAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getApplicableTradeTax().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addApplicableTradeTax(
        @Nonnull
        final TradeTaxType elem) {
        getApplicableTradeTax().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpecifiedTradeAllowanceChargeEntries() {
        return (!getSpecifiedTradeAllowanceCharge().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpecifiedTradeAllowanceChargeEntries() {
        return getSpecifiedTradeAllowanceCharge().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpecifiedTradeAllowanceChargeCount() {
        return getSpecifiedTradeAllowanceCharge().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeAllowanceChargeType getSpecifiedTradeAllowanceChargeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpecifiedTradeAllowanceCharge().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpecifiedTradeAllowanceCharge(
        @Nonnull
        final TradeAllowanceChargeType elem) {
        getSpecifiedTradeAllowanceCharge().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSubtotalCalculatedTradeTaxEntries() {
        return (!getSubtotalCalculatedTradeTax().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSubtotalCalculatedTradeTaxEntries() {
        return getSubtotalCalculatedTradeTax().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSubtotalCalculatedTradeTaxCount() {
        return getSubtotalCalculatedTradeTax().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeTaxType getSubtotalCalculatedTradeTaxAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSubtotalCalculatedTradeTax().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSubtotalCalculatedTradeTax(
        @Nonnull
        final TradeTaxType elem) {
        getSubtotalCalculatedTradeTax().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpecifiedLogisticsServiceChargeEntries() {
        return (!getSpecifiedLogisticsServiceCharge().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpecifiedLogisticsServiceChargeEntries() {
        return getSpecifiedLogisticsServiceCharge().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpecifiedLogisticsServiceChargeCount() {
        return getSpecifiedLogisticsServiceCharge().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LogisticsServiceChargeType getSpecifiedLogisticsServiceChargeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpecifiedLogisticsServiceCharge().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpecifiedLogisticsServiceCharge(
        @Nonnull
        final LogisticsServiceChargeType elem) {
        getSpecifiedLogisticsServiceCharge().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpecifiedTradePaymentTermsEntries() {
        return (!getSpecifiedTradePaymentTerms().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpecifiedTradePaymentTermsEntries() {
        return getSpecifiedTradePaymentTerms().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpecifiedTradePaymentTermsCount() {
        return getSpecifiedTradePaymentTerms().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradePaymentTermsType getSpecifiedTradePaymentTermsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpecifiedTradePaymentTerms().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpecifiedTradePaymentTerms(
        @Nonnull
        final TradePaymentTermsType elem) {
        getSpecifiedTradePaymentTerms().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpecifiedFinancialAdjustmentEntries() {
        return (!getSpecifiedFinancialAdjustment().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpecifiedFinancialAdjustmentEntries() {
        return getSpecifiedFinancialAdjustment().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpecifiedFinancialAdjustmentCount() {
        return getSpecifiedFinancialAdjustment().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FinancialAdjustmentType getSpecifiedFinancialAdjustmentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpecifiedFinancialAdjustment().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpecifiedFinancialAdjustment(
        @Nonnull
        final FinancialAdjustmentType elem) {
        getSpecifiedFinancialAdjustment().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalReferencedDocumentEntries() {
        return (!getAdditionalReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalReferencedDocumentEntries() {
        return getAdditionalReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalReferencedDocumentCount() {
        return getAdditionalReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getAdditionalReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getAdditionalReferencedDocument().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPayableSpecifiedTradeAccountingAccountEntries() {
        return (!getPayableSpecifiedTradeAccountingAccount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPayableSpecifiedTradeAccountingAccountEntries() {
        return getPayableSpecifiedTradeAccountingAccount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPayableSpecifiedTradeAccountingAccountCount() {
        return getPayableSpecifiedTradeAccountingAccount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeAccountingAccountType getPayableSpecifiedTradeAccountingAccountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPayableSpecifiedTradeAccountingAccount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPayableSpecifiedTradeAccountingAccount(
        @Nonnull
        final TradeAccountingAccountType elem) {
        getPayableSpecifiedTradeAccountingAccount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasReceivableSpecifiedTradeAccountingAccountEntries() {
        return (!getReceivableSpecifiedTradeAccountingAccount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoReceivableSpecifiedTradeAccountingAccountEntries() {
        return getReceivableSpecifiedTradeAccountingAccount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getReceivableSpecifiedTradeAccountingAccountCount() {
        return getReceivableSpecifiedTradeAccountingAccount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeAccountingAccountType getReceivableSpecifiedTradeAccountingAccountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getReceivableSpecifiedTradeAccountingAccount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addReceivableSpecifiedTradeAccountingAccount(
        @Nonnull
        final TradeAccountingAccountType elem) {
        getReceivableSpecifiedTradeAccountingAccount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPurchaseSpecifiedTradeAccountingAccountEntries() {
        return (!getPurchaseSpecifiedTradeAccountingAccount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPurchaseSpecifiedTradeAccountingAccountEntries() {
        return getPurchaseSpecifiedTradeAccountingAccount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPurchaseSpecifiedTradeAccountingAccountCount() {
        return getPurchaseSpecifiedTradeAccountingAccount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeAccountingAccountType getPurchaseSpecifiedTradeAccountingAccountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPurchaseSpecifiedTradeAccountingAccount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPurchaseSpecifiedTradeAccountingAccount(
        @Nonnull
        final TradeAccountingAccountType elem) {
        getPurchaseSpecifiedTradeAccountingAccount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSalesSpecifiedTradeAccountingAccountEntries() {
        return (!getSalesSpecifiedTradeAccountingAccount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSalesSpecifiedTradeAccountingAccountEntries() {
        return getSalesSpecifiedTradeAccountingAccount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSalesSpecifiedTradeAccountingAccountCount() {
        return getSalesSpecifiedTradeAccountingAccount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeAccountingAccountType getSalesSpecifiedTradeAccountingAccountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSalesSpecifiedTradeAccountingAccount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSalesSpecifiedTradeAccountingAccount(
        @Nonnull
        final TradeAccountingAccountType elem) {
        getSalesSpecifiedTradeAccountingAccount().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        LineTradeSettlementType ret) {
        if (additionalReferencedDocument == null) {
            ret.additionalReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retAdditionalReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getAdditionalReferencedDocument()) {
                retAdditionalReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalReferencedDocument = retAdditionalReferencedDocument;
        }
        if (applicableTradeTax == null) {
            ret.applicableTradeTax = null;
        } else {
            List<TradeTaxType> retApplicableTradeTax = new ArrayList<>();
            for (TradeTaxType aItem: getApplicableTradeTax()) {
                retApplicableTradeTax.add(((aItem == null)?null:aItem.clone()));
            }
            ret.applicableTradeTax = retApplicableTradeTax;
        }
        ret.billingSpecifiedPeriod = ((billingSpecifiedPeriod == null)?null:billingSpecifiedPeriod.clone());
        ret.discountIndicator = ((discountIndicator == null)?null:discountIndicator.clone());
        ret.invoiceIssuerReference = ((invoiceIssuerReference == null)?null:invoiceIssuerReference.clone());
        ret.invoiceReferencedDocument = ((invoiceReferencedDocument == null)?null:invoiceReferencedDocument.clone());
        if (payableSpecifiedTradeAccountingAccount == null) {
            ret.payableSpecifiedTradeAccountingAccount = null;
        } else {
            List<TradeAccountingAccountType> retPayableSpecifiedTradeAccountingAccount = new ArrayList<>();
            for (TradeAccountingAccountType aItem: getPayableSpecifiedTradeAccountingAccount()) {
                retPayableSpecifiedTradeAccountingAccount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.payableSpecifiedTradeAccountingAccount = retPayableSpecifiedTradeAccountingAccount;
        }
        if (paymentReference == null) {
            ret.paymentReference = null;
        } else {
            List<TextType> retPaymentReference = new ArrayList<>();
            for (TextType aItem: getPaymentReference()) {
                retPaymentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.paymentReference = retPaymentReference;
        }
        if (purchaseSpecifiedTradeAccountingAccount == null) {
            ret.purchaseSpecifiedTradeAccountingAccount = null;
        } else {
            List<TradeAccountingAccountType> retPurchaseSpecifiedTradeAccountingAccount = new ArrayList<>();
            for (TradeAccountingAccountType aItem: getPurchaseSpecifiedTradeAccountingAccount()) {
                retPurchaseSpecifiedTradeAccountingAccount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.purchaseSpecifiedTradeAccountingAccount = retPurchaseSpecifiedTradeAccountingAccount;
        }
        if (receivableSpecifiedTradeAccountingAccount == null) {
            ret.receivableSpecifiedTradeAccountingAccount = null;
        } else {
            List<TradeAccountingAccountType> retReceivableSpecifiedTradeAccountingAccount = new ArrayList<>();
            for (TradeAccountingAccountType aItem: getReceivableSpecifiedTradeAccountingAccount()) {
                retReceivableSpecifiedTradeAccountingAccount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.receivableSpecifiedTradeAccountingAccount = retReceivableSpecifiedTradeAccountingAccount;
        }
        if (salesSpecifiedTradeAccountingAccount == null) {
            ret.salesSpecifiedTradeAccountingAccount = null;
        } else {
            List<TradeAccountingAccountType> retSalesSpecifiedTradeAccountingAccount = new ArrayList<>();
            for (TradeAccountingAccountType aItem: getSalesSpecifiedTradeAccountingAccount()) {
                retSalesSpecifiedTradeAccountingAccount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.salesSpecifiedTradeAccountingAccount = retSalesSpecifiedTradeAccountingAccount;
        }
        if (specifiedFinancialAdjustment == null) {
            ret.specifiedFinancialAdjustment = null;
        } else {
            List<FinancialAdjustmentType> retSpecifiedFinancialAdjustment = new ArrayList<>();
            for (FinancialAdjustmentType aItem: getSpecifiedFinancialAdjustment()) {
                retSpecifiedFinancialAdjustment.add(((aItem == null)?null:aItem.clone()));
            }
            ret.specifiedFinancialAdjustment = retSpecifiedFinancialAdjustment;
        }
        if (specifiedLogisticsServiceCharge == null) {
            ret.specifiedLogisticsServiceCharge = null;
        } else {
            List<LogisticsServiceChargeType> retSpecifiedLogisticsServiceCharge = new ArrayList<>();
            for (LogisticsServiceChargeType aItem: getSpecifiedLogisticsServiceCharge()) {
                retSpecifiedLogisticsServiceCharge.add(((aItem == null)?null:aItem.clone()));
            }
            ret.specifiedLogisticsServiceCharge = retSpecifiedLogisticsServiceCharge;
        }
        if (specifiedTradeAllowanceCharge == null) {
            ret.specifiedTradeAllowanceCharge = null;
        } else {
            List<TradeAllowanceChargeType> retSpecifiedTradeAllowanceCharge = new ArrayList<>();
            for (TradeAllowanceChargeType aItem: getSpecifiedTradeAllowanceCharge()) {
                retSpecifiedTradeAllowanceCharge.add(((aItem == null)?null:aItem.clone()));
            }
            ret.specifiedTradeAllowanceCharge = retSpecifiedTradeAllowanceCharge;
        }
        if (specifiedTradePaymentTerms == null) {
            ret.specifiedTradePaymentTerms = null;
        } else {
            List<TradePaymentTermsType> retSpecifiedTradePaymentTerms = new ArrayList<>();
            for (TradePaymentTermsType aItem: getSpecifiedTradePaymentTerms()) {
                retSpecifiedTradePaymentTerms.add(((aItem == null)?null:aItem.clone()));
            }
            ret.specifiedTradePaymentTerms = retSpecifiedTradePaymentTerms;
        }
        ret.specifiedTradeSettlementFinancialCard = ((specifiedTradeSettlementFinancialCard == null)?null:specifiedTradeSettlementFinancialCard.clone());
        ret.specifiedTradeSettlementLineMonetarySummation = ((specifiedTradeSettlementLineMonetarySummation == null)?null:specifiedTradeSettlementLineMonetarySummation.clone());
        if (subtotalCalculatedTradeTax == null) {
            ret.subtotalCalculatedTradeTax = null;
        } else {
            List<TradeTaxType> retSubtotalCalculatedTradeTax = new ArrayList<>();
            for (TradeTaxType aItem: getSubtotalCalculatedTradeTax()) {
                retSubtotalCalculatedTradeTax.add(((aItem == null)?null:aItem.clone()));
            }
            ret.subtotalCalculatedTradeTax = retSubtotalCalculatedTradeTax;
        }
        ret.totalAdjustmentAmount = ((totalAdjustmentAmount == null)?null:totalAdjustmentAmount.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public LineTradeSettlementType clone() {
        LineTradeSettlementType ret = new LineTradeSettlementType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setInvoiceIssuerReference(
        @Nullable
        final String valueParam) {
        TextType aObj = getInvoiceIssuerReference();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setInvoiceIssuerReference(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setTotalAdjustmentAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getTotalAdjustmentAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setTotalAdjustmentAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getInvoiceIssuerReferenceValue() {
        TextType aObj = getInvoiceIssuerReference();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTotalAdjustmentAmountValue() {
        AmountType aObj = getTotalAdjustmentAmount();
        return (aObj == null)?null:aObj.getValue();
    }

}
