
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.ChargePayingPartyRoleCodeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.FreightChargeTariffClassCodeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.FreightChargeTypeIDType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.LogisticsChargeCalculationBasisCodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for LogisticsServiceChargeType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="LogisticsServiceChargeType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ID" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}FreightChargeTypeIDType" minOccurs="0"/>
 *         <element name="Description" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="PaymentArrangementCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="TariffClassCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}FreightChargeTariffClassCodeType" minOccurs="0"/>
 *         <element name="ChargeCategoryCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="ServiceCategoryCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="DisbursementAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="AppliedAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="AllowanceCharge" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="PayingPartyRoleCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}ChargePayingPartyRoleCodeType" minOccurs="0"/>
 *         <element name="CalculationBasisCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}LogisticsChargeCalculationBasisCodeType" minOccurs="0"/>
 *         <element name="CalculationBasis" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="TransportPaymentMethodCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="PaymentPlaceLogisticsLocation" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}LogisticsLocationType" minOccurs="0"/>
 *         <element name="AppliedFromLogisticsLocation" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}LogisticsLocationType" minOccurs="0"/>
 *         <element name="AppliedToLogisticsLocation" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}LogisticsLocationType" minOccurs="0"/>
 *         <element name="AppliedTradeTax" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradeTaxType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LogisticsServiceChargeType", propOrder = {
    "id",
    "description",
    "paymentArrangementCode",
    "tariffClassCode",
    "chargeCategoryCode",
    "serviceCategoryCode",
    "disbursementAmount",
    "appliedAmount",
    "allowanceCharge",
    "payingPartyRoleCode",
    "calculationBasisCode",
    "calculationBasis",
    "transportPaymentMethodCode",
    "paymentPlaceLogisticsLocation",
    "appliedFromLogisticsLocation",
    "appliedToLogisticsLocation",
    "appliedTradeTax"
})
@CodingStyleguideUnaware
public class LogisticsServiceChargeType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID")
    private FreightChargeTypeIDType id;
    @XmlElement(name = "Description")
    private List<TextType> description;
    @XmlElement(name = "PaymentArrangementCode")
    private CodeType paymentArrangementCode;
    @XmlElement(name = "TariffClassCode")
    private FreightChargeTariffClassCodeType tariffClassCode;
    @XmlElement(name = "ChargeCategoryCode")
    private CodeType chargeCategoryCode;
    @XmlElement(name = "ServiceCategoryCode")
    private CodeType serviceCategoryCode;
    @XmlElement(name = "DisbursementAmount")
    private List<AmountType> disbursementAmount;
    @XmlElement(name = "AppliedAmount")
    private List<AmountType> appliedAmount;
    @XmlElement(name = "AllowanceCharge")
    private TextType allowanceCharge;
    @XmlElement(name = "PayingPartyRoleCode")
    private ChargePayingPartyRoleCodeType payingPartyRoleCode;
    @XmlElement(name = "CalculationBasisCode")
    private LogisticsChargeCalculationBasisCodeType calculationBasisCode;
    @XmlElement(name = "CalculationBasis")
    private TextType calculationBasis;
    @XmlElement(name = "TransportPaymentMethodCode")
    private CodeType transportPaymentMethodCode;
    @XmlElement(name = "PaymentPlaceLogisticsLocation")
    private LogisticsLocationType paymentPlaceLogisticsLocation;
    @XmlElement(name = "AppliedFromLogisticsLocation")
    private LogisticsLocationType appliedFromLogisticsLocation;
    @XmlElement(name = "AppliedToLogisticsLocation")
    private LogisticsLocationType appliedToLogisticsLocation;
    @XmlElement(name = "AppliedTradeTax")
    private List<TradeTaxType> appliedTradeTax;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public LogisticsServiceChargeType() {
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link FreightChargeTypeIDType }
     *     
     */
    @Nullable
    public FreightChargeTypeIDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link FreightChargeTypeIDType }
     *     
     */
    public void setID(
        @Nullable
        FreightChargeTypeIDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the paymentArrangementCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getPaymentArrangementCode() {
        return paymentArrangementCode;
    }

    /**
     * Sets the value of the paymentArrangementCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setPaymentArrangementCode(
        @Nullable
        CodeType value) {
        this.paymentArrangementCode = value;
    }

    /**
     * Gets the value of the tariffClassCode property.
     * 
     * @return
     *     possible object is
     *     {@link FreightChargeTariffClassCodeType }
     *     
     */
    @Nullable
    public FreightChargeTariffClassCodeType getTariffClassCode() {
        return tariffClassCode;
    }

    /**
     * Sets the value of the tariffClassCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link FreightChargeTariffClassCodeType }
     *     
     */
    public void setTariffClassCode(
        @Nullable
        FreightChargeTariffClassCodeType value) {
        this.tariffClassCode = value;
    }

    /**
     * Gets the value of the chargeCategoryCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getChargeCategoryCode() {
        return chargeCategoryCode;
    }

    /**
     * Sets the value of the chargeCategoryCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setChargeCategoryCode(
        @Nullable
        CodeType value) {
        this.chargeCategoryCode = value;
    }

    /**
     * Gets the value of the serviceCategoryCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getServiceCategoryCode() {
        return serviceCategoryCode;
    }

    /**
     * Sets the value of the serviceCategoryCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setServiceCategoryCode(
        @Nullable
        CodeType value) {
        this.serviceCategoryCode = value;
    }

    /**
     * Gets the value of the disbursementAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the disbursementAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDisbursementAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the disbursementAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getDisbursementAmount() {
        if (disbursementAmount == null) {
            disbursementAmount = new ArrayList<>();
        }
        return this.disbursementAmount;
    }

    /**
     * Gets the value of the appliedAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the appliedAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAppliedAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the appliedAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getAppliedAmount() {
        if (appliedAmount == null) {
            appliedAmount = new ArrayList<>();
        }
        return this.appliedAmount;
    }

    /**
     * Gets the value of the allowanceCharge property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getAllowanceCharge() {
        return allowanceCharge;
    }

    /**
     * Sets the value of the allowanceCharge property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setAllowanceCharge(
        @Nullable
        TextType value) {
        this.allowanceCharge = value;
    }

    /**
     * Gets the value of the payingPartyRoleCode property.
     * 
     * @return
     *     possible object is
     *     {@link ChargePayingPartyRoleCodeType }
     *     
     */
    @Nullable
    public ChargePayingPartyRoleCodeType getPayingPartyRoleCode() {
        return payingPartyRoleCode;
    }

    /**
     * Sets the value of the payingPartyRoleCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChargePayingPartyRoleCodeType }
     *     
     */
    public void setPayingPartyRoleCode(
        @Nullable
        ChargePayingPartyRoleCodeType value) {
        this.payingPartyRoleCode = value;
    }

    /**
     * Gets the value of the calculationBasisCode property.
     * 
     * @return
     *     possible object is
     *     {@link LogisticsChargeCalculationBasisCodeType }
     *     
     */
    @Nullable
    public LogisticsChargeCalculationBasisCodeType getCalculationBasisCode() {
        return calculationBasisCode;
    }

    /**
     * Sets the value of the calculationBasisCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link LogisticsChargeCalculationBasisCodeType }
     *     
     */
    public void setCalculationBasisCode(
        @Nullable
        LogisticsChargeCalculationBasisCodeType value) {
        this.calculationBasisCode = value;
    }

    /**
     * Gets the value of the calculationBasis property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getCalculationBasis() {
        return calculationBasis;
    }

    /**
     * Sets the value of the calculationBasis property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setCalculationBasis(
        @Nullable
        TextType value) {
        this.calculationBasis = value;
    }

    /**
     * Gets the value of the transportPaymentMethodCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getTransportPaymentMethodCode() {
        return transportPaymentMethodCode;
    }

    /**
     * Sets the value of the transportPaymentMethodCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setTransportPaymentMethodCode(
        @Nullable
        CodeType value) {
        this.transportPaymentMethodCode = value;
    }

    /**
     * Gets the value of the paymentPlaceLogisticsLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LogisticsLocationType }
     *     
     */
    @Nullable
    public LogisticsLocationType getPaymentPlaceLogisticsLocation() {
        return paymentPlaceLogisticsLocation;
    }

    /**
     * Sets the value of the paymentPlaceLogisticsLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LogisticsLocationType }
     *     
     */
    public void setPaymentPlaceLogisticsLocation(
        @Nullable
        LogisticsLocationType value) {
        this.paymentPlaceLogisticsLocation = value;
    }

    /**
     * Gets the value of the appliedFromLogisticsLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LogisticsLocationType }
     *     
     */
    @Nullable
    public LogisticsLocationType getAppliedFromLogisticsLocation() {
        return appliedFromLogisticsLocation;
    }

    /**
     * Sets the value of the appliedFromLogisticsLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LogisticsLocationType }
     *     
     */
    public void setAppliedFromLogisticsLocation(
        @Nullable
        LogisticsLocationType value) {
        this.appliedFromLogisticsLocation = value;
    }

    /**
     * Gets the value of the appliedToLogisticsLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LogisticsLocationType }
     *     
     */
    @Nullable
    public LogisticsLocationType getAppliedToLogisticsLocation() {
        return appliedToLogisticsLocation;
    }

    /**
     * Sets the value of the appliedToLogisticsLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LogisticsLocationType }
     *     
     */
    public void setAppliedToLogisticsLocation(
        @Nullable
        LogisticsLocationType value) {
        this.appliedToLogisticsLocation = value;
    }

    /**
     * Gets the value of the appliedTradeTax property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the appliedTradeTax property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAppliedTradeTax().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradeTaxType }
     * 
     * 
     * @return
     *     The value of the appliedTradeTax property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradeTaxType> getAppliedTradeTax() {
        if (appliedTradeTax == null) {
            appliedTradeTax = new ArrayList<>();
        }
        return this.appliedTradeTax;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final LogisticsServiceChargeType rhs = ((LogisticsServiceChargeType) o);
        if (!EqualsHelper.equals(allowanceCharge, rhs.allowanceCharge)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(appliedAmount, rhs.appliedAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(appliedFromLogisticsLocation, rhs.appliedFromLogisticsLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(appliedToLogisticsLocation, rhs.appliedToLogisticsLocation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(appliedTradeTax, rhs.appliedTradeTax)) {
            return false;
        }
        if (!EqualsHelper.equals(calculationBasis, rhs.calculationBasis)) {
            return false;
        }
        if (!EqualsHelper.equals(calculationBasisCode, rhs.calculationBasisCode)) {
            return false;
        }
        if (!EqualsHelper.equals(chargeCategoryCode, rhs.chargeCategoryCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(disbursementAmount, rhs.disbursementAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(payingPartyRoleCode, rhs.payingPartyRoleCode)) {
            return false;
        }
        if (!EqualsHelper.equals(paymentArrangementCode, rhs.paymentArrangementCode)) {
            return false;
        }
        if (!EqualsHelper.equals(paymentPlaceLogisticsLocation, rhs.paymentPlaceLogisticsLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(serviceCategoryCode, rhs.serviceCategoryCode)) {
            return false;
        }
        if (!EqualsHelper.equals(tariffClassCode, rhs.tariffClassCode)) {
            return false;
        }
        if (!EqualsHelper.equals(transportPaymentMethodCode, rhs.transportPaymentMethodCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(allowanceCharge).append(appliedAmount).append(appliedFromLogisticsLocation).append(appliedToLogisticsLocation).append(appliedTradeTax).append(calculationBasis).append(calculationBasisCode).append(chargeCategoryCode).append(description).append(disbursementAmount).append(id).append(payingPartyRoleCode).append(paymentArrangementCode).append(paymentPlaceLogisticsLocation).append(serviceCategoryCode).append(tariffClassCode).append(transportPaymentMethodCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("allowanceCharge", allowanceCharge).append("appliedAmount", appliedAmount).append("appliedFromLogisticsLocation", appliedFromLogisticsLocation).append("appliedToLogisticsLocation", appliedToLogisticsLocation).append("appliedTradeTax", appliedTradeTax).append("calculationBasis", calculationBasis).append("calculationBasisCode", calculationBasisCode).append("chargeCategoryCode", chargeCategoryCode).append("description", description).append("disbursementAmount", disbursementAmount).append("id", id).append("payingPartyRoleCode", payingPartyRoleCode).append("paymentArrangementCode", paymentArrangementCode).append("paymentPlaceLogisticsLocation", paymentPlaceLogisticsLocation).append("serviceCategoryCode", serviceCategoryCode).append("tariffClassCode", tariffClassCode).append("transportPaymentMethodCode", transportPaymentMethodCode).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<TextType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDisbursementAmount(
        @Nullable
        final List<AmountType> aList) {
        disbursementAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAppliedAmount(
        @Nullable
        final List<AmountType> aList) {
        appliedAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAppliedTradeTax(
        @Nullable
        final List<TradeTaxType> aList) {
        appliedTradeTax = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final TextType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDisbursementAmountEntries() {
        return (!getDisbursementAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDisbursementAmountEntries() {
        return getDisbursementAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDisbursementAmountCount() {
        return getDisbursementAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getDisbursementAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDisbursementAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDisbursementAmount(
        @Nonnull
        final AmountType elem) {
        getDisbursementAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAppliedAmountEntries() {
        return (!getAppliedAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAppliedAmountEntries() {
        return getAppliedAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAppliedAmountCount() {
        return getAppliedAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getAppliedAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAppliedAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAppliedAmount(
        @Nonnull
        final AmountType elem) {
        getAppliedAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAppliedTradeTaxEntries() {
        return (!getAppliedTradeTax().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAppliedTradeTaxEntries() {
        return getAppliedTradeTax().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAppliedTradeTaxCount() {
        return getAppliedTradeTax().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradeTaxType getAppliedTradeTaxAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAppliedTradeTax().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAppliedTradeTax(
        @Nonnull
        final TradeTaxType elem) {
        getAppliedTradeTax().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        LogisticsServiceChargeType ret) {
        ret.allowanceCharge = ((allowanceCharge == null)?null:allowanceCharge.clone());
        if (appliedAmount == null) {
            ret.appliedAmount = null;
        } else {
            List<AmountType> retAppliedAmount = new ArrayList<>();
            for (AmountType aItem: getAppliedAmount()) {
                retAppliedAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.appliedAmount = retAppliedAmount;
        }
        ret.appliedFromLogisticsLocation = ((appliedFromLogisticsLocation == null)?null:appliedFromLogisticsLocation.clone());
        ret.appliedToLogisticsLocation = ((appliedToLogisticsLocation == null)?null:appliedToLogisticsLocation.clone());
        if (appliedTradeTax == null) {
            ret.appliedTradeTax = null;
        } else {
            List<TradeTaxType> retAppliedTradeTax = new ArrayList<>();
            for (TradeTaxType aItem: getAppliedTradeTax()) {
                retAppliedTradeTax.add(((aItem == null)?null:aItem.clone()));
            }
            ret.appliedTradeTax = retAppliedTradeTax;
        }
        ret.calculationBasis = ((calculationBasis == null)?null:calculationBasis.clone());
        ret.calculationBasisCode = ((calculationBasisCode == null)?null:calculationBasisCode.clone());
        ret.chargeCategoryCode = ((chargeCategoryCode == null)?null:chargeCategoryCode.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<TextType> retDescription = new ArrayList<>();
            for (TextType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        if (disbursementAmount == null) {
            ret.disbursementAmount = null;
        } else {
            List<AmountType> retDisbursementAmount = new ArrayList<>();
            for (AmountType aItem: getDisbursementAmount()) {
                retDisbursementAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.disbursementAmount = retDisbursementAmount;
        }
        ret.id = ((id == null)?null:id.clone());
        ret.payingPartyRoleCode = ((payingPartyRoleCode == null)?null:payingPartyRoleCode.clone());
        ret.paymentArrangementCode = ((paymentArrangementCode == null)?null:paymentArrangementCode.clone());
        ret.paymentPlaceLogisticsLocation = ((paymentPlaceLogisticsLocation == null)?null:paymentPlaceLogisticsLocation.clone());
        ret.serviceCategoryCode = ((serviceCategoryCode == null)?null:serviceCategoryCode.clone());
        ret.tariffClassCode = ((tariffClassCode == null)?null:tariffClassCode.clone());
        ret.transportPaymentMethodCode = ((transportPaymentMethodCode == null)?null:transportPaymentMethodCode.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public LogisticsServiceChargeType clone() {
        LogisticsServiceChargeType ret = new LogisticsServiceChargeType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FreightChargeTypeIDType and never <code>null</code>
     */
    @Nonnull
    public FreightChargeTypeIDType setID(
        @Nullable
        final String valueParam) {
        FreightChargeTypeIDType aObj = getID();
        if (aObj == null) {
            aObj = new FreightChargeTypeIDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setPaymentArrangementCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getPaymentArrangementCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setPaymentArrangementCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FreightChargeTariffClassCodeType and never <code>null</code>
     */
    @Nonnull
    public FreightChargeTariffClassCodeType setTariffClassCode(
        @Nullable
        final String valueParam) {
        FreightChargeTariffClassCodeType aObj = getTariffClassCode();
        if (aObj == null) {
            aObj = new FreightChargeTariffClassCodeType(valueParam);
            setTariffClassCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setChargeCategoryCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getChargeCategoryCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setChargeCategoryCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setServiceCategoryCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getServiceCategoryCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setServiceCategoryCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setAllowanceCharge(
        @Nullable
        final String valueParam) {
        TextType aObj = getAllowanceCharge();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setAllowanceCharge(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ChargePayingPartyRoleCodeType and never <code>null</code>
     */
    @Nonnull
    public ChargePayingPartyRoleCodeType setPayingPartyRoleCode(
        @Nullable
        final String valueParam) {
        ChargePayingPartyRoleCodeType aObj = getPayingPartyRoleCode();
        if (aObj == null) {
            aObj = new ChargePayingPartyRoleCodeType(valueParam);
            setPayingPartyRoleCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LogisticsChargeCalculationBasisCodeType and never <code>null</code>
     */
    @Nonnull
    public LogisticsChargeCalculationBasisCodeType setCalculationBasisCode(
        @Nullable
        final String valueParam) {
        LogisticsChargeCalculationBasisCodeType aObj = getCalculationBasisCode();
        if (aObj == null) {
            aObj = new LogisticsChargeCalculationBasisCodeType(valueParam);
            setCalculationBasisCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setCalculationBasis(
        @Nullable
        final String valueParam) {
        TextType aObj = getCalculationBasis();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setCalculationBasis(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setTransportPaymentMethodCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getTransportPaymentMethodCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setTransportPaymentMethodCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained FreightChargeTypeIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FreightChargeTypeIDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        FreightChargeTypeIDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getPaymentArrangementCodeValue() {
        CodeType aObj = getPaymentArrangementCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FreightChargeTariffClassCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FreightChargeTariffClassCodeType object or <code>null</code>
     */
    @Nullable
    public String getTariffClassCodeValue() {
        FreightChargeTariffClassCodeType aObj = getTariffClassCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getChargeCategoryCodeValue() {
        CodeType aObj = getChargeCategoryCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getServiceCategoryCodeValue() {
        CodeType aObj = getServiceCategoryCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getAllowanceChargeValue() {
        TextType aObj = getAllowanceCharge();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ChargePayingPartyRoleCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ChargePayingPartyRoleCodeType object or <code>null</code>
     */
    @Nullable
    public String getPayingPartyRoleCodeValue() {
        ChargePayingPartyRoleCodeType aObj = getPayingPartyRoleCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LogisticsChargeCalculationBasisCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LogisticsChargeCalculationBasisCodeType object or <code>null</code>
     */
    @Nullable
    public String getCalculationBasisCodeValue() {
        LogisticsChargeCalculationBasisCodeType aObj = getCalculationBasisCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getCalculationBasisValue() {
        TextType aObj = getCalculationBasis();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getTransportPaymentMethodCodeValue() {
        CodeType aObj = getTransportPaymentMethodCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
