
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.TransportModeCodeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.TransportMovementStageCodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for LogisticsTransportMovementType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="LogisticsTransportMovementType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="StageCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}TransportMovementStageCodeType" minOccurs="0"/>
 *         <element name="ModeCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}TransportModeCodeType" minOccurs="0"/>
 *         <element name="Mode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" minOccurs="0"/>
 *         <element name="UsedLogisticsTransportMeans" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}LogisticsTransportMeansType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LogisticsTransportMovementType", propOrder = {
    "stageCode",
    "modeCode",
    "mode",
    "usedLogisticsTransportMeans"
})
@CodingStyleguideUnaware
public class LogisticsTransportMovementType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "StageCode")
    private TransportMovementStageCodeType stageCode;
    @XmlElement(name = "ModeCode")
    private TransportModeCodeType modeCode;
    @XmlElement(name = "Mode")
    private TextType mode;
    @XmlElement(name = "UsedLogisticsTransportMeans")
    private LogisticsTransportMeansType usedLogisticsTransportMeans;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public LogisticsTransportMovementType() {
    }

    /**
     * Gets the value of the stageCode property.
     * 
     * @return
     *     possible object is
     *     {@link TransportMovementStageCodeType }
     *     
     */
    @Nullable
    public TransportMovementStageCodeType getStageCode() {
        return stageCode;
    }

    /**
     * Sets the value of the stageCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportMovementStageCodeType }
     *     
     */
    public void setStageCode(
        @Nullable
        TransportMovementStageCodeType value) {
        this.stageCode = value;
    }

    /**
     * Gets the value of the modeCode property.
     * 
     * @return
     *     possible object is
     *     {@link TransportModeCodeType }
     *     
     */
    @Nullable
    public TransportModeCodeType getModeCode() {
        return modeCode;
    }

    /**
     * Sets the value of the modeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportModeCodeType }
     *     
     */
    public void setModeCode(
        @Nullable
        TransportModeCodeType value) {
        this.modeCode = value;
    }

    /**
     * Gets the value of the mode property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getMode() {
        return mode;
    }

    /**
     * Sets the value of the mode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setMode(
        @Nullable
        TextType value) {
        this.mode = value;
    }

    /**
     * Gets the value of the usedLogisticsTransportMeans property.
     * 
     * @return
     *     possible object is
     *     {@link LogisticsTransportMeansType }
     *     
     */
    @Nullable
    public LogisticsTransportMeansType getUsedLogisticsTransportMeans() {
        return usedLogisticsTransportMeans;
    }

    /**
     * Sets the value of the usedLogisticsTransportMeans property.
     * 
     * @param value
     *     allowed object is
     *     {@link LogisticsTransportMeansType }
     *     
     */
    public void setUsedLogisticsTransportMeans(
        @Nullable
        LogisticsTransportMeansType value) {
        this.usedLogisticsTransportMeans = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final LogisticsTransportMovementType rhs = ((LogisticsTransportMovementType) o);
        if (!EqualsHelper.equals(mode, rhs.mode)) {
            return false;
        }
        if (!EqualsHelper.equals(modeCode, rhs.modeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(stageCode, rhs.stageCode)) {
            return false;
        }
        if (!EqualsHelper.equals(usedLogisticsTransportMeans, rhs.usedLogisticsTransportMeans)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(mode).append(modeCode).append(stageCode).append(usedLogisticsTransportMeans).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("mode", mode).append("modeCode", modeCode).append("stageCode", stageCode).append("usedLogisticsTransportMeans", usedLogisticsTransportMeans).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        LogisticsTransportMovementType ret) {
        ret.mode = ((mode == null)?null:mode.clone());
        ret.modeCode = ((modeCode == null)?null:modeCode.clone());
        ret.stageCode = ((stageCode == null)?null:stageCode.clone());
        ret.usedLogisticsTransportMeans = ((usedLogisticsTransportMeans == null)?null:usedLogisticsTransportMeans.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public LogisticsTransportMovementType clone() {
        LogisticsTransportMovementType ret = new LogisticsTransportMovementType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransportMovementStageCodeType and never <code>null</code>
     */
    @Nonnull
    public TransportMovementStageCodeType setStageCode(
        @Nullable
        final String valueParam) {
        TransportMovementStageCodeType aObj = getStageCode();
        if (aObj == null) {
            aObj = new TransportMovementStageCodeType(valueParam);
            setStageCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransportModeCodeType and never <code>null</code>
     */
    @Nonnull
    public TransportModeCodeType setModeCode(
        @Nullable
        final String valueParam) {
        TransportModeCodeType aObj = getModeCode();
        if (aObj == null) {
            aObj = new TransportModeCodeType(valueParam);
            setModeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setMode(
        @Nullable
        final String valueParam) {
        TextType aObj = getMode();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setMode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained TransportMovementStageCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransportMovementStageCodeType object or <code>null</code>
     */
    @Nullable
    public String getStageCodeValue() {
        TransportMovementStageCodeType aObj = getStageCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TransportModeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransportModeCodeType object or <code>null</code>
     */
    @Nullable
    public String getModeCodeValue() {
        TransportModeCodeType aObj = getModeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getModeValue() {
        TextType aObj = getMode();
        return (aObj == null)?null:aObj.getValue();
    }

}
