
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.AutomaticDataCaptureMethodCodeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.PackagingMarkingCodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.DateTimeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for PackagingMarkingType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="PackagingMarkingType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}PackagingMarkingCodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="Content" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ContentDateTime" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}DateTimeType" minOccurs="0"/>
 *         <element name="ContentAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="BarcodeTypeCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ContentCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="AutomaticDataCaptureMethodTypeCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}AutomaticDataCaptureMethodCodeType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PackagingMarkingType", propOrder = {
    "typeCode",
    "content",
    "contentDateTime",
    "contentAmount",
    "barcodeTypeCode",
    "contentCode",
    "automaticDataCaptureMethodTypeCode"
})
@CodingStyleguideUnaware
public class PackagingMarkingType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "TypeCode")
    private List<PackagingMarkingCodeType> typeCode;
    @XmlElement(name = "Content")
    private List<TextType> content;
    @XmlElement(name = "ContentDateTime")
    private DateTimeType contentDateTime;
    @XmlElement(name = "ContentAmount")
    private List<AmountType> contentAmount;
    @XmlElement(name = "BarcodeTypeCode")
    private List<CodeType> barcodeTypeCode;
    @XmlElement(name = "ContentCode")
    private List<CodeType> contentCode;
    @XmlElement(name = "AutomaticDataCaptureMethodTypeCode")
    private List<AutomaticDataCaptureMethodCodeType> automaticDataCaptureMethodTypeCode;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public PackagingMarkingType() {
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the typeCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTypeCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PackagingMarkingCodeType }
     * 
     * 
     * @return
     *     The value of the typeCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PackagingMarkingCodeType> getTypeCode() {
        if (typeCode == null) {
            typeCode = new ArrayList<>();
        }
        return this.typeCode;
    }

    /**
     * Gets the value of the content property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the content property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the content property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getContent() {
        if (content == null) {
            content = new ArrayList<>();
        }
        return this.content;
    }

    /**
     * Gets the value of the contentDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link DateTimeType }
     *     
     */
    @Nullable
    public DateTimeType getContentDateTime() {
        return contentDateTime;
    }

    /**
     * Sets the value of the contentDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateTimeType }
     *     
     */
    public void setContentDateTime(
        @Nullable
        DateTimeType value) {
        this.contentDateTime = value;
    }

    /**
     * Gets the value of the contentAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the contentAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContentAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the contentAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getContentAmount() {
        if (contentAmount == null) {
            contentAmount = new ArrayList<>();
        }
        return this.contentAmount;
    }

    /**
     * Gets the value of the barcodeTypeCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the barcodeTypeCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBarcodeTypeCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the barcodeTypeCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getBarcodeTypeCode() {
        if (barcodeTypeCode == null) {
            barcodeTypeCode = new ArrayList<>();
        }
        return this.barcodeTypeCode;
    }

    /**
     * Gets the value of the contentCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the contentCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContentCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     * @return
     *     The value of the contentCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getContentCode() {
        if (contentCode == null) {
            contentCode = new ArrayList<>();
        }
        return this.contentCode;
    }

    /**
     * Gets the value of the automaticDataCaptureMethodTypeCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the automaticDataCaptureMethodTypeCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAutomaticDataCaptureMethodTypeCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AutomaticDataCaptureMethodCodeType }
     * 
     * 
     * @return
     *     The value of the automaticDataCaptureMethodTypeCode property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AutomaticDataCaptureMethodCodeType> getAutomaticDataCaptureMethodTypeCode() {
        if (automaticDataCaptureMethodTypeCode == null) {
            automaticDataCaptureMethodTypeCode = new ArrayList<>();
        }
        return this.automaticDataCaptureMethodTypeCode;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PackagingMarkingType rhs = ((PackagingMarkingType) o);
        if (!EqualsHelper.equalsCollection(automaticDataCaptureMethodTypeCode, rhs.automaticDataCaptureMethodTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(barcodeTypeCode, rhs.barcodeTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(content, rhs.content)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(contentAmount, rhs.contentAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(contentCode, rhs.contentCode)) {
            return false;
        }
        if (!EqualsHelper.equals(contentDateTime, rhs.contentDateTime)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(typeCode, rhs.typeCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(automaticDataCaptureMethodTypeCode).append(barcodeTypeCode).append(content).append(contentAmount).append(contentCode).append(contentDateTime).append(typeCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("automaticDataCaptureMethodTypeCode", automaticDataCaptureMethodTypeCode).append("barcodeTypeCode", barcodeTypeCode).append("content", content).append("contentAmount", contentAmount).append("contentCode", contentCode).append("contentDateTime", contentDateTime).append("typeCode", typeCode).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTypeCode(
        @Nullable
        final List<PackagingMarkingCodeType> aList) {
        typeCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setContent(
        @Nullable
        final List<TextType> aList) {
        content = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setContentAmount(
        @Nullable
        final List<AmountType> aList) {
        contentAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setBarcodeTypeCode(
        @Nullable
        final List<CodeType> aList) {
        barcodeTypeCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setContentCode(
        @Nullable
        final List<CodeType> aList) {
        contentCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAutomaticDataCaptureMethodTypeCode(
        @Nullable
        final List<AutomaticDataCaptureMethodCodeType> aList) {
        automaticDataCaptureMethodTypeCode = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTypeCodeEntries() {
        return (!getTypeCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTypeCodeEntries() {
        return getTypeCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTypeCodeCount() {
        return getTypeCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PackagingMarkingCodeType getTypeCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTypeCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTypeCode(
        @Nonnull
        final PackagingMarkingCodeType elem) {
        getTypeCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasContentEntries() {
        return (!getContent().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoContentEntries() {
        return getContent().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getContentCount() {
        return getContent().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getContentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getContent().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addContent(
        @Nonnull
        final TextType elem) {
        getContent().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasContentAmountEntries() {
        return (!getContentAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoContentAmountEntries() {
        return getContentAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getContentAmountCount() {
        return getContentAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getContentAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getContentAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addContentAmount(
        @Nonnull
        final AmountType elem) {
        getContentAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasBarcodeTypeCodeEntries() {
        return (!getBarcodeTypeCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoBarcodeTypeCodeEntries() {
        return getBarcodeTypeCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getBarcodeTypeCodeCount() {
        return getBarcodeTypeCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getBarcodeTypeCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getBarcodeTypeCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addBarcodeTypeCode(
        @Nonnull
        final CodeType elem) {
        getBarcodeTypeCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasContentCodeEntries() {
        return (!getContentCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoContentCodeEntries() {
        return getContentCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getContentCodeCount() {
        return getContentCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getContentCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getContentCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addContentCode(
        @Nonnull
        final CodeType elem) {
        getContentCode().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAutomaticDataCaptureMethodTypeCodeEntries() {
        return (!getAutomaticDataCaptureMethodTypeCode().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAutomaticDataCaptureMethodTypeCodeEntries() {
        return getAutomaticDataCaptureMethodTypeCode().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAutomaticDataCaptureMethodTypeCodeCount() {
        return getAutomaticDataCaptureMethodTypeCode().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AutomaticDataCaptureMethodCodeType getAutomaticDataCaptureMethodTypeCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAutomaticDataCaptureMethodTypeCode().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAutomaticDataCaptureMethodTypeCode(
        @Nonnull
        final AutomaticDataCaptureMethodCodeType elem) {
        getAutomaticDataCaptureMethodTypeCode().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PackagingMarkingType ret) {
        if (automaticDataCaptureMethodTypeCode == null) {
            ret.automaticDataCaptureMethodTypeCode = null;
        } else {
            List<AutomaticDataCaptureMethodCodeType> retAutomaticDataCaptureMethodTypeCode = new ArrayList<>();
            for (AutomaticDataCaptureMethodCodeType aItem: getAutomaticDataCaptureMethodTypeCode()) {
                retAutomaticDataCaptureMethodTypeCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.automaticDataCaptureMethodTypeCode = retAutomaticDataCaptureMethodTypeCode;
        }
        if (barcodeTypeCode == null) {
            ret.barcodeTypeCode = null;
        } else {
            List<CodeType> retBarcodeTypeCode = new ArrayList<>();
            for (CodeType aItem: getBarcodeTypeCode()) {
                retBarcodeTypeCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.barcodeTypeCode = retBarcodeTypeCode;
        }
        if (content == null) {
            ret.content = null;
        } else {
            List<TextType> retContent = new ArrayList<>();
            for (TextType aItem: getContent()) {
                retContent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.content = retContent;
        }
        if (contentAmount == null) {
            ret.contentAmount = null;
        } else {
            List<AmountType> retContentAmount = new ArrayList<>();
            for (AmountType aItem: getContentAmount()) {
                retContentAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.contentAmount = retContentAmount;
        }
        if (contentCode == null) {
            ret.contentCode = null;
        } else {
            List<CodeType> retContentCode = new ArrayList<>();
            for (CodeType aItem: getContentCode()) {
                retContentCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.contentCode = retContentCode;
        }
        ret.contentDateTime = ((contentDateTime == null)?null:contentDateTime.clone());
        if (typeCode == null) {
            ret.typeCode = null;
        } else {
            List<PackagingMarkingCodeType> retTypeCode = new ArrayList<>();
            for (PackagingMarkingCodeType aItem: getTypeCode()) {
                retTypeCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.typeCode = retTypeCode;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PackagingMarkingType clone() {
        PackagingMarkingType ret = new PackagingMarkingType();
        cloneTo(ret);
        return ret;
    }

}
