
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IndicatorType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;


/**
 * <p>Java class for ReferencePriceType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ReferencePriceType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ChargeAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" minOccurs="0"/>
 *         <element name="BasisQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="NetPriceIndicator" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IndicatorType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ComparisonMethodCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ReferencePriceType", propOrder = {
    "chargeAmount",
    "basisQuantity",
    "netPriceIndicator",
    "comparisonMethodCode"
})
@CodingStyleguideUnaware
public class ReferencePriceType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ChargeAmount")
    private AmountType chargeAmount;
    @XmlElement(name = "BasisQuantity")
    private List<QuantityType> basisQuantity;
    @XmlElement(name = "NetPriceIndicator")
    private List<IndicatorType> netPriceIndicator;
    @XmlElement(name = "ComparisonMethodCode")
    private CodeType comparisonMethodCode;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ReferencePriceType() {
    }

    /**
     * Gets the value of the chargeAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getChargeAmount() {
        return chargeAmount;
    }

    /**
     * Sets the value of the chargeAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setChargeAmount(
        @Nullable
        AmountType value) {
        this.chargeAmount = value;
    }

    /**
     * Gets the value of the basisQuantity property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the basisQuantity property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBasisQuantity().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link QuantityType }
     * 
     * 
     * @return
     *     The value of the basisQuantity property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<QuantityType> getBasisQuantity() {
        if (basisQuantity == null) {
            basisQuantity = new ArrayList<>();
        }
        return this.basisQuantity;
    }

    /**
     * Gets the value of the netPriceIndicator property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the netPriceIndicator property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNetPriceIndicator().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IndicatorType }
     * 
     * 
     * @return
     *     The value of the netPriceIndicator property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IndicatorType> getNetPriceIndicator() {
        if (netPriceIndicator == null) {
            netPriceIndicator = new ArrayList<>();
        }
        return this.netPriceIndicator;
    }

    /**
     * Gets the value of the comparisonMethodCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getComparisonMethodCode() {
        return comparisonMethodCode;
    }

    /**
     * Sets the value of the comparisonMethodCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setComparisonMethodCode(
        @Nullable
        CodeType value) {
        this.comparisonMethodCode = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ReferencePriceType rhs = ((ReferencePriceType) o);
        if (!EqualsHelper.equalsCollection(basisQuantity, rhs.basisQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(chargeAmount, rhs.chargeAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(comparisonMethodCode, rhs.comparisonMethodCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(netPriceIndicator, rhs.netPriceIndicator)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(basisQuantity).append(chargeAmount).append(comparisonMethodCode).append(netPriceIndicator).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("basisQuantity", basisQuantity).append("chargeAmount", chargeAmount).append("comparisonMethodCode", comparisonMethodCode).append("netPriceIndicator", netPriceIndicator).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setBasisQuantity(
        @Nullable
        final List<QuantityType> aList) {
        basisQuantity = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNetPriceIndicator(
        @Nullable
        final List<IndicatorType> aList) {
        netPriceIndicator = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasBasisQuantityEntries() {
        return (!getBasisQuantity().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoBasisQuantityEntries() {
        return getBasisQuantity().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getBasisQuantityCount() {
        return getBasisQuantity().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public QuantityType getBasisQuantityAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getBasisQuantity().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addBasisQuantity(
        @Nonnull
        final QuantityType elem) {
        getBasisQuantity().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNetPriceIndicatorEntries() {
        return (!getNetPriceIndicator().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNetPriceIndicatorEntries() {
        return getNetPriceIndicator().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNetPriceIndicatorCount() {
        return getNetPriceIndicator().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IndicatorType getNetPriceIndicatorAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNetPriceIndicator().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNetPriceIndicator(
        @Nonnull
        final IndicatorType elem) {
        getNetPriceIndicator().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ReferencePriceType ret) {
        if (basisQuantity == null) {
            ret.basisQuantity = null;
        } else {
            List<QuantityType> retBasisQuantity = new ArrayList<>();
            for (QuantityType aItem: getBasisQuantity()) {
                retBasisQuantity.add(((aItem == null)?null:aItem.clone()));
            }
            ret.basisQuantity = retBasisQuantity;
        }
        ret.chargeAmount = ((chargeAmount == null)?null:chargeAmount.clone());
        ret.comparisonMethodCode = ((comparisonMethodCode == null)?null:comparisonMethodCode.clone());
        if (netPriceIndicator == null) {
            ret.netPriceIndicator = null;
        } else {
            List<IndicatorType> retNetPriceIndicator = new ArrayList<>();
            for (IndicatorType aItem: getNetPriceIndicator()) {
                retNetPriceIndicator.add(((aItem == null)?null:aItem.clone()));
            }
            ret.netPriceIndicator = retNetPriceIndicator;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ReferencePriceType clone() {
        ReferencePriceType ret = new ReferencePriceType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setChargeAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getChargeAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setChargeAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setComparisonMethodCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getComparisonMethodCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setComparisonMethodCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getChargeAmountValue() {
        AmountType aObj = getChargeAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getComparisonMethodCodeValue() {
        CodeType aObj = getComparisonMethodCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
