
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.DocumentCodeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.DocumentStatusCodeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.FormattedDateTimeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.ReferenceCodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.BinaryObjectType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IndicatorType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for ReferencedDocumentType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ReferencedDocumentType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="IssuerAssignedID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="URIID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="StatusCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}DocumentStatusCodeType" minOccurs="0"/>
 *         <element name="CopyIndicator" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IndicatorType" minOccurs="0"/>
 *         <element name="LineID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}DocumentCodeType" minOccurs="0"/>
 *         <element name="GlobalID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="RevisionID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" minOccurs="0"/>
 *         <element name="Name" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="AttachmentBinaryObject" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}BinaryObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="Information" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="ReferenceTypeCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}ReferenceCodeType" minOccurs="0"/>
 *         <element name="SectionName" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="PreviousRevisionID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="FormattedIssueDateTime" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}FormattedDateTimeType" minOccurs="0"/>
 *         <element name="EffectiveSpecifiedPeriod" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpecifiedPeriodType" minOccurs="0"/>
 *         <element name="IssuerTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="AttachedSpecifiedBinaryFile" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpecifiedBinaryFileType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ReferencedDocumentType", propOrder = {
    "issuerAssignedID",
    "uriid",
    "statusCode",
    "copyIndicator",
    "lineID",
    "typeCode",
    "globalID",
    "revisionID",
    "name",
    "attachmentBinaryObject",
    "information",
    "referenceTypeCode",
    "sectionName",
    "previousRevisionID",
    "formattedIssueDateTime",
    "effectiveSpecifiedPeriod",
    "issuerTradeParty",
    "attachedSpecifiedBinaryFile"
})
@CodingStyleguideUnaware
public class ReferencedDocumentType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "IssuerAssignedID")
    private IDType issuerAssignedID;
    @XmlElement(name = "URIID")
    private IDType uriid;
    @XmlElement(name = "StatusCode")
    private DocumentStatusCodeType statusCode;
    @XmlElement(name = "CopyIndicator")
    private IndicatorType copyIndicator;
    @XmlElement(name = "LineID")
    private IDType lineID;
    @XmlElement(name = "TypeCode")
    private DocumentCodeType typeCode;
    @XmlElement(name = "GlobalID")
    private IDType globalID;
    @XmlElement(name = "RevisionID")
    private IDType revisionID;
    @XmlElement(name = "Name")
    private List<TextType> name;
    @XmlElement(name = "AttachmentBinaryObject")
    private List<BinaryObjectType> attachmentBinaryObject;
    @XmlElement(name = "Information")
    private List<TextType> information;
    @XmlElement(name = "ReferenceTypeCode")
    private ReferenceCodeType referenceTypeCode;
    @XmlElement(name = "SectionName")
    private List<TextType> sectionName;
    @XmlElement(name = "PreviousRevisionID")
    private List<IDType> previousRevisionID;
    @XmlElement(name = "FormattedIssueDateTime")
    private FormattedDateTimeType formattedIssueDateTime;
    @XmlElement(name = "EffectiveSpecifiedPeriod")
    private SpecifiedPeriodType effectiveSpecifiedPeriod;
    @XmlElement(name = "IssuerTradeParty")
    private TradePartyType issuerTradeParty;
    @XmlElement(name = "AttachedSpecifiedBinaryFile")
    private List<SpecifiedBinaryFileType> attachedSpecifiedBinaryFile;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ReferencedDocumentType() {
    }

    /**
     * Gets the value of the issuerAssignedID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getIssuerAssignedID() {
        return issuerAssignedID;
    }

    /**
     * Sets the value of the issuerAssignedID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setIssuerAssignedID(
        @Nullable
        IDType value) {
        this.issuerAssignedID = value;
    }

    /**
     * Gets the value of the uriid property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getURIID() {
        return uriid;
    }

    /**
     * Sets the value of the uriid property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setURIID(
        @Nullable
        IDType value) {
        this.uriid = value;
    }

    /**
     * Gets the value of the statusCode property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentStatusCodeType }
     *     
     */
    @Nullable
    public DocumentStatusCodeType getStatusCode() {
        return statusCode;
    }

    /**
     * Sets the value of the statusCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentStatusCodeType }
     *     
     */
    public void setStatusCode(
        @Nullable
        DocumentStatusCodeType value) {
        this.statusCode = value;
    }

    /**
     * Gets the value of the copyIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link IndicatorType }
     *     
     */
    @Nullable
    public IndicatorType getCopyIndicator() {
        return copyIndicator;
    }

    /**
     * Sets the value of the copyIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link IndicatorType }
     *     
     */
    public void setCopyIndicator(
        @Nullable
        IndicatorType value) {
        this.copyIndicator = value;
    }

    /**
     * Gets the value of the lineID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getLineID() {
        return lineID;
    }

    /**
     * Sets the value of the lineID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setLineID(
        @Nullable
        IDType value) {
        this.lineID = value;
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * @return
     *     possible object is
     *     {@link DocumentCodeType }
     *     
     */
    @Nullable
    public DocumentCodeType getTypeCode() {
        return typeCode;
    }

    /**
     * Sets the value of the typeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link DocumentCodeType }
     *     
     */
    public void setTypeCode(
        @Nullable
        DocumentCodeType value) {
        this.typeCode = value;
    }

    /**
     * Gets the value of the globalID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getGlobalID() {
        return globalID;
    }

    /**
     * Sets the value of the globalID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setGlobalID(
        @Nullable
        IDType value) {
        this.globalID = value;
    }

    /**
     * Gets the value of the revisionID property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getRevisionID() {
        return revisionID;
    }

    /**
     * Sets the value of the revisionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setRevisionID(
        @Nullable
        IDType value) {
        this.revisionID = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the name property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the name property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getName() {
        if (name == null) {
            name = new ArrayList<>();
        }
        return this.name;
    }

    /**
     * Gets the value of the attachmentBinaryObject property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the attachmentBinaryObject property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttachmentBinaryObject().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BinaryObjectType }
     * 
     * 
     * @return
     *     The value of the attachmentBinaryObject property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<BinaryObjectType> getAttachmentBinaryObject() {
        if (attachmentBinaryObject == null) {
            attachmentBinaryObject = new ArrayList<>();
        }
        return this.attachmentBinaryObject;
    }

    /**
     * Gets the value of the information property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the information property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInformation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the information property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getInformation() {
        if (information == null) {
            information = new ArrayList<>();
        }
        return this.information;
    }

    /**
     * Gets the value of the referenceTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link ReferenceCodeType }
     *     
     */
    @Nullable
    public ReferenceCodeType getReferenceTypeCode() {
        return referenceTypeCode;
    }

    /**
     * Sets the value of the referenceTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferenceCodeType }
     *     
     */
    public void setReferenceTypeCode(
        @Nullable
        ReferenceCodeType value) {
        this.referenceTypeCode = value;
    }

    /**
     * Gets the value of the sectionName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the sectionName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSectionName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the sectionName property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getSectionName() {
        if (sectionName == null) {
            sectionName = new ArrayList<>();
        }
        return this.sectionName;
    }

    /**
     * Gets the value of the previousRevisionID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the previousRevisionID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPreviousRevisionID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDType }
     * 
     * 
     * @return
     *     The value of the previousRevisionID property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDType> getPreviousRevisionID() {
        if (previousRevisionID == null) {
            previousRevisionID = new ArrayList<>();
        }
        return this.previousRevisionID;
    }

    /**
     * Gets the value of the formattedIssueDateTime property.
     * 
     * @return
     *     possible object is
     *     {@link FormattedDateTimeType }
     *     
     */
    @Nullable
    public FormattedDateTimeType getFormattedIssueDateTime() {
        return formattedIssueDateTime;
    }

    /**
     * Sets the value of the formattedIssueDateTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link FormattedDateTimeType }
     *     
     */
    public void setFormattedIssueDateTime(
        @Nullable
        FormattedDateTimeType value) {
        this.formattedIssueDateTime = value;
    }

    /**
     * Gets the value of the effectiveSpecifiedPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link SpecifiedPeriodType }
     *     
     */
    @Nullable
    public SpecifiedPeriodType getEffectiveSpecifiedPeriod() {
        return effectiveSpecifiedPeriod;
    }

    /**
     * Sets the value of the effectiveSpecifiedPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpecifiedPeriodType }
     *     
     */
    public void setEffectiveSpecifiedPeriod(
        @Nullable
        SpecifiedPeriodType value) {
        this.effectiveSpecifiedPeriod = value;
    }

    /**
     * Gets the value of the issuerTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getIssuerTradeParty() {
        return issuerTradeParty;
    }

    /**
     * Sets the value of the issuerTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setIssuerTradeParty(
        @Nullable
        TradePartyType value) {
        this.issuerTradeParty = value;
    }

    /**
     * Gets the value of the attachedSpecifiedBinaryFile property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the attachedSpecifiedBinaryFile property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttachedSpecifiedBinaryFile().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SpecifiedBinaryFileType }
     * 
     * 
     * @return
     *     The value of the attachedSpecifiedBinaryFile property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SpecifiedBinaryFileType> getAttachedSpecifiedBinaryFile() {
        if (attachedSpecifiedBinaryFile == null) {
            attachedSpecifiedBinaryFile = new ArrayList<>();
        }
        return this.attachedSpecifiedBinaryFile;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ReferencedDocumentType rhs = ((ReferencedDocumentType) o);
        if (!EqualsHelper.equalsCollection(attachedSpecifiedBinaryFile, rhs.attachedSpecifiedBinaryFile)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(attachmentBinaryObject, rhs.attachmentBinaryObject)) {
            return false;
        }
        if (!EqualsHelper.equals(copyIndicator, rhs.copyIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(effectiveSpecifiedPeriod, rhs.effectiveSpecifiedPeriod)) {
            return false;
        }
        if (!EqualsHelper.equals(formattedIssueDateTime, rhs.formattedIssueDateTime)) {
            return false;
        }
        if (!EqualsHelper.equals(globalID, rhs.globalID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(information, rhs.information)) {
            return false;
        }
        if (!EqualsHelper.equals(issuerAssignedID, rhs.issuerAssignedID)) {
            return false;
        }
        if (!EqualsHelper.equals(issuerTradeParty, rhs.issuerTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(lineID, rhs.lineID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(previousRevisionID, rhs.previousRevisionID)) {
            return false;
        }
        if (!EqualsHelper.equals(referenceTypeCode, rhs.referenceTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(revisionID, rhs.revisionID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(sectionName, rhs.sectionName)) {
            return false;
        }
        if (!EqualsHelper.equals(statusCode, rhs.statusCode)) {
            return false;
        }
        if (!EqualsHelper.equals(typeCode, rhs.typeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(uriid, rhs.uriid)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(attachedSpecifiedBinaryFile).append(attachmentBinaryObject).append(copyIndicator).append(effectiveSpecifiedPeriod).append(formattedIssueDateTime).append(globalID).append(information).append(issuerAssignedID).append(issuerTradeParty).append(lineID).append(name).append(previousRevisionID).append(referenceTypeCode).append(revisionID).append(sectionName).append(statusCode).append(typeCode).append(uriid).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("attachedSpecifiedBinaryFile", attachedSpecifiedBinaryFile).append("attachmentBinaryObject", attachmentBinaryObject).append("copyIndicator", copyIndicator).append("effectiveSpecifiedPeriod", effectiveSpecifiedPeriod).append("formattedIssueDateTime", formattedIssueDateTime).append("globalID", globalID).append("information", information).append("issuerAssignedID", issuerAssignedID).append("issuerTradeParty", issuerTradeParty).append("lineID", lineID).append("name", name).append("previousRevisionID", previousRevisionID).append("referenceTypeCode", referenceTypeCode).append("revisionID", revisionID).append("sectionName", sectionName).append("statusCode", statusCode).append("typeCode", typeCode).append("uriid", uriid).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setName(
        @Nullable
        final List<TextType> aList) {
        name = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAttachmentBinaryObject(
        @Nullable
        final List<BinaryObjectType> aList) {
        attachmentBinaryObject = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setInformation(
        @Nullable
        final List<TextType> aList) {
        information = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSectionName(
        @Nullable
        final List<TextType> aList) {
        sectionName = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPreviousRevisionID(
        @Nullable
        final List<IDType> aList) {
        previousRevisionID = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAttachedSpecifiedBinaryFile(
        @Nullable
        final List<SpecifiedBinaryFileType> aList) {
        attachedSpecifiedBinaryFile = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNameEntries() {
        return (!getName().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNameEntries() {
        return getName().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNameCount() {
        return getName().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getName().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addName(
        @Nonnull
        final TextType elem) {
        getName().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAttachmentBinaryObjectEntries() {
        return (!getAttachmentBinaryObject().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAttachmentBinaryObjectEntries() {
        return getAttachmentBinaryObject().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAttachmentBinaryObjectCount() {
        return getAttachmentBinaryObject().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public BinaryObjectType getAttachmentBinaryObjectAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAttachmentBinaryObject().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAttachmentBinaryObject(
        @Nonnull
        final BinaryObjectType elem) {
        getAttachmentBinaryObject().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasInformationEntries() {
        return (!getInformation().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoInformationEntries() {
        return getInformation().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getInformationCount() {
        return getInformation().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getInformationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getInformation().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addInformation(
        @Nonnull
        final TextType elem) {
        getInformation().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSectionNameEntries() {
        return (!getSectionName().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSectionNameEntries() {
        return getSectionName().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSectionNameCount() {
        return getSectionName().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getSectionNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSectionName().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSectionName(
        @Nonnull
        final TextType elem) {
        getSectionName().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPreviousRevisionIDEntries() {
        return (!getPreviousRevisionID().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPreviousRevisionIDEntries() {
        return getPreviousRevisionID().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPreviousRevisionIDCount() {
        return getPreviousRevisionID().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDType getPreviousRevisionIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPreviousRevisionID().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPreviousRevisionID(
        @Nonnull
        final IDType elem) {
        getPreviousRevisionID().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAttachedSpecifiedBinaryFileEntries() {
        return (!getAttachedSpecifiedBinaryFile().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAttachedSpecifiedBinaryFileEntries() {
        return getAttachedSpecifiedBinaryFile().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAttachedSpecifiedBinaryFileCount() {
        return getAttachedSpecifiedBinaryFile().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SpecifiedBinaryFileType getAttachedSpecifiedBinaryFileAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAttachedSpecifiedBinaryFile().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAttachedSpecifiedBinaryFile(
        @Nonnull
        final SpecifiedBinaryFileType elem) {
        getAttachedSpecifiedBinaryFile().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ReferencedDocumentType ret) {
        if (attachedSpecifiedBinaryFile == null) {
            ret.attachedSpecifiedBinaryFile = null;
        } else {
            List<SpecifiedBinaryFileType> retAttachedSpecifiedBinaryFile = new ArrayList<>();
            for (SpecifiedBinaryFileType aItem: getAttachedSpecifiedBinaryFile()) {
                retAttachedSpecifiedBinaryFile.add(((aItem == null)?null:aItem.clone()));
            }
            ret.attachedSpecifiedBinaryFile = retAttachedSpecifiedBinaryFile;
        }
        if (attachmentBinaryObject == null) {
            ret.attachmentBinaryObject = null;
        } else {
            List<BinaryObjectType> retAttachmentBinaryObject = new ArrayList<>();
            for (BinaryObjectType aItem: getAttachmentBinaryObject()) {
                retAttachmentBinaryObject.add(((aItem == null)?null:aItem.clone()));
            }
            ret.attachmentBinaryObject = retAttachmentBinaryObject;
        }
        ret.copyIndicator = ((copyIndicator == null)?null:copyIndicator.clone());
        ret.effectiveSpecifiedPeriod = ((effectiveSpecifiedPeriod == null)?null:effectiveSpecifiedPeriod.clone());
        ret.formattedIssueDateTime = ((formattedIssueDateTime == null)?null:formattedIssueDateTime.clone());
        ret.globalID = ((globalID == null)?null:globalID.clone());
        if (information == null) {
            ret.information = null;
        } else {
            List<TextType> retInformation = new ArrayList<>();
            for (TextType aItem: getInformation()) {
                retInformation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.information = retInformation;
        }
        ret.issuerAssignedID = ((issuerAssignedID == null)?null:issuerAssignedID.clone());
        ret.issuerTradeParty = ((issuerTradeParty == null)?null:issuerTradeParty.clone());
        ret.lineID = ((lineID == null)?null:lineID.clone());
        if (name == null) {
            ret.name = null;
        } else {
            List<TextType> retName = new ArrayList<>();
            for (TextType aItem: getName()) {
                retName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.name = retName;
        }
        if (previousRevisionID == null) {
            ret.previousRevisionID = null;
        } else {
            List<IDType> retPreviousRevisionID = new ArrayList<>();
            for (IDType aItem: getPreviousRevisionID()) {
                retPreviousRevisionID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.previousRevisionID = retPreviousRevisionID;
        }
        ret.referenceTypeCode = ((referenceTypeCode == null)?null:referenceTypeCode.clone());
        ret.revisionID = ((revisionID == null)?null:revisionID.clone());
        if (sectionName == null) {
            ret.sectionName = null;
        } else {
            List<TextType> retSectionName = new ArrayList<>();
            for (TextType aItem: getSectionName()) {
                retSectionName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.sectionName = retSectionName;
        }
        ret.statusCode = ((statusCode == null)?null:statusCode.clone());
        ret.typeCode = ((typeCode == null)?null:typeCode.clone());
        ret.uriid = ((uriid == null)?null:uriid.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ReferencedDocumentType clone() {
        ReferencedDocumentType ret = new ReferencedDocumentType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setIssuerAssignedID(
        @Nullable
        final String valueParam) {
        IDType aObj = getIssuerAssignedID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setIssuerAssignedID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setURIID(
        @Nullable
        final String valueParam) {
        IDType aObj = getURIID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setURIID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DocumentStatusCodeType and never <code>null</code>
     */
    @Nonnull
    public DocumentStatusCodeType setStatusCode(
        @Nullable
        final String valueParam) {
        DocumentStatusCodeType aObj = getStatusCode();
        if (aObj == null) {
            aObj = new DocumentStatusCodeType(valueParam);
            setStatusCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setLineID(
        @Nullable
        final String valueParam) {
        IDType aObj = getLineID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setLineID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DocumentCodeType and never <code>null</code>
     */
    @Nonnull
    public DocumentCodeType setTypeCode(
        @Nullable
        final String valueParam) {
        DocumentCodeType aObj = getTypeCode();
        if (aObj == null) {
            aObj = new DocumentCodeType(valueParam);
            setTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setGlobalID(
        @Nullable
        final String valueParam) {
        IDType aObj = getGlobalID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setGlobalID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setRevisionID(
        @Nullable
        final String valueParam) {
        IDType aObj = getRevisionID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setRevisionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ReferenceCodeType and never <code>null</code>
     */
    @Nonnull
    public ReferenceCodeType setReferenceTypeCode(
        @Nullable
        final String valueParam) {
        ReferenceCodeType aObj = getReferenceTypeCode();
        if (aObj == null) {
            aObj = new ReferenceCodeType(valueParam);
            setReferenceTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIssuerAssignedIDValue() {
        IDType aObj = getIssuerAssignedID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getURIIDValue() {
        IDType aObj = getURIID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DocumentStatusCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DocumentStatusCodeType object or <code>null</code>
     */
    @Nullable
    public String getStatusCodeValue() {
        DocumentStatusCodeType aObj = getStatusCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getLineIDValue() {
        IDType aObj = getLineID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DocumentCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DocumentCodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeCodeValue() {
        DocumentCodeType aObj = getTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getGlobalIDValue() {
        IDType aObj = getGlobalID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getRevisionIDValue() {
        IDType aObj = getRevisionID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ReferenceCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ReferenceCodeType object or <code>null</code>
     */
    @Nullable
    public String getReferenceTypeCodeValue() {
        ReferenceCodeType aObj = getReferenceTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
