
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IndicatorType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for RegisteredTaxType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="RegisteredTaxType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="ExemptionReasonCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="ExemptionReason" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="CurrencyCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="Jurisdiction" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="Description" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="CustomsDutyIndicator" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IndicatorType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "RegisteredTaxType", propOrder = {
    "typeCode",
    "exemptionReasonCode",
    "exemptionReason",
    "currencyCode",
    "jurisdiction",
    "description",
    "customsDutyIndicator"
})
@CodingStyleguideUnaware
public class RegisteredTaxType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "TypeCode")
    private CodeType typeCode;
    @XmlElement(name = "ExemptionReasonCode")
    private CodeType exemptionReasonCode;
    @XmlElement(name = "ExemptionReason")
    private List<TextType> exemptionReason;
    @XmlElement(name = "CurrencyCode")
    private CodeType currencyCode;
    @XmlElement(name = "Jurisdiction")
    private List<TextType> jurisdiction;
    @XmlElement(name = "Description")
    private List<TextType> description;
    @XmlElement(name = "CustomsDutyIndicator")
    private IndicatorType customsDutyIndicator;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public RegisteredTaxType() {
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getTypeCode() {
        return typeCode;
    }

    /**
     * Sets the value of the typeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setTypeCode(
        @Nullable
        CodeType value) {
        this.typeCode = value;
    }

    /**
     * Gets the value of the exemptionReasonCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getExemptionReasonCode() {
        return exemptionReasonCode;
    }

    /**
     * Sets the value of the exemptionReasonCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setExemptionReasonCode(
        @Nullable
        CodeType value) {
        this.exemptionReasonCode = value;
    }

    /**
     * Gets the value of the exemptionReason property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the exemptionReason property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getExemptionReason().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the exemptionReason property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getExemptionReason() {
        if (exemptionReason == null) {
            exemptionReason = new ArrayList<>();
        }
        return this.exemptionReason;
    }

    /**
     * Gets the value of the currencyCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getCurrencyCode() {
        return currencyCode;
    }

    /**
     * Sets the value of the currencyCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setCurrencyCode(
        @Nullable
        CodeType value) {
        this.currencyCode = value;
    }

    /**
     * Gets the value of the jurisdiction property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the jurisdiction property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getJurisdiction().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the jurisdiction property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getJurisdiction() {
        if (jurisdiction == null) {
            jurisdiction = new ArrayList<>();
        }
        return this.jurisdiction;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the customsDutyIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link IndicatorType }
     *     
     */
    @Nullable
    public IndicatorType getCustomsDutyIndicator() {
        return customsDutyIndicator;
    }

    /**
     * Sets the value of the customsDutyIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link IndicatorType }
     *     
     */
    public void setCustomsDutyIndicator(
        @Nullable
        IndicatorType value) {
        this.customsDutyIndicator = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final RegisteredTaxType rhs = ((RegisteredTaxType) o);
        if (!EqualsHelper.equals(currencyCode, rhs.currencyCode)) {
            return false;
        }
        if (!EqualsHelper.equals(customsDutyIndicator, rhs.customsDutyIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(exemptionReason, rhs.exemptionReason)) {
            return false;
        }
        if (!EqualsHelper.equals(exemptionReasonCode, rhs.exemptionReasonCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(jurisdiction, rhs.jurisdiction)) {
            return false;
        }
        if (!EqualsHelper.equals(typeCode, rhs.typeCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(currencyCode).append(customsDutyIndicator).append(description).append(exemptionReason).append(exemptionReasonCode).append(jurisdiction).append(typeCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("currencyCode", currencyCode).append("customsDutyIndicator", customsDutyIndicator).append("description", description).append("exemptionReason", exemptionReason).append("exemptionReasonCode", exemptionReasonCode).append("jurisdiction", jurisdiction).append("typeCode", typeCode).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setExemptionReason(
        @Nullable
        final List<TextType> aList) {
        exemptionReason = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setJurisdiction(
        @Nullable
        final List<TextType> aList) {
        jurisdiction = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<TextType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasExemptionReasonEntries() {
        return (!getExemptionReason().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoExemptionReasonEntries() {
        return getExemptionReason().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getExemptionReasonCount() {
        return getExemptionReason().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getExemptionReasonAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getExemptionReason().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addExemptionReason(
        @Nonnull
        final TextType elem) {
        getExemptionReason().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasJurisdictionEntries() {
        return (!getJurisdiction().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoJurisdictionEntries() {
        return getJurisdiction().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getJurisdictionCount() {
        return getJurisdiction().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getJurisdictionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getJurisdiction().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addJurisdiction(
        @Nonnull
        final TextType elem) {
        getJurisdiction().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final TextType elem) {
        getDescription().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        RegisteredTaxType ret) {
        ret.currencyCode = ((currencyCode == null)?null:currencyCode.clone());
        ret.customsDutyIndicator = ((customsDutyIndicator == null)?null:customsDutyIndicator.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<TextType> retDescription = new ArrayList<>();
            for (TextType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        if (exemptionReason == null) {
            ret.exemptionReason = null;
        } else {
            List<TextType> retExemptionReason = new ArrayList<>();
            for (TextType aItem: getExemptionReason()) {
                retExemptionReason.add(((aItem == null)?null:aItem.clone()));
            }
            ret.exemptionReason = retExemptionReason;
        }
        ret.exemptionReasonCode = ((exemptionReasonCode == null)?null:exemptionReasonCode.clone());
        if (jurisdiction == null) {
            ret.jurisdiction = null;
        } else {
            List<TextType> retJurisdiction = new ArrayList<>();
            for (TextType aItem: getJurisdiction()) {
                retJurisdiction.add(((aItem == null)?null:aItem.clone()));
            }
            ret.jurisdiction = retJurisdiction;
        }
        ret.typeCode = ((typeCode == null)?null:typeCode.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public RegisteredTaxType clone() {
        RegisteredTaxType ret = new RegisteredTaxType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setTypeCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getTypeCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setExemptionReasonCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getExemptionReasonCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setExemptionReasonCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setCurrencyCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getCurrencyCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setCurrencyCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeCodeValue() {
        CodeType aObj = getTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getExemptionReasonCodeValue() {
        CodeType aObj = getExemptionReasonCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getCurrencyCodeValue() {
        CodeType aObj = getCurrencyCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
