
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.CodeType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.IDType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.TextType;


/**
 * <p>Java class for ReturnableAssetInstructionsType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ReturnableAssetInstructionsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="MaterialID" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}IDType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TermsAndConditionsDescription" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}TextType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TermsAndConditionsDescriptionCode" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}CodeType" minOccurs="0"/>
 *         <element name="DepositValueSpecifiedAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="DepositValueValiditySpecifiedPeriod" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SpecifiedPeriodType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ReturnableAssetInstructionsType", propOrder = {
    "materialID",
    "termsAndConditionsDescription",
    "termsAndConditionsDescriptionCode",
    "depositValueSpecifiedAmount",
    "depositValueValiditySpecifiedPeriod"
})
@CodingStyleguideUnaware
public class ReturnableAssetInstructionsType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "MaterialID")
    private List<IDType> materialID;
    @XmlElement(name = "TermsAndConditionsDescription")
    private List<TextType> termsAndConditionsDescription;
    @XmlElement(name = "TermsAndConditionsDescriptionCode")
    private CodeType termsAndConditionsDescriptionCode;
    @XmlElement(name = "DepositValueSpecifiedAmount")
    private List<AmountType> depositValueSpecifiedAmount;
    @XmlElement(name = "DepositValueValiditySpecifiedPeriod")
    private SpecifiedPeriodType depositValueValiditySpecifiedPeriod;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ReturnableAssetInstructionsType() {
    }

    /**
     * Gets the value of the materialID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the materialID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMaterialID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDType }
     * 
     * 
     * @return
     *     The value of the materialID property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDType> getMaterialID() {
        if (materialID == null) {
            materialID = new ArrayList<>();
        }
        return this.materialID;
    }

    /**
     * Gets the value of the termsAndConditionsDescription property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the termsAndConditionsDescription property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTermsAndConditionsDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     * @return
     *     The value of the termsAndConditionsDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getTermsAndConditionsDescription() {
        if (termsAndConditionsDescription == null) {
            termsAndConditionsDescription = new ArrayList<>();
        }
        return this.termsAndConditionsDescription;
    }

    /**
     * Gets the value of the termsAndConditionsDescriptionCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getTermsAndConditionsDescriptionCode() {
        return termsAndConditionsDescriptionCode;
    }

    /**
     * Sets the value of the termsAndConditionsDescriptionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setTermsAndConditionsDescriptionCode(
        @Nullable
        CodeType value) {
        this.termsAndConditionsDescriptionCode = value;
    }

    /**
     * Gets the value of the depositValueSpecifiedAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the depositValueSpecifiedAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDepositValueSpecifiedAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the depositValueSpecifiedAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getDepositValueSpecifiedAmount() {
        if (depositValueSpecifiedAmount == null) {
            depositValueSpecifiedAmount = new ArrayList<>();
        }
        return this.depositValueSpecifiedAmount;
    }

    /**
     * Gets the value of the depositValueValiditySpecifiedPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link SpecifiedPeriodType }
     *     
     */
    @Nullable
    public SpecifiedPeriodType getDepositValueValiditySpecifiedPeriod() {
        return depositValueValiditySpecifiedPeriod;
    }

    /**
     * Sets the value of the depositValueValiditySpecifiedPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpecifiedPeriodType }
     *     
     */
    public void setDepositValueValiditySpecifiedPeriod(
        @Nullable
        SpecifiedPeriodType value) {
        this.depositValueValiditySpecifiedPeriod = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ReturnableAssetInstructionsType rhs = ((ReturnableAssetInstructionsType) o);
        if (!EqualsHelper.equalsCollection(depositValueSpecifiedAmount, rhs.depositValueSpecifiedAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(depositValueValiditySpecifiedPeriod, rhs.depositValueValiditySpecifiedPeriod)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(materialID, rhs.materialID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(termsAndConditionsDescription, rhs.termsAndConditionsDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(termsAndConditionsDescriptionCode, rhs.termsAndConditionsDescriptionCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(depositValueSpecifiedAmount).append(depositValueValiditySpecifiedPeriod).append(materialID).append(termsAndConditionsDescription).append(termsAndConditionsDescriptionCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("depositValueSpecifiedAmount", depositValueSpecifiedAmount).append("depositValueValiditySpecifiedPeriod", depositValueValiditySpecifiedPeriod).append("materialID", materialID).append("termsAndConditionsDescription", termsAndConditionsDescription).append("termsAndConditionsDescriptionCode", termsAndConditionsDescriptionCode).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setMaterialID(
        @Nullable
        final List<IDType> aList) {
        materialID = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTermsAndConditionsDescription(
        @Nullable
        final List<TextType> aList) {
        termsAndConditionsDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDepositValueSpecifiedAmount(
        @Nullable
        final List<AmountType> aList) {
        depositValueSpecifiedAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasMaterialIDEntries() {
        return (!getMaterialID().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoMaterialIDEntries() {
        return getMaterialID().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getMaterialIDCount() {
        return getMaterialID().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDType getMaterialIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getMaterialID().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addMaterialID(
        @Nonnull
        final IDType elem) {
        getMaterialID().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTermsAndConditionsDescriptionEntries() {
        return (!getTermsAndConditionsDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTermsAndConditionsDescriptionEntries() {
        return getTermsAndConditionsDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTermsAndConditionsDescriptionCount() {
        return getTermsAndConditionsDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getTermsAndConditionsDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTermsAndConditionsDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTermsAndConditionsDescription(
        @Nonnull
        final TextType elem) {
        getTermsAndConditionsDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDepositValueSpecifiedAmountEntries() {
        return (!getDepositValueSpecifiedAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDepositValueSpecifiedAmountEntries() {
        return getDepositValueSpecifiedAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDepositValueSpecifiedAmountCount() {
        return getDepositValueSpecifiedAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getDepositValueSpecifiedAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDepositValueSpecifiedAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDepositValueSpecifiedAmount(
        @Nonnull
        final AmountType elem) {
        getDepositValueSpecifiedAmount().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ReturnableAssetInstructionsType ret) {
        if (depositValueSpecifiedAmount == null) {
            ret.depositValueSpecifiedAmount = null;
        } else {
            List<AmountType> retDepositValueSpecifiedAmount = new ArrayList<>();
            for (AmountType aItem: getDepositValueSpecifiedAmount()) {
                retDepositValueSpecifiedAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.depositValueSpecifiedAmount = retDepositValueSpecifiedAmount;
        }
        ret.depositValueValiditySpecifiedPeriod = ((depositValueValiditySpecifiedPeriod == null)?null:depositValueValiditySpecifiedPeriod.clone());
        if (materialID == null) {
            ret.materialID = null;
        } else {
            List<IDType> retMaterialID = new ArrayList<>();
            for (IDType aItem: getMaterialID()) {
                retMaterialID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.materialID = retMaterialID;
        }
        if (termsAndConditionsDescription == null) {
            ret.termsAndConditionsDescription = null;
        } else {
            List<TextType> retTermsAndConditionsDescription = new ArrayList<>();
            for (TextType aItem: getTermsAndConditionsDescription()) {
                retTermsAndConditionsDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.termsAndConditionsDescription = retTermsAndConditionsDescription;
        }
        ret.termsAndConditionsDescriptionCode = ((termsAndConditionsDescriptionCode == null)?null:termsAndConditionsDescriptionCode.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ReturnableAssetInstructionsType clone() {
        ReturnableAssetInstructionsType ret = new ReturnableAssetInstructionsType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setTermsAndConditionsDescriptionCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getTermsAndConditionsDescriptionCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setTermsAndConditionsDescriptionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getTermsAndConditionsDescriptionCodeValue() {
        CodeType aObj = getTermsAndConditionsDescriptionCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
