
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;


/**
 * <p>Java class for SubordinateLineTradeDeliveryType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SubordinateLineTradeDeliveryType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="PackageQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="ProductUnitQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="PerPackageUnitQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="IncludedSupplyChainPackaging" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SupplyChainPackagingType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SubordinateLineTradeDeliveryType", propOrder = {
    "packageQuantity",
    "productUnitQuantity",
    "perPackageUnitQuantity",
    "includedSupplyChainPackaging"
})
@CodingStyleguideUnaware
public class SubordinateLineTradeDeliveryType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "PackageQuantity")
    private QuantityType packageQuantity;
    @XmlElement(name = "ProductUnitQuantity")
    private QuantityType productUnitQuantity;
    @XmlElement(name = "PerPackageUnitQuantity")
    private QuantityType perPackageUnitQuantity;
    @XmlElement(name = "IncludedSupplyChainPackaging")
    private List<SupplyChainPackagingType> includedSupplyChainPackaging;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public SubordinateLineTradeDeliveryType() {
    }

    /**
     * Gets the value of the packageQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getPackageQuantity() {
        return packageQuantity;
    }

    /**
     * Sets the value of the packageQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setPackageQuantity(
        @Nullable
        QuantityType value) {
        this.packageQuantity = value;
    }

    /**
     * Gets the value of the productUnitQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getProductUnitQuantity() {
        return productUnitQuantity;
    }

    /**
     * Sets the value of the productUnitQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setProductUnitQuantity(
        @Nullable
        QuantityType value) {
        this.productUnitQuantity = value;
    }

    /**
     * Gets the value of the perPackageUnitQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getPerPackageUnitQuantity() {
        return perPackageUnitQuantity;
    }

    /**
     * Sets the value of the perPackageUnitQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setPerPackageUnitQuantity(
        @Nullable
        QuantityType value) {
        this.perPackageUnitQuantity = value;
    }

    /**
     * Gets the value of the includedSupplyChainPackaging property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the includedSupplyChainPackaging property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIncludedSupplyChainPackaging().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupplyChainPackagingType }
     * 
     * 
     * @return
     *     The value of the includedSupplyChainPackaging property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SupplyChainPackagingType> getIncludedSupplyChainPackaging() {
        if (includedSupplyChainPackaging == null) {
            includedSupplyChainPackaging = new ArrayList<>();
        }
        return this.includedSupplyChainPackaging;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final SubordinateLineTradeDeliveryType rhs = ((SubordinateLineTradeDeliveryType) o);
        if (!EqualsHelper.equalsCollection(includedSupplyChainPackaging, rhs.includedSupplyChainPackaging)) {
            return false;
        }
        if (!EqualsHelper.equals(packageQuantity, rhs.packageQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(perPackageUnitQuantity, rhs.perPackageUnitQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(productUnitQuantity, rhs.productUnitQuantity)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(includedSupplyChainPackaging).append(packageQuantity).append(perPackageUnitQuantity).append(productUnitQuantity).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("includedSupplyChainPackaging", includedSupplyChainPackaging).append("packageQuantity", packageQuantity).append("perPackageUnitQuantity", perPackageUnitQuantity).append("productUnitQuantity", productUnitQuantity).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setIncludedSupplyChainPackaging(
        @Nullable
        final List<SupplyChainPackagingType> aList) {
        includedSupplyChainPackaging = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIncludedSupplyChainPackagingEntries() {
        return (!getIncludedSupplyChainPackaging().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIncludedSupplyChainPackagingEntries() {
        return getIncludedSupplyChainPackaging().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIncludedSupplyChainPackagingCount() {
        return getIncludedSupplyChainPackaging().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SupplyChainPackagingType getIncludedSupplyChainPackagingAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIncludedSupplyChainPackaging().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addIncludedSupplyChainPackaging(
        @Nonnull
        final SupplyChainPackagingType elem) {
        getIncludedSupplyChainPackaging().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        SubordinateLineTradeDeliveryType ret) {
        if (includedSupplyChainPackaging == null) {
            ret.includedSupplyChainPackaging = null;
        } else {
            List<SupplyChainPackagingType> retIncludedSupplyChainPackaging = new ArrayList<>();
            for (SupplyChainPackagingType aItem: getIncludedSupplyChainPackaging()) {
                retIncludedSupplyChainPackaging.add(((aItem == null)?null:aItem.clone()));
            }
            ret.includedSupplyChainPackaging = retIncludedSupplyChainPackaging;
        }
        ret.packageQuantity = ((packageQuantity == null)?null:packageQuantity.clone());
        ret.perPackageUnitQuantity = ((perPackageUnitQuantity == null)?null:perPackageUnitQuantity.clone());
        ret.productUnitQuantity = ((productUnitQuantity == null)?null:productUnitQuantity.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SubordinateLineTradeDeliveryType clone() {
        SubordinateLineTradeDeliveryType ret = new SubordinateLineTradeDeliveryType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setPackageQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getPackageQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setPackageQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setProductUnitQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getProductUnitQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setProductUnitQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setPerPackageUnitQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getPerPackageUnitQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setPerPackageUnitQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPackageQuantityValue() {
        QuantityType aObj = getPackageQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getProductUnitQuantityValue() {
        QuantityType aObj = getProductUnitQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPerPackageUnitQuantityValue() {
        QuantityType aObj = getPerPackageUnitQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

}
