
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.GoodsTypeCodeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.GoodsTypeExtensionCodeType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.WeightUnitMeasureType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.MeasureType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;


/**
 * <p>Java class for SupplyChainConsignmentItemType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SupplyChainConsignmentItemType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="TypeCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}GoodsTypeCodeType" minOccurs="0"/>
 *         <element name="TypeExtensionCode" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}GoodsTypeExtensionCodeType" minOccurs="0"/>
 *         <element name="DeclaredValueForCustomsAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" minOccurs="0"/>
 *         <element name="DeclaredValueForStatisticsAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" minOccurs="0"/>
 *         <element name="InvoiceAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="GrossWeightMeasure" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}WeightUnitMeasureType" minOccurs="0"/>
 *         <element name="NetWeightMeasure" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}MeasureType" minOccurs="0"/>
 *         <element name="TariffQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="NatureIdentificationTransportCargo" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TransportCargoType" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SupplyChainConsignmentItemType", propOrder = {
    "typeCode",
    "typeExtensionCode",
    "declaredValueForCustomsAmount",
    "declaredValueForStatisticsAmount",
    "invoiceAmount",
    "grossWeightMeasure",
    "netWeightMeasure",
    "tariffQuantity",
    "natureIdentificationTransportCargo"
})
@CodingStyleguideUnaware
public class SupplyChainConsignmentItemType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "TypeCode")
    private GoodsTypeCodeType typeCode;
    @XmlElement(name = "TypeExtensionCode")
    private GoodsTypeExtensionCodeType typeExtensionCode;
    @XmlElement(name = "DeclaredValueForCustomsAmount")
    private AmountType declaredValueForCustomsAmount;
    @XmlElement(name = "DeclaredValueForStatisticsAmount")
    private AmountType declaredValueForStatisticsAmount;
    @XmlElement(name = "InvoiceAmount")
    private List<AmountType> invoiceAmount;
    @XmlElement(name = "GrossWeightMeasure")
    private WeightUnitMeasureType grossWeightMeasure;
    @XmlElement(name = "NetWeightMeasure")
    private MeasureType netWeightMeasure;
    @XmlElement(name = "TariffQuantity")
    private QuantityType tariffQuantity;
    @XmlElement(name = "NatureIdentificationTransportCargo")
    private TransportCargoType natureIdentificationTransportCargo;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public SupplyChainConsignmentItemType() {
    }

    /**
     * Gets the value of the typeCode property.
     * 
     * @return
     *     possible object is
     *     {@link GoodsTypeCodeType }
     *     
     */
    @Nullable
    public GoodsTypeCodeType getTypeCode() {
        return typeCode;
    }

    /**
     * Sets the value of the typeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link GoodsTypeCodeType }
     *     
     */
    public void setTypeCode(
        @Nullable
        GoodsTypeCodeType value) {
        this.typeCode = value;
    }

    /**
     * Gets the value of the typeExtensionCode property.
     * 
     * @return
     *     possible object is
     *     {@link GoodsTypeExtensionCodeType }
     *     
     */
    @Nullable
    public GoodsTypeExtensionCodeType getTypeExtensionCode() {
        return typeExtensionCode;
    }

    /**
     * Sets the value of the typeExtensionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link GoodsTypeExtensionCodeType }
     *     
     */
    public void setTypeExtensionCode(
        @Nullable
        GoodsTypeExtensionCodeType value) {
        this.typeExtensionCode = value;
    }

    /**
     * Gets the value of the declaredValueForCustomsAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getDeclaredValueForCustomsAmount() {
        return declaredValueForCustomsAmount;
    }

    /**
     * Sets the value of the declaredValueForCustomsAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setDeclaredValueForCustomsAmount(
        @Nullable
        AmountType value) {
        this.declaredValueForCustomsAmount = value;
    }

    /**
     * Gets the value of the declaredValueForStatisticsAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getDeclaredValueForStatisticsAmount() {
        return declaredValueForStatisticsAmount;
    }

    /**
     * Sets the value of the declaredValueForStatisticsAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setDeclaredValueForStatisticsAmount(
        @Nullable
        AmountType value) {
        this.declaredValueForStatisticsAmount = value;
    }

    /**
     * Gets the value of the invoiceAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the invoiceAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getInvoiceAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the invoiceAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getInvoiceAmount() {
        if (invoiceAmount == null) {
            invoiceAmount = new ArrayList<>();
        }
        return this.invoiceAmount;
    }

    /**
     * Gets the value of the grossWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link WeightUnitMeasureType }
     *     
     */
    @Nullable
    public WeightUnitMeasureType getGrossWeightMeasure() {
        return grossWeightMeasure;
    }

    /**
     * Sets the value of the grossWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link WeightUnitMeasureType }
     *     
     */
    public void setGrossWeightMeasure(
        @Nullable
        WeightUnitMeasureType value) {
        this.grossWeightMeasure = value;
    }

    /**
     * Gets the value of the netWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link MeasureType }
     *     
     */
    @Nullable
    public MeasureType getNetWeightMeasure() {
        return netWeightMeasure;
    }

    /**
     * Sets the value of the netWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link MeasureType }
     *     
     */
    public void setNetWeightMeasure(
        @Nullable
        MeasureType value) {
        this.netWeightMeasure = value;
    }

    /**
     * Gets the value of the tariffQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getTariffQuantity() {
        return tariffQuantity;
    }

    /**
     * Sets the value of the tariffQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setTariffQuantity(
        @Nullable
        QuantityType value) {
        this.tariffQuantity = value;
    }

    /**
     * Gets the value of the natureIdentificationTransportCargo property.
     * 
     * @return
     *     possible object is
     *     {@link TransportCargoType }
     *     
     */
    @Nullable
    public TransportCargoType getNatureIdentificationTransportCargo() {
        return natureIdentificationTransportCargo;
    }

    /**
     * Sets the value of the natureIdentificationTransportCargo property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportCargoType }
     *     
     */
    public void setNatureIdentificationTransportCargo(
        @Nullable
        TransportCargoType value) {
        this.natureIdentificationTransportCargo = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final SupplyChainConsignmentItemType rhs = ((SupplyChainConsignmentItemType) o);
        if (!EqualsHelper.equals(declaredValueForCustomsAmount, rhs.declaredValueForCustomsAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(declaredValueForStatisticsAmount, rhs.declaredValueForStatisticsAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(grossWeightMeasure, rhs.grossWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(invoiceAmount, rhs.invoiceAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(natureIdentificationTransportCargo, rhs.natureIdentificationTransportCargo)) {
            return false;
        }
        if (!EqualsHelper.equals(netWeightMeasure, rhs.netWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(tariffQuantity, rhs.tariffQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(typeCode, rhs.typeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(typeExtensionCode, rhs.typeExtensionCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(declaredValueForCustomsAmount).append(declaredValueForStatisticsAmount).append(grossWeightMeasure).append(invoiceAmount).append(natureIdentificationTransportCargo).append(netWeightMeasure).append(tariffQuantity).append(typeCode).append(typeExtensionCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("declaredValueForCustomsAmount", declaredValueForCustomsAmount).append("declaredValueForStatisticsAmount", declaredValueForStatisticsAmount).append("grossWeightMeasure", grossWeightMeasure).append("invoiceAmount", invoiceAmount).append("natureIdentificationTransportCargo", natureIdentificationTransportCargo).append("netWeightMeasure", netWeightMeasure).append("tariffQuantity", tariffQuantity).append("typeCode", typeCode).append("typeExtensionCode", typeExtensionCode).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setInvoiceAmount(
        @Nullable
        final List<AmountType> aList) {
        invoiceAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasInvoiceAmountEntries() {
        return (!getInvoiceAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoInvoiceAmountEntries() {
        return getInvoiceAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getInvoiceAmountCount() {
        return getInvoiceAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getInvoiceAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getInvoiceAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addInvoiceAmount(
        @Nonnull
        final AmountType elem) {
        getInvoiceAmount().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        SupplyChainConsignmentItemType ret) {
        ret.declaredValueForCustomsAmount = ((declaredValueForCustomsAmount == null)?null:declaredValueForCustomsAmount.clone());
        ret.declaredValueForStatisticsAmount = ((declaredValueForStatisticsAmount == null)?null:declaredValueForStatisticsAmount.clone());
        ret.grossWeightMeasure = ((grossWeightMeasure == null)?null:grossWeightMeasure.clone());
        if (invoiceAmount == null) {
            ret.invoiceAmount = null;
        } else {
            List<AmountType> retInvoiceAmount = new ArrayList<>();
            for (AmountType aItem: getInvoiceAmount()) {
                retInvoiceAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.invoiceAmount = retInvoiceAmount;
        }
        ret.natureIdentificationTransportCargo = ((natureIdentificationTransportCargo == null)?null:natureIdentificationTransportCargo.clone());
        ret.netWeightMeasure = ((netWeightMeasure == null)?null:netWeightMeasure.clone());
        ret.tariffQuantity = ((tariffQuantity == null)?null:tariffQuantity.clone());
        ret.typeCode = ((typeCode == null)?null:typeCode.clone());
        ret.typeExtensionCode = ((typeExtensionCode == null)?null:typeExtensionCode.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SupplyChainConsignmentItemType clone() {
        SupplyChainConsignmentItemType ret = new SupplyChainConsignmentItemType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GoodsTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public GoodsTypeCodeType setTypeCode(
        @Nullable
        final String valueParam) {
        GoodsTypeCodeType aObj = getTypeCode();
        if (aObj == null) {
            aObj = new GoodsTypeCodeType(valueParam);
            setTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GoodsTypeExtensionCodeType and never <code>null</code>
     */
    @Nonnull
    public GoodsTypeExtensionCodeType setTypeExtensionCode(
        @Nullable
        final String valueParam) {
        GoodsTypeExtensionCodeType aObj = getTypeExtensionCode();
        if (aObj == null) {
            aObj = new GoodsTypeExtensionCodeType(valueParam);
            setTypeExtensionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setDeclaredValueForCustomsAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getDeclaredValueForCustomsAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setDeclaredValueForCustomsAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setDeclaredValueForStatisticsAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getDeclaredValueForStatisticsAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setDeclaredValueForStatisticsAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WeightUnitMeasureType and never <code>null</code>
     */
    @Nonnull
    public WeightUnitMeasureType setGrossWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        WeightUnitMeasureType aObj = getGrossWeightMeasure();
        if (aObj == null) {
            aObj = new WeightUnitMeasureType(valueParam);
            setGrossWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MeasureType and never <code>null</code>
     */
    @Nonnull
    public MeasureType setNetWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        MeasureType aObj = getNetWeightMeasure();
        if (aObj == null) {
            aObj = new MeasureType(valueParam);
            setNetWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setTariffQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getTariffQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setTariffQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained GoodsTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GoodsTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeCodeValue() {
        GoodsTypeCodeType aObj = getTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained GoodsTypeExtensionCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GoodsTypeExtensionCodeType object or <code>null</code>
     */
    @Nullable
    public String getTypeExtensionCodeValue() {
        GoodsTypeExtensionCodeType aObj = getTypeExtensionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getDeclaredValueForCustomsAmountValue() {
        AmountType aObj = getDeclaredValueForCustomsAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getDeclaredValueForStatisticsAmountValue() {
        AmountType aObj = getDeclaredValueForStatisticsAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained WeightUnitMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WeightUnitMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getGrossWeightMeasureValue() {
        WeightUnitMeasureType aObj = getGrossWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getNetWeightMeasureValue() {
        MeasureType aObj = getNetWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTariffQuantityValue() {
        QuantityType aObj = getTariffQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

}
