
package un.unece.uncefact.data.standard.reusableaggregatebusinessinformationentity._100;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.VolumeUnitMeasureType;
import un.unece.uncefact.data.standard.qualifieddatatype._100.WeightUnitMeasureType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.AmountType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.MeasureType;
import un.unece.uncefact.data.standard.unqualifieddatatype._100.QuantityType;


/**
 * <p>Java class for SupplyChainConsignmentType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SupplyChainConsignmentType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="GrossWeightMeasure" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}WeightUnitMeasureType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="NetWeightMeasure" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}MeasureType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="GrossVolumeMeasure" type="{urn:un:unece:uncefact:data:standard:QualifiedDataType:100}VolumeUnitMeasureType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="InsurancePremiumAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" minOccurs="0"/>
 *         <element name="AssociatedInvoiceAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TotalChargeAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" minOccurs="0"/>
 *         <element name="DeclaredValueForCustomsAmount" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}AmountType" minOccurs="0"/>
 *         <element name="PackageQuantity" type="{urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100}QuantityType" minOccurs="0"/>
 *         <element name="ConsignorTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="ConsigneeTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="CarrierTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="FreightForwarderTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="DeliveryTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="CustomsImportAgentTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="CustomsExportAgentTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" minOccurs="0"/>
 *         <element name="GroupingCentreTradeParty" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}TradePartyType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="TransportContractReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" minOccurs="0"/>
 *         <element name="AssociatedReferencedDocument" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}ReferencedDocumentType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="IncludedSupplyChainConsignmentItem" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}SupplyChainConsignmentItemType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="UtilizedLogisticsTransportEquipment" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}LogisticsTransportEquipmentType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="SpecifiedLogisticsTransportMovement" type="{urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100}LogisticsTransportMovementType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SupplyChainConsignmentType", propOrder = {
    "grossWeightMeasure",
    "netWeightMeasure",
    "grossVolumeMeasure",
    "insurancePremiumAmount",
    "associatedInvoiceAmount",
    "totalChargeAmount",
    "declaredValueForCustomsAmount",
    "packageQuantity",
    "consignorTradeParty",
    "consigneeTradeParty",
    "carrierTradeParty",
    "freightForwarderTradeParty",
    "deliveryTradeParty",
    "customsImportAgentTradeParty",
    "customsExportAgentTradeParty",
    "groupingCentreTradeParty",
    "transportContractReferencedDocument",
    "associatedReferencedDocument",
    "includedSupplyChainConsignmentItem",
    "utilizedLogisticsTransportEquipment",
    "specifiedLogisticsTransportMovement"
})
@CodingStyleguideUnaware
public class SupplyChainConsignmentType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "GrossWeightMeasure")
    private List<WeightUnitMeasureType> grossWeightMeasure;
    @XmlElement(name = "NetWeightMeasure")
    private List<MeasureType> netWeightMeasure;
    @XmlElement(name = "GrossVolumeMeasure")
    private List<VolumeUnitMeasureType> grossVolumeMeasure;
    @XmlElement(name = "InsurancePremiumAmount")
    private AmountType insurancePremiumAmount;
    @XmlElement(name = "AssociatedInvoiceAmount")
    private List<AmountType> associatedInvoiceAmount;
    @XmlElement(name = "TotalChargeAmount")
    private AmountType totalChargeAmount;
    @XmlElement(name = "DeclaredValueForCustomsAmount")
    private AmountType declaredValueForCustomsAmount;
    @XmlElement(name = "PackageQuantity")
    private QuantityType packageQuantity;
    @XmlElement(name = "ConsignorTradeParty")
    private TradePartyType consignorTradeParty;
    @XmlElement(name = "ConsigneeTradeParty")
    private TradePartyType consigneeTradeParty;
    @XmlElement(name = "CarrierTradeParty")
    private TradePartyType carrierTradeParty;
    @XmlElement(name = "FreightForwarderTradeParty")
    private TradePartyType freightForwarderTradeParty;
    @XmlElement(name = "DeliveryTradeParty")
    private TradePartyType deliveryTradeParty;
    @XmlElement(name = "CustomsImportAgentTradeParty")
    private TradePartyType customsImportAgentTradeParty;
    @XmlElement(name = "CustomsExportAgentTradeParty")
    private TradePartyType customsExportAgentTradeParty;
    @XmlElement(name = "GroupingCentreTradeParty")
    private List<TradePartyType> groupingCentreTradeParty;
    @XmlElement(name = "TransportContractReferencedDocument")
    private ReferencedDocumentType transportContractReferencedDocument;
    @XmlElement(name = "AssociatedReferencedDocument")
    private List<ReferencedDocumentType> associatedReferencedDocument;
    @XmlElement(name = "IncludedSupplyChainConsignmentItem")
    private List<SupplyChainConsignmentItemType> includedSupplyChainConsignmentItem;
    @XmlElement(name = "UtilizedLogisticsTransportEquipment")
    private List<LogisticsTransportEquipmentType> utilizedLogisticsTransportEquipment;
    @XmlElement(name = "SpecifiedLogisticsTransportMovement")
    private List<LogisticsTransportMovementType> specifiedLogisticsTransportMovement;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public SupplyChainConsignmentType() {
    }

    /**
     * Gets the value of the grossWeightMeasure property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the grossWeightMeasure property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGrossWeightMeasure().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WeightUnitMeasureType }
     * 
     * 
     * @return
     *     The value of the grossWeightMeasure property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<WeightUnitMeasureType> getGrossWeightMeasure() {
        if (grossWeightMeasure == null) {
            grossWeightMeasure = new ArrayList<>();
        }
        return this.grossWeightMeasure;
    }

    /**
     * Gets the value of the netWeightMeasure property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the netWeightMeasure property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNetWeightMeasure().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link MeasureType }
     * 
     * 
     * @return
     *     The value of the netWeightMeasure property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<MeasureType> getNetWeightMeasure() {
        if (netWeightMeasure == null) {
            netWeightMeasure = new ArrayList<>();
        }
        return this.netWeightMeasure;
    }

    /**
     * Gets the value of the grossVolumeMeasure property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the grossVolumeMeasure property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGrossVolumeMeasure().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VolumeUnitMeasureType }
     * 
     * 
     * @return
     *     The value of the grossVolumeMeasure property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<VolumeUnitMeasureType> getGrossVolumeMeasure() {
        if (grossVolumeMeasure == null) {
            grossVolumeMeasure = new ArrayList<>();
        }
        return this.grossVolumeMeasure;
    }

    /**
     * Gets the value of the insurancePremiumAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getInsurancePremiumAmount() {
        return insurancePremiumAmount;
    }

    /**
     * Sets the value of the insurancePremiumAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setInsurancePremiumAmount(
        @Nullable
        AmountType value) {
        this.insurancePremiumAmount = value;
    }

    /**
     * Gets the value of the associatedInvoiceAmount property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the associatedInvoiceAmount property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAssociatedInvoiceAmount().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AmountType }
     * 
     * 
     * @return
     *     The value of the associatedInvoiceAmount property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AmountType> getAssociatedInvoiceAmount() {
        if (associatedInvoiceAmount == null) {
            associatedInvoiceAmount = new ArrayList<>();
        }
        return this.associatedInvoiceAmount;
    }

    /**
     * Gets the value of the totalChargeAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getTotalChargeAmount() {
        return totalChargeAmount;
    }

    /**
     * Sets the value of the totalChargeAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setTotalChargeAmount(
        @Nullable
        AmountType value) {
        this.totalChargeAmount = value;
    }

    /**
     * Gets the value of the declaredValueForCustomsAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getDeclaredValueForCustomsAmount() {
        return declaredValueForCustomsAmount;
    }

    /**
     * Sets the value of the declaredValueForCustomsAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setDeclaredValueForCustomsAmount(
        @Nullable
        AmountType value) {
        this.declaredValueForCustomsAmount = value;
    }

    /**
     * Gets the value of the packageQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityType }
     *     
     */
    @Nullable
    public QuantityType getPackageQuantity() {
        return packageQuantity;
    }

    /**
     * Sets the value of the packageQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityType }
     *     
     */
    public void setPackageQuantity(
        @Nullable
        QuantityType value) {
        this.packageQuantity = value;
    }

    /**
     * Gets the value of the consignorTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getConsignorTradeParty() {
        return consignorTradeParty;
    }

    /**
     * Sets the value of the consignorTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setConsignorTradeParty(
        @Nullable
        TradePartyType value) {
        this.consignorTradeParty = value;
    }

    /**
     * Gets the value of the consigneeTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getConsigneeTradeParty() {
        return consigneeTradeParty;
    }

    /**
     * Sets the value of the consigneeTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setConsigneeTradeParty(
        @Nullable
        TradePartyType value) {
        this.consigneeTradeParty = value;
    }

    /**
     * Gets the value of the carrierTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getCarrierTradeParty() {
        return carrierTradeParty;
    }

    /**
     * Sets the value of the carrierTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setCarrierTradeParty(
        @Nullable
        TradePartyType value) {
        this.carrierTradeParty = value;
    }

    /**
     * Gets the value of the freightForwarderTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getFreightForwarderTradeParty() {
        return freightForwarderTradeParty;
    }

    /**
     * Sets the value of the freightForwarderTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setFreightForwarderTradeParty(
        @Nullable
        TradePartyType value) {
        this.freightForwarderTradeParty = value;
    }

    /**
     * Gets the value of the deliveryTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getDeliveryTradeParty() {
        return deliveryTradeParty;
    }

    /**
     * Sets the value of the deliveryTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setDeliveryTradeParty(
        @Nullable
        TradePartyType value) {
        this.deliveryTradeParty = value;
    }

    /**
     * Gets the value of the customsImportAgentTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getCustomsImportAgentTradeParty() {
        return customsImportAgentTradeParty;
    }

    /**
     * Sets the value of the customsImportAgentTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setCustomsImportAgentTradeParty(
        @Nullable
        TradePartyType value) {
        this.customsImportAgentTradeParty = value;
    }

    /**
     * Gets the value of the customsExportAgentTradeParty property.
     * 
     * @return
     *     possible object is
     *     {@link TradePartyType }
     *     
     */
    @Nullable
    public TradePartyType getCustomsExportAgentTradeParty() {
        return customsExportAgentTradeParty;
    }

    /**
     * Sets the value of the customsExportAgentTradeParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradePartyType }
     *     
     */
    public void setCustomsExportAgentTradeParty(
        @Nullable
        TradePartyType value) {
        this.customsExportAgentTradeParty = value;
    }

    /**
     * Gets the value of the groupingCentreTradeParty property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the groupingCentreTradeParty property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGroupingCentreTradeParty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradePartyType }
     * 
     * 
     * @return
     *     The value of the groupingCentreTradeParty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradePartyType> getGroupingCentreTradeParty() {
        if (groupingCentreTradeParty == null) {
            groupingCentreTradeParty = new ArrayList<>();
        }
        return this.groupingCentreTradeParty;
    }

    /**
     * Gets the value of the transportContractReferencedDocument property.
     * 
     * @return
     *     possible object is
     *     {@link ReferencedDocumentType }
     *     
     */
    @Nullable
    public ReferencedDocumentType getTransportContractReferencedDocument() {
        return transportContractReferencedDocument;
    }

    /**
     * Sets the value of the transportContractReferencedDocument property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReferencedDocumentType }
     *     
     */
    public void setTransportContractReferencedDocument(
        @Nullable
        ReferencedDocumentType value) {
        this.transportContractReferencedDocument = value;
    }

    /**
     * Gets the value of the associatedReferencedDocument property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the associatedReferencedDocument property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAssociatedReferencedDocument().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedDocumentType }
     * 
     * 
     * @return
     *     The value of the associatedReferencedDocument property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedDocumentType> getAssociatedReferencedDocument() {
        if (associatedReferencedDocument == null) {
            associatedReferencedDocument = new ArrayList<>();
        }
        return this.associatedReferencedDocument;
    }

    /**
     * Gets the value of the includedSupplyChainConsignmentItem property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the includedSupplyChainConsignmentItem property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIncludedSupplyChainConsignmentItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupplyChainConsignmentItemType }
     * 
     * 
     * @return
     *     The value of the includedSupplyChainConsignmentItem property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SupplyChainConsignmentItemType> getIncludedSupplyChainConsignmentItem() {
        if (includedSupplyChainConsignmentItem == null) {
            includedSupplyChainConsignmentItem = new ArrayList<>();
        }
        return this.includedSupplyChainConsignmentItem;
    }

    /**
     * Gets the value of the utilizedLogisticsTransportEquipment property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the utilizedLogisticsTransportEquipment property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getUtilizedLogisticsTransportEquipment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LogisticsTransportEquipmentType }
     * 
     * 
     * @return
     *     The value of the utilizedLogisticsTransportEquipment property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LogisticsTransportEquipmentType> getUtilizedLogisticsTransportEquipment() {
        if (utilizedLogisticsTransportEquipment == null) {
            utilizedLogisticsTransportEquipment = new ArrayList<>();
        }
        return this.utilizedLogisticsTransportEquipment;
    }

    /**
     * Gets the value of the specifiedLogisticsTransportMovement property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the specifiedLogisticsTransportMovement property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpecifiedLogisticsTransportMovement().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LogisticsTransportMovementType }
     * 
     * 
     * @return
     *     The value of the specifiedLogisticsTransportMovement property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LogisticsTransportMovementType> getSpecifiedLogisticsTransportMovement() {
        if (specifiedLogisticsTransportMovement == null) {
            specifiedLogisticsTransportMovement = new ArrayList<>();
        }
        return this.specifiedLogisticsTransportMovement;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final SupplyChainConsignmentType rhs = ((SupplyChainConsignmentType) o);
        if (!EqualsHelper.equalsCollection(associatedInvoiceAmount, rhs.associatedInvoiceAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(associatedReferencedDocument, rhs.associatedReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equals(carrierTradeParty, rhs.carrierTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(consigneeTradeParty, rhs.consigneeTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(consignorTradeParty, rhs.consignorTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(customsExportAgentTradeParty, rhs.customsExportAgentTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(customsImportAgentTradeParty, rhs.customsImportAgentTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(declaredValueForCustomsAmount, rhs.declaredValueForCustomsAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(deliveryTradeParty, rhs.deliveryTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equals(freightForwarderTradeParty, rhs.freightForwarderTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(grossVolumeMeasure, rhs.grossVolumeMeasure)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(grossWeightMeasure, rhs.grossWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(groupingCentreTradeParty, rhs.groupingCentreTradeParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(includedSupplyChainConsignmentItem, rhs.includedSupplyChainConsignmentItem)) {
            return false;
        }
        if (!EqualsHelper.equals(insurancePremiumAmount, rhs.insurancePremiumAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(netWeightMeasure, rhs.netWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(packageQuantity, rhs.packageQuantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(specifiedLogisticsTransportMovement, rhs.specifiedLogisticsTransportMovement)) {
            return false;
        }
        if (!EqualsHelper.equals(totalChargeAmount, rhs.totalChargeAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(transportContractReferencedDocument, rhs.transportContractReferencedDocument)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(utilizedLogisticsTransportEquipment, rhs.utilizedLogisticsTransportEquipment)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(associatedInvoiceAmount).append(associatedReferencedDocument).append(carrierTradeParty).append(consigneeTradeParty).append(consignorTradeParty).append(customsExportAgentTradeParty).append(customsImportAgentTradeParty).append(declaredValueForCustomsAmount).append(deliveryTradeParty).append(freightForwarderTradeParty).append(grossVolumeMeasure).append(grossWeightMeasure).append(groupingCentreTradeParty).append(includedSupplyChainConsignmentItem).append(insurancePremiumAmount).append(netWeightMeasure).append(packageQuantity).append(specifiedLogisticsTransportMovement).append(totalChargeAmount).append(transportContractReferencedDocument).append(utilizedLogisticsTransportEquipment).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("associatedInvoiceAmount", associatedInvoiceAmount).append("associatedReferencedDocument", associatedReferencedDocument).append("carrierTradeParty", carrierTradeParty).append("consigneeTradeParty", consigneeTradeParty).append("consignorTradeParty", consignorTradeParty).append("customsExportAgentTradeParty", customsExportAgentTradeParty).append("customsImportAgentTradeParty", customsImportAgentTradeParty).append("declaredValueForCustomsAmount", declaredValueForCustomsAmount).append("deliveryTradeParty", deliveryTradeParty).append("freightForwarderTradeParty", freightForwarderTradeParty).append("grossVolumeMeasure", grossVolumeMeasure).append("grossWeightMeasure", grossWeightMeasure).append("groupingCentreTradeParty", groupingCentreTradeParty).append("includedSupplyChainConsignmentItem", includedSupplyChainConsignmentItem).append("insurancePremiumAmount", insurancePremiumAmount).append("netWeightMeasure", netWeightMeasure).append("packageQuantity", packageQuantity).append("specifiedLogisticsTransportMovement", specifiedLogisticsTransportMovement).append("totalChargeAmount", totalChargeAmount).append("transportContractReferencedDocument", transportContractReferencedDocument).append("utilizedLogisticsTransportEquipment", utilizedLogisticsTransportEquipment).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGrossWeightMeasure(
        @Nullable
        final List<WeightUnitMeasureType> aList) {
        grossWeightMeasure = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNetWeightMeasure(
        @Nullable
        final List<MeasureType> aList) {
        netWeightMeasure = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGrossVolumeMeasure(
        @Nullable
        final List<VolumeUnitMeasureType> aList) {
        grossVolumeMeasure = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAssociatedInvoiceAmount(
        @Nullable
        final List<AmountType> aList) {
        associatedInvoiceAmount = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGroupingCentreTradeParty(
        @Nullable
        final List<TradePartyType> aList) {
        groupingCentreTradeParty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAssociatedReferencedDocument(
        @Nullable
        final List<ReferencedDocumentType> aList) {
        associatedReferencedDocument = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setIncludedSupplyChainConsignmentItem(
        @Nullable
        final List<SupplyChainConsignmentItemType> aList) {
        includedSupplyChainConsignmentItem = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setUtilizedLogisticsTransportEquipment(
        @Nullable
        final List<LogisticsTransportEquipmentType> aList) {
        utilizedLogisticsTransportEquipment = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpecifiedLogisticsTransportMovement(
        @Nullable
        final List<LogisticsTransportMovementType> aList) {
        specifiedLogisticsTransportMovement = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGrossWeightMeasureEntries() {
        return (!getGrossWeightMeasure().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGrossWeightMeasureEntries() {
        return getGrossWeightMeasure().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGrossWeightMeasureCount() {
        return getGrossWeightMeasure().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public WeightUnitMeasureType getGrossWeightMeasureAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGrossWeightMeasure().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGrossWeightMeasure(
        @Nonnull
        final WeightUnitMeasureType elem) {
        getGrossWeightMeasure().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNetWeightMeasureEntries() {
        return (!getNetWeightMeasure().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNetWeightMeasureEntries() {
        return getNetWeightMeasure().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNetWeightMeasureCount() {
        return getNetWeightMeasure().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public MeasureType getNetWeightMeasureAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNetWeightMeasure().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNetWeightMeasure(
        @Nonnull
        final MeasureType elem) {
        getNetWeightMeasure().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGrossVolumeMeasureEntries() {
        return (!getGrossVolumeMeasure().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGrossVolumeMeasureEntries() {
        return getGrossVolumeMeasure().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGrossVolumeMeasureCount() {
        return getGrossVolumeMeasure().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public VolumeUnitMeasureType getGrossVolumeMeasureAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGrossVolumeMeasure().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGrossVolumeMeasure(
        @Nonnull
        final VolumeUnitMeasureType elem) {
        getGrossVolumeMeasure().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAssociatedInvoiceAmountEntries() {
        return (!getAssociatedInvoiceAmount().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAssociatedInvoiceAmountEntries() {
        return getAssociatedInvoiceAmount().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAssociatedInvoiceAmountCount() {
        return getAssociatedInvoiceAmount().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AmountType getAssociatedInvoiceAmountAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAssociatedInvoiceAmount().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAssociatedInvoiceAmount(
        @Nonnull
        final AmountType elem) {
        getAssociatedInvoiceAmount().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGroupingCentreTradePartyEntries() {
        return (!getGroupingCentreTradeParty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGroupingCentreTradePartyEntries() {
        return getGroupingCentreTradeParty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGroupingCentreTradePartyCount() {
        return getGroupingCentreTradeParty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradePartyType getGroupingCentreTradePartyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGroupingCentreTradeParty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGroupingCentreTradeParty(
        @Nonnull
        final TradePartyType elem) {
        getGroupingCentreTradeParty().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAssociatedReferencedDocumentEntries() {
        return (!getAssociatedReferencedDocument().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAssociatedReferencedDocumentEntries() {
        return getAssociatedReferencedDocument().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAssociatedReferencedDocumentCount() {
        return getAssociatedReferencedDocument().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedDocumentType getAssociatedReferencedDocumentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAssociatedReferencedDocument().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAssociatedReferencedDocument(
        @Nonnull
        final ReferencedDocumentType elem) {
        getAssociatedReferencedDocument().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIncludedSupplyChainConsignmentItemEntries() {
        return (!getIncludedSupplyChainConsignmentItem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIncludedSupplyChainConsignmentItemEntries() {
        return getIncludedSupplyChainConsignmentItem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIncludedSupplyChainConsignmentItemCount() {
        return getIncludedSupplyChainConsignmentItem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SupplyChainConsignmentItemType getIncludedSupplyChainConsignmentItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIncludedSupplyChainConsignmentItem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addIncludedSupplyChainConsignmentItem(
        @Nonnull
        final SupplyChainConsignmentItemType elem) {
        getIncludedSupplyChainConsignmentItem().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasUtilizedLogisticsTransportEquipmentEntries() {
        return (!getUtilizedLogisticsTransportEquipment().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoUtilizedLogisticsTransportEquipmentEntries() {
        return getUtilizedLogisticsTransportEquipment().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getUtilizedLogisticsTransportEquipmentCount() {
        return getUtilizedLogisticsTransportEquipment().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LogisticsTransportEquipmentType getUtilizedLogisticsTransportEquipmentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getUtilizedLogisticsTransportEquipment().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addUtilizedLogisticsTransportEquipment(
        @Nonnull
        final LogisticsTransportEquipmentType elem) {
        getUtilizedLogisticsTransportEquipment().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpecifiedLogisticsTransportMovementEntries() {
        return (!getSpecifiedLogisticsTransportMovement().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpecifiedLogisticsTransportMovementEntries() {
        return getSpecifiedLogisticsTransportMovement().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpecifiedLogisticsTransportMovementCount() {
        return getSpecifiedLogisticsTransportMovement().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LogisticsTransportMovementType getSpecifiedLogisticsTransportMovementAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpecifiedLogisticsTransportMovement().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpecifiedLogisticsTransportMovement(
        @Nonnull
        final LogisticsTransportMovementType elem) {
        getSpecifiedLogisticsTransportMovement().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        SupplyChainConsignmentType ret) {
        if (associatedInvoiceAmount == null) {
            ret.associatedInvoiceAmount = null;
        } else {
            List<AmountType> retAssociatedInvoiceAmount = new ArrayList<>();
            for (AmountType aItem: getAssociatedInvoiceAmount()) {
                retAssociatedInvoiceAmount.add(((aItem == null)?null:aItem.clone()));
            }
            ret.associatedInvoiceAmount = retAssociatedInvoiceAmount;
        }
        if (associatedReferencedDocument == null) {
            ret.associatedReferencedDocument = null;
        } else {
            List<ReferencedDocumentType> retAssociatedReferencedDocument = new ArrayList<>();
            for (ReferencedDocumentType aItem: getAssociatedReferencedDocument()) {
                retAssociatedReferencedDocument.add(((aItem == null)?null:aItem.clone()));
            }
            ret.associatedReferencedDocument = retAssociatedReferencedDocument;
        }
        ret.carrierTradeParty = ((carrierTradeParty == null)?null:carrierTradeParty.clone());
        ret.consigneeTradeParty = ((consigneeTradeParty == null)?null:consigneeTradeParty.clone());
        ret.consignorTradeParty = ((consignorTradeParty == null)?null:consignorTradeParty.clone());
        ret.customsExportAgentTradeParty = ((customsExportAgentTradeParty == null)?null:customsExportAgentTradeParty.clone());
        ret.customsImportAgentTradeParty = ((customsImportAgentTradeParty == null)?null:customsImportAgentTradeParty.clone());
        ret.declaredValueForCustomsAmount = ((declaredValueForCustomsAmount == null)?null:declaredValueForCustomsAmount.clone());
        ret.deliveryTradeParty = ((deliveryTradeParty == null)?null:deliveryTradeParty.clone());
        ret.freightForwarderTradeParty = ((freightForwarderTradeParty == null)?null:freightForwarderTradeParty.clone());
        if (grossVolumeMeasure == null) {
            ret.grossVolumeMeasure = null;
        } else {
            List<VolumeUnitMeasureType> retGrossVolumeMeasure = new ArrayList<>();
            for (VolumeUnitMeasureType aItem: getGrossVolumeMeasure()) {
                retGrossVolumeMeasure.add(((aItem == null)?null:aItem.clone()));
            }
            ret.grossVolumeMeasure = retGrossVolumeMeasure;
        }
        if (grossWeightMeasure == null) {
            ret.grossWeightMeasure = null;
        } else {
            List<WeightUnitMeasureType> retGrossWeightMeasure = new ArrayList<>();
            for (WeightUnitMeasureType aItem: getGrossWeightMeasure()) {
                retGrossWeightMeasure.add(((aItem == null)?null:aItem.clone()));
            }
            ret.grossWeightMeasure = retGrossWeightMeasure;
        }
        if (groupingCentreTradeParty == null) {
            ret.groupingCentreTradeParty = null;
        } else {
            List<TradePartyType> retGroupingCentreTradeParty = new ArrayList<>();
            for (TradePartyType aItem: getGroupingCentreTradeParty()) {
                retGroupingCentreTradeParty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.groupingCentreTradeParty = retGroupingCentreTradeParty;
        }
        if (includedSupplyChainConsignmentItem == null) {
            ret.includedSupplyChainConsignmentItem = null;
        } else {
            List<SupplyChainConsignmentItemType> retIncludedSupplyChainConsignmentItem = new ArrayList<>();
            for (SupplyChainConsignmentItemType aItem: getIncludedSupplyChainConsignmentItem()) {
                retIncludedSupplyChainConsignmentItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.includedSupplyChainConsignmentItem = retIncludedSupplyChainConsignmentItem;
        }
        ret.insurancePremiumAmount = ((insurancePremiumAmount == null)?null:insurancePremiumAmount.clone());
        if (netWeightMeasure == null) {
            ret.netWeightMeasure = null;
        } else {
            List<MeasureType> retNetWeightMeasure = new ArrayList<>();
            for (MeasureType aItem: getNetWeightMeasure()) {
                retNetWeightMeasure.add(((aItem == null)?null:aItem.clone()));
            }
            ret.netWeightMeasure = retNetWeightMeasure;
        }
        ret.packageQuantity = ((packageQuantity == null)?null:packageQuantity.clone());
        if (specifiedLogisticsTransportMovement == null) {
            ret.specifiedLogisticsTransportMovement = null;
        } else {
            List<LogisticsTransportMovementType> retSpecifiedLogisticsTransportMovement = new ArrayList<>();
            for (LogisticsTransportMovementType aItem: getSpecifiedLogisticsTransportMovement()) {
                retSpecifiedLogisticsTransportMovement.add(((aItem == null)?null:aItem.clone()));
            }
            ret.specifiedLogisticsTransportMovement = retSpecifiedLogisticsTransportMovement;
        }
        ret.totalChargeAmount = ((totalChargeAmount == null)?null:totalChargeAmount.clone());
        ret.transportContractReferencedDocument = ((transportContractReferencedDocument == null)?null:transportContractReferencedDocument.clone());
        if (utilizedLogisticsTransportEquipment == null) {
            ret.utilizedLogisticsTransportEquipment = null;
        } else {
            List<LogisticsTransportEquipmentType> retUtilizedLogisticsTransportEquipment = new ArrayList<>();
            for (LogisticsTransportEquipmentType aItem: getUtilizedLogisticsTransportEquipment()) {
                retUtilizedLogisticsTransportEquipment.add(((aItem == null)?null:aItem.clone()));
            }
            ret.utilizedLogisticsTransportEquipment = retUtilizedLogisticsTransportEquipment;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SupplyChainConsignmentType clone() {
        SupplyChainConsignmentType ret = new SupplyChainConsignmentType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setInsurancePremiumAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getInsurancePremiumAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setInsurancePremiumAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setTotalChargeAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getTotalChargeAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setTotalChargeAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setDeclaredValueForCustomsAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getDeclaredValueForCustomsAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setDeclaredValueForCustomsAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityType and never <code>null</code>
     */
    @Nonnull
    public QuantityType setPackageQuantity(
        @Nullable
        final BigDecimal valueParam) {
        QuantityType aObj = getPackageQuantity();
        if (aObj == null) {
            aObj = new QuantityType(valueParam);
            setPackageQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getInsurancePremiumAmountValue() {
        AmountType aObj = getInsurancePremiumAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTotalChargeAmountValue() {
        AmountType aObj = getTotalChargeAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getDeclaredValueForCustomsAmountValue() {
        AmountType aObj = getDeclaredValueForCustomsAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPackageQuantityValue() {
        QuantityType aObj = getPackageQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

}
